/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import com.ibm.cfwk.pki.X509Cert;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.SSLightKeyDatabase;
import com.ibm.gsk.ikeyman.basic.SSLightKeyDatabaseException;
import com.ibm.sslight.KeyStore;
import com.ibm.sslight.SSLCert;
import com.ibm.sslight.SSLightKeyRing;
import com.ibm.sslight.tools.GrabCert;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class KeyringDB {
    private static final int DEFAULT_PORT = 9476;
    private static final int DEFAULT_PWD_EXP = 0;
    private static final String DEFAULT_PWD = "toolbox";
    private static final String STR_TOOLNAME = "KeyringDB";
    private static final String STR_CONNECT = "-co";
    private static final String STR_CONNECT_ = "-connect";
    private static final String STR_CHGPWD = "-cp";
    private static final String STR_CHGPWD_ = "-changepassword";
    private static final String STR_VERIFY = "-v";
    private static final String STR_VERIFY_ = "-verify";
    private static final String STR_PASSWORD = "-p";
    private static final String STR_PASSWORD_ = "-password";
    private static final String STR_CREATE = "-ct";
    private static final String STR_CREATE_ = "-create";
    private static final String STR_ADD = "-a";
    private static final String STR_ADD_ = "-add";
    private static final String STR_CA = "--ca";
    private static final String STR_CA_ = "--certificateauthority";
    private static final String STR_LABEL = "--lbl";
    private static final String STR_LABEL_ = "--label";
    private static final String STR_DELETE = "-del";
    private static final String STR_DELETE_ = "-delete";
    private static final String STR_TRUST = "-tr";
    private static final String STR_TRUST_ = "-trust";
    private static final String STR_YES = "y";
    private static final String STR_YES_ = "yes";
    private static final String STR_NO = "n";
    private static final String STR_NO_ = "no";
    private static final String ALREADY_IN_DB = "The server's certificate is already in the database.";
    private static final String CLASS_LOAD_FAILURE_MESSAGE = "Error: Unable to load key class.";
    private static final String ALIAS_TOO_SHORT = "Please use a label with at least one character:";
    private static final String ALIAS_IN_USE = "That label is in use.  Please choose another:";
    private static final String CLASS_STORE_FAILURE_MESSAGE = "Error: Unable to store key class.";
    private static final String SELECTED_CERT_PROMPT = "Select certificate [default = 0, 99 to cancel]: ";
    private static final String ALIAS_PROMPT = "Name for chosen certificate:";
    private static final String CERTIFICATE_NUMBER = " Certificate - Number ";
    private static final String CERTIFICATE_INVALID_WARNING = "    WARNING : Certificate not valid\n";
    private static final String CERTIFICATE_BAD_ERROR = "ERROR: bad certificate.";
    private static final String SITE = "Site";
    private static final String CA = "CA";
    private static final String KEY = "        Key : ";
    private static final String BITS = " bits\n";
    private static final String SUBJECT = "     Subject: ";
    private static final String ISSUER = "      Issuer: ";
    private static final String VALID_FROM = "  Valid from: ";
    private static final String VALID_TO = "    Valid to: ";
    private static final String FINGER_PRINT = "";

    private static SSLightKeyDatabase CreateDBClass(SSLightKeyDatabase sSLightKeyDatabase) throws SSLightKeyDatabaseException {
        sSLightKeyDatabase.create();
        sSLightKeyDatabase.save();
        sSLightKeyDatabase.close();
        return sSLightKeyDatabase;
    }

    private static SSLightKeyDatabase OpenDB(SSLightKeyDatabase sSLightKeyDatabase, String string) {
        try {
            sSLightKeyDatabase.open();
            return sSLightKeyDatabase;
        }
        catch (Exception exception) {
            System.err.println("KeyringDB: Database Open failed: \n       " + exception);
            System.exit(20);
            return null;
        }
    }

    private static void PrintBanner() {
        System.out.println("AS/400 Toolbox for Java \n\n(C) Copyright IBM Corporation 2000.  All rights reserved.  \nU.S. Government users Restricted Rights - Use, duplication or \n disclosure restricted by GSA ADP Schedule Contract with IBM Corp. \nLicensed Materials - Property of IBM \n");
    }

    private static void PrintUsage() {
        System.err.println("Usage:   KeyringDB FullyQualifiedClassName <options>  \n\nViable options: \n    -password <password> - pass in keydatabase password in-line \n    -add                 - adds new certificate to database, can list several --ca's\n      --ca <BinaryX509CertFile> - file holding the certificate\n        [--label <KeyLabel>]    - optional: label for certificate\n    -changepassword      - change your keydatabase password\n    -verify              - outputs keydatabase information\n    -connect <host:port> - conenct to host and get its certificates\n    -delete              - delete the KeyItem associated with the given label \n      --label <KeyLabel>        - label of certificate to delete \n");
        System.exit(10);
    }

    private static boolean doesLabelExist(SSLightKeyDatabase sSLightKeyDatabase, String string) {
        Vector vector = new Vector();
        try {
            sSLightKeyDatabase.buildKeyLabelList();
            String string2 = FINGER_PRINT;
            vector = sSLightKeyDatabase.getKeyLabelList();
            int n = 0;
            while (n < vector.size()) {
                string2 = (String)vector.elementAt(n);
                if (string2.compareTo(string) == 0) {
                    return true;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    private static void fingerPrint(SSLCert sSLCert) {
        try {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(KEY + sSLCert.getKeyInfo() + BITS);
            int[] nArray = new int[]{3, 7, 11, 10, 6};
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            int[] nArray3 = nArray2;
            int n = 0;
            while (n < nArray3.length) {
                stringBuffer.append(n == 0 ? SUBJECT : ISSUER);
                boolean bl = false;
                int n2 = 0;
                while (n2 < nArray.length) {
                    String string = sSLCert.getNameComponent(nArray3[n], nArray[n2]);
                    if (string != null) {
                        if (bl) {
                            stringBuffer.append(", ");
                        }
                        bl = true;
                        stringBuffer.append(string);
                    }
                    ++n2;
                }
                stringBuffer.append("\n");
                ++n;
            }
            Date[] dateArray = sSLCert.getValidity();
            if (dateArray != null) {
                stringBuffer.append(VALID_FROM + dateArray[0] + "\n");
                stringBuffer.append(VALID_TO + dateArray[1] + "\n");
            }
            stringBuffer.append(FINGER_PRINT);
            byte[] byArray = sSLCert.fingerprint();
            int n3 = 0;
            while (n3 < byArray.length) {
                if (n3 > 0) {
                    stringBuffer.append(':');
                }
                byte by = byArray[n3];
                stringBuffer.append("0123456789ABCDEF".charAt(by >> 4 & 0xF));
                stringBuffer.append("0123456789ABCDEF".charAt(by & 0xF));
                ++n3;
            }
            stringBuffer.append("\n");
            if (sSLCert.verify(null) != 0) {
                stringBuffer.append(CERTIFICATE_INVALID_WARNING);
            }
            System.out.println(stringBuffer);
        }
        catch (Exception exception) {
            System.out.println(CERTIFICATE_BAD_ERROR);
        }
    }

    private static String getAlias(KeyStore keyStore) {
        String string = null;
        try {
            while (true) {
                System.out.print(ALIAS_PROMPT);
                System.out.flush();
                DataInputStream dataInputStream = new DataInputStream(System.in);
                string = dataInputStream.readLine();
                if (string.length() <= 0) {
                    System.out.println(ALIAS_TOO_SHORT);
                    continue;
                }
                if (!keyStore.engineContainsAlias(string)) break;
                System.out.println(ALIAS_IN_USE);
            }
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getPasswd(String string) {
        try {
            System.out.print("Password for " + string + ": ");
            System.out.flush();
            DataInputStream dataInputStream = new DataInputStream(System.in);
            String string2 = dataInputStream.readLine();
            if (string2.length() > 0) {
                return string2;
            }
        }
        catch (Exception exception) {
            System.err.println("KeyringDB: Password change failure: \n       " + exception);
            System.exit(20);
        }
        return null;
    }

    private static int getSelectedCert() {
        try {
            System.out.print(SELECTED_CERT_PROMPT);
            System.out.flush();
            DataInputStream dataInputStream = new DataInputStream(System.in);
            String string = dataInputStream.readLine();
            if (string.length() > 0) {
                return Integer.parseInt(string);
            }
        }
        catch (Exception exception) {}
        return 0;
    }

    public static void main(String[] stringArray) {
        KeyringDB.PrintBanner();
        if (stringArray.length < 2 || stringArray[1].toString().toLowerCase().compareTo(STR_ADD) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_VERIFY) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_PASSWORD) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_CONNECT) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_CHGPWD) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_CREATE) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_DELETE) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_TRUST) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_ADD_) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_VERIFY_) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_PASSWORD_) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_CONNECT_) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_CHGPWD_) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_CREATE_) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_DELETE_) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_TRUST_) != 0) {
            KeyringDB.PrintUsage();
        }
        try {
            int n = 1;
            boolean bl = true;
            String string = new String(stringArray[0]);
            String string2 = "." + File.separator;
            String string3 = FINGER_PRINT;
            String string4 = DEFAULT_PWD;
            if (stringArray[n].toString().toLowerCase().compareTo(STR_PASSWORD) == 0 || stringArray[n].toString().toLowerCase().compareTo(STR_PASSWORD_) == 0) {
                if (stringArray.length < 2) {
                    KeyringDB.PrintUsage();
                }
                string4 = stringArray[n + 1];
                n += 2;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n2 = stringTokenizer.countTokens();
            String string5 = FINGER_PRINT;
            int n3 = 0;
            while (n3 < n2 - 2) {
                if (n3 > 0) {
                    string3 = String.valueOf(string3) + ".";
                }
                string5 = stringTokenizer.nextToken();
                string3 = String.valueOf(string3) + string5;
                string2 = String.valueOf(string2) + string5 + File.separator;
                ++n3;
            }
            string = stringTokenizer.nextToken();
            if (n2 > 1) {
                string5 = stringTokenizer.nextToken();
                if (string5.toLowerCase().compareTo("class") == 0) {
                    string = String.valueOf(string) + "." + string5;
                } else {
                    string3 = String.valueOf(string3) + "." + string;
                    string2 = String.valueOf(string2) + string + File.separator;
                    string = String.valueOf(string5) + ".class";
                }
            } else {
                string = String.valueOf(string) + ".class";
            }
            string2 = String.valueOf(string2) + string;
            SSLightKeyDatabase sSLightKeyDatabase = new SSLightKeyDatabase(string2, string4);
            if (string3.compareTo(FINGER_PRINT) != 0) {
                sSLightKeyDatabase.setPackageName(string3);
            }
            System.out.println("fileout  : " + string2);
            System.out.println("pkgout   : " + string3);
            System.out.println("filename : " + string);
            System.out.println();
            boolean bl2 = false;
            if (stringArray[n].toString().toLowerCase().compareTo(STR_CREATE) == 0 || stringArray[n].toString().toLowerCase().compareTo(STR_CREATE_) == 0) {
                try {
                    KeyringDB.CreateDBClass(sSLightKeyDatabase);
                }
                catch (Exception exception) {
                    System.err.println("KeyringDB: Database Creation failed: \n       " + exception);
                    System.exit(20);
                }
            } else if (stringArray[n].toString().toLowerCase().compareTo(STR_VERIFY) == 0 || stringArray[n].toString().toLowerCase().compareTo(STR_VERIFY_) == 0) {
                KeyringDB.OpenDB(sSLightKeyDatabase, string);
                KeyItem keyItem = new KeyItem();
                Vector vector = new Vector();
                sSLightKeyDatabase.buildKeyLabelList();
                vector = sSLightKeyDatabase.getKeyLabelList();
                int n4 = 0;
                while (n4 < vector.size()) {
                    keyItem = sSLightKeyDatabase.getKeyItemByLabel((String)vector.elementAt(n4));
                    System.out.println("***********KeyRing Entry : " + (n4 + 1) + " ************");
                    System.out.println("Label:  " + vector.elementAt(n4));
                    System.out.println("Info:   " + keyItem.toString());
                    ++n4;
                }
                sSLightKeyDatabase.close();
            } else if (stringArray[n].toString().toLowerCase().compareTo(STR_CHGPWD) == 0 || stringArray[n].toString().toLowerCase().compareTo(STR_CHGPWD_) == 0) {
                KeyringDB.OpenDB(sSLightKeyDatabase, string);
                try {
                    String string6 = null;
                    String string7 = null;
                    if (stringArray[1].toString().toLowerCase().compareTo(STR_PASSWORD) != 0 && stringArray[1].toString().toLowerCase().compareTo(STR_PASSWORD_) != 0) {
                        string6 = new String(KeyringDB.getPasswd(string));
                    }
                    string7 = new String(KeyringDB.getPasswd(string));
                    sSLightKeyDatabase.changeKeyDbPwd(string6, string7, 0L);
                }
                catch (Exception exception) {
                    System.err.println("KeyringDB: Database Password Change Failed:  \n       " + exception);
                    System.exit(20);
                }
                sSLightKeyDatabase.save();
                sSLightKeyDatabase.close();
            } else if (stringArray[n].toString().toLowerCase().compareTo(STR_ADD) == 0 || stringArray[n].toString().toLowerCase().compareTo(STR_ADD_) == 0) {
                if (stringArray.length < n + 2) {
                    KeyringDB.PrintUsage();
                }
                try {
                    KeyringDB.CreateDBClass(sSLightKeyDatabase);
                }
                catch (Exception exception) {}
                KeyringDB.OpenDB(sSLightKeyDatabase, string);
                String string8 = new String();
                int n5 = n + 1;
                while (n5 < stringArray.length) {
                    if (stringArray[n5].toString().toLowerCase().compareTo(STR_CA) != 0 && stringArray[n5].toString().toLowerCase().compareTo(STR_CA_) != 0 && stringArray[n5].toString().toLowerCase().compareTo(STR_LABEL) != 0 && stringArray[n5].toString().toLowerCase().compareTo(STR_LABEL_) != 0 || stringArray.length <= n5 + 1) {
                        KeyringDB.PrintUsage();
                    }
                    n5 += 2;
                }
                int n6 = n + 1;
                while (n6 < stringArray.length) {
                    if (stringArray[n6].toString().toLowerCase().compareTo(STR_CA) == 0 || stringArray[n6].toString().toLowerCase().compareTo(STR_CA_) == 0) {
                        if (stringArray.length >= n6 + 3 && (stringArray[n6 + 2].toString().toLowerCase().compareTo(STR_LABEL) == 0 || stringArray[n6 + 2].toString().toLowerCase().compareTo(STR_LABEL_) == 0)) {
                            string8 = stringArray[n6 + 3];
                        } else {
                            Date date = new Date();
                            string8 = "CA-400-" + date.toString();
                        }
                        try {
                            sSLightKeyDatabase.addCACertificate(string8, stringArray[n6 + 1], false);
                        }
                        catch (Exception exception) {
                            System.err.println("KeyringDB: Database Add CA Certificate failed:  " + string8 + "\n       " + exception);
                            System.exit(20);
                        }
                        sSLightKeyDatabase.save();
                        sSLightKeyDatabase.close();
                        System.out.println("**    Added  " + string8 + "  to KeyDatabase file " + string + "   **");
                    } else if (stringArray[n6].toString().toLowerCase().compareTo(STR_LABEL) != 0 && stringArray[n6].toString().toLowerCase().compareTo(STR_LABEL_) != 0) {
                        KeyringDB.PrintUsage();
                    }
                    n6 += 2;
                }
            } else if (stringArray[n].toString().toLowerCase().compareTo(STR_DELETE) == 0 || stringArray[n].toString().toLowerCase().compareTo(STR_DELETE_) == 0) {
                if (stringArray.length < n + 2 || stringArray[n + 1].toString().toLowerCase().compareTo(STR_LABEL) != 0 && stringArray[n + 1].toString().toLowerCase().compareTo(STR_LABEL_) != 0) {
                    KeyringDB.PrintUsage();
                }
                KeyringDB.OpenDB(sSLightKeyDatabase, string);
                if (!KeyringDB.doesLabelExist(sSLightKeyDatabase, stringArray[n + 2])) {
                    System.out.println("Cannot delete " + stringArray[n + 2].toString() + ", label does not exist in database.");
                    System.exit(10);
                }
                try {
                    sSLightKeyDatabase.deleteKeyByLabel(stringArray[n + 2].toString());
                }
                catch (Exception exception) {
                    System.err.println("Delete certificate " + stringArray[n + 2].toString() + "failed. \n       " + exception);
                    System.exit(20);
                }
                sSLightKeyDatabase.save();
                sSLightKeyDatabase.close();
                System.out.println("**    Deleted  " + stringArray[n + 2].toString() + "  from KeyDatabase file " + string + "   **");
            } else if (stringArray[n].toString().toLowerCase().compareTo(STR_CONNECT) == 0 || stringArray[n].toString().toLowerCase().compareTo(STR_CONNECT_) == 0) {
                if (stringArray.length <= n + 1) {
                    KeyringDB.PrintUsage();
                }
                String string9 = stringArray[n + 1];
                int n7 = 9476;
                int n8 = string9.indexOf(58);
                if (n8 != -1) {
                    try {
                        n7 = Integer.parseInt(string9.substring(n8 + 1));
                        string9 = string9.substring(0, n8);
                    }
                    catch (Exception exception) {
                        System.err.println("KeyringDB: wrong address format");
                        System.exit(10);
                    }
                }
                System.out.println("Connecting to " + string9 + ":" + n7);
                try {
                    KeyringDB.CreateDBClass(sSLightKeyDatabase);
                }
                catch (Exception exception) {}
                String string10 = string3.equals(FINGER_PRINT) ? string : String.valueOf(string3) + "." + string;
                int n9 = string10.lastIndexOf(46);
                KeyStore keyStore = new KeyStore();
                GrabCert grabCert = new GrabCert();
                boolean bl3 = true;
                string10 = string10.substring(0, n9);
                try {
                    SSLightKeyRing sSLightKeyRing = (SSLightKeyRing)Class.forName(string10).newInstance();
                    String string11 = sSLightKeyRing.getKeyRingData();
                    keyStore.engineLoad(string11, string4.toCharArray());
                    grabCert.importKeyRings(string11, string4);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println("Unexpected error.");
                }
                catch (Exception exception) {
                    System.err.println(CLASS_LOAD_FAILURE_MESSAGE);
                    throw exception;
                }
                try {
                    SSLCert[] sSLCertArray;
                    try {
                        sSLCertArray = grabCert.getPeerChain(string9, n7);
                    }
                    catch (Exception exception) {
                        System.err.println(exception.getMessage());
                        throw exception;
                    }
                    int n10 = 0;
                    while (n10 < sSLCertArray.length) {
                        System.out.println(String.valueOf(n10 == sSLCertArray.length - 1 ? SITE : CA) + CERTIFICATE_NUMBER + n10 + "\n");
                        KeyringDB.fingerPrint(sSLCertArray[n10]);
                        ++n10;
                    }
                    int n11 = KeyringDB.getSelectedCert();
                    if (n11 < 0 || n11 >= sSLCertArray.length) {
                        System.out.println("Selection " + (n11 == 99 ? "cancelled." : "out of range."));
                        System.exit(0);
                    }
                    X509Cert x509Cert = new X509Cert(sSLCertArray[n11].encode());
                    if (n11 == sSLCertArray.length - 1) {
                        keyStore.engineSetSiteCertificateEntry(KeyringDB.getAlias(keyStore), x509Cert);
                    } else {
                        keyStore.engineSetCertificateEntry(KeyringDB.getAlias(keyStore), x509Cert);
                    }
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(string2);
                        keyStore.engineStore((OutputStream)fileOutputStream, string4.toCharArray(), string10);
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        System.err.println(CLASS_STORE_FAILURE_MESSAGE);
                        throw exception;
                    }
                }
                catch (Exception exception) {
                    System.err.println("KeyringDB: Connection Failed: \n      " + exception);
                    System.exit(20);
                }
            }
            System.out.println("**    Successful   **");
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("KeyringDB: Something failed: " + exception);
            System.exit(20);
        }
    }
}

