/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.DialogAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VUtilities;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class OutputReplyAction
extends DialogAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String displayName_ = ResourceLoader.getText("ACTION_REPLY");
    private static final String replyText_ = ResourceLoader.getPrintText("REPLY") + ":";
    private static final String messageIDText_ = ResourceLoader.getPrintText("MESSAGE_ID") + ":";
    private static final String dateSentText_ = ResourceLoader.getPrintText("DATE_SENT") + ":";
    private static final String messageText_ = ResourceLoader.getPrintText("MESSAGE") + ":";
    private static final String messageHelpText_ = ResourceLoader.getPrintText("MESSAGE_HELP") + ":";
    private static DateFormat dateFormat_ = DateFormat.getDateTimeInstance();
    private SpooledFile splF_ = null;
    private AS400Message msg_ = null;
    private JTextField replyField_ = null;

    public OutputReplyAction(VObject vObject, SpooledFile spooledFile) {
        super(vObject);
        this.splF_ = spooledFile;
    }

    public JComponent getInputComponent() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        try {
            this.msg_ = this.splF_.getMessage();
            VUtilities.constrain(new JLabel(messageIDText_), jPanel, gridBagLayout, 0, 0, 1, 1);
            VUtilities.constrain(new JLabel(this.msg_.getID().trim()), jPanel, gridBagLayout, 1, 0, 1, 1);
            VUtilities.constrain(new JLabel(dateSentText_), jPanel, gridBagLayout, 0, 2, 1, 1);
            Date date = this.msg_.getDate().getTime();
            VUtilities.constrain(new JLabel(dateFormat_.format(date)), jPanel, gridBagLayout, 1, 2, 1, 1);
            VUtilities.constrain(new JLabel(" "), jPanel, gridBagLayout, 0, 3, 2, 1);
            VUtilities.constrain(new JLabel(messageText_), jPanel, gridBagLayout, 0, 4, 1, 1);
            VUtilities.constrain(new JLabel(this.msg_.getText().trim()), jPanel, gridBagLayout, 1, 4, 1, 1);
            VUtilities.constrain(new JLabel(" "), jPanel, gridBagLayout, 0, 5, 2, 1);
            String string = this.msg_.getHelp().trim();
            if (string != null) {
                VUtilities.constrain(new JLabel(messageHelpText_), jPanel, gridBagLayout, 0, 6, 1, 1);
                JTextArea jTextArea = new JTextArea(string);
                jTextArea.setEditable(false);
                jTextArea.setColumns(80);
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                VUtilities.constrain(jTextArea, jPanel, gridBagLayout, 1, 6, 1, 1);
            }
            VUtilities.constrain(new JLabel(replyText_), jPanel, gridBagLayout, 0, 7, 1, 1);
            this.replyField_ = new JTextField(this.msg_.getDefaultReply().trim());
            this.replyField_.setEditable(true);
            VUtilities.constrain(this.replyField_, jPanel, gridBagLayout, 1, 7, 1, 1);
        }
        catch (Exception exception) {
            jPanel = null;
            this.fireError(exception);
        }
        return jPanel;
    }

    public String getText() {
        return displayName_;
    }

    public void perform2() {
        try {
            String string = this.replyField_.getText().trim();
            this.fireStartWorking();
            this.splF_.answerMessage(string);
            this.fireStopWorking();
            if (Trace.isTraceOn()) {
                Trace.log(3, "Replied to file [" + this.splF_.getName() + "].");
            }
            this.fireObjectChanged();
        }
        catch (Exception exception) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "ERROR repling to file [" + this.splF_.getName() + "].");
            }
            this.fireError(exception);
        }
    }
}

