/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VIFSDirectory;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import javax.swing.CellEditor;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

class IFSDirectoryCreateAction
implements VAction,
CellEditorListener {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String newName_ = ResourceLoader.getText("IFS_NEW_DIRECTORY");
    private static final String text_ = ResourceLoader.getText("ACTION_DIRECTORY_CREATE");
    private IFSFile directory_ = null;
    private boolean enabled_ = true;
    private IFSFile newDirectory_ = null;
    private VIFSDirectory newObject_ = null;
    private VIFSDirectory object_ = null;
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public IFSDirectoryCreateAction(VIFSDirectory vIFSDirectory, IFSFile iFSFile) {
        this.directory_ = iFSFile;
        this.object_ = vIFSDirectory;
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public void editingCanceled(ChangeEvent changeEvent) {
    }

    public void editingStopped(ChangeEvent changeEvent) {
        CellEditor cellEditor = (CellEditor)changeEvent.getSource();
        cellEditor.removeCellEditorListener(this);
        String string = cellEditor.getCellEditorValue().toString();
        try {
            if (Trace.isTraceOn()) {
                Trace.log(3, "Renaming new directory [" + this.newDirectory_.getName() + "] to [" + string + "].");
            }
            this.newDirectory_.renameTo(new IFSFile(this.newDirectory_.getSystem(), this.newDirectory_.getParent(), string));
            this.objectEventSupport_.fireObjectChanged(this.newObject_);
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
    }

    public String getText() {
        return text_;
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void perform(VActionContext vActionContext) {
        try {
            int n = 1;
            boolean bl = false;
            AS400 aS400 = this.directory_.getSystem();
            this.newDirectory_ = new IFSFile(aS400, this.directory_, newName_);
            while (this.newDirectory_.exists()) {
                this.newDirectory_ = new IFSFile(aS400, this.directory_, newName_ + " (" + ++n + ")");
            }
            if (Trace.isTraceOn()) {
                Trace.log(3, "Creating new directory [" + this.newDirectory_.getName() + "].");
            }
            this.newDirectory_.mkdir();
            this.newObject_ = new VIFSDirectory(this.object_, this.newDirectory_);
            this.objectEventSupport_.fireObjectCreated(this.newObject_, this.object_);
            CellEditor cellEditor = vActionContext.startEditing(this.newObject_, VObject.NAME_PROPERTY);
            if (cellEditor != null) {
                cellEditor.addCellEditorListener(this);
            }
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setEnabled(boolean bl) {
        this.enabled_ = bl;
    }

    public String toString() {
        return this.getText();
    }
}

