/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400File;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.MemberDescription;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MemberList {
    private static final SimpleDateFormat dateTimeFormat_ = new SimpleDateFormat("yyMMddHHmmss");
    private static final String QUSLMBR_FORMAT_100 = "MBRL0100";
    private static final String QUSLMBR_FORMAT_200 = "MBRL0200";
    private static final QSYSObjectPathName USERSPACE_PATH = new QSYSObjectPathName("QTEMP", "JT4QUSLMBR", "USRSPC");
    private AS400 system_;
    private QSYSObjectPathName path_;
    private String memberSelection_ = "*ALL";
    private final Map memberDescriptions_ = new HashMap();
    private final List attributes_ = new ArrayList();
    private static final int OFFSET_MEMBER_NAME = 0;
    private static final int OFFSET_SOURCE_TYPE = 10;
    private static final int OFFSET_CREATION_DATE_TIME = 20;
    private static final int OFFSET_LAST_SOURCE_CHANGE_DATE = 33;
    private static final int OFFSET_MEMBER_TEXT_DESCRIPTION = 46;
    private static final int OFFSET_MEMBER_TEXT_DESCRIPTION_CCSID = 96;
    private final AS400Bin4 intConverter_ = new AS400Bin4();

    public MemberList(AS400File aS400File) {
        if (aS400File == null) {
            throw new NullPointerException("file");
        }
        this.system_ = aS400File.getSystem();
        this.path_ = new QSYSObjectPathName(aS400File.getLibraryName(), aS400File.getFileName(), "FILE");
        String string = aS400File.getMemberName();
        if (string != null && string.length() != 0) {
            if (string.startsWith("*")) {
                this.memberSelection_ = "*ALL";
                if (Trace.traceOn_) {
                    Trace.log(1, "Setting member selection to *ALL.  Member name from AS400File object:", string);
                }
            } else {
                this.memberSelection_ = string;
            }
        }
    }

    public MemberList(AS400 aS400, QSYSObjectPathName qSYSObjectPathName) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (qSYSObjectPathName == null) {
            throw new NullPointerException("path");
        }
        this.system_ = aS400;
        this.path_ = qSYSObjectPathName;
        String string = this.path_.getMemberName();
        if (string == null || string.length() == 0) {
            this.memberSelection_ = "*ALL";
            if (Trace.traceOn_) {
                Trace.log(1, "Setting member selection to *ALL.  Member name from QSYSObjectPathName object is: " + string);
            }
        } else {
            this.memberSelection_ = string;
        }
    }

    public MemberList(AS400 aS400, String string, String string2) {
        this(aS400, new QSYSObjectPathName(string, string2, "FILE"));
    }

    private String lookupFormat(int n) {
        String string;
        switch (n) {
            case 3: {
                string = QUSLMBR_FORMAT_100;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 26: {
                string = QUSLMBR_FORMAT_200;
                break;
            }
            default: {
                if (Trace.traceOn_) {
                    Trace.log(4, "Unrecognized attribute key:", n);
                }
                string = QUSLMBR_FORMAT_200;
            }
        }
        return string;
    }

    public void clear() {
        this.memberDescriptions_.clear();
    }

    public void clearAttributeList() {
        this.attributes_.clear();
    }

    public void addAttribute(int n) {
        this.attributes_.add(new Integer(n));
    }

    public void refresh() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.clear();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QUSLMBR.PGM", this.buildProgramParameters(this.getFormat()));
        boolean bl = programCall.isStayOnThread();
        Serializable serializable = bl ? USERSPACE_PATH : this.system_;
        Serializable serializable2 = serializable;
        synchronized (serializable2) {
            UserSpace userSpace = new UserSpace(this.system_, USERSPACE_PATH.getPath());
            userSpace.setMustUseProgramCall(true);
            if (!bl) {
                userSpace.setMustUseSockets(true);
            }
            try {
                userSpace.create(65535, true, "JT400", (byte)0, "Userspace for loading members", "*ALL");
                if (!programCall.run()) {
                    throw new AS400Exception(programCall.getMessageList());
                }
                byte[] byArray = new byte[65535];
                int n = userSpace.read(byArray, 0, 0, 144);
                if (n < 144) {
                    Trace.log(2, "Failed to read the generic header.  Number of bytes read: " + n);
                    throw new InternalErrorException(6, n);
                }
                int n2 = BinaryConverter.byteArrayToInt(byArray, 116);
                int n3 = BinaryConverter.byteArrayToInt(byArray, 120);
                int n4 = BinaryConverter.byteArrayToInt(byArray, 124);
                int n5 = BinaryConverter.byteArrayToInt(byArray, 128);
                int n6 = BinaryConverter.byteArrayToInt(byArray, 132);
                int n7 = BinaryConverter.byteArrayToInt(byArray, 136);
                int n8 = BinaryConverter.byteArrayToInt(byArray, 140);
                if (n8 == 0) {
                    n8 = this.system_.getCcsid();
                }
                CharConverter charConverter = new CharConverter(n8);
                n = userSpace.read(byArray, n2, 0, n3);
                if (n < n3) {
                    Trace.log(2, "Failed to read the header section.  Number of bytes read: " + n);
                    throw new InternalErrorException(6, n);
                }
                String string = charConverter.byteArrayToString(byArray, 10, 10).trim();
                if (n5 > byArray.length) {
                    byArray = new byte[n5 + 1];
                }
                if ((n = userSpace.read(byArray, n4, 0, n5)) < n5) {
                    Trace.log(2, "Failed to read the list data section.  Number of bytes read: " + n);
                    throw new InternalErrorException(6, n);
                }
                String string2 = this.getFormat();
                for (int i = 0; i < n6; ++i) {
                    byte[] byArray2 = new byte[n7];
                    System.arraycopy(byArray, i * n7, byArray2, 0, n7);
                    this.readMemberInfoFromUserspaceEntry(byArray2, string2, charConverter, string);
                }
            }
            finally {
                try {
                    userSpace.delete();
                }
                catch (Exception exception) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)exception);
                }
            }
        }
    }

    private ProgramParameter[] buildProgramParameters(String string) throws UnsupportedEncodingException {
        CharConverter charConverter = new CharConverter(this.system_.getCcsid(), this.system_);
        ProgramParameter[] programParameterArray = new ProgramParameter[6];
        programParameterArray[0] = new ProgramParameter(CharConverter.stringToByteArray(this.system_, USERSPACE_PATH.toQualifiedObjectName()));
        programParameterArray[1] = new ProgramParameter(CharConverter.stringToByteArray(this.system_, string));
        programParameterArray[2] = new ProgramParameter(CharConverter.stringToByteArray(this.system_, this.path_.toQualifiedObjectName()));
        programParameterArray[3] = new ProgramParameter(new AS400Text(10).toBytes(this.memberSelection_));
        programParameterArray[4] = new ProgramParameter(CharConverter.stringToByteArray(this.system_, "1"));
        programParameterArray[5] = new ErrorCodeParameter();
        return programParameterArray;
    }

    private void readMemberInfoFromUserspaceEntry(byte[] byArray, String string, CharConverter charConverter, String string2) {
        String string3 = charConverter.byteArrayToString(byArray, 0, 10).trim();
        MemberDescription memberDescription = (MemberDescription)this.memberDescriptions_.get(string3);
        if (memberDescription == null) {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(this.path_.getPath());
            try {
                qSYSObjectPathName.setMemberName(string3);
                qSYSObjectPathName.setLibraryName(string2);
            }
            catch (PropertyVetoException propertyVetoException) {
                Trace.log(2, "Error ignored.", (Throwable)propertyVetoException);
            }
            memberDescription = new MemberDescription(this.system_, qSYSObjectPathName);
            memberDescription.setAttribute(3, string3);
            this.memberDescriptions_.put(string3, memberDescription);
        }
        if (QUSLMBR_FORMAT_200.equals(string)) {
            memberDescription.setAttribute(5, charConverter.byteArrayToString(byArray, 10, 10).trim());
            memberDescription.setAttribute(8, charConverter.byteArrayToString(byArray, 46, 50).trim());
            memberDescription.setAttribute(26, new Integer(this.intConverter_.toInt(byArray, 96)));
            memberDescription.setAttribute(7, this.transformDate(charConverter.byteArrayToString(byArray, 33, 13)));
            memberDescription.setAttribute(6, this.transformDate(charConverter.byteArrayToString(byArray, 20, 13)));
        }
    }

    public MemberDescription[] getMemberDescriptions() {
        return this.memberDescriptions_.values().toArray(new MemberDescription[this.memberDescriptions_.size()]);
    }

    private String getFormat() {
        String string = QUSLMBR_FORMAT_100;
        Iterator iterator = this.attributes_.iterator();
        while (iterator.hasNext()) {
            String string2 = this.lookupFormat((Integer)iterator.next());
            if (string.compareTo(string2) >= 0) continue;
            string = string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date transformDate(String string) {
        Date date;
        block6: {
            date = null;
            if (string != null && string.length() != 0) {
                try {
                    SimpleDateFormat simpleDateFormat = dateTimeFormat_;
                    synchronized (simpleDateFormat) {
                        date = dateTimeFormat_.parse(string.substring(1));
                    }
                }
                catch (ParseException parseException) {
                    if (!Trace.traceOn_) break block6;
                    Trace.log(2, "Ignored error while parsing date string: " + string, (Throwable)parseException);
                }
            }
        }
        return date;
    }
}

