/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceGenerator
implements PersistentIdentifierGenerator,
Configurable {
    private static final Logger log = LoggerFactory.getLogger((Class)SequenceGenerator.class);
    public static final String SEQUENCE = "sequence";
    public static final String PARAMETERS = "parameters";
    private String sequenceName;
    private String parameters;
    private Type identifierType;
    private String sql;

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        this.sequenceName = normalizer.normalizeIdentifierQuoting(PropertiesHelper.getString(SEQUENCE, params, "hibernate_sequence"));
        this.parameters = params.getProperty(PARAMETERS);
        if (this.sequenceName.indexOf(46) < 0) {
            String schemaName = normalizer.normalizeIdentifierQuoting(params.getProperty("schema"));
            String catalogName = normalizer.normalizeIdentifierQuoting(params.getProperty("catalog"));
            this.sequenceName = Table.qualify(dialect.quote(catalogName), dialect.quote(schemaName), dialect.quote(this.sequenceName));
        }
        this.identifierType = type;
        this.sql = dialect.getSequenceNextValString(this.sequenceName);
    }

    public Serializable generate(SessionImplementor session, Object obj) {
        return this.generateHolder(session).makeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IntegralDataTypeHolder generateHolder(SessionImplementor session) {
        try {
            IntegralDataTypeHolder integralDataTypeHolder;
            PreparedStatement st = session.getBatcher().prepareSelectStatement(this.sql);
            try {
                ResultSet rs = st.executeQuery();
                try {
                    rs.next();
                    IntegralDataTypeHolder result = this.buildHolder();
                    result.initialize(rs, 1L);
                    if (log.isDebugEnabled()) {
                        log.debug("Sequence identifier generated: " + result);
                    }
                    integralDataTypeHolder = result;
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                session.getBatcher().closeStatement(st);
                throw throwable;
            }
            session.getBatcher().closeStatement(st);
            return integralDataTypeHolder;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not get next sequence value", this.sql);
        }
    }

    protected IntegralDataTypeHolder buildHolder() {
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.identifierType.getReturnedClass());
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        String[] ddl = dialect.getCreateSequenceStrings(this.sequenceName);
        if (this.parameters != null) {
            int n = ddl.length - 1;
            ddl[n] = ddl[n] + ' ' + this.parameters;
        }
        return ddl;
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return dialect.getDropSequenceStrings(this.sequenceName);
    }

    public Object generatorKey() {
        return this.sequenceName;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }
}

