/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Permission;
import com.ibm.as400.access.RootPermission;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import com.ibm.as400.vaccess.PermissionMainPanel;
import com.ibm.as400.vaccess.PermissionNameCellObject;
import com.ibm.as400.vaccess.ResourceLoader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

class PermissionTableModelRoot
extends DefaultTableModel {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Permission permission_;
    private Vector userPermissions_;
    private JTable table_;
    private PermissionMainPanel mainPanel_;
    private int selectedColumn_ = 1;
    private boolean read = false;
    private boolean write = false;
    private boolean execute = false;
    private String[] columnNames_;
    private static String addUserExceptionDialogMessage_;
    private static String addUserExceptionDialogTitle_;

    public PermissionTableModelRoot(PermissionMainPanel permissionMainPanel, Permission permission) {
        this.initializeTable();
        this.mainPanel_ = permissionMainPanel;
        this.permission_ = permission;
        Enumeration enumeration = this.permission_.getUserPermissions();
        this.userPermissions_ = new Vector();
        while (enumeration.hasMoreElements()) {
            this.userPermissions_.addElement(enumeration.nextElement());
        }
    }

    public void addRow(String string) {
        try {
            this.permission_.addAuthorizedUser(string);
            this.mainPanel_.getApplyButton().setEnabled(true);
            this.table_.clearSelection();
            Enumeration enumeration = this.permission_.getUserPermissions();
            this.userPermissions_ = new Vector();
            while (enumeration.hasMoreElements()) {
                this.userPermissions_.addElement(enumeration.nextElement());
            }
            int n = this.userPermissions_.size() - 1;
            this.fireTableRowsInserted(n, n);
        }
        catch (ExtendedIllegalArgumentException extendedIllegalArgumentException) {
            Trace.log(2, "Error in addRow : " + extendedIllegalArgumentException);
            this.mainPanel_.fireError(extendedIllegalArgumentException);
        }
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public int getColumnCount() {
        return this.columnNames_.length;
    }

    public String getColumnName(int n) {
        return this.columnNames_[n];
    }

    public int getRowCount() {
        if (this.userPermissions_ == null) {
            return 0;
        }
        return this.userPermissions_.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.userPermissions_.size()) {
            return null;
        }
        if (this.selectedColumn_ > 0) {
            this.table_.clearSelection();
        } else if (this.table_.getSelectedRow() >= 0 && this.table_.getSelectedRowCount() > 0) {
            this.mainPanel_.getRemoveButton().setEnabled(true);
        }
        RootPermission rootPermission = null;
        rootPermission = (RootPermission)this.userPermissions_.elementAt(n);
        String string = rootPermission.getDataAuthority().toUpperCase();
        Object object = null;
        switch (n2) {
            case 0: {
                object = new PermissionNameCellObject(rootPermission.getUserID(), rootPermission.getGroupIndicator());
                break;
            }
            case 1: {
                object = new Boolean(string.indexOf("R") > -1);
                break;
            }
            case 2: {
                object = new Boolean(string.indexOf("W") > -1);
                break;
            }
            case 3: {
                object = new Boolean(string.indexOf("X") > -1 && string.indexOf("E") == -1);
                break;
            }
            case 4: {
                object = new Boolean(rootPermission.isManagement());
                break;
            }
            case 5: {
                object = new Boolean(rootPermission.isExistence());
                break;
            }
            case 6: {
                object = new Boolean(rootPermission.isAlter());
                break;
            }
            case 7: {
                object = new Boolean(rootPermission.isReference());
                break;
            }
            case 8: {
                object = new Boolean(rootPermission.isFromAuthorizationList());
            }
        }
        return object;
    }

    private void initializeTable() {
        this.columnNames_ = new String[9];
        this.columnNames_[0] = ResourceLoader.getText("OBJECT_USER_NAME");
        this.columnNames_[1] = ResourceLoader.getText("OBJECT_AUTHORITY_READ");
        this.columnNames_[2] = ResourceLoader.getText("OBJECT_AUTHORITY_WRITE");
        this.columnNames_[3] = ResourceLoader.getText("OBJECT_AUTHORITY_EXECUTE");
        this.columnNames_[4] = ResourceLoader.getText("OBJECT_AUTHORITY_MANAGEMENT");
        this.columnNames_[5] = ResourceLoader.getText("OBJECT_AUTHORITY_EXISTENCE");
        this.columnNames_[6] = ResourceLoader.getText("OBJECT_AUTHORITY_ALTER");
        this.columnNames_[7] = ResourceLoader.getText("OBJECT_AUTHORITY_REFERENCE");
        this.columnNames_[8] = ResourceLoader.getText("OBJECT_FROM_AUTHORIZATION_LIST");
        addUserExceptionDialogMessage_ = ResourceLoader.getText("OBJECT_ADD_USER_EXCEPTION_DIALOG_MESSAGE");
        addUserExceptionDialogTitle_ = ResourceLoader.getText("OBJECT_ADD_USER_EXCEPTION_DIALOG_TITLE");
    }

    public boolean isCellEditable(int n, int n2) {
        this.selectedColumn_ = n2;
        switch (n2) {
            case 0: {
                return false;
            }
            case 8: {
                UserPermission userPermission = (UserPermission)this.userPermissions_.elementAt(n);
                if (!this.mainPanel_.getAutList().toUpperCase().equals("*NONE") && userPermission.getUserID().toUpperCase().equals("*PUBLIC")) break;
                return false;
            }
        }
        return true;
    }

    public void removeRow(int n) {
        this.table_.clearSelection();
        RootPermission rootPermission = (RootPermission)this.userPermissions_.elementAt(n);
        this.permission_.removeAuthorizedUser(rootPermission.getUserID());
        Enumeration enumeration = this.permission_.getUserPermissions();
        this.userPermissions_ = new Vector();
        while (enumeration.hasMoreElements()) {
            this.userPermissions_.addElement(enumeration.nextElement());
        }
        this.fireTableRowsDeleted(n, n);
    }

    void resetPublicAuthorizationList() {
        UserPermission userPermission = this.permission_.getUserPermission("*PUBLIC");
        int n = this.userPermissions_.indexOf(userPermission);
        if (n >= 0) {
            this.setValueAt(new Boolean(false), n, 8);
        }
    }

    public void setTableInstance(JTable jTable) {
        this.table_ = jTable;
    }

    public void setValueAt(Object object, int n, int n2) {
        this.mainPanel_.getRemoveButton().setEnabled(false);
        RootPermission rootPermission = (RootPermission)this.userPermissions_.elementAt(n);
        String string = rootPermission.getDataAuthority().trim();
        if (string.equals("*EXCLUDE") || string.equals("*NONE")) {
            this.read = false;
            this.write = false;
            this.execute = false;
        } else {
            this.read = string.indexOf("R") > -1;
            this.write = string.indexOf("W") > -1;
            this.execute = string.indexOf("X") > -1;
        }
        String string2 = "*";
        switch (n2) {
            case 1: {
                this.read = (Boolean)object;
                if (this.read) {
                    string2 = string2 + "R";
                }
                if (this.write) {
                    string2 = string2 + "W";
                }
                if (this.execute) {
                    string2 = string2 + "X";
                }
                if (string2.equals("*")) {
                    string2 = string2 + "NONE";
                }
                rootPermission.setDataAuthority(string2);
                break;
            }
            case 2: {
                this.write = (Boolean)object;
                if (this.read) {
                    string2 = string2 + "R";
                }
                if (this.write) {
                    string2 = string2 + "W";
                }
                if (this.execute) {
                    string2 = string2 + "X";
                }
                if (string2.equals("*")) {
                    string2 = string2 + "NONE";
                }
                rootPermission.setDataAuthority(string2);
                break;
            }
            case 3: {
                this.execute = (Boolean)object;
                if (this.read) {
                    string2 = string2 + "R";
                }
                if (this.write) {
                    string2 = string2 + "W";
                }
                if (this.execute) {
                    string2 = string2 + "X";
                }
                if (string2.equals("*")) {
                    string2 = string2 + "NONE";
                }
                rootPermission.setDataAuthority(string2);
                break;
            }
            case 4: {
                boolean bl = (Boolean)object;
                rootPermission.setManagement(bl);
                break;
            }
            case 5: {
                boolean bl = (Boolean)object;
                rootPermission.setExistence(bl);
                break;
            }
            case 6: {
                boolean bl = (Boolean)object;
                rootPermission.setAlter(bl);
                break;
            }
            case 7: {
                boolean bl = (Boolean)object;
                rootPermission.setReference(bl);
                break;
            }
            case 8: {
                boolean bl = (Boolean)object;
                rootPermission.setFromAuthorizationList(bl);
            }
        }
        this.fireTableRowsUpdated(n, n);
        this.mainPanel_.getApplyButton().setEnabled(true);
    }
}

