/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;

public class AS400DateTimeConverter {
    protected static AS400 as400_;

    public AS400DateTimeConverter(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        as400_ = aS400;
    }

    public static byte[] convert(AS400 aS400, byte[] byArray, String string, String string2) {
        byte[] byArray2 = null;
        Trace.log(3, "convert");
        Trace.log(3, "parameters : " + byArray + " | " + byArray2 + " | " + string + " | " + string2);
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        ProgramCall programCall = new ProgramCall(aS400);
        try {
            String string3 = "/QSYS.LIB/QWCCVTDT.PGM";
            AS400Text aS400Text = new AS400Text(10);
            ProgramParameter[] programParameterArray = new ProgramParameter[5];
            programParameterArray[0] = new ProgramParameter(aS400Text.toBytes(string));
            programParameterArray[1] = new ProgramParameter(byArray);
            programParameterArray[2] = new ProgramParameter(aS400Text.toBytes(string2));
            programParameterArray[3] = new ProgramParameter(17);
            byte[] byArray3 = new byte[70];
            programParameterArray[4] = new ProgramParameter(byArray3);
            programCall.setProgram(string3, programParameterArray);
            programCall.suggestThreadsafe();
            if (!programCall.run()) {
                Trace.log(2, "program failed!");
                AS400Message[] aS400MessageArray = programCall.getMessageList();
                for (int i = 0; i < aS400MessageArray.length; ++i) {
                }
                throw new AS400Exception(aS400MessageArray);
            }
            byArray2 = programParameterArray[3].getOutputData();
        }
        catch (Exception exception) {
            Trace.log(2, "convert failed : " + exception);
        }
        return byArray2;
    }

    public static Date getDate(byte[] byArray, String string) {
        Trace.log(3, "getDate");
        String string2 = "*YYMD";
        byte[] byArray2 = AS400DateTimeConverter.convert(as400_, byArray, string, string2);
        RecordFormat recordFormat = new RecordFormat();
        CharacterFieldDescription[] characterFieldDescriptionArray = new CharacterFieldDescription[]{new CharacterFieldDescription(new AS400Text(4), "year"), new CharacterFieldDescription(new AS400Text(2), "month"), new CharacterFieldDescription(new AS400Text(2), "day"), new CharacterFieldDescription(new AS400Text(2), "hour"), new CharacterFieldDescription(new AS400Text(2), "minute"), new CharacterFieldDescription(new AS400Text(2), "second"), new CharacterFieldDescription(new AS400Text(3), "millisecond")};
        for (int i = 0; i < 7; ++i) {
            recordFormat.addFieldDescription(characterFieldDescriptionArray[i]);
        }
        try {
            Record record = recordFormat.getNewRecord(byArray2);
            Calendar calendar = AS400Calendar.getGregorianInstance();
            calendar.clear();
            calendar.set(Integer.parseInt(((String)record.getField("year")).trim()), Integer.parseInt(((String)record.getField("month")).trim()) - 1, Integer.parseInt(((String)record.getField("day")).trim()), Integer.parseInt(((String)record.getField("hour")).trim()), Integer.parseInt(((String)record.getField("minute")).trim()), Integer.parseInt(((String)record.getField("second")).trim()));
            return calendar.getTime();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.log(3, "convert Date/Time : " + unsupportedEncodingException);
            return null;
        }
    }

    public static byte[] getByteArray(Date date, String string) {
        Object object;
        Trace.log(3, "getByteArray");
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.setTime(date);
        RecordFormat recordFormat = new RecordFormat();
        CharacterFieldDescription[] characterFieldDescriptionArray = new CharacterFieldDescription[]{new CharacterFieldDescription(new AS400Text(4), "year"), new CharacterFieldDescription(new AS400Text(2), "month"), new CharacterFieldDescription(new AS400Text(2), "day"), new CharacterFieldDescription(new AS400Text(2), "hour"), new CharacterFieldDescription(new AS400Text(2), "minute"), new CharacterFieldDescription(new AS400Text(2), "second"), new CharacterFieldDescription(new AS400Text(3), "millisecond")};
        for (int i = 0; i < 7; ++i) {
            recordFormat.addFieldDescription(characterFieldDescriptionArray[i]);
        }
        Record record = recordFormat.getNewRecord();
        record.setField("year", (Object)Integer.toString(calendar.get(1)));
        record.setField("month", (Object)Integer.toString(calendar.get(2) + 1));
        record.setField("day", (Object)Integer.toString(calendar.get(5)));
        record.setField("hour", (Object)Integer.toString(calendar.get(11)));
        record.setField("minute", (Object)Integer.toString(calendar.get(12)));
        record.setField("second", (Object)Integer.toString(calendar.get(13)));
        record.setField("millisecond", (Object)Integer.toString(calendar.get(14)));
        byte[] byArray = null;
        try {
            byArray = record.getContents();
            object = new AS400Text(17);
        }
        catch (Exception exception) {
            Trace.log(2, "Error constructing program parameters");
        }
        object = "*YYMD";
        return AS400DateTimeConverter.convert(as400_, byArray, (String)object, string);
    }
}

