/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.LabelledComponent;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.SQLQueryBuilderPane;
import com.ibm.as400.vaccess.SQLQueryClause;
import com.ibm.as400.vaccess.ScrollingTextPane;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import com.ibm.as400.vaccess.WorkingEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;

class SQLQueryTablePane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private JButton tableButton_ = null;
    private JLabel catalog_ = null;
    private transient JTable tablesTable_;
    private boolean tablesShown_ = false;
    private JScrollPane tablesPane_;
    SQLQueryClause clause_;
    JDialog dialog_;
    private String catalogName_ = "";
    private DefaultTableModel tablesTableModel_;
    private String[] tables_;
    String[] schemas_;
    boolean userSelectTableSchemas_;
    private DefaultListModel schemaListModel_;
    private transient Connection connection_;
    boolean changes_ = false;
    private transient DocumentListener_ docListener_;
    private transient ErrorEventSupport errors_ = new ErrorEventSupport(this);
    private transient WorkingCursorAdapter worker_ = null;
    private transient WorkingEvent workEvent_ = null;
    SQLQueryBuilderPane parent_;
    private boolean enabled_ = true;
    private boolean buttonEnabled_;
    private boolean inited_ = false;

    public SQLQueryTablePane(SQLQueryBuilderPane sQLQueryBuilderPane, Connection connection, String[] stringArray, String[] stringArray2, boolean bl) {
        this.parent_ = sQLQueryBuilderPane;
        this.connection_ = connection;
        this.tables_ = stringArray;
        this.schemas_ = stringArray2;
        this.userSelectTableSchemas_ = bl;
        this.tablesTableModel_ = new DefaultTableModel(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.addFocusListener(new SerializationListener(this));
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errors_.addErrorListener(errorListener);
    }

    public void complete() {
        if (this.changes_) {
            if (this.clause_ != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.clause_.getText(), ",");
                Vector<String> vector = new Vector<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    vector.addElement(stringTokenizer.nextToken().trim());
                }
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                boolean bl = false;
                if (this.tables_.length == objectArray.length) {
                    for (int i = 0; i < this.tables_.length; ++i) {
                        if (this.tables_[i].equals(objectArray[i])) continue;
                        bl = true;
                        break;
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.tables_ = objectArray;
                }
            }
            this.changes_ = false;
        }
    }

    private void enableButton(boolean bl) {
        this.buttonEnabled_ = bl;
        if (this.enabled_) {
            this.tableButton_.setEnabled(bl);
        }
    }

    private void fillClause() {
        if (this.clause_ != null) {
            if (this.tables_.length > 0) {
                StringBuffer stringBuffer = new StringBuffer(this.tables_[0]);
                for (int i = 1; i < this.tables_.length; ++i) {
                    stringBuffer.append(", ");
                    stringBuffer.append(this.tables_[i]);
                }
                this.clause_.setText(stringBuffer.toString());
            } else {
                this.clause_.setText("");
            }
        }
    }

    public String[] getSchemas() {
        return this.schemas_;
    }

    public String[] getTables() {
        return this.tables_;
    }

    public void init() {
        this.setupPane();
        this.inited_ = true;
    }

    public void load() {
        if (this.tablesShown_) {
            this.tableButton_.setText(ResourceLoader.getQueryText("DBQUERY_BUTTON_DISPLAY_TABLES"));
            int n = this.tablesTableModel_.getRowCount();
            while (n > 0) {
                this.tablesTableModel_.removeRow(--n);
            }
            this.tablesShown_ = false;
        }
        if (this.connection_ != null) {
            this.enableButton(true);
            try {
                this.catalog_.setText(this.connection_.getCatalog());
            }
            catch (SQLException sQLException) {
                this.errors_.fireError(sQLException);
            }
        } else {
            this.enableButton(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void loadTables() {
        this.worker_.startWorking(this.workEvent_);
        if (!this.tablesShown_) {
            this.tableButton_.setText(ResourceLoader.getQueryText("DBQUERY_BUTTON_CHANGE_SCHEMAS"));
            if (this.userSelectTableSchemas_) {
                this.enableButton(true);
            } else {
                this.enableButton(false);
            }
            this.tablesShown_ = true;
        }
        int n = this.tablesTableModel_.getRowCount();
        while (n > 0) {
            this.tablesTableModel_.removeRow(--n);
        }
        ResultSet resultSet = null;
        DatabaseMetaData databaseMetaData = this.connection_.getMetaData();
        resultSet = databaseMetaData.getTableTypes();
        Vector<String> vector = new Vector<String>();
        while (resultSet.next()) {
            vector.addElement(resultSet.getString(1));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        for (int i = 0; i < this.schemas_.length; ++i) {
            String string = this.schemas_[i];
            resultSet = databaseMetaData.getTables(null, string, "%", (String[])objectArray);
            Object[] objectArray2 = new String[4];
            while (resultSet.next()) {
                objectArray2[0] = resultSet.getString(2) != null ? resultSet.getString(2).trim() : "";
                objectArray2[1] = resultSet.getString(3).trim();
                objectArray2[2] = resultSet.getString(4);
                objectArray2[3] = resultSet.getString(5) != null ? resultSet.getString(5).trim() : "";
                this.tablesTableModel_.addRow(objectArray2);
            }
        }
        Object var9_10 = null;
        this.worker_.stopWorking(this.workEvent_);
        if (resultSet == null) return;
        try {
            resultSet.close();
            return;
        }
        catch (SQLException sQLException) {
            this.errors_.fireError(sQLException);
        }
        return;
        {
            catch (SQLException sQLException) {
                this.errors_.fireError(sQLException);
                Object var9_11 = null;
                this.worker_.stopWorking(this.workEvent_);
                if (resultSet == null) return;
                try {
                    resultSet.close();
                    return;
                }
                catch (SQLException sQLException2) {
                    this.errors_.fireError(sQLException2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.worker_.stopWorking(this.workEvent_);
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                this.errors_.fireError(sQLException);
            }
            throw throwable;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.errors_ = new ErrorEventSupport(this);
        this.connection_ = null;
        this.addFocusListener(new SerializationListener(this));
        if (this.inited_) {
            this.init();
        }
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errors_.removeErrorListener(errorListener);
    }

    protected void rowPicked(int n) {
        String string = this.tablesTable_.getValueAt(n, 0) + "." + this.tablesTable_.getValueAt(n, 1);
        if (this.clause_ != null) {
            this.clause_.appendTextWithComma(string);
        }
    }

    public void setConnection(Connection connection) {
        this.connection_ = connection;
    }

    public void setEnabled(boolean bl) {
        this.enabled_ = bl;
        if (this.clause_ != null) {
            this.clause_.setEditable(bl);
        }
        this.tablesTable_.setEnabled(bl);
        if (this.buttonEnabled_) {
            this.tableButton_.setEnabled(bl);
        }
    }

    public void setTables(String[] stringArray) {
        this.tables_ = stringArray;
        this.fillClause();
    }

    public void setSchemas(String[] stringArray) {
        this.schemas_ = stringArray;
        if (this.dialog_ != null) {
            this.schemaListModel_.removeAllElements();
            for (int i = 0; i < this.schemas_.length; ++i) {
                this.schemaListModel_.addElement(this.schemas_[i]);
            }
        }
    }

    public void setUserSelectTableSchemas(boolean bl) {
        this.userSelectTableSchemas_ = bl;
        if (this.tablesShown_ && this.tableButton_ != null) {
            if (this.userSelectTableSchemas_) {
                this.enableButton(true);
            } else {
                this.enableButton(false);
            }
        }
    }

    private void setupPane() {
        JLabel jLabel = new JLabel(ResourceLoader.getQueryText("DBQUERY_LABEL_CATALOG"));
        this.catalog_ = new JLabel(this.catalogName_);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        box.add(jLabel);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.catalog_);
        box.add(Box.createHorizontalGlue());
        this.tableButton_ = new JButton(ResourceLoader.getQueryText("DBQUERY_BUTTON_DISPLAY_TABLES"));
        if (this.connection_ != null) {
            this.enableButton(true);
        } else {
            this.enableButton(false);
        }
        this.tableButton_.addActionListener(new ButtonListener_());
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalStrut(5));
        box2.add(this.tableButton_);
        box2.add(Box.createHorizontalGlue());
        this.worker_ = new WorkingCursorAdapter(this);
        this.workEvent_ = new WorkingEvent(this);
        String string = ResourceLoader.getQueryText("DBQUERY_COLUMN_TABLE_SCHEMA");
        this.tablesTableModel_.addColumn(string);
        string = ResourceLoader.getQueryText("DBQUERY_COLUMN_TABLE_NAME");
        this.tablesTableModel_.addColumn(string);
        string = ResourceLoader.getQueryText("DBQUERY_COLUMN_TABLE_TYPE");
        this.tablesTableModel_.addColumn(string);
        string = ResourceLoader.getQueryText("DBQUERY_COLUMN_TABLE_TEXT");
        this.tablesTableModel_.addColumn(string);
        this.tablesTable_ = new JTable(this.tablesTableModel_);
        this.tablesTable_.setName("tableTableTable");
        this.tablesTable_.setAutoResizeMode(3);
        this.tablesTable_.setShowGrid(false);
        this.tablesTable_.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.tablesTable_.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.tablesTable_.getColumnModel().getColumn(2).setPreferredWidth(70);
        this.tablesTable_.getColumnModel().getColumn(3).setPreferredWidth(180);
        this.tablesPane_ = new JScrollPane(this.tablesTable_);
        this.tablesPane_.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), this.tablesPane_.getBorder()));
        final JTable jTable = this.tablesTable_;
        jTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() > 1 && (n = jTable.rowAtPoint(mouseEvent.getPoint())) != -1) {
                    SQLQueryTablePane.this.rowPicked(n);
                }
            }
        });
        this.clause_ = new SQLQueryClause(5);
        this.fillClause();
        boolean bl = this.tables_.length != 0;
        boolean bl2 = this.parent_.getSelectedItems().length != 0;
        this.docListener_ = new DocumentListener_(bl, bl2);
        this.clause_.getDocument().addDocumentListener(this.docListener_);
        Box box3 = Box.createVerticalBox();
        box3.add(Box.createVerticalStrut(10));
        box3.add(box);
        box3.add(Box.createVerticalStrut(10));
        box3.add(box2);
        box3.add(Box.createVerticalStrut(10));
        box3.add(this.tablesPane_);
        box3.add(Box.createVerticalStrut(10));
        box3.add(new LabelledComponent("DBQUERY_LABEL_TABLES", new ScrollingTextPane(this.clause_)));
        this.setLayout(new BorderLayout());
        this.add("Center", box3);
    }

    void setupSchemaDialog() {
        JLabel jLabel = new JLabel(ResourceLoader.getQueryText("DBQUERY_TEXT_SCHEMAS"));
        JLabel jLabel2 = new JLabel(ResourceLoader.getQueryText("DBQUERY_TEXT_SCHEMAS2"));
        jLabel.setBorder(new EmptyBorder(10, 10, 5, 10));
        jLabel2.setBorder(new EmptyBorder(5, 10, 10, 10));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("North", jLabel);
        jPanel.add("South", jLabel2);
        jPanel.getAccessibleContext().setAccessibleName("PROMPT");
        final JTextField jTextField = new JTextField(12);
        this.schemaListModel_ = new DefaultListModel();
        for (int i = 0; i < this.schemas_.length; ++i) {
            this.schemaListModel_.addElement(this.schemas_[i]);
        }
        final JList jList = new JList(this.schemaListModel_);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jList.setSelectionMode(2);
        final DefaultListModel defaultListModel = this.schemaListModel_;
        JButton jButton = new JButton(ResourceLoader.getQueryText("DBQUERY_BUTTON_ADD"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText();
                if (!string.equals("")) {
                    defaultListModel.addElement(string);
                    jTextField.setText("");
                }
            }
        });
        JButton jButton2 = new JButton(ResourceLoader.getQueryText("DBQUERY_BUTTON_REMOVE"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = jList.getSelectedIndices();
                int n = nArray.length;
                while (n > 0) {
                    defaultListModel.removeElementAt(nArray[--n]);
                }
            }
        });
        JButton jButton3 = new JButton(ResourceLoader.getQueryText("DBQUERY_BUTTON_OK"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = defaultListModel.toArray();
                String[] stringArray = new String[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = (String)objectArray[i];
                }
                SQLQueryTablePane.this.schemas_ = stringArray;
                SQLQueryTablePane.this.loadTables();
                SQLQueryTablePane.this.dialog_.dispose();
            }
        });
        JButton jButton4 = new JButton(ResourceLoader.getQueryText("DBQUERY_BUTTON_CANCEL"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                defaultListModel.removeAllElements();
                for (int i = 0; i < SQLQueryTablePane.this.schemas_.length; ++i) {
                    defaultListModel.addElement(SQLQueryTablePane.this.schemas_[i]);
                }
                SQLQueryTablePane.this.dialog_.dispose();
            }
        });
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.getAccessibleContext().setAccessibleName("BODY");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        VUtilities.constrain(jTextField, jPanel2, gridBagLayout, gridBagConstraints, 0, 1, 100, 0, 1, 0, 1, 10);
        VUtilities.constrain(jButton, jPanel2, gridBagLayout, gridBagConstraints, 1, 1, 0, 0, 1, 0, 2, 10);
        VUtilities.constrain(jScrollPane, jPanel2, gridBagLayout, gridBagConstraints, 0, 1, 100, 1, 1, 100, 1, 10);
        VUtilities.constrain(jButton2, jPanel2, gridBagLayout, gridBagConstraints, 1, 1, 0, 1, 1, 100, 2, 10);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton3);
        jPanel3.add(jButton4);
        jPanel3.getAccessibleContext().setAccessibleName("BUTTON");
        this.dialog_ = new JDialog(VUtilities.getFrame(this), ResourceLoader.getQueryText("DBQUERY_TITLE_SCHEMAS"), true);
        this.dialog_.getContentPane().setLayout(new BorderLayout());
        this.dialog_.getContentPane().add("North", jPanel);
        this.dialog_.getContentPane().add("Center", jPanel2);
        this.dialog_.getContentPane().add("South", jPanel3);
        this.dialog_.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SQLQueryTablePane.this.dialog_.dispose();
            }
        });
        this.dialog_.pack();
        this.dialog_.setLocationRelativeTo(this);
        this.dialog_.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                for (int i = 0; i < SQLQueryTablePane.this.dialog_.getContentPane().getComponentCount(); ++i) {
                    JComponent jComponent = (JComponent)SQLQueryTablePane.this.dialog_.getContentPane().getComponent(i);
                    if (!jComponent.getAccessibleContext().getAccessibleName().equals("BODY")) continue;
                    for (int j = 0; j < jComponent.getComponentCount(); ++j) {
                        if (!(jComponent.getComponent(j) instanceof JTextField)) continue;
                        jComponent.getComponent(j).requestFocus();
                        return;
                    }
                    return;
                }
            }
        });
    }

    void update() {
        boolean bl = this.docListener_.enableOrder_ = this.parent_.getSelectedItems().length != 0;
        if (this.docListener_.enableOrder_) {
            this.parent_.notebook_.setEnabledAt(6, true);
        }
    }

    private class ButtonListener_
    implements ActionListener {
        private ButtonListener_() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SQLQueryTablePane.this.userSelectTableSchemas_) {
                if (SQLQueryTablePane.this.dialog_ == null) {
                    SQLQueryTablePane.this.setupSchemaDialog();
                }
                ((Component)SQLQueryTablePane.this.dialog_).setVisible(true);
            } else {
                SQLQueryTablePane.this.loadTables();
            }
        }
    }

    private class DocumentListener_
    implements DocumentListener {
        boolean enableOrder_;
        boolean enabled_;

        public DocumentListener_(boolean bl, boolean bl2) {
            this.enabled_ = bl;
            this.enableOrder_ = bl2;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            int n;
            SQLQueryTablePane.this.changes_ = true;
            String string = SQLQueryTablePane.this.clause_.getText();
            if (!this.enabled_ && !string.equals("")) {
                this.enabled_ = true;
                SQLQueryBuilderPane cfr_ignored_0 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(1, true);
                SQLQueryBuilderPane cfr_ignored_1 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(3, true);
                SQLQueryBuilderPane cfr_ignored_2 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(4, true);
                SQLQueryBuilderPane cfr_ignored_3 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(5, true);
                SQLQueryBuilderPane cfr_ignored_4 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(2, true);
                if (this.enableOrder_) {
                    SQLQueryBuilderPane cfr_ignored_5 = SQLQueryTablePane.this.parent_;
                    SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(6, true);
                }
            }
            if ((n = string.indexOf(",")) == -1 || n == string.length() - 1) {
                SQLQueryBuilderPane cfr_ignored_6 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(2, false);
            } else {
                SQLQueryBuilderPane cfr_ignored_7 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(2, true);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            SQLQueryTablePane.this.changes_ = true;
            String string = SQLQueryTablePane.this.clause_.getText();
            if (string.equals("")) {
                this.enabled_ = false;
                SQLQueryBuilderPane cfr_ignored_0 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(1, false);
                SQLQueryBuilderPane cfr_ignored_1 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(3, false);
                SQLQueryBuilderPane cfr_ignored_2 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(4, false);
                SQLQueryBuilderPane cfr_ignored_3 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(5, false);
                SQLQueryBuilderPane cfr_ignored_4 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(2, false);
                SQLQueryBuilderPane cfr_ignored_5 = SQLQueryTablePane.this.parent_;
                SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(6, false);
            } else {
                int n = string.indexOf(",");
                if (n == -1 || n == string.length() - 1) {
                    SQLQueryBuilderPane cfr_ignored_6 = SQLQueryTablePane.this.parent_;
                    SQLQueryTablePane.this.parent_.notebook_.setEnabledAt(2, false);
                }
            }
        }
    }
}

