/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;

class ConvTable1208
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";

    ConvTable1208() {
        super(1208);
    }

    final String byteArrayToString(byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) {
        if (Trace.traceOn_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, byArray, n, n2);
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            int n4 = byArray[i] & 0xFF;
            int n5 = 0;
            if ((n4 & 0x80) == 0) {
                n5 = n4;
            } else if ((n4 & 0xE0) == 192) {
                n5 = (n4 & 0x1F) << 6;
                n5 |= byArray[++i] & 0x3F;
            } else if ((n4 & 0xF0) == 224) {
                n5 = (n4 & 0xF) << 12;
                n5 |= (byArray[++i] & 0x3F) << 6;
                n5 |= byArray[++i] & 0x3F;
            } else {
                n5 = (n4 & 7) << 18;
                n5 |= (byArray[++i] & 0x3F) << 12;
                n5 |= (byArray[++i] & 0x3F) << 6;
                n5 |= byArray[++i] & 0x3F;
            }
            if (n5 > 65535) {
                cArray[n3++] = (char)((n5 - 65536) / 1024 + 55296);
                cArray[n3++] = (char)((n5 - 65536) % 1024 + 56320);
                continue;
            }
            cArray[n3++] = (char)n5;
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    final byte[] stringToByteArray(String string, BidiConversionProperties bidiConversionProperties) {
        if (Trace.traceOn_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(string.toCharArray(), 0, string.length()));
        }
        int n = string.length();
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = string.charAt(i) & 0xFFFF;
            if (n3 > 55295 && n3 < 56320) {
                if (++i < n) {
                    n3 = (n3 - 55296) * 1024 + ((string.charAt(i) & 0xFFFF) - 56320) + 65536;
                } else {
                    if (!CharConverter.isFaultTolerantConversion()) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(byArray, 0, byArray2, 0, n2);
                    if (Trace.traceOn_) {
                        Trace.log(5, "Fault-tolerant in mid-surrogate. Destination byte array for ccsid: " + this.ccsid_, byArray2);
                    }
                    return byArray2;
                }
            }
            if (n3 < 128) {
                byArray[n2++] = (byte)n3;
                continue;
            }
            if (n3 < 2048) {
                byArray[n2++] = (byte)(0xC0 | n3 >> 6);
                byArray[n2++] = (byte)(0x80 | n3 & 0x3F);
                continue;
            }
            if (n3 < 65536) {
                byArray[n2++] = (byte)(0xE0 | n3 >> 12);
                byArray[n2++] = (byte)(0x80 | n3 >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | n3 & 0x3F);
                continue;
            }
            byArray[n2++] = (byte)(0xF0 | n3 >> 18);
            byArray[n2++] = (byte)(0x80 | n3 >> 12 & 0x3F);
            byArray[n2++] = (byte)(0x80 | n3 >> 6 & 0x3F);
            byArray[n2++] = (byte)(0x80 | n3 & 0x3F);
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        if (Trace.traceOn_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray3);
        }
        return byArray3;
    }

    final byte[] stringToByteArray(char[] cArray, int n, int n2) {
        if (Trace.traceOn_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray, n, n2));
        }
        byte[] byArray = new byte[cArray.length * 4];
        int n3 = 0;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            int n5 = cArray[i] & 0xFFFF;
            if (n5 > 55295 && n5 < 56320) {
                if (++i < n4) {
                    n5 = (n5 - 55296) * 1024 + ((cArray[i] & 0xFFFF) - 56320) + 65536;
                } else {
                    if (!CharConverter.isFaultTolerantConversion()) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    byte[] byArray2 = new byte[n3];
                    System.arraycopy(byArray, 0, byArray2, 0, n3);
                    if (Trace.traceOn_) {
                        Trace.log(5, "Fault-tolerant in mid-surrogate. Destination byte array for ccsid: " + this.ccsid_, byArray2);
                    }
                    return byArray2;
                }
            }
            if (n5 < 128) {
                byArray[n3++] = (byte)n5;
                continue;
            }
            if (n5 < 2048) {
                byArray[n3++] = (byte)(0xC0 | n5 >> 6);
                byArray[n3++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            if (n5 < 65536) {
                byArray[n3++] = (byte)(0xE0 | n5 >> 12);
                byArray[n3++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            byArray[n3++] = (byte)(0xF0 | n5 >> 18);
            byArray[n3++] = (byte)(0x80 | n5 >> 12 & 0x3F);
            byArray[n3++] = (byte)(0x80 | n5 >> 6 & 0x3F);
            byArray[n3++] = (byte)(0x80 | n5 & 0x3F);
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, 0, byArray3, 0, n3);
        if (Trace.traceOn_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray3);
        }
        return byArray3;
    }

    final void stringToByteArray(String string, byte[] byArray, int n) throws CharConversionException {
        int n2 = n;
        if (Trace.traceOn_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(string.toCharArray()));
        }
        try {
            int n3 = string.length();
            for (int i = 0; i < n3; ++i) {
                int n4 = string.charAt(i) & 0xFFFF;
                if (n4 > 55295 && n4 < 56320) {
                    if (++i < n3) {
                        n4 = (n4 - 55296) * 1024 + ((string.charAt(i) & 0xFFFF) - 56320) + 65536;
                    } else {
                        if (!CharConverter.isFaultTolerantConversion()) {
                            throw new CharConversionException();
                        }
                        if (Trace.traceOn_) {
                            Trace.log(5, "Fault-tolerant in mid-surrogate. Destination byte array for ccsid: " + this.ccsid_, byArray, n, n2 - n);
                        }
                        return;
                    }
                }
                if (n4 < 128) {
                    byArray[n2++] = (byte)n4;
                    continue;
                }
                if (n4 < 2048) {
                    byArray[n2++] = (byte)(0xC0 | n4 >> 6);
                    byArray[n2++] = (byte)(0x80 | n4 & 0x3F);
                    continue;
                }
                if (n4 < 65536) {
                    byArray[n2++] = (byte)(0xE0 | n4 >> 12);
                    byArray[n2++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                    byArray[n2++] = (byte)(0x80 | n4 & 0x3F);
                    continue;
                }
                byArray[n2++] = (byte)(0xF0 | n4 >> 18);
                byArray[n2++] = (byte)(0x80 | n4 >> 12 & 0x3F);
                byArray[n2++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | n4 & 0x3F);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CharConversionException();
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray, n, n2 - n);
        }
    }

    final void stringToByteArray(String string, byte[] byArray, int n, int n2) throws CharConversionException {
        this.stringToByteArrayTruncation(string, byArray, n, n2);
    }

    final int stringToByteArrayTruncation(String string, byte[] byArray, int n, int n2) throws CharConversionException {
        int n3 = 0;
        if (Trace.traceOn_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(string.toCharArray()));
        }
        try {
            int n4 = string.length();
            int n5 = n;
            int n6 = n + n2;
            for (int i = 0; i < n4; ++i) {
                int n7 = string.charAt(i) & 0xFFFF;
                if (n7 > 55295 && n7 < 56320) {
                    if (++i < n4) {
                        n7 = (n7 - 55296) * 1024 + ((string.charAt(i) & 0xFFFF) - 56320) + 65536;
                    } else {
                        if (!CharConverter.isFaultTolerantConversion()) {
                            throw new CharConversionException();
                        }
                        if (Trace.traceOn_) {
                            Trace.log(5, "Fault-tolerant in mid-surrogate. Destination byte array for ccsid: " + this.ccsid_, byArray, n, n2);
                        }
                        return n3;
                    }
                }
                if (n7 < 128) {
                    if (n5 < n6) {
                        byArray[n5++] = (byte)n7;
                        continue;
                    }
                    if (n7 == 32) continue;
                    ++n3;
                    continue;
                }
                if (n7 < 2048) {
                    if (n5 < n6) {
                        byArray[n5++] = (byte)(0xC0 | n7 >> 6);
                    } else {
                        ++n3;
                    }
                    if (n5 < n6) {
                        byArray[n5++] = (byte)(0x80 | n7 & 0x3F);
                        continue;
                    }
                    ++n3;
                    continue;
                }
                if (n7 < 65536) {
                    if (n5 < n6) {
                        byArray[n5++] = (byte)(0xE0 | n7 >> 12);
                    } else {
                        ++n3;
                    }
                    if (n5 < n6) {
                        byArray[n5++] = (byte)(0x80 | n7 >> 6 & 0x3F);
                    } else {
                        ++n3;
                    }
                    if (n5 < n6) {
                        byArray[n5++] = (byte)(0x80 | n7 & 0x3F);
                        continue;
                    }
                    ++n3;
                    continue;
                }
                if (n5 < n6) {
                    byArray[n5++] = (byte)(0xF0 | n7 >> 18);
                } else {
                    ++n3;
                }
                if (n5 < n6) {
                    byArray[n5++] = (byte)(0x80 | n7 >> 12 & 0x3F);
                } else {
                    ++n3;
                }
                if (n5 < n6) {
                    byArray[n5++] = (byte)(0x80 | n7 >> 6 & 0x3F);
                } else {
                    ++n3;
                }
                if (n5 < n6) {
                    byArray[n5++] = (byte)(0x80 | n7 & 0x3F);
                    continue;
                }
                ++n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CharConversionException();
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray, n, n2);
        }
        return n3;
    }

    final int stringToByteArray(String string, byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) throws CharConversionException {
        return this.stringToByteArrayTruncation(string, byArray, n, n2);
    }
}

