/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400JDBCDataSource;
import com.ibm.as400.ui.framework.ResourceLoader;
import com.ibm.as400.ui.framework.java.ChoiceDescriptor;
import com.ibm.as400.ui.framework.java.DataBean;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.IllegalUserDataException;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.framework.java.TabbedPaneManager;
import com.ibm.as400.vaccess.AS400JDBCDataSourcePaneDataBean;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class AS400JDBCDataSourcePane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private AS400JDBCDataSource m_currentDataSource;
    private AS400JDBCDataSourcePaneDataBean m_dataBean;
    private TabbedPaneManager m_tabbedPaneManager = null;
    private boolean m_justBeingCreated = true;
    private PanelManager m_generalPaneManager = null;
    private PanelManager m_serverPaneManager = null;
    private PanelManager m_packagePaneManager = null;
    private PanelManager m_performancePaneManager = null;
    private PanelManager m_languagePaneManager = null;
    private PanelManager m_otherPaneManager = null;
    private PanelManager m_translationPaneManager = null;
    private PanelManager m_formatPaneManager = null;
    private PanelManager m_connoptPaneManager = null;
    public static final int TAB_GENERAL = 0;
    public static final int TAB_SERVER = 1;
    public static final int TAB_PACKAGE = 2;
    public static final int TAB_PERFORMANCE = 3;
    public static final int TAB_LANGUAGE = 4;
    public static final int TAB_OTHER = 5;
    public static final int TAB_TRANSLATION = 6;
    public static final int TAB_FORMAT = 7;
    public static final int TAB_CONNECTIONOPTIONS = 8;
    private transient PropertyChangeSupport propertyChangeSupport_ = new PropertyChangeSupport(this);
    static ResourceLoader resource_Loader = new ResourceLoader();

    public AS400JDBCDataSourcePane() {
        AS400JDBCDataSource aS400JDBCDataSource = new AS400JDBCDataSource();
        this.createPaneAndSetDataSource(aS400JDBCDataSource);
    }

    public AS400JDBCDataSourcePane(AS400JDBCDataSource aS400JDBCDataSource) {
        this.createPaneAndSetDataSource(aS400JDBCDataSource);
    }

    private void createPaneAndSetDataSource(AS400JDBCDataSource aS400JDBCDataSource) {
        this.m_dataBean = new AS400JDBCDataSourcePaneDataBean();
        this.m_dataBean.load();
        DataBean[] dataBeanArray = new DataBean[]{this.m_dataBean};
        JFrame jFrame = new JFrame();
        Container container = jFrame.getContentPane();
        try {
            this.m_tabbedPaneManager = new TabbedPaneManager("com.ibm.as400.vaccess.AS400JDBCDataSourcePaneGUI", "AJDSP_TABBEDPANE", dataBeanArray, container);
        }
        catch (DisplayManagerException displayManagerException) {
            displayManagerException.displayUserMessage(null);
            return;
        }
        this.m_generalPaneManager = (PanelManager)this.m_tabbedPaneManager.getDelegateManager("AJDSP_GENERAL");
        this.m_serverPaneManager = (PanelManager)this.m_tabbedPaneManager.getDelegateManager("AJDSP_SERVER");
        this.m_packagePaneManager = (PanelManager)this.m_tabbedPaneManager.getDelegateManager("AJDSP_PACKAGE");
        this.m_performancePaneManager = (PanelManager)this.m_tabbedPaneManager.getDelegateManager("AJDSP_PERFORMANCE");
        this.m_languagePaneManager = (PanelManager)this.m_tabbedPaneManager.getDelegateManager("AJDSP_LANGUAGE");
        this.m_otherPaneManager = (PanelManager)this.m_tabbedPaneManager.getDelegateManager("AJDSP_OTHER");
        this.m_translationPaneManager = (PanelManager)this.m_tabbedPaneManager.getDelegateManager("AJDSP_TRANSLATION");
        this.m_formatPaneManager = (PanelManager)this.m_tabbedPaneManager.getDelegateManager("AJDSP_FORMAT");
        this.m_connoptPaneManager = (PanelManager)this.m_tabbedPaneManager.getDelegateManager("AJDSP_CONNOPT");
        this.enableListenersForComponentsWeCareAbout();
        this.setDataSource(aS400JDBCDataSource);
        this.setLayout(new BorderLayout());
        this.add("Center", container);
        this.m_justBeingCreated = false;
        this.m_packagePaneManager.getComponent("AJDSP_PACKAGE_TEXTBOX").setEnabled(false);
        this.m_packagePaneManager.getComponent("AJDSP_PACKAGELIB_TEXTBOX").setEnabled(false);
        this.m_packagePaneManager.getComponent("AJDSP_USE_RADIOBUTTON").setEnabled(false);
        this.m_packagePaneManager.getComponent("AJDSP_USEADD_RADIOBUTTON").setEnabled(false);
        this.m_packagePaneManager.getComponent("AJDSP_SEND_EXCEP_RADIOBUTTON").setEnabled(false);
        this.m_packagePaneManager.getComponent("AJDSP_POST_WARN_RADIOBUTTON").setEnabled(false);
        this.m_packagePaneManager.getComponent("AJDSP_IGNORE_RADIOBUTTON").setEnabled(false);
        this.m_packagePaneManager.getComponent("AJDSP_CACHE_PACKAGE_CHECKBOX").setEnabled(false);
        this.m_languagePaneManager.getComponent("AJDSP_SORTTABLE_TEXTBOX").setEnabled(false);
        this.m_languagePaneManager.getComponent("AJDSP_SHAREDWEIGHT_RADIOBUTTON").setEnabled(false);
        this.m_languagePaneManager.getComponent("AJDSP_UNIQUEWEIGHT_RADIOBUTTON").setEnabled(false);
        this.m_languagePaneManager.getComponent("AJDSP_LANGUAGE_COMBOBOX").setEnabled(false);
    }

    private void enableListenersForComponentsWeCareAbout() {
        JComboBox jComboBox = (JComboBox)this.m_languagePaneManager.getComponent("AJDSP_SORTTYPE_COMBOBOX");
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AS400JDBCDataSourcePane.this.enableComponentsBasedOnSortType(actionEvent);
            }
        });
    }

    private void enableComponentsBasedOnSortType(ActionEvent actionEvent) {
        JComboBox jComboBox = (JComboBox)this.m_languagePaneManager.getComponent("AJDSP_SORTTYPE_COMBOBOX");
        ChoiceDescriptor choiceDescriptor = (ChoiceDescriptor)jComboBox.getSelectedItem();
        if (choiceDescriptor == null) {
            return;
        }
        String string = choiceDescriptor.getTitle();
        if (string.equals(resource_Loader.getString("AJDSP_SORTHEX")) || string.equals(resource_Loader.getString("AJDSP_SORTJOB"))) {
            this.m_languagePaneManager.getComponent("AJDSP_SORTTABLE_LABEL").setEnabled(false);
            this.m_languagePaneManager.getComponent("AJDSP_SORTTABLE_TEXTBOX").setEnabled(false);
            this.m_languagePaneManager.getComponent("AJDSP_SORTWEIGHT_LABEL").setEnabled(false);
            this.m_languagePaneManager.getComponent("AJDSP_SHAREDWEIGHT_RADIOBUTTON").setEnabled(false);
            this.m_languagePaneManager.getComponent("AJDSP_UNIQUEWEIGHT_RADIOBUTTON").setEnabled(false);
            this.m_languagePaneManager.getComponent("AJDSP_LANGUAGE_LABEL").setEnabled(false);
            this.m_languagePaneManager.getComponent("AJDSP_LANGUAGE_COMBOBOX").setEnabled(false);
        } else if (string.equals(resource_Loader.getString("AJDSP_SORTLANGID"))) {
            this.m_languagePaneManager.getComponent("AJDSP_SORTTABLE_LABEL").setEnabled(false);
            this.m_languagePaneManager.getComponent("AJDSP_SORTTABLE_TEXTBOX").setEnabled(false);
            this.m_languagePaneManager.getComponent("AJDSP_SORTWEIGHT_LABEL").setEnabled(true);
            this.m_languagePaneManager.getComponent("AJDSP_SHAREDWEIGHT_RADIOBUTTON").setEnabled(true);
            this.m_languagePaneManager.getComponent("AJDSP_UNIQUEWEIGHT_RADIOBUTTON").setEnabled(true);
            this.m_languagePaneManager.getComponent("AJDSP_LANGUAGE_LABEL").setEnabled(true);
            this.m_languagePaneManager.getComponent("AJDSP_LANGUAGE_COMBOBOX").setEnabled(true);
        } else if (string.equals(resource_Loader.getString("AJDSP_SORTTABLE"))) {
            this.m_languagePaneManager.getComponent("AJDSP_SORTTABLE_LABEL").setEnabled(true);
            this.m_languagePaneManager.getComponent("AJDSP_SORTTABLE_TEXTBOX").setEnabled(true);
            this.m_languagePaneManager.getComponent("AJDSP_SORTWEIGHT_LABEL").setEnabled(false);
            this.m_languagePaneManager.getComponent("AJDSP_SHAREDWEIGHT_RADIOBUTTON").setEnabled(false);
            this.m_languagePaneManager.getComponent("AJDSP_UNIQUEWEIGHT_RADIOBUTTON").setEnabled(false);
            this.m_languagePaneManager.getComponent("AJDSP_LANGUAGE_LABEL").setEnabled(false);
            this.m_languagePaneManager.getComponent("AJDSP_LANGUAGE_COMBOBOX").setEnabled(false);
        }
    }

    public AS400JDBCDataSource getDataSource() {
        return this.m_currentDataSource;
    }

    public void setDataSource(AS400JDBCDataSource aS400JDBCDataSource) {
        AS400JDBCDataSource aS400JDBCDataSource2 = this.m_currentDataSource;
        this.m_currentDataSource = aS400JDBCDataSource;
        this.setDataSourcePreLoadData(this.m_currentDataSource);
        if (this.m_justBeingCreated) {
            this.m_tabbedPaneManager.loadData();
        } else {
            this.m_generalPaneManager.loadData();
            this.m_serverPaneManager.loadData();
            this.m_packagePaneManager.loadData();
            this.m_performancePaneManager.loadData();
            this.m_languagePaneManager.loadData();
            this.m_otherPaneManager.loadData();
            this.m_translationPaneManager.loadData();
            this.m_formatPaneManager.loadData();
            this.m_connoptPaneManager.loadData();
        }
        this.propertyChangeSupport_.firePropertyChange("dataSource", aS400JDBCDataSource2, this.m_currentDataSource);
    }

    public boolean applyChanges() {
        try {
            this.m_tabbedPaneManager.applyChanges();
        }
        catch (IllegalUserDataException illegalUserDataException) {
            Container container = (Container)illegalUserDataException.getComponent();
            PanelManager.handleDataException((IllegalUserDataException)illegalUserDataException, (Container)container);
            return false;
        }
        this.applyChangesToCurrentDataSource(this.m_currentDataSource);
        return true;
    }

    private void applyChangesToCurrentDataSource(AS400JDBCDataSource aS400JDBCDataSource) {
        Object object;
        String string;
        Object object2;
        aS400JDBCDataSource.setDataSourceName(this.m_dataBean.getDataSourceName());
        aS400JDBCDataSource.setDescription(this.m_dataBean.getDescription());
        aS400JDBCDataSource.setServerName(this.m_dataBean.getAS400Server());
        String string2 = this.m_dataBean.getDefaultLibraries().trim();
        if (string2.length() > 0) {
            aS400JDBCDataSource.setLibraries(this.m_dataBean.getSQLlibrary().trim() + ", " + string2);
        } else {
            aS400JDBCDataSource.setLibraries(this.m_dataBean.getSQLlibrary().trim());
        }
        String string3 = ((ChoiceDescriptor)this.m_dataBean.getCommitMode()).getName();
        if (string3.equals("AJDSP_COMMIT_NONE")) {
            aS400JDBCDataSource.setTransactionIsolation("none");
        } else if (string3.equals("AJDSP_COMMIT_CS")) {
            aS400JDBCDataSource.setTransactionIsolation("read committed");
        } else if (string3.equals("AJDSP_COMMIT_CHG")) {
            aS400JDBCDataSource.setTransactionIsolation("read uncommitted");
        } else if (string3.equals("AJDSP_COMMIT_ALL")) {
            aS400JDBCDataSource.setTransactionIsolation("repeatable read");
        } else if (string3.equals("AJDSP_COMMIT_RR")) {
            aS400JDBCDataSource.setTransactionIsolation("serializable");
        }
        string3 = ((ChoiceDescriptor)this.m_dataBean.getMaxPrecision()).getTitle();
        if (string3.equals("31")) {
            aS400JDBCDataSource.setMaximumPrecision(31);
        } else {
            aS400JDBCDataSource.setMaximumPrecision(63);
        }
        string3 = ((ChoiceDescriptor)this.m_dataBean.getMaxScale()).getTitle();
        if (string3.equals("0")) {
            aS400JDBCDataSource.setMaximumScale(0);
        } else if (string3.equals("31")) {
            aS400JDBCDataSource.setMaximumScale(31);
        } else {
            aS400JDBCDataSource.setMaximumScale(63);
        }
        string3 = ((ChoiceDescriptor)this.m_dataBean.getMinDivideScale()).getTitle();
        if (string3.equals("0")) {
            aS400JDBCDataSource.setMinimumDivideScale(0);
        } else if (string3.equals("1")) {
            aS400JDBCDataSource.setMinimumDivideScale(1);
        } else if (string3.equals("2")) {
            aS400JDBCDataSource.setMinimumDivideScale(2);
        } else if (string3.equals("3")) {
            aS400JDBCDataSource.setMinimumDivideScale(3);
        } else if (string3.equals("4")) {
            aS400JDBCDataSource.setMinimumDivideScale(4);
        } else if (string3.equals("5")) {
            aS400JDBCDataSource.setMinimumDivideScale(5);
        } else if (string3.equals("6")) {
            aS400JDBCDataSource.setMinimumDivideScale(6);
        } else if (string3.equals("7")) {
            aS400JDBCDataSource.setMinimumDivideScale(7);
        } else if (string3.equals("8")) {
            aS400JDBCDataSource.setMinimumDivideScale(8);
        } else {
            aS400JDBCDataSource.setMinimumDivideScale(9);
        }
        aS400JDBCDataSource.setExtendedDynamic(this.m_dataBean.isEnableExtDynamic());
        aS400JDBCDataSource.setPackageCriteria("select");
        aS400JDBCDataSource.setPackage(this.m_dataBean.getPackage());
        aS400JDBCDataSource.setPackageLibrary(this.m_dataBean.getPackageLibrary());
        if (this.m_dataBean.getUsageGroup().equals("AJDSP_USE_RADIOBUTTON")) {
            aS400JDBCDataSource.setPackageAdd(false);
        } else if (this.m_dataBean.getUsageGroup().equals("AJDSP_USEADD_RADIOBUTTON")) {
            aS400JDBCDataSource.setPackageAdd(true);
        }
        if (this.m_dataBean.getUnusablePkgActionGroup().equals("AJDSP_SEND_EXCEP_RADIOBUTTON")) {
            aS400JDBCDataSource.setPackageError("exception");
        } else if (this.m_dataBean.getUnusablePkgActionGroup().equals("AJDSP_POST_WARN_RADIOBUTTON")) {
            aS400JDBCDataSource.setPackageError("warning");
        } else if (this.m_dataBean.getUnusablePkgActionGroup().equals("AJDSP_IGNORE_RADIOBUTTON")) {
            aS400JDBCDataSource.setPackageError("none");
        }
        aS400JDBCDataSource.setPackageCache(this.m_dataBean.isCachePackageLocally());
        aS400JDBCDataSource.setLazyClose(this.m_dataBean.isEnableLazyClose());
        aS400JDBCDataSource.setPrefetch(this.m_dataBean.isEnablePrefetch());
        aS400JDBCDataSource.setDataCompression(this.m_dataBean.isEnableDataCompression());
        string3 = ((ChoiceDescriptor)this.m_dataBean.getRecordBlockingCriteria()).getName();
        if (string3.equals("AJDSP_RECBLK_DISABLE")) {
            aS400JDBCDataSource.setBlockCriteria(0);
        } else if (string3.equals("AJDSP_RECBLK_FORFETCH")) {
            aS400JDBCDataSource.setBlockCriteria(1);
        } else if (string3.equals("AJDSP_RECBLK_NOTUPDT")) {
            aS400JDBCDataSource.setBlockCriteria(2);
        }
        string3 = ((ChoiceDescriptor)this.m_dataBean.getRecordBlockingSize()).getName();
        if (string3.equals("AJDSP_BLOCK_SIZE_0")) {
            aS400JDBCDataSource.setBlockSize(0);
        } else if (string3.equals("AJDSP_BLOCK_SIZE_8")) {
            aS400JDBCDataSource.setBlockSize(8);
        } else if (string3.equals("AJDSP_BLOCK_SIZE_16")) {
            aS400JDBCDataSource.setBlockSize(16);
        } else if (string3.equals("AJDSP_BLOCK_SIZE_32")) {
            aS400JDBCDataSource.setBlockSize(32);
        } else if (string3.equals("AJDSP_BLOCK_SIZE_64")) {
            aS400JDBCDataSource.setBlockSize(64);
        } else if (string3.equals("AJDSP_BLOCK_SIZE_128")) {
            aS400JDBCDataSource.setBlockSize(128);
        } else if (string3.equals("AJDSP_BLOCK_SIZE_256")) {
            aS400JDBCDataSource.setBlockSize(256);
        } else if (string3.equals("AJDSP_BLOCK_SIZE_512")) {
            aS400JDBCDataSource.setBlockSize(512);
        }
        Object object3 = this.m_dataBean.getLOBThreshold();
        if (object3 instanceof ChoiceDescriptor) {
            object2 = (ChoiceDescriptor)object3;
            string = object2.getTitle();
            object = new Double(string);
            double d = (Double)object;
            int n = (int)(d * 1024.0);
            aS400JDBCDataSource.setLobThreshold(n);
        } else if (object3 instanceof Double) {
            object2 = (Double)object3;
            double d = (Double)object2;
            int n = (int)(d * 1024.0);
            aS400JDBCDataSource.setLobThreshold(n);
        }
        string3 = ((ChoiceDescriptor)this.m_dataBean.getSortType()).getName();
        if (string3.equals("AJDSP_SORTHEX")) {
            aS400JDBCDataSource.setSort("hex");
        } else if (string3.equals("AJDSP_SORTJOB")) {
            aS400JDBCDataSource.setSort("job");
        } else if (string3.equals("AJDSP_SORTLANGID")) {
            aS400JDBCDataSource.setSort("language");
        } else if (string3.equals("AJDSP_SORTTABLE")) {
            aS400JDBCDataSource.setSort("table");
        }
        aS400JDBCDataSource.setSortTable(this.m_dataBean.getSortTable());
        if (this.m_dataBean.getSortWeightGroup().equals("AJDSP_SHAREDWEIGHT_RADIOBUTTON")) {
            aS400JDBCDataSource.setSortWeight("shared");
        } else if (this.m_dataBean.getSortWeightGroup().equals("AJDSP_UNIQUEWEIGHT_RADIOBUTTON")) {
            aS400JDBCDataSource.setSortWeight("unique");
        }
        object2 = this.m_dataBean.getLanguage();
        if (object2 instanceof ChoiceDescriptor) {
            string = (ChoiceDescriptor)object2;
            object = string.getName();
            String string4 = ((String)object).substring(13, 16).toLowerCase();
            aS400JDBCDataSource.setSortLanguage(string4);
        } else if (object2 instanceof String) {
            aS400JDBCDataSource.setSortLanguage(((String)object2).toLowerCase());
        }
        if (this.m_dataBean.getAccessTypeGroup().equals("AJDSP_ACCESSTYPE_RW")) {
            aS400JDBCDataSource.setAccess("all");
        } else if (this.m_dataBean.getAccessTypeGroup().equals("AJDSP_ACCESSTYPE_RC")) {
            aS400JDBCDataSource.setAccess("read call");
        } else if (this.m_dataBean.getAccessTypeGroup().equals("AJDSP_ACCESSTYPE_RO")) {
            aS400JDBCDataSource.setAccess("read only");
        }
        if (this.m_dataBean.getRemarksSourceGroup().equals("AJDSP_SQLDESC_RADIOBUTTON")) {
            aS400JDBCDataSource.setRemarks("sql");
        } else if (this.m_dataBean.getRemarksSourceGroup().equals("AJDSP_OS400DESC_RADIOBUTTON")) {
            aS400JDBCDataSource.setRemarks("system");
        }
        aS400JDBCDataSource.setTranslateBinary(this.m_dataBean.isTranslate65535());
        aS400JDBCDataSource.setTranslateHex(this.m_dataBean.isTranslateHex() ? "binary" : "character");
        string3 = ((ChoiceDescriptor)this.m_dataBean.getNamingConvention()).getName();
        if (string3.equals("AJDSP_NAMING_SQL")) {
            aS400JDBCDataSource.setNaming("sql");
        } else if (string3.equals("AJDSP_NAMING_SYSTEM")) {
            aS400JDBCDataSource.setNaming("system");
        }
        string3 = ((ChoiceDescriptor)this.m_dataBean.getDecimalSeparator()).getName();
        if (string3.equals("AJDSP_USE_SERVER_JOB")) {
            aS400JDBCDataSource.setDecimalSeparator("");
        } else if (string3.equals("AJDSP_DECIMAL_PERIOD")) {
            aS400JDBCDataSource.setDecimalSeparator(".");
        } else if (string3.equals("AJDSP_DECIMAL_COMMA")) {
            aS400JDBCDataSource.setDecimalSeparator(",");
        }
        string3 = ((ChoiceDescriptor)this.m_dataBean.getTimeFormat()).getName();
        if (string3.equals("AJDSP_USE_SERVER_JOB")) {
            aS400JDBCDataSource.setTimeFormat("");
        } else if (string3.equals("AJDSP_TIMEFMT_HMS")) {
            aS400JDBCDataSource.setTimeFormat("hms");
        } else if (string3.equals("AJDSP_TIMEFMT_USA")) {
            aS400JDBCDataSource.setTimeFormat("usa");
        } else if (string3.equals("AJDSP_TIMEFMT_ISO")) {
            aS400JDBCDataSource.setTimeFormat("iso");
        } else if (string3.equals("AJDSP_TIMEFMT_EUR")) {
            aS400JDBCDataSource.setTimeFormat("eur");
        } else if (string3.equals("AJDSP_TIMEFMT_JIS")) {
            aS400JDBCDataSource.setTimeFormat("jis");
        }
        string3 = ((ChoiceDescriptor)this.m_dataBean.getTimeSeparator()).getName();
        if (string3.equals("AJDSP_USE_SERVER_JOB")) {
            aS400JDBCDataSource.setTimeSeparator("");
        } else if (string3.equals("AJDSP_TIMESEP_COLON")) {
            aS400JDBCDataSource.setTimeSeparator(":");
        } else if (string3.equals("AJDSP_TIMESEP_PERIOD")) {
            aS400JDBCDataSource.setTimeSeparator(".");
        } else if (string3.equals("AJDSP_TIMESEP_COMMA")) {
            aS400JDBCDataSource.setTimeSeparator(",");
        } else if (string3.equals("AJDSP_TIMESEP_BLANK")) {
            aS400JDBCDataSource.setTimeSeparator("b");
        }
        string3 = ((ChoiceDescriptor)this.m_dataBean.getDateFormat()).getName();
        if (string3.equals("AJDSP_USE_SERVER_JOB")) {
            aS400JDBCDataSource.setDateFormat("");
        } else if (string3.equals("AJDSP_DATEFMT_JULIAN")) {
            aS400JDBCDataSource.setDateFormat("julian");
        } else if (string3.equals("AJDSP_DATEFMT_MDY")) {
            aS400JDBCDataSource.setDateFormat("mdy");
        } else if (string3.equals("AJDSP_DATEFMT_DMY")) {
            aS400JDBCDataSource.setDateFormat("dmy");
        } else if (string3.equals("AJDSP_DATEFMT_YMD")) {
            aS400JDBCDataSource.setDateFormat("ymd");
        } else if (string3.equals("AJDSP_DATEFMT_USA")) {
            aS400JDBCDataSource.setDateFormat("usa");
        } else if (string3.equals("AJDSP_DATEFMT_ISO")) {
            aS400JDBCDataSource.setDateFormat("iso");
        } else if (string3.equals("AJDSP_DATEFMT_EUR")) {
            aS400JDBCDataSource.setDateFormat("eur");
        } else if (string3.equals("AJDSP_DATEFMT_JIS")) {
            aS400JDBCDataSource.setDateFormat("jis");
        }
        string3 = ((ChoiceDescriptor)this.m_dataBean.getDateSeparator()).getName();
        if (string3.equals("AJDSP_USE_SERVER_JOB")) {
            aS400JDBCDataSource.setDateSeparator("");
        } else if (string3.equals("AJDSP_DATESEP_FORWARDSLASH")) {
            aS400JDBCDataSource.setDateSeparator("/");
        } else if (string3.equals("AJDSP_DATESEP_DASH")) {
            aS400JDBCDataSource.setDateSeparator("-");
        } else if (string3.equals("AJDSP_DATESEP_PERIOD")) {
            aS400JDBCDataSource.setDateSeparator(".");
        } else if (string3.equals("AJDSP_DATESEP_COMMA")) {
            aS400JDBCDataSource.setDateSeparator(",");
        } else if (string3.equals("AJDSP_DATESEP_BLANK")) {
            aS400JDBCDataSource.setDateSeparator("b");
        }
        aS400JDBCDataSource.setUser(this.m_dataBean.getDefaultUserID());
        aS400JDBCDataSource.setSecure(this.m_dataBean.isUseSSL());
    }

    private void setDataSourcePreLoadData(AS400JDBCDataSource aS400JDBCDataSource) {
        int n;
        this.m_dataBean.setDataSourceName(aS400JDBCDataSource.getDataSourceName());
        this.m_dataBean.setDescription(aS400JDBCDataSource.getDescription());
        this.m_dataBean.setAS400Server(aS400JDBCDataSource.getServerName());
        String string = aS400JDBCDataSource.getLibraries().trim();
        if (string.length() > 0) {
            if (string.charAt(0) == ',') {
                this.m_dataBean.setDefaultLibraries(string.substring(1).trim());
            } else {
                n = string.indexOf(44);
                int n2 = string.indexOf(32);
                if (n == -1 && n2 == -1) {
                    this.m_dataBean.setSQLlibrary(string);
                } else {
                    if (n >= 0) {
                        if (n2 >= 0 && n2 < n) {
                            n = n2;
                        }
                    } else if (n2 >= 0) {
                        n = n2;
                    }
                    this.m_dataBean.setSQLlibrary(string.substring(0, n));
                    this.m_dataBean.setDefaultLibraries(string.substring(n + 1));
                }
            }
        }
        if (aS400JDBCDataSource.getTransactionIsolation().equals("none")) {
            string = resource_Loader.getString("AJDSP_COMMIT_NONE");
            this.m_dataBean.setCommitMode(new ChoiceDescriptor("AJDSP_COMMIT_NONE", string));
        } else if (aS400JDBCDataSource.getTransactionIsolation().equals("read committed")) {
            string = resource_Loader.getString("AJDSP_COMMIT_CS");
            this.m_dataBean.setCommitMode(new ChoiceDescriptor("AJDSP_COMMIT_CS", string));
        } else if (aS400JDBCDataSource.getTransactionIsolation().equals("read uncommitted")) {
            string = resource_Loader.getString("AJDSP_COMMIT_CHG");
            this.m_dataBean.setCommitMode(new ChoiceDescriptor("AJDSP_COMMIT_CHG", string));
        } else if (aS400JDBCDataSource.getTransactionIsolation().equals("repeatable read")) {
            string = resource_Loader.getString("AJDSP_COMMIT_ALL");
            this.m_dataBean.setCommitMode(new ChoiceDescriptor("AJDSP_COMMIT_ALL", string));
        } else if (aS400JDBCDataSource.getTransactionIsolation().equals("serializable")) {
            string = resource_Loader.getString("AJDSP_COMMIT_RR");
            this.m_dataBean.setCommitMode(new ChoiceDescriptor("AJDSP_COMMIT_RR", string));
        }
        n = aS400JDBCDataSource.getMaximumPrecision();
        if (n == 63) {
            this.m_dataBean.setMaxPrecision(new ChoiceDescriptor("AJDSP_MAXPREC_63", "63"));
        } else {
            this.m_dataBean.setMaxPrecision(new ChoiceDescriptor("AJDSP_MAXPREC_31", "31"));
        }
        n = aS400JDBCDataSource.getMaximumScale();
        if (n == 63) {
            this.m_dataBean.setMaxScale(new ChoiceDescriptor("AJDSP_MAXSCALE_63", "63"));
        } else if (n >= 31) {
            this.m_dataBean.setMaxScale(new ChoiceDescriptor("AJDSP_MAXSCALE_31", "31"));
        } else {
            this.m_dataBean.setMaxScale(new ChoiceDescriptor("AJDSP_MAXSCALE_0", "0"));
        }
        n = aS400JDBCDataSource.getMinimumDivideScale();
        if (n == 0) {
            this.m_dataBean.setMinDivideScale(new ChoiceDescriptor("AJDSP_MINDIVSCALE_0", "0"));
        } else if (n == 1) {
            this.m_dataBean.setMinDivideScale(new ChoiceDescriptor("AJDSP_MINDIVSCALE_1", "1"));
        } else if (n == 2) {
            this.m_dataBean.setMinDivideScale(new ChoiceDescriptor("AJDSP_MINDIVSCALE_2", "2"));
        } else if (n == 3) {
            this.m_dataBean.setMinDivideScale(new ChoiceDescriptor("AJDSP_MINDIVSCALE_3", "3"));
        } else if (n == 4) {
            this.m_dataBean.setMinDivideScale(new ChoiceDescriptor("AJDSP_MINDIVSCALE_4", "4"));
        } else if (n == 5) {
            this.m_dataBean.setMinDivideScale(new ChoiceDescriptor("AJDSP_MINDIVSCALE_5", "5"));
        } else if (n == 6) {
            this.m_dataBean.setMinDivideScale(new ChoiceDescriptor("AJDSP_MINDIVSCALE_6", "6"));
        } else if (n == 7) {
            this.m_dataBean.setMinDivideScale(new ChoiceDescriptor("AJDSP_MINDIVSCALE_7", "7"));
        } else if (n == 8) {
            this.m_dataBean.setMinDivideScale(new ChoiceDescriptor("AJDSP_MINDIVSCALE_8", "8"));
        } else {
            this.m_dataBean.setMinDivideScale(new ChoiceDescriptor("AJDSP_MINDIVSCALE_9", "9"));
        }
        this.m_dataBean.setEnableExtDynamic(aS400JDBCDataSource.isExtendedDynamic());
        this.m_dataBean.setPackage(aS400JDBCDataSource.getPackage());
        this.m_dataBean.setPackageLibrary(aS400JDBCDataSource.getPackageLibrary());
        if (aS400JDBCDataSource.isPackageAdd()) {
            this.m_dataBean.setUsageGroup("AJDSP_USEADD_RADIOBUTTON");
        } else {
            this.m_dataBean.setUsageGroup("AJDSP_USE_RADIOBUTTON");
        }
        if (aS400JDBCDataSource.getPackageError().equals("exception")) {
            this.m_dataBean.setUnusablePkgActionGroup("AJDSP_SEND_EXCEP_RADIOBUTTON");
        } else if (aS400JDBCDataSource.getPackageError().equals("warning")) {
            this.m_dataBean.setUnusablePkgActionGroup("AJDSP_POST_WARN_RADIOBUTTON");
        } else if (aS400JDBCDataSource.getPackageError().equals("none")) {
            this.m_dataBean.setUnusablePkgActionGroup("AJDSP_IGNORE_RADIOBUTTON");
        }
        this.m_dataBean.setCachePackageLocally(aS400JDBCDataSource.isPackageCache());
        this.m_dataBean.setEnableLazyClose(aS400JDBCDataSource.isLazyClose());
        this.m_dataBean.setEnablePrefetch(aS400JDBCDataSource.isPrefetch());
        this.m_dataBean.setEnableDataCompression(aS400JDBCDataSource.isDataCompression());
        if (aS400JDBCDataSource.getBlockCriteria() == 0) {
            string = resource_Loader.getString("AJDSP_RECBLK_DISABLE");
            this.m_dataBean.setRecordBlockingCriteria(new ChoiceDescriptor("AJDSP_RECBLK_DISABLE", string));
        } else if (aS400JDBCDataSource.getBlockCriteria() == 1) {
            string = resource_Loader.getString("AJDSP_RECBLK_FORFETCH");
            this.m_dataBean.setRecordBlockingCriteria(new ChoiceDescriptor("AJDSP_RECBLK_FORFETCH", string));
        } else if (aS400JDBCDataSource.getBlockCriteria() == 2) {
            string = resource_Loader.getString("AJDSP_RECBLK_NOTUPDT");
            this.m_dataBean.setRecordBlockingCriteria(new ChoiceDescriptor("AJDSP_RECBLK_NOTUPDT", string));
        }
        switch (aS400JDBCDataSource.getBlockSize()) {
            case 0: {
                string = resource_Loader.getString("AJDSP_BLOCK_SIZE_0");
                this.m_dataBean.setRecordBlockingSize(new ChoiceDescriptor("AJDSP_BLOCK_SIZE_0", string));
                break;
            }
            case 8: {
                string = resource_Loader.getString("AJDSP_BLOCK_SIZE_8");
                this.m_dataBean.setRecordBlockingSize(new ChoiceDescriptor("AJDSP_BLOCK_SIZE_8", string));
                break;
            }
            case 16: {
                string = resource_Loader.getString("AJDSP_BLOCK_SIZE_16");
                this.m_dataBean.setRecordBlockingSize(new ChoiceDescriptor("AJDSP_BLOCK_SIZE_16", string));
                break;
            }
            case 32: {
                string = resource_Loader.getString("AJDSP_BLOCK_SIZE_32");
                this.m_dataBean.setRecordBlockingSize(new ChoiceDescriptor("AJDSP_BLOCK_SIZE_32", string));
                break;
            }
            case 64: {
                string = resource_Loader.getString("AJDSP_BLOCK_SIZE_64");
                this.m_dataBean.setRecordBlockingSize(new ChoiceDescriptor("AJDSP_BLOCK_SIZE_64", string));
                break;
            }
            case 128: {
                string = resource_Loader.getString("AJDSP_BLOCK_SIZE_128");
                this.m_dataBean.setRecordBlockingSize(new ChoiceDescriptor("AJDSP_BLOCK_SIZE_128", string));
                break;
            }
            case 256: {
                string = resource_Loader.getString("AJDSP_BLOCK_SIZE_256");
                this.m_dataBean.setRecordBlockingSize(new ChoiceDescriptor("AJDSP_BLOCK_SIZE_256", string));
                break;
            }
            case 512: {
                string = resource_Loader.getString("AJDSP_BLOCK_SIZE_512");
                this.m_dataBean.setRecordBlockingSize(new ChoiceDescriptor("AJDSP_BLOCK_SIZE_512", string));
            }
        }
        double d = (double)aS400JDBCDataSource.getLobThreshold() / 1024.0;
        Double d2 = new Double(d);
        this.m_dataBean.setLOBThreshold(d2);
        if (aS400JDBCDataSource.getSort().equals("hex")) {
            string = resource_Loader.getString("AJDSP_SORTHEX");
            this.m_dataBean.setSortType(new ChoiceDescriptor("AJDSP_SORTHEX", string));
        } else if (aS400JDBCDataSource.getSort().equals("job")) {
            string = resource_Loader.getString("AJDSP_SORTJOB");
            this.m_dataBean.setSortType(new ChoiceDescriptor("AJDSP_SORTJOB", string));
        } else if (aS400JDBCDataSource.getSort().equals("language")) {
            string = resource_Loader.getString("AJDSP_SORTLANGID");
            this.m_dataBean.setSortType(new ChoiceDescriptor("AJDSP_SORTLANGID", string));
        } else if (aS400JDBCDataSource.getSort().equals("table")) {
            string = resource_Loader.getString("AJDSP_SORTTABLE");
            this.m_dataBean.setSortType(new ChoiceDescriptor("AJDSP_SORTTABLE", string));
        }
        this.m_dataBean.setSortTable(aS400JDBCDataSource.getSortTable());
        if (aS400JDBCDataSource.getSortWeight().equals("shared")) {
            this.m_dataBean.setSortWeightGroup("AJDSP_SHAREDWEIGHT_RADIOBUTTON");
        } else if (aS400JDBCDataSource.getSortWeight().equals("unique")) {
            this.m_dataBean.setSortWeightGroup("AJDSP_UNIQUEWEIGHT_RADIOBUTTON");
        }
        String string2 = aS400JDBCDataSource.getSortLanguage();
        if (string2.equalsIgnoreCase("afr") || string2.equalsIgnoreCase("ara") || string2.equalsIgnoreCase("bel") || string2.equalsIgnoreCase("bgr") || string2.equalsIgnoreCase("cat") || string2.equalsIgnoreCase("chs") || string2.equalsIgnoreCase("cht") || string2.equalsIgnoreCase("csy") || string2.equalsIgnoreCase("dan") || string2.equalsIgnoreCase("des") || string2.equalsIgnoreCase("deu") || string2.equalsIgnoreCase("ell") || string2.equalsIgnoreCase("ena") || string2.equalsIgnoreCase("enb") || string2.equalsIgnoreCase("eng") || string2.equalsIgnoreCase("enp") || string2.equalsIgnoreCase("enu") || string2.equalsIgnoreCase("esp") || string2.equalsIgnoreCase("est") || string2.equalsIgnoreCase("far") || string2.equalsIgnoreCase("fin") || string2.equalsIgnoreCase("fra") || string2.equalsIgnoreCase("frb") || string2.equalsIgnoreCase("frc") || string2.equalsIgnoreCase("frs") || string2.equalsIgnoreCase("gae") || string2.equalsIgnoreCase("heb") || string2.equalsIgnoreCase("hrv") || string2.equalsIgnoreCase("hun") || string2.equalsIgnoreCase("isl") || string2.equalsIgnoreCase("ita") || string2.equalsIgnoreCase("its") || string2.equalsIgnoreCase("jpn") || string2.equalsIgnoreCase("kor") || string2.equalsIgnoreCase("lao") || string2.equalsIgnoreCase("ltu") || string2.equalsIgnoreCase("lva") || string2.equalsIgnoreCase("mkd") || string2.equalsIgnoreCase("nlb") || string2.equalsIgnoreCase("nld") || string2.equalsIgnoreCase("non") || string2.equalsIgnoreCase("nor") || string2.equalsIgnoreCase("plk") || string2.equalsIgnoreCase("ptb") || string2.equalsIgnoreCase("ptg") || string2.equalsIgnoreCase("rms") || string2.equalsIgnoreCase("rom") || string2.equalsIgnoreCase("rus") || string2.equalsIgnoreCase("sky") || string2.equalsIgnoreCase("slo") || string2.equalsIgnoreCase("sqi") || string2.equalsIgnoreCase("srb") || string2.equalsIgnoreCase("srl") || string2.equalsIgnoreCase("sve") || string2.equalsIgnoreCase("tha") || string2.equalsIgnoreCase("trk") || string2.equalsIgnoreCase("ukr") || string2.equalsIgnoreCase("urd") || string2.equalsIgnoreCase("vie")) {
            String string3 = "AJDSP_SORTLG_" + string2.toUpperCase() + "_TEXT";
            string = resource_Loader.getString(string3);
            this.m_dataBean.setLanguage(new ChoiceDescriptor(string3, string));
        } else {
            this.m_dataBean.setLanguage(string2);
        }
        boolean bl = true;
        if (aS400JDBCDataSource.getAccess().equals("all")) {
            this.m_dataBean.setAccessTypeGroup("AJDSP_ACCESSTYPE_RW");
        } else if (aS400JDBCDataSource.getAccess().equals("read call")) {
            this.m_dataBean.setAccessTypeGroup("AJDSP_ACCESSTYPE_RC");
        } else if (aS400JDBCDataSource.getAccess().equals("read only")) {
            this.m_dataBean.setAccessTypeGroup("AJDSP_ACCESSTYPE_RO");
        }
        if (aS400JDBCDataSource.getRemarks().equals("sql")) {
            this.m_dataBean.setRemarksSourceGroup("AJDSP_SQLDESC_RADIOBUTTON");
        } else if (aS400JDBCDataSource.getRemarks().equals("system")) {
            this.m_dataBean.setRemarksSourceGroup("AJDSP_OS400DESC_RADIOBUTTON");
        }
        this.m_dataBean.setTranslate65535(aS400JDBCDataSource.isTranslateBinary());
        this.m_dataBean.setTranslateHex(aS400JDBCDataSource.getTranslateHex().equals("binary"));
        if (aS400JDBCDataSource.getNaming().equals("sql")) {
            string = resource_Loader.getString("AJDSP_NAMING_SQL");
            this.m_dataBean.setNamingConvention(new ChoiceDescriptor("AJDSP_NAMING_SQL", string));
        } else if (aS400JDBCDataSource.getNaming().equals("system")) {
            string = resource_Loader.getString("AJDSP_NAMING_SYSTEM");
            this.m_dataBean.setNamingConvention(new ChoiceDescriptor("AJDSP_NAMING_SYSTEM", string));
        }
        if (aS400JDBCDataSource.getDecimalSeparator().equals("")) {
            string = resource_Loader.getString("AJDSP_USE_SERVER_JOB");
            this.m_dataBean.setDecimalSeparator(new ChoiceDescriptor("AJDSP_USE_SERVER_JOB", string));
        } else if (aS400JDBCDataSource.getDecimalSeparator().equals(".")) {
            string = resource_Loader.getString("AJDSP_DECIMAL_PERIOD");
            this.m_dataBean.setDecimalSeparator(new ChoiceDescriptor("AJDSP_DECIMAL_PERIOD", string));
        } else if (aS400JDBCDataSource.getDecimalSeparator().equals(",")) {
            string = resource_Loader.getString("AJDSP_DECIMAL_COMMA");
            this.m_dataBean.setDecimalSeparator(new ChoiceDescriptor("AJDSP_DECIMAL_COMMA", string));
        }
        if (aS400JDBCDataSource.getTimeFormat().equals("")) {
            string = resource_Loader.getString("AJDSP_USE_SERVER_JOB");
            this.m_dataBean.setTimeFormat(new ChoiceDescriptor("AJDSP_USE_SERVER_JOB", string));
        } else if (aS400JDBCDataSource.getTimeFormat().equals("hms")) {
            string = resource_Loader.getString("AJDSP_TIMEFMT_HMS");
            this.m_dataBean.setTimeFormat(new ChoiceDescriptor("AJDSP_TIMEFMT_HMS", string));
        } else if (aS400JDBCDataSource.getTimeFormat().equals("usa")) {
            string = resource_Loader.getString("AJDSP_TIMEFMT_USA");
            this.m_dataBean.setTimeFormat(new ChoiceDescriptor("AJDSP_TIMEFMT_USA", string));
        } else if (aS400JDBCDataSource.getTimeFormat().equals("iso")) {
            string = resource_Loader.getString("AJDSP_TIMEFMT_ISO");
            this.m_dataBean.setTimeFormat(new ChoiceDescriptor("AJDSP_TIMEFMT_ISO", string));
        } else if (aS400JDBCDataSource.getTimeFormat().equals("eur")) {
            string = resource_Loader.getString("AJDSP_TIMEFMT_EUR");
            this.m_dataBean.setTimeFormat(new ChoiceDescriptor("AJDSP_TIMEFMT_EUR", string));
        } else if (aS400JDBCDataSource.getTimeFormat().equals("jis")) {
            string = resource_Loader.getString("AJDSP_TIMEFMT_JIS");
            this.m_dataBean.setTimeFormat(new ChoiceDescriptor("AJDSP_TIMEFMT_JIS", string));
        }
        if (aS400JDBCDataSource.getTimeSeparator().equals("")) {
            string = resource_Loader.getString("AJDSP_USE_SERVER_JOB");
            this.m_dataBean.setTimeSeparator(new ChoiceDescriptor("AJDSP_USE_SERVER_JOB", string));
        } else if (aS400JDBCDataSource.getTimeSeparator().equals(":")) {
            string = resource_Loader.getString("AJDSP_TIMESEP_COLON");
            this.m_dataBean.setTimeSeparator(new ChoiceDescriptor("AJDSP_TIMESEP_COLON", string));
        } else if (aS400JDBCDataSource.getTimeSeparator().equals(".")) {
            string = resource_Loader.getString("AJDSP_TIMESEP_PERIOD");
            this.m_dataBean.setTimeSeparator(new ChoiceDescriptor("AJDSP_TIMESEP_PERIOD", string));
        } else if (aS400JDBCDataSource.getTimeSeparator().equals(",")) {
            string = resource_Loader.getString("AJDSP_TIMESEP_COMMA");
            this.m_dataBean.setTimeSeparator(new ChoiceDescriptor("AJDSP_TIMESEP_COMMA", string));
        } else if (aS400JDBCDataSource.getTimeSeparator().equals("b")) {
            string = resource_Loader.getString("AJDSP_TIMESEP_BLANK");
            this.m_dataBean.setTimeSeparator(new ChoiceDescriptor("AJDSP_TIMESEP_BLANK", string));
        }
        if (aS400JDBCDataSource.getDateFormat().equals("")) {
            string = resource_Loader.getString("AJDSP_USE_SERVER_JOB");
            this.m_dataBean.setDateFormat(new ChoiceDescriptor("AJDSP_USE_SERVER_JOB", string));
        } else if (aS400JDBCDataSource.getDateFormat().equals("julian")) {
            string = resource_Loader.getString("AJDSP_DATEFMT_JULIAN");
            this.m_dataBean.setDateFormat(new ChoiceDescriptor("AJDSP_DATEFMT_JULIAN", string));
        } else if (aS400JDBCDataSource.getDateFormat().equals("mdy")) {
            string = resource_Loader.getString("AJDSP_DATEFMT_MDY");
            this.m_dataBean.setDateFormat(new ChoiceDescriptor("AJDSP_DATEFMT_MDY", string));
        } else if (aS400JDBCDataSource.getDateFormat().equals("dmy")) {
            string = resource_Loader.getString("AJDSP_DATEFMT_DMY");
            this.m_dataBean.setDateFormat(new ChoiceDescriptor("AJDSP_DATEFMT_DMY", string));
        } else if (aS400JDBCDataSource.getDateFormat().equals("ymd")) {
            string = resource_Loader.getString("AJDSP_DATEFMT_YMD");
            this.m_dataBean.setDateFormat(new ChoiceDescriptor("AJDSP_DATEFMT_YMD", string));
        } else if (aS400JDBCDataSource.getDateFormat().equals("usa")) {
            string = resource_Loader.getString("AJDSP_DATEFMT_USA");
            this.m_dataBean.setDateFormat(new ChoiceDescriptor("AJDSP_DATEFMT_USA", string));
        } else if (aS400JDBCDataSource.getDateFormat().equals("iso")) {
            string = resource_Loader.getString("AJDSP_DATEFMT_ISO");
            this.m_dataBean.setDateFormat(new ChoiceDescriptor("AJDSP_DATEFMT_ISO", string));
        } else if (aS400JDBCDataSource.getDateFormat().equals("eur")) {
            string = resource_Loader.getString("AJDSP_DATEFMT_EUR");
            this.m_dataBean.setDateFormat(new ChoiceDescriptor("AJDSP_DATEFMT_EUR", string));
        } else if (aS400JDBCDataSource.getDateFormat().equals("jis")) {
            string = resource_Loader.getString("AJDSP_DATEFMT_JIS");
            this.m_dataBean.setDateFormat(new ChoiceDescriptor("AJDSP_DATEFMT_JIS", string));
        }
        if (aS400JDBCDataSource.getDateSeparator().equals("")) {
            string = resource_Loader.getString("AJDSP_USE_SERVER_JOB");
            this.m_dataBean.setDateSeparator(new ChoiceDescriptor("AJDSP_USE_SERVER_JOB", string));
        } else if (aS400JDBCDataSource.getDateSeparator().equals("/")) {
            string = resource_Loader.getString("AJDSP_DATESEP_FORWARDSLASH");
            this.m_dataBean.setDateSeparator(new ChoiceDescriptor("AJDSP_DATESEP_FORWARDSLASH", string));
        } else if (aS400JDBCDataSource.getDateSeparator().equals("-")) {
            string = resource_Loader.getString("AJDSP_DATESEP_DASH");
            this.m_dataBean.setDateSeparator(new ChoiceDescriptor("AJDSP_DATESEP_DASH", string));
        } else if (aS400JDBCDataSource.getDateSeparator().equals(".")) {
            string = resource_Loader.getString("AJDSP_DATESEP_PERIOD");
            this.m_dataBean.setDateSeparator(new ChoiceDescriptor("AJDSP_DATESEP_PERIOD", string));
        } else if (aS400JDBCDataSource.getDateSeparator().equals(",")) {
            string = resource_Loader.getString("AJDSP_DATESEP_COMMA");
            this.m_dataBean.setDateSeparator(new ChoiceDescriptor("AJDSP_DATESEP_COMMA", string));
        } else if (aS400JDBCDataSource.getDateSeparator().equals("b")) {
            string = resource_Loader.getString("AJDSP_DATESEP_BLANK");
            this.m_dataBean.setDateSeparator(new ChoiceDescriptor("AJDSP_DATESEP_BLANK", string));
        }
        this.m_dataBean.setDefaultUserID(aS400JDBCDataSource.getUser());
        this.m_dataBean.setUseSSL(aS400JDBCDataSource.isSecure());
    }

    public void removeTabAt(int n) {
        switch (n) {
            case 0: {
                this.m_tabbedPaneManager.removePane("AJDSP_GENERAL");
                break;
            }
            case 1: {
                this.m_tabbedPaneManager.removePane("AJDSP_SERVER");
                break;
            }
            case 2: {
                this.m_tabbedPaneManager.removePane("AJDSP_PACKAGE");
                break;
            }
            case 3: {
                this.m_tabbedPaneManager.removePane("AJDSP_PERFORMANCE");
                break;
            }
            case 4: {
                this.m_tabbedPaneManager.removePane("AJDSP_LANGUAGE");
                break;
            }
            case 5: {
                this.m_tabbedPaneManager.removePane("AJDSP_OTHER");
                break;
            }
            case 6: {
                this.m_tabbedPaneManager.removePane("AJDSP_TRANSLATION");
                break;
            }
            case 7: {
                this.m_tabbedPaneManager.removePane("AJDSP_FORMAT");
                break;
            }
            case 8: {
                this.m_tabbedPaneManager.removePane("AJDSP_CONNOPT");
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
    }

    static {
        resource_Loader.setResourceName("com.ibm.as400.vaccess.AS400JDBCDataSourcePaneGUI");
    }
}

