/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ProgramAttributeGetter;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.ProgramMapEntry;
import com.ibm.as400.resource.ResourceException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class ProgramAttributeSetter
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private ProgramMap attributeMap_ = null;
    private int defaultBidiStringType_ = -1;
    private ProgramCallDocument document_ = null;
    private AS400 system_ = null;

    public ProgramAttributeSetter(AS400 aS400, ProgramCallDocument programCallDocument, ProgramMap programMap) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (programCallDocument == null) {
            throw new NullPointerException("document");
        }
        if (programMap == null) {
            throw new NullPointerException("attributeMap");
        }
        this.system_ = aS400;
        this.document_ = programCallDocument;
        this.attributeMap_ = programMap;
    }

    public void initializeAttributeValues(ProgramAttributeGetter programAttributeGetter) throws ResourceException {
        this.initializeAttributeValues(programAttributeGetter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeAttributeValues(ProgramAttributeGetter programAttributeGetter, Object[] objectArray) throws ResourceException {
        programAttributeGetter.clearBuffer();
        if (this.defaultBidiStringType_ == -1) {
            this.defaultBidiStringType_ = AS400BidiTransform.getStringType((char)this.system_.getCcsid());
        }
        try {
            ProgramAttributeSetter programAttributeSetter = this;
            synchronized (programAttributeSetter) {
                Object object;
                Object object2;
                int n;
                Object[] objectArray2 = this.attributeMap_.getIDs();
                if (objectArray != null) {
                    for (n = 0; n < objectArray.length; ++n) {
                        object2 = objectArray[n];
                        boolean bl = false;
                        for (int i = n; i < objectArray2.length; ++i) {
                            if (!objectArray2[i].equals(object2)) continue;
                            object = objectArray2[n];
                            objectArray2[n] = objectArray2[i];
                            objectArray2[i] = object;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        Trace.log(2, "Specified attribute ID is not in the getter's map: " + (String)object2);
                        throw new ResourceException(2);
                    }
                }
                for (n = 0; n < objectArray2.length; ++n) {
                    object2 = (String)objectArray2[n];
                    Object object3 = programAttributeGetter.getValue(object2);
                    ProgramMapEntry[] programMapEntryArray = this.attributeMap_.getEntries(object2);
                    object = null;
                    for (int i = 0; i < programMapEntryArray.length; ++i) {
                        object = programMapEntryArray[i].getProgramName();
                        programMapEntryArray[i].setValue(this.system_, this.document_, null, null, object3, this.defaultBidiStringType_);
                    }
                }
            }
        }
        catch (PcmlException pcmlException) {
            throw new ResourceException(2, (Throwable)pcmlException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(Object[] objectArray, Object[] objectArray2) throws ResourceException {
        if (objectArray == null) {
            throw new NullPointerException("attributeIDs");
        }
        if (objectArray2 == null) {
            throw new NullPointerException("values");
        }
        if (objectArray.length != objectArray2.length) {
            throw new ExtendedIllegalArgumentException("values", 2);
        }
        if (this.defaultBidiStringType_ == -1) {
            this.defaultBidiStringType_ = AS400BidiTransform.getStringType((char)this.system_.getCcsid());
        }
        ProgramAttributeSetter programAttributeSetter = this;
        synchronized (programAttributeSetter) {
            Object object;
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < objectArray.length; ++i) {
                object = this.attributeMap_.getEntries(objectArray[i]);
                String string = null;
                int n = -1;
                for (int j = 0; j < ((ProgramMapEntry[])object).length; ++j) {
                    string = object[j].getProgramName();
                    if (!vector.contains(string)) continue;
                    n = j;
                    try {
                        object[j].setValue(this.system_, this.document_, null, null, objectArray2[i], this.defaultBidiStringType_);
                        if (!Trace.isTraceOn()) break;
                        Trace.log(3, "Setting attribute value using PCML document " + this.document_ + ", program " + string + ".");
                        break;
                    }
                    catch (PcmlException pcmlException) {
                        throw new ResourceException(2, (Throwable)pcmlException);
                    }
                }
                if (n >= 0) continue;
                n = 0;
                string = object[0].getProgramName();
                try {
                    object[0].setValue(this.system_, this.document_, null, null, objectArray2[i], this.defaultBidiStringType_);
                    if (Trace.isTraceOn()) {
                        Trace.log(3, "Setting attribute value using PCML document " + this.document_ + ", program " + string + ".");
                    }
                    vector.addElement(string);
                    continue;
                }
                catch (PcmlException pcmlException) {
                    throw new ResourceException(2, (Throwable)pcmlException);
                }
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                boolean bl = false;
                try {
                    bl = this.document_.callProgram((String)object);
                    if (bl) continue;
                    throw new ResourceException(this.document_.getMessageList((String)object));
                }
                catch (PcmlException pcmlException) {
                    throw new ResourceException(2, (Throwable)pcmlException);
                }
            }
        }
    }
}

