/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlDocRoot;
import com.ibm.as400.data.PcmlDocument;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlNode;
import java.util.Enumeration;

abstract class PcmlDocNode
extends PcmlNode {
    public final int PROGRAM = 1;
    public final int STRUCT = 2;
    public final int DATA = 3;
    public final int RECORDFORMAT = 5;
    public static final int UNSUPPORTED = 0;
    public static final int INHERIT = 1;
    public static final int INPUT = 2;
    public static final int OUTPUT = 3;
    public static final int INPUTOUTPUT = 4;
    static final long serialVersionUID = 2085968464631195453L;
    protected transient PcmlAttributeList m_XmlAttrs;
    private String m_Name;
    private String m_QualName;
    private String m_TagName;
    private int m_NodeType;
    private int m_Usage;
    private String m_Type;
    private String m_Struct;
    private String m_CondensedName;
    private boolean m_IsExtendedType;
    private int m_CountReps;

    public PcmlDocNode() {
        this.m_XmlAttrs = null;
        this.m_Name = null;
        this.m_QualName = null;
        this.m_TagName = "";
        this.m_CondensedName = "";
        this.m_IsExtendedType = false;
        this.m_NodeType = 1;
        this.m_CountReps = -10;
    }

    public PcmlDocNode(PcmlAttributeList pcmlAttributeList) {
        this.m_XmlAttrs = pcmlAttributeList;
        this.m_TagName = "";
        this.m_CondensedName = "";
        this.m_IsExtendedType = false;
        this.m_CountReps = -10;
        this.m_NodeType = 1;
        this.m_Name = this.getAttributeValue("name");
        this.m_QualName = null;
        this.setUsage(this.getAttributeValue("usage"));
        this.m_Type = this.getAttributeValue("type");
        this.m_Struct = this.getAttributeValue("struct");
    }

    public Object clone() {
        PcmlDocNode pcmlDocNode = null;
        PcmlDocNode pcmlDocNode2 = null;
        PcmlDocNode pcmlDocNode3 = (PcmlDocNode)super.clone();
        pcmlDocNode3.m_QualName = null;
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            pcmlDocNode = (PcmlDocNode)enumeration.nextElement();
            pcmlDocNode2 = (PcmlDocNode)pcmlDocNode.clone();
            pcmlDocNode3.addChild(pcmlDocNode2);
        }
        return pcmlDocNode3;
    }

    protected void addChild(PcmlNode pcmlNode) {
        super.addChild(pcmlNode);
        String string = pcmlNode.getQualifiedName();
        if (!string.equals("") && this.getDoc() != null) {
            if (this.getDoc().containsElement(string)) {
                this.getDoc().addPcmlSpecificationError("MULTIPLE_DEFINE", new Object[]{string});
            }
            this.getRootNode().addElement(pcmlNode);
        }
    }

    AS400 getAs400() {
        return this.getDoc().getAs400();
    }

    int getAs400VRM() throws PcmlException {
        return this.getDoc().getAs400VRM();
    }

    final PcmlDocument getDoc() {
        return (PcmlDocument)this.getRootNode();
    }

    public String getName() {
        if (this.m_Name == null) {
            return "";
        }
        return this.m_Name;
    }

    public String getQualifiedName() {
        if (this.m_QualName != null && !this.m_QualName.equals("")) {
            return this.m_QualName;
        }
        String string = this.getName();
        if (this.getDoc() == null) {
            return "";
        }
        if (this.getParent() == null) {
            return "";
        }
        if (string.equals("") && this.getParent().getParent() != null) {
            return "";
        }
        String string2 = ((PcmlDocNode)this.getParent()).getQualifiedName();
        if (string2.equals("")) {
            if (this.getParent().getParent() != null) {
                return "";
            }
            this.m_QualName = string;
            return this.m_QualName;
        }
        this.m_QualName = string2 + "." + string;
        return this.m_QualName;
    }

    public String getNameForException() {
        String string;
        String string2 = this.getName();
        if (this.getParent() == null) {
            return "";
        }
        if (string2.equals("")) {
            string2 = "[" + Integer.toString(this.getChildNbr()) + "]";
        }
        if ((string = ((PcmlDocNode)this.getParent()).getQualifiedName()).equals("")) {
            return string2;
        }
        return string + "." + string2;
    }

    int getNodeType() {
        return this.m_NodeType;
    }

    protected void setNodeType(int n) {
        this.m_NodeType = n;
        switch (this.m_NodeType) {
            case 1: {
                this.m_TagName = "pcml";
                break;
            }
            case 5: {
                this.m_TagName = "rfml";
                break;
            }
            case 2: {
                this.m_TagName = "program";
                break;
            }
            case 6: {
                this.m_TagName = "recordformat";
                break;
            }
            case 3: {
                this.m_TagName = "struct";
                break;
            }
            case 4: {
                this.m_TagName = "data";
            }
        }
    }

    protected String getStructName() {
        return this.m_Struct;
    }

    protected String getType() {
        return this.m_Type;
    }

    public int getUsage() {
        if (this.m_Usage == 1) {
            if (this.getParent() == null) {
                return 4;
            }
            return ((PcmlDocNode)this.getParent()).getUsage();
        }
        return this.m_Usage;
    }

    String resolveRelativeName(String string) {
        PcmlDocNode pcmlDocNode = this.resolveRelativeNode(string);
        if (pcmlDocNode != null) {
            return pcmlDocNode.getQualifiedName();
        }
        return null;
    }

    PcmlDocNode resolveRelativeNode(String string) {
        PcmlDocRoot pcmlDocRoot = this.getRootNode();
        PcmlDocNode pcmlDocNode = null;
        if (string == null) {
            return null;
        }
        for (PcmlDocNode pcmlDocNode2 = (PcmlDocNode)this.getParent(); pcmlDocNode2 != null; pcmlDocNode2 = (PcmlDocNode)pcmlDocNode2.getParent()) {
            String string2 = pcmlDocNode2.getQualifiedName();
            string2 = string2.equals("") ? string : string2 + "." + string;
            pcmlDocNode = (PcmlDocNode)pcmlDocRoot.getElement(string2);
            if (pcmlDocNode == null) continue;
            return pcmlDocNode;
        }
        return null;
    }

    public String toString() {
        String string = this.getQualifiedName();
        if (string.equals("")) {
            return super.toString();
        }
        return super.toString() + ":" + string;
    }

    String getTagName() {
        return this.m_TagName;
    }

    String getBracketedTagName() {
        return "<" + this.m_TagName + ">";
    }

    abstract String[] getAttributeList();

    protected String getAttributeValue(String string) {
        return this.m_XmlAttrs.getAttributeValue(string);
    }

    private void setUsage(String string) {
        this.m_Usage = string == null || string.equals("") ? 1 : (string.equals("inherit") ? 1 : (string.equals("input") ? 2 : (string.equals("output") ? 3 : (string.equals("inputoutput") ? 4 : 0))));
    }

    protected void checkAttributes() {
        if (this.m_Name != null && (this.m_Name.indexOf(37) == 0 || this.m_Name.indexOf(47) == 0 || this.m_Name.indexOf(92) == 0 || this.m_Name.indexOf(58) == 0 || this.m_Name.indexOf(91) == 0 || this.m_Name.indexOf(46) > -1 || this.m_Name.indexOf(32) > -1)) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_SYNTAX", new Object[]{PcmlDocNode.makeQuotedAttr("name", this.m_Name), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_Usage == 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_SYNTAX", new Object[]{PcmlDocNode.makeQuotedAttr("usage", this.getAttributeValue("usage")), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_NodeType == 1) {
            this.getDoc().addPcmlSpecificationError("BAD_TAG", new Object[]{this.getBracketedTagName(), this.getNameForException()});
        }
    }

    protected static String makeQuotedAttr(String string, String string2) {
        return string + "=\"" + string2 + "\"";
    }

    protected static String makeQuotedAttr(String string, int n) {
        return PcmlDocNode.makeQuotedAttr(string, Integer.toString(n));
    }

    void setCondensedName(String string) {
        this.m_CondensedName = string;
    }

    String getCondensedName() {
        return this.m_CondensedName;
    }

    void setIsExtendedType(boolean bl) {
        this.m_IsExtendedType = bl;
    }

    boolean getIsExtendedType() {
        return this.m_IsExtendedType;
    }

    protected void setCountReps(int n) {
        this.m_CountReps = n;
    }

    protected int getCountReps() {
        return this.m_CountReps;
    }
}

