/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLDate;
import com.ibm.as400.access.SQLTime;
import com.ibm.as400.access.SQLTimestamp;
import java.io.CharConversionException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

final class SQLChar
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private int maxLength_;
    private String value_;

    SQLChar(int n, SQLConversionSettings sQLConversionSettings) {
        super(sQLConversionSettings);
        this.maxLength_ = n;
        this.value_ = "";
    }

    public Object clone() {
        return new SQLChar(this.maxLength_, this.settings_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        int n2 = this.settings_.getBidiStringType();
        if (n2 == -1) {
            n2 = convTable.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n2);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        try {
            this.value_ = convTable.byteArrayToString(byArray, n, this.maxLength_, bidiConversionProperties);
        }
        catch (Exception exception) {
            JDError.throwSQLException("22524", exception);
        }
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        int n2 = this.settings_.getBidiStringType();
        if (n2 == -1) {
            n2 = convTable.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n2);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        try {
            this.truncated_ = convTable.stringToByteArray(this.value_, byArray, n, this.maxLength_, bidiConversionProperties);
        }
        catch (CharConversionException charConversionException) {
            this.maxLength_ = convTable.stringToByteArray(this.value_, bidiConversionProperties).length;
            JDError.throwSQLException(this, "HY000", charConversionException, "Change Descriptor");
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        int n2;
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Character) {
            string = object.toString();
        } else if (object instanceof Number) {
            string = object.toString();
        } else if (object instanceof Boolean) {
            string = this.settings_.getTranslateBoolean() ? object.toString() : ((Boolean)object == true ? "1" : "0");
        } else if (object instanceof Time) {
            string = SQLTime.timeToString((Time)object, this.settings_, calendar);
        } else if (object instanceof Timestamp) {
            string = SQLTimestamp.timestampToString((Timestamp)object, calendar);
        } else if (object instanceof Date) {
            string = SQLDate.dateToString((Date)object, this.settings_, calendar);
        } else if (object instanceof URL) {
            string = object.toString();
        } else if (JDUtilities.JDBCLevel_ >= 20 && object instanceof Clob) {
            Clob clob = (Clob)object;
            string = clob.getSubString(1L, (int)clob.length());
        }
        if (string == null) {
            JDError.throwSQLException((Object)this, "07006");
        }
        this.value_ = string;
        int n3 = this.value_.length();
        if (n3 < (n2 = this.getDisplaySize())) {
            StringBuffer stringBuffer = new StringBuffer(this.value_);
            char c = ' ';
            for (int i = n3; i < n2; ++i) {
                stringBuffer.append(c);
            }
            this.value_ = stringBuffer.toString();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
        } else if (n3 > n2) {
            this.value_ = this.value_.substring(0, n2);
            this.truncated_ = n3 - n2;
            this.outOfBounds_ = false;
        } else {
            this.truncated_ = 0;
        }
        this.outOfBounds_ = false;
    }

    public int getSQLType() {
        return 5;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH");
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "java.lang.String";
    }

    public String getLiteralPrefix() {
        return "'";
    }

    public String getLiteralSuffix() {
        return "'";
    }

    public String getLocalName() {
        return "CHAR";
    }

    public int getMaximumPrecision() {
        return 32765;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 452;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 1;
    }

    public String getTypeName() {
        return "CHAR";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.value_.length();
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new HexReaderInputStream(new StringReader(this.getString()));
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.getString()), this.maxLength_);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            Double d = new Double(this.value_.trim());
            double d2 = d;
            if (d2 > 127.0 || d2 < -128.0) {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
            return d.byteValue();
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return -1;
        }
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public Object getObject() throws SQLException {
        return this.getString();
    }

    public String getString() throws SQLException {
        int n = this.settings_.getMaxFieldSize();
        if (this.value_.length() > n && n > 0) {
            return this.value_.substring(0, n);
        }
        return this.value_;
    }

    public void trim() {
        this.value_ = this.value_.trim();
    }

    public String getNString() throws SQLException {
        int n = this.settings_.getMaxFieldSize();
        if (this.value_.length() > n && n > 0) {
            return this.value_.substring(0, n);
        }
        return this.value_;
    }
}

