/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.NPAttribute;
import com.ibm.as400.access.NPAttributeIFS;
import com.ibm.as400.access.NPCodePoint;
import com.ibm.as400.access.PrintObject;

class NPCPAttributeIDList
extends NPCodePoint
implements Cloneable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final int LEN_ATTRLIST_HEADER = 4;
    private byte[] idList_;
    private boolean fDataOutOfDate_;
    private boolean fListOutOfDate_;

    protected Object clone() {
        NPCPAttributeIDList nPCPAttributeIDList = new NPCPAttributeIDList(this);
        return nPCPAttributeIDList;
    }

    NPCPAttributeIDList(NPCPAttributeIDList nPCPAttributeIDList) {
        super(nPCPAttributeIDList);
        this.fDataOutOfDate_ = nPCPAttributeIDList.fDataOutOfDate_;
        this.fListOutOfDate_ = nPCPAttributeIDList.fListOutOfDate_;
        this.idList_ = new byte[336];
        System.arraycopy(nPCPAttributeIDList.idList_, 0, this.idList_, 0, this.idList_.length);
    }

    public NPCPAttributeIDList() {
        super(7);
        this.fDataOutOfDate_ = false;
        this.fListOutOfDate_ = false;
        this.idList_ = new byte[336];
    }

    NPCPAttributeIDList(byte[] byArray) {
        super(7, byArray);
        this.fDataOutOfDate_ = false;
        this.fListOutOfDate_ = true;
        this.idList_ = new byte[336];
    }

    int getLength() {
        if (this.fDataOutOfDate_) {
            this.updateData();
        }
        return super.getLength();
    }

    void setDataBuffer(byte[] byArray, int n, int n2) {
        this.fListOutOfDate_ = true;
        this.fDataOutOfDate_ = false;
        super.setDataBuffer(byArray, n, n2);
    }

    byte[] getDataBuffer() {
        if (this.fDataOutOfDate_) {
            this.updateData();
        }
        return super.getDataBuffer();
    }

    byte[] getDataBuffer(int n) {
        if (this.fDataOutOfDate_) {
            this.updateData();
        }
        this.fListOutOfDate_ = true;
        return super.getDataBuffer(n);
    }

    void reset() {
        this.zeroIDList();
        this.fListOutOfDate_ = false;
        this.fDataOutOfDate_ = false;
        super.reset();
    }

    void addAttrID(int n) {
        if (!NPAttribute.idIsValid(n)) {
            throw new ExtendedIllegalArgumentException(PrintObject.getAttributeName(n), 2);
        }
        if (this.fListOutOfDate_) {
            this.updateList();
        }
        if (n < 0) {
            n = Math.abs(n) - 1;
            NPAttributeIFS nPAttributeIFS = NPAttributeIFS.ifsAttrs[n];
            this.idList_[nPAttributeIFS.nameID_] = 1;
            this.idList_[nPAttributeIFS.libraryID_] = 1;
            if (nPAttributeIFS.typeID_ != 0) {
                this.idList_[nPAttributeIFS.typeID_] = 1;
            }
        } else {
            this.idList_[n] = 1;
        }
        this.fDataOutOfDate_ = true;
    }

    boolean containsID(int n) {
        boolean bl = false;
        if (NPAttribute.idIsValid(n)) {
            if (this.fListOutOfDate_) {
                this.updateList();
            }
            if (n < 0) {
                n = Math.abs(n) - 1;
                NPAttributeIFS nPAttributeIFS = NPAttributeIFS.ifsAttrs[n];
                if (this.idList_[nPAttributeIFS.nameID_] != 0 && this.idList_[nPAttributeIFS.libraryID_] != 0) {
                    if (nPAttributeIFS.typeID_ != 0) {
                        if (this.idList_[nPAttributeIFS.typeID_] != 0) {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                }
            } else if (this.idList_[n] != 0) {
                bl = true;
            }
        }
        return bl;
    }

    private void updateData() {
        int n;
        int n2 = 0;
        int n3 = 4;
        for (n = 0; n < this.idList_.length; ++n) {
            if (this.idList_[n] == 0) continue;
            ++n2;
        }
        byte[] byArray = super.getDataBuffer(n3 += 2 * n2);
        int n4 = super.getOffset();
        BinaryConverter.unsignedShortToByteArray(n2, byArray, n4);
        BinaryConverter.unsignedShortToByteArray(2, byArray, n4 += 2);
        n4 += 2;
        for (n = 0; n < this.idList_.length && n2 != 0; ++n) {
            if (this.idList_[n] == 0) continue;
            BinaryConverter.unsignedShortToByteArray(n, byArray, n4);
            n4 += 2;
            --n2;
        }
        this.fDataOutOfDate_ = false;
    }

    private void updateList() {
        this.zeroIDList();
        byte[] byArray = super.getDataBuffer();
        if (byArray != null && byArray.length >= 4) {
            long l = super.getDataLength();
            int n = super.getOffset();
            if (l > 4L) {
                int n2;
                int n3 = BinaryConverter.byteArrayToUnsignedShort(byArray, n);
                n += 2;
                if (n3 != 0 && (n2 = BinaryConverter.byteArrayToUnsignedShort(byArray, n)) == 2 && l >= (long)((n += 2) + n3 * 2)) {
                    while (n3 != 0) {
                        int n4 = BinaryConverter.byteArrayToUnsignedShort(byArray, n);
                        n += 2;
                        --n3;
                        if (n4 < 0 || n4 >= this.idList_.length) continue;
                        this.idList_[n4] = 1;
                    }
                }
            }
        }
        this.fListOutOfDate_ = false;
    }

    private void zeroIDList() {
        int n = this.idList_.length;
        for (int i = 0; i < n; ++i) {
            this.idList_[i] = 0;
        }
    }
}

