/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class LineDataRecordWriter {
    private OutputStream outPut;
    private Converter cvt;
    private ByteArrayOutputStream buffer;

    public LineDataRecordWriter(OutputStream outputStream, AS400 aS400) throws UnsupportedEncodingException {
        this.outPut = outputStream;
        this.cvt = new Converter(aS400.getCcsid(), aS400);
        this.buffer = new ByteArrayOutputStream();
    }

    public LineDataRecordWriter(OutputStream outputStream, int n, AS400 aS400) throws UnsupportedEncodingException {
        this.outPut = outputStream;
        this.cvt = new Converter(n, aS400);
        this.buffer = new ByteArrayOutputStream();
    }

    private void addToBuffer(byte[] byArray) throws IOException {
        if (this.outPut == null) {
            throw new IOException("Stream closed");
        }
        int n = byArray.length;
        this.buffer.write(byArray, 0, n);
    }

    public int getCcsid() {
        if (this.cvt == null) {
            return 0;
        }
        return this.cvt.getCcsid();
    }

    public String getEncoding() {
        if (this.cvt == null) {
            return null;
        }
        return this.cvt.getEncoding();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void retrieveRecord(Record record) throws IOException, UnsupportedEncodingException, ExtendedIllegalStateException {
        RecordFormat recordFormat = record.getRecordFormat();
        String string = recordFormat.getRecordFormatID();
        int n = recordFormat.getRecordFormatType();
        Object[] objectArray = record.getFields();
        char c = recordFormat.getDelimiter();
        if (string == "") {
            throw new ExtendedIllegalStateException("recordFormatID", 4);
        }
        if (n == 0) {
            throw new ExtendedIllegalStateException("recordFormatType for record format " + string, 4);
        }
        byte[] byArray = this.cvt.stringToByteArray(string);
        this.addToBuffer(byArray);
        for (int i = 0; i < objectArray.length; ++i) {
            String string2;
            FieldDescription fieldDescription = recordFormat.getFieldDescription(i);
            String string3 = objectArray[i].toString();
            int n2 = string3.length();
            if (n == 1) {
                int n3 = fieldDescription.getLayoutAlignment();
                int n4 = fieldDescription.getLayoutLength();
                if (n3 == 0) {
                    n3 = 1;
                }
                if (n4 < n2) throw new ExtendedIllegalArgumentException("Field description " + fieldDescription.getFieldName(), 1);
                int n5 = n4 - n2;
                String string4 = this.pad(n5);
                string2 = n3 == 2 ? string4 + string3 : string3 + string4;
            } else {
                if (c == '\u0000') {
                    throw new ExtendedIllegalStateException("delimiter for record format " + string, 4);
                }
                string2 = string3 + c;
            }
            byte[] byArray2 = this.cvt.stringToByteArray(string2);
            this.addToBuffer(byArray2);
        }
    }

    public void writeRecord(Record record) throws IOException, UnsupportedEncodingException, ExtendedIllegalStateException {
        this.buffer.reset();
        this.retrieveRecord(record);
        if (this.buffer.size() > 0) {
            if (this.outPut == null) {
                throw new IOException("Stream closed");
            }
            this.buffer.writeTo(this.outPut);
            this.outPut.flush();
            this.buffer.reset();
        }
    }

    private String pad(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

