/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ActionCompletedEvent;
import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.JavaApplicationCallThread;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class JavaApplicationCall
implements Serializable {
    static final long serialVersionUID = 4L;
    private static int DEFAULT_STANDARD_ERROR_PORT = 2852;
    private static int DEFAULT_STANDARD_IN_PORT = 2850;
    private static int DEFAULT_STANDARD_OUT_PORT = 2851;
    private static int PORT_SEARCH_TIMES = 1000;
    private AS400 as400_ = null;
    private CommandCall command_ = null;
    private AS400Message[] messageList_ = null;
    private transient PropertyChangeSupport propertyChange_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetoableChange_ = new VetoableChangeSupport(this);
    private transient Vector completedListeners_ = new Vector();
    private transient JavaApplicationCallThread openSocketsThread_ = null;
    private transient ServerSocket error_ = null;
    private transient ServerSocket read_ = null;
    private transient ServerSocket write_ = null;
    private String classPath_ = "";
    private int defaultPort_ = DEFAULT_STANDARD_IN_PORT;
    private boolean findPort_ = true;
    private int garbageCollectionInitialSize_ = 2048;
    private String garbageCollectionMaximumSize_ = "*NOMAX";
    private int garbageCollectionFrequency_ = 50;
    private int garbageCollectionPriority_ = 20;
    private String interpret_ = "*OPTIMIZE";
    private String jobname_ = "QJVACMDSRV";
    private String javaApplication_ = null;
    private String optimization_ = "10";
    private String[] options_ = new String[]{"*NONE"};
    private String[] parameters_ = new String[0];
    private Properties properties_ = null;
    private String securityCheckLevel_ = "*WARN";
    private int standardErrorPort_ = DEFAULT_STANDARD_ERROR_PORT;
    private int standardInPort_ = DEFAULT_STANDARD_IN_PORT;
    private int standardOutPort_ = DEFAULT_STANDARD_OUT_PORT;

    public JavaApplicationCall() {
    }

    public JavaApplicationCall(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.as400_ = aS400;
    }

    public JavaApplicationCall(AS400 aS400, String string) {
        this(aS400);
        if (string == null) {
            throw new NullPointerException("application");
        }
        this.javaApplication_ = string;
    }

    public JavaApplicationCall(AS400 aS400, String string, String string2) {
        this(aS400, string);
        if (string2 == null) {
            throw new NullPointerException("classPath");
        }
        this.classPath_ = string2;
    }

    public void addActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        if (actionCompletedListener == null) {
            throw new NullPointerException("addActionCompletedListener");
        }
        this.completedListeners_.addElement(actionCompletedListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("addPropertyChangeListener");
        }
        this.propertyChange_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("addVetoableChangeListener");
        }
        this.vetoableChange_.addVetoableChangeListener(vetoableChangeListener);
    }

    public String getClassPath() {
        return this.classPath_;
    }

    public CommandCall getCommandCall() {
        return this.command_;
    }

    public int getDefaultPort() {
        return this.defaultPort_;
    }

    private void getFreePort() {
        this.read_ = null;
        this.write_ = null;
        this.error_ = null;
        if (!this.isFindPort()) {
            this.standardInPort_ = this.defaultPort_;
            this.standardOutPort_ = this.defaultPort_ + 1;
            this.standardErrorPort_ = this.defaultPort_ + 2;
            try {
                this.read_ = new ServerSocket(this.standardInPort_);
            }
            catch (Exception exception) {
                Trace.log(2, exception.toString(), (Throwable)exception);
            }
            try {
                this.write_ = new ServerSocket(this.standardOutPort_);
            }
            catch (Exception exception) {
                Trace.log(2, exception.toString(), (Throwable)exception);
            }
            try {
                this.error_ = new ServerSocket(this.standardErrorPort_);
            }
            catch (Exception exception) {
                Trace.log(2, exception.toString(), (Throwable)exception);
            }
        } else {
            this.standardInPort_ = this.searchPort(this.defaultPort_, DEFAULT_STANDARD_IN_PORT);
            this.standardOutPort_ = this.searchPort(this.standardInPort_ + 1, DEFAULT_STANDARD_OUT_PORT);
            this.standardErrorPort_ = this.searchPort(this.standardOutPort_ + 1, DEFAULT_STANDARD_ERROR_PORT);
        }
        if (this.read_ == null || this.write_ == null || this.error_ == null) {
            try {
                if (this.read_ != null) {
                    this.read_.close();
                }
                this.read_ = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.write_ != null) {
                    this.write_.close();
                }
                this.write_ = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.error_ != null) {
                    this.error_.close();
                }
                this.error_ = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string = "Setup of connection with IBM i system failed.";
            Trace.log(2, string);
            throw new RuntimeException(string);
        }
    }

    public int getGarbageCollectionFrequency() {
        return this.garbageCollectionFrequency_;
    }

    public int getGarbageCollectionInitialSize() {
        return this.garbageCollectionInitialSize_;
    }

    public String getGarbageCollectionMaximumSize() {
        return this.garbageCollectionMaximumSize_;
    }

    public int getGarbageCollectionPriority() {
        return this.garbageCollectionPriority_;
    }

    public String getInterpret() {
        return this.interpret_;
    }

    public String getJavaApplication() {
        return this.javaApplication_;
    }

    public String getJobName() {
        return this.jobname_;
    }

    public AS400Message[] getMessageList() {
        return this.messageList_;
    }

    public String getOptimization() {
        return this.optimization_;
    }

    public String[] getOptions() {
        return this.options_;
    }

    public String[] getParameters() {
        return this.parameters_;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public String getSecurityCheckLevel() {
        return this.securityCheckLevel_;
    }

    private int getStandardErrorPort() {
        return this.standardErrorPort_;
    }

    public String getStandardErrorString() {
        if (this.openSocketsThread_ != null) {
            return this.openSocketsThread_.getStandardErrorString();
        }
        return null;
    }

    private int getStandardInPort() {
        return this.standardInPort_;
    }

    private int getStandardOutPort() {
        return this.standardOutPort_;
    }

    public String getStandardOutString() {
        if (this.openSocketsThread_ != null) {
            return this.openSocketsThread_.getStandardOutString();
        }
        return null;
    }

    public AS400 getSystem() {
        return this.as400_;
    }

    public boolean isFindPort() {
        return this.findPort_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.propertyChange_ = new PropertyChangeSupport(this);
        this.vetoableChange_ = new VetoableChangeSupport(this);
        this.completedListeners_ = new Vector();
        this.openSocketsThread_ = null;
        this.read_ = null;
        this.write_ = null;
        this.error_ = null;
    }

    public synchronized void removeActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        if (actionCompletedListener == null) {
            throw new NullPointerException("removeActionCompletedListener");
        }
        this.completedListeners_.removeElement(actionCompletedListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("removePropertyChangeListener");
        }
        this.propertyChange_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("removeVetoableChangeListener");
        }
        this.vetoableChange_.removeVetoableChangeListener(vetoableChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run() throws AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException {
        boolean bl;
        Object object;
        block21: {
            String[] stringArray;
            if (this.getSystem() == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            if (this.getJavaApplication() == null) {
                throw new ExtendedIllegalStateException("javaApplication", 4);
            }
            this.getSystem().getVRM();
            this.getFreePort();
            this.openSocketsThread_ = new JavaApplicationCallThread(this.read_, this.write_, this.error_);
            this.openSocketsThread_.start();
            this.command_ = new CommandCall(this.getSystem());
            this.command_.suggestThreadsafe(false);
            StringBuffer stringBuffer = new StringBuffer("JAVA CLASS(" + this.getJavaApplication() + ") ");
            String[] stringArray2 = this.getParameters();
            if (stringArray2.length > 0) {
                stringBuffer.append("PARM(");
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringBuffer.append("'" + stringArray2[i] + "' ");
                }
                stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                stringBuffer.append(") ");
            }
            if (this.getClassPath().length() > 0) {
                stringBuffer.append("CLASSPATH('" + this.getClassPath() + "') ");
            }
            stringBuffer.append("CHKPATH(" + this.getSecurityCheckLevel() + ") ");
            stringBuffer.append("OPTIMIZE(" + this.getOptimization() + ") ");
            stringBuffer.append("INTERPRET(" + this.getInterpret() + ") ");
            String string = null;
            try {
                stringArray = new Socket(this.getSystem().getSystemName(), 449);
                string = stringArray.getLocalAddress().getHostAddress();
                stringArray.close();
            }
            catch (Exception exception) {
                string = null;
            }
            if (string == null) {
                string = "localhost";
                try {
                    string = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    Trace.log(2, unknownHostException.toString());
                }
            }
            stringBuffer.append("PROP((os400.stdin 'port:" + string + ":" + new Integer(this.getStandardInPort()).toString() + "') " + "(os400.stdout 'port:" + string + ":" + new Integer(this.getStandardOutPort()).toString() + "') " + "(os400.stderr 'port:" + string + ":" + new Integer(this.getStandardErrorPort()).toString() + "') ");
            stringBuffer.append("(os400.stdio.convert N)");
            if (this.getProperties() != null) {
                stringArray = ((Hashtable)this.properties_).keys();
                while (stringArray.hasMoreElements()) {
                    String string2 = (String)stringArray.nextElement();
                    object = (String)((Hashtable)this.properties_).get(string2);
                    stringBuffer.append(" (" + string2 + " " + (String)object + ")");
                }
            }
            stringBuffer.append(") ");
            stringBuffer.append("GCHINL(" + this.getGarbageCollectionInitialSize() + ") ");
            stringBuffer.append("GCHMAX(" + this.getGarbageCollectionMaximumSize() + ") ");
            stringBuffer.append("GCFRQ(" + this.getGarbageCollectionFrequency() + ") ");
            stringBuffer.append("GCPTY(" + this.getGarbageCollectionPriority() + ") ");
            stringArray = this.getOptions();
            if (stringArray.length > 0) {
                stringBuffer.append("OPTION(");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i] + " ");
                }
                stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                stringBuffer.append(") ");
            }
            if (this.as400_.getVRM() >= 328448) {
                stringBuffer.append("JOB(" + this.getJobName() + ") ");
            }
            bl = false;
            try {
                Object var8_13;
                try {
                    bl = this.command_.run(stringBuffer.toString());
                }
                catch (PropertyVetoException propertyVetoException) {
                    var8_13 = null;
                    this.openSocketsThread_.closeSockets();
                    this.openSocketsThread_ = null;
                    this.parameters_ = new String[0];
                    this.properties_ = null;
                    this.read_ = null;
                    this.write_ = null;
                    this.error_ = null;
                    break block21;
                }
                var8_13 = null;
                this.openSocketsThread_.closeSockets();
                this.openSocketsThread_ = null;
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                this.openSocketsThread_.closeSockets();
                this.openSocketsThread_ = null;
                this.parameters_ = new String[0];
                this.properties_ = null;
                this.read_ = null;
                this.write_ = null;
                this.error_ = null;
                throw throwable;
            }
            this.parameters_ = new String[0];
            this.properties_ = null;
            this.read_ = null;
            this.write_ = null;
            this.error_ = null;
        }
        if (bl) {
            object = (Vector)this.completedListeners_.clone();
            ActionCompletedEvent actionCompletedEvent = new ActionCompletedEvent(this);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                ActionCompletedListener actionCompletedListener = (ActionCompletedListener)((Vector)object).elementAt(i);
                actionCompletedListener.actionCompleted(actionCompletedEvent);
            }
        }
        this.messageList_ = this.command_.getMessageList();
        return bl;
    }

    private int searchPort(int n, int n2) {
        ServerSocket serverSocket = null;
        int n3 = n;
        boolean bl = false;
        for (int i = 0; i <= PORT_SEARCH_TIMES; ++i) {
            try {
                serverSocket = new ServerSocket(n3);
            }
            catch (Exception exception) {
                n3 += 3;
                continue;
            }
            bl = true;
            break;
        }
        if (bl) {
            if (n2 == DEFAULT_STANDARD_IN_PORT) {
                this.read_ = serverSocket;
            } else if (n2 == DEFAULT_STANDARD_OUT_PORT) {
                this.write_ = serverSocket;
            } else {
                this.error_ = serverSocket;
            }
        } else {
            n3 = n;
        }
        return n3;
    }

    public void sendStandardInString(String string) {
        if (this.openSocketsThread_ != null) {
            this.openSocketsThread_.sendStandardInString(string);
        }
    }

    public void setClassPath(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("classPath");
        }
        String string2 = this.classPath_;
        this.vetoableChange_.fireVetoableChange("classPath", string2, string);
        this.classPath_ = string;
        this.propertyChange_.firePropertyChange("classPath", string2, string);
    }

    public void setDefaultPort(int n) throws PropertyVetoException {
        if (n <= 0) {
            throw new IllegalArgumentException("defaultPort");
        }
        Integer n2 = new Integer(this.defaultPort_);
        this.vetoableChange_.fireVetoableChange("defaultPort", n2, new Integer(n));
        this.defaultPort_ = n;
        this.propertyChange_.firePropertyChange("defaultPort", n2, new Integer(n));
    }

    public void setFindPort(boolean bl) throws PropertyVetoException {
        Boolean bl2 = new Boolean(this.findPort_);
        this.vetoableChange_.fireVetoableChange("findPort", bl2, new Boolean(bl));
        this.findPort_ = bl;
        this.propertyChange_.firePropertyChange("findPort", bl2, new Boolean(bl));
    }

    public void setGarbageCollectionFrequency(int n) throws PropertyVetoException {
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("garbageCollectionFrequency");
        }
        int n2 = this.garbageCollectionFrequency_;
        this.vetoableChange_.fireVetoableChange("garbageCollectionFrequency", new Integer(n2), new Integer(n));
        this.garbageCollectionFrequency_ = n;
        this.propertyChange_.firePropertyChange("garbageCollectionFrequency", new Integer(n2), new Integer(n));
    }

    public void setGarbageCollectionInitialSize(int n) throws PropertyVetoException {
        int n2;
        if (n > 0) {
            if (Trace.traceOn_) {
                n2 = -1;
                boolean bl = false;
                try {
                    n2 = Integer.parseInt(this.getGarbageCollectionMaximumSize());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                if (!bl && n > n2) {
                    Trace.log(4, "Initial size (" + n + ") exceeds specified maximum size (" + n2 + ")");
                }
            }
        } else {
            throw new IllegalArgumentException("garbageCollectionInitialSize");
        }
        n2 = this.garbageCollectionInitialSize_;
        this.vetoableChange_.fireVetoableChange("garbageCollectionInitialSize", new Integer(n2), new Integer(n));
        this.garbageCollectionInitialSize_ = n;
        this.propertyChange_.firePropertyChange("garbageCollectionInitialSize", new Integer(n2), new Integer(n));
    }

    public void setGarbageCollectionMaximumSize(String string) throws PropertyVetoException {
        if (string != null) {
            if (!string.toUpperCase().equalsIgnoreCase("*NOMAX")) {
                try {
                    Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("garbageCollectionMaximumSize");
                }
            }
        } else {
            throw new NullPointerException("garbageCollectionMaximumSize");
        }
        String string2 = this.garbageCollectionMaximumSize_;
        this.vetoableChange_.fireVetoableChange("garbageCollectionMaximumSize", string2, string);
        this.garbageCollectionMaximumSize_ = string;
        this.propertyChange_.firePropertyChange("garbageCollectionMaximumSize", string2, string);
    }

    public void setGarbageCollectionPriority(int n) throws PropertyVetoException {
        if (n != 10 && n != 20 && n != 30) {
            throw new IllegalArgumentException("garbageCollectionPriority");
        }
        int n2 = this.garbageCollectionPriority_;
        this.vetoableChange_.fireVetoableChange("garbageCollectionPriority", new Integer(n2), new Integer(n));
        this.garbageCollectionPriority_ = n;
        this.propertyChange_.firePropertyChange("garbageCollectionPriority", new Integer(n2), new Integer(n));
    }

    public void setInterpret(String string) throws PropertyVetoException {
        if (string != null) {
            if (!(string.equalsIgnoreCase("*OPTIMIZE") || string.equalsIgnoreCase("*NO") || string.equalsIgnoreCase("*YES") || string.equalsIgnoreCase("*JIT"))) {
                throw new IllegalArgumentException("interpret");
            }
        } else {
            throw new NullPointerException("interpret");
        }
        String string2 = this.interpret_;
        this.vetoableChange_.fireVetoableChange("interpret", string2, string);
        this.interpret_ = string;
        this.propertyChange_.firePropertyChange("interpret", string2, string);
    }

    public void setJavaApplication(String string) throws PropertyVetoException {
        if (string == null || string.length() <= 0) {
            throw new NullPointerException("application");
        }
        String string2 = this.javaApplication_;
        this.vetoableChange_.fireVetoableChange("application", string2, string);
        this.javaApplication_ = string;
        this.propertyChange_.firePropertyChange("application", string2, string);
    }

    public void setJobName(String string) {
        if (string != null) {
            if (string.length() > 10 || string.length() <= 0) {
                throw new IllegalArgumentException("jobname");
            }
        } else {
            throw new NullPointerException("jobname");
        }
        String string2 = this.jobname_;
        this.jobname_ = string;
        this.propertyChange_.firePropertyChange("jobname", string2, string);
    }

    public void setOptimization(String string) throws PropertyVetoException {
        if (string != null) {
            if (!(string.equalsIgnoreCase("10") || string.equalsIgnoreCase("*INTERPRET") || string.equalsIgnoreCase("*JIT") || string.equalsIgnoreCase("20") || string.equalsIgnoreCase("30") || string.equalsIgnoreCase("40"))) {
                throw new IllegalArgumentException("optimization");
            }
        } else {
            throw new NullPointerException("optimization");
        }
        String string2 = this.optimization_;
        this.vetoableChange_.fireVetoableChange("optimization", string2, string);
        this.optimization_ = string;
        this.propertyChange_.firePropertyChange("optimization", string2, string);
    }

    public void setOptions(String[] stringArray) throws PropertyVetoException {
        if (stringArray != null) {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                bl = true;
                String string = stringArray[i];
                if (string.equalsIgnoreCase("*NONE") || string.equalsIgnoreCase("*VERBOSE") || string.equalsIgnoreCase("*DEBUG") || string.equalsIgnoreCase("*VERBOSEGC") || string.equalsIgnoreCase("*NOCLASSGC")) continue;
                bl = false;
                break;
            }
            if (!bl) {
                throw new IllegalArgumentException("option");
            }
        } else {
            throw new NullPointerException("option");
        }
        String[] stringArray2 = this.options_;
        this.vetoableChange_.fireVetoableChange("options", stringArray2, stringArray);
        this.options_ = stringArray;
        this.propertyChange_.firePropertyChange("options", stringArray2, stringArray);
    }

    public void setParameters(String[] stringArray) throws PropertyVetoException {
        if (stringArray == null) {
            throw new NullPointerException("parameters");
        }
        String[] stringArray2 = this.parameters_;
        this.vetoableChange_.fireVetoableChange("parameters", stringArray2, stringArray);
        this.parameters_ = stringArray;
        this.propertyChange_.firePropertyChange("parameters", stringArray2, stringArray);
    }

    public void setProperties(Properties properties) throws PropertyVetoException {
        Properties properties2;
        if (properties != null) {
            properties2 = properties;
            if (((Hashtable)properties2).containsKey("os400.stdin")) {
                ((Hashtable)properties2).remove("os400.stdin");
            }
            if (((Hashtable)properties2).containsKey("os400.stdout")) {
                ((Hashtable)properties2).remove("os400.stdout");
            }
            if (((Hashtable)properties2).containsKey("os400.stderr")) {
                ((Hashtable)properties2).remove("os400.stderr");
            }
            if (((Hashtable)properties2).containsKey("os400.stdio.convert")) {
                ((Hashtable)properties2).remove("os400.stdio.convert");
            }
        } else {
            throw new NullPointerException("properties");
        }
        Properties properties3 = this.properties_;
        this.vetoableChange_.fireVetoableChange("properties", properties3, properties2);
        this.properties_ = (Properties)((Hashtable)properties2).clone();
        this.propertyChange_.firePropertyChange("properties", properties3, properties2);
    }

    public void setSecurityCheckLevel(String string) throws PropertyVetoException {
        if (string != null) {
            if (!(string.equalsIgnoreCase("*WARN") || string.equalsIgnoreCase("*SECURE") || string.equalsIgnoreCase("*IGNORE"))) {
                throw new IllegalArgumentException("securityCheckLevel");
            }
        } else {
            throw new NullPointerException("securityCheckLevel");
        }
        String string2 = this.securityCheckLevel_;
        this.vetoableChange_.fireVetoableChange("securityCheckLevel", string2, string);
        this.securityCheckLevel_ = string;
        this.propertyChange_.firePropertyChange("securityCheckLevel", string2, string);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("as400");
        }
        AS400 aS4002 = this.as400_;
        this.vetoableChange_.fireVetoableChange("as400", aS4002, aS400);
        this.as400_ = aS400;
        this.propertyChange_.firePropertyChange("as400", aS4002, aS400);
    }
}

