/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FileEvent;
import com.ibm.as400.access.FileListener;
import com.ibm.as400.access.IFSCachedAttributes;
import com.ibm.as400.access.IFSFileDescriptor;
import com.ibm.as400.access.IFSFileEnumeration;
import com.ibm.as400.access.IFSFileFilter;
import com.ibm.as400.access.IFSFileImpl;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Permission;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class IFSFile
implements Serializable,
Comparable {
    static final long serialVersionUID = 4L;
    public static final String pathSeparator = ";";
    public static final char pathSeparatorChar = ';';
    public static final String separator = "/";
    public static final char separatorChar = '/';
    private static final String DOT = ".";
    private static final String DOTDOT = "..";
    static final int ACCESS_EXECUTE = 1;
    static final int ACCESS_WRITE = 2;
    static final int ACCESS_READ = 4;
    public static final int PATTERN_POSIX = 0;
    static final int PATTERN_DEFAULT = 0;
    public static final int PATTERN_POSIX_ALL = 1;
    public static final int PATTERN_OS2 = 2;
    private static final String SECURITY_EXCEPTION = "Security exception.";
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    private transient Vector fileListeners_;
    private transient IFSFileImpl impl_;
    private transient ServiceProgramCall servicePgm_;
    private AS400 system_;
    private String path_ = "";
    private Permission permission_;
    private String subType_;
    private transient IFSCachedAttributes cachedAttributes_;
    private boolean isDirectory_;
    private boolean isFile_;
    private boolean isSymbolicLink_;
    private int patternMatching_;
    private boolean sortLists_;
    private int listFiles0LastNumObjsReturned_;
    private String listFiles0LastRestartName_ = null;
    private byte[] listFiles0LastRestartID_;

    public IFSFile() {
        this.initializeTransient();
    }

    public IFSFile(AS400 aS400, IFSFile iFSFile, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (iFSFile == null) {
            throw new NullPointerException("directory");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.initializeTransient();
        this.path_ = iFSFile.getAbsolutePath();
        if (this.path_.charAt(this.path_.length() - 1) != '/') {
            this.path_ = this.path_ + separator;
        }
        this.path_ = this.path_ + string;
        this.system_ = aS400;
        this.permission_ = null;
    }

    public IFSFile(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("path");
        }
        this.initializeTransient();
        this.path_ = string.length() == 0 || string.charAt(0) != '/' ? separator + string : string;
        this.system_ = aS400;
    }

    public IFSFile(AS400 aS400, String string, String string2) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("directory");
        }
        if (string2 == null) {
            throw new NullPointerException("name");
        }
        this.initializeTransient();
        this.path_ = string.length() == 0 || string.charAt(0) != '/' ? separator + string : string;
        if (this.path_.charAt(this.path_.length() - 1) != '/') {
            this.path_ = this.path_ + separator;
        }
        this.path_ = this.path_ + string2;
        this.system_ = aS400;
    }

    public IFSFile(AS400 aS400, IFSJavaFile iFSJavaFile, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (iFSJavaFile == null) {
            throw new NullPointerException("directory");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.initializeTransient();
        this.path_ = iFSJavaFile.getAbsolutePath().replace(File.separatorChar, '/');
        if (this.path_.charAt(this.path_.length() - 1) != '/') {
            this.path_ = this.path_ + separator;
        }
        this.path_ = this.path_ + string;
        this.system_ = aS400;
    }

    IFSFile(AS400 aS400, IFSCachedAttributes iFSCachedAttributes) {
        if (iFSCachedAttributes == null) {
            throw new NullPointerException("attributes");
        }
        this.initializeTransient();
        String string = iFSCachedAttributes.getParent();
        String string2 = iFSCachedAttributes.getName();
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() == 0 || string.charAt(0) != '/') {
            stringBuffer.append(separator).append(string);
        } else {
            stringBuffer.append(string);
        }
        if (stringBuffer.toString().charAt(stringBuffer.toString().length() - 1) != '/') {
            stringBuffer.append(separator);
        }
        this.path_ = stringBuffer.append(string2).toString();
        this.system_ = aS400;
        this.cachedAttributes_ = iFSCachedAttributes;
        this.isDirectory_ = iFSCachedAttributes.getIsDirectory();
        this.isFile_ = iFSCachedAttributes.getIsFile();
        this.isSymbolicLink_ = iFSCachedAttributes.isSymbolicLink();
    }

    public IFSFile(IFSFile iFSFile, String string) {
        this(iFSFile == null ? null : iFSFile.getSystem(), iFSFile == null ? null : iFSFile.getPath(), string);
    }

    public void addFileListener(FileListener fileListener) {
        if (fileListener == null) {
            throw new NullPointerException("listener");
        }
        this.fileListeners_.addElement(fileListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public boolean canExecute() throws IOException {
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            return this.impl_.canExecute();
        }
        catch (AS400SecurityException aS400SecurityException) {
            if (aS400SecurityException.getReturnCode() == 1) {
                return false;
            }
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public boolean canRead() throws IOException {
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            return this.impl_.canRead();
        }
        catch (AS400SecurityException aS400SecurityException) {
            if (aS400SecurityException.getReturnCode() == 1) {
                return false;
            }
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public boolean canWrite() throws IOException {
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            return this.impl_.canWrite();
        }
        catch (AS400SecurityException aS400SecurityException) {
            if (aS400SecurityException.getReturnCode() == 1) {
                return false;
            }
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    void chooseImpl() throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            if (this.system_ == null) {
                throw new ExtendedIllegalStateException("system", 4);
            }
            if (this.path_.length() == 0) {
                throw new ExtendedIllegalStateException("path", 4);
            }
            this.impl_ = (IFSFileImpl)this.system_.loadImpl2("com.ibm.as400.access.IFSFileImplRemote", "com.ibm.as400.access.IFSFileImplProxy");
            this.system_.connectService(0);
            this.impl_.setSystem(this.system_.getImpl());
            this.impl_.setPath(this.path_);
        }
    }

    public void clearCachedAttributes() {
        this.cachedAttributes_ = null;
        if (this.impl_ != null) {
            this.impl_.clearCachedAttributes();
        }
    }

    public int compareTo(Object object) {
        if (object instanceof IFSFile) {
            return this.getPath().compareTo(((IFSFile)object).getPath());
        }
        return this.getPath().compareTo(((File)object).getPath());
    }

    public boolean copyTo(String string) throws IOException, AS400SecurityException, ObjectAlreadyExistsException {
        return this.copyTo(string, true);
    }

    boolean copyTo(String string, boolean bl) throws IOException, AS400SecurityException, ObjectAlreadyExistsException {
        if (string == null) {
            throw new NullPointerException("path");
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.copyTo(string, bl);
    }

    public long created() throws IOException {
        try {
            if (this.cachedAttributes_ != null) {
                return this.cachedAttributes_.getCreationDate();
            }
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            return this.impl_.created();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public boolean createNewFile() throws IOException {
        int n = 2;
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            n = this.impl_.createNewFile();
            switch (n) {
                case 0: {
                    break;
                }
                case 4: {
                    if (Trace.traceOn_) {
                        Trace.log(1, "File already exists: " + this.path_);
                    }
                    break;
                }
                case 3: {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Path not found: " + this.path_);
                    }
                    break;
                }
                default: {
                    Trace.log(2, "Return code " + n + " from createNewFile().");
                    throw new ExtendedIOException(n);
                }
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int delete0() throws IOException, AS400SecurityException {
        int n;
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if ((n = this.impl_.delete()) == 0) {
            if (this.fileListeners_.size() != 0) {
                FileEvent fileEvent = new FileEvent(this, 1);
                Vector vector = this.fileListeners_;
                synchronized (vector) {
                    Enumeration enumeration = this.fileListeners_.elements();
                    while (enumeration.hasMoreElements()) {
                        FileListener fileListener = (FileListener)enumeration.nextElement();
                        fileListener.fileDeleted(fileEvent);
                    }
                }
            }
            this.cachedAttributes_ = null;
        }
        return n;
    }

    public boolean delete() throws IOException {
        int n = 2;
        try {
            n = this.delete0();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
        return n == 0;
    }

    public Enumeration enumerateFiles(IFSFileFilter iFSFileFilter, String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("pattern");
        }
        try {
            return new IFSFileEnumeration(this, iFSFileFilter, string);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public Enumeration enumerateFiles(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("pattern");
        }
        try {
            return new IFSFileEnumeration(this, null, string);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public Enumeration enumerateFiles(IFSFileFilter iFSFileFilter) throws IOException {
        try {
            return new IFSFileEnumeration(this, iFSFileFilter, "*");
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public Enumeration enumerateFiles() throws IOException {
        try {
            return new IFSFileEnumeration(this, null, "*");
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IFSFile)) {
            return false;
        }
        IFSFile iFSFile = (IFSFile)object;
        String string = iFSFile.getPath();
        AS400 aS400 = iFSFile.getSystem();
        String string2 = null;
        if (aS400 != null) {
            string2 = aS400.getSystemName();
        }
        boolean bl = true;
        bl = this.system_ == null ? string2 == null : this.system_.getSystemName().equals(string2);
        bl = bl && this.path_.equals(string);
        return bl;
    }

    int exists0() throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.exists();
    }

    public boolean exists() throws IOException {
        int n = 2;
        try {
            n = this.exists0();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
        return n == 0;
    }

    public String getAbsolutePath() {
        return this.path_;
    }

    public String getCanonicalPath() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (Trace.isTraceOn()) {
            Trace.log(1, " path_='" + this.path_ + "'");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.path_, separator);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (Trace.isTraceOn()) {
                Trace.log(1, " pathElem='" + string + "'");
            }
            if (string.length() == 0 || string.equals(DOT)) continue;
            if (string.equals(DOTDOT)) {
                int n = stringBuffer.lastIndexOf(separator);
                if (n == -1) continue;
                stringBuffer.delete(n, stringBuffer.length());
                continue;
            }
            stringBuffer.append(separator);
            stringBuffer.append(string);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, " pathBuffer.toString()='" + stringBuffer.toString() + "'");
        }
        if (stringBuffer.length() == 0) {
            return separator;
        }
        return stringBuffer.toString();
    }

    public int getCCSID() throws IOException {
        int n = -1;
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            n = this.impl_.getCCSID();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
        return n;
    }

    public String getFileSystem() {
        return this.getPath();
    }

    public long getFreeSpace() throws IOException {
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            return this.impl_.getAvailableSpace(true);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public static long getFreeSpace(AS400 aS400) throws IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        try {
            IFSFileImpl iFSFileImpl = (IFSFileImpl)aS400.loadImpl2("com.ibm.as400.access.IFSFileImplRemote", "com.ibm.as400.access.IFSFileImplProxy");
            aS400.connectService(0);
            iFSFileImpl.setSystem(aS400.getImpl());
            iFSFileImpl.setPath(separator);
            return iFSFileImpl.getAvailableSpace(true);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(5);
        }
    }

    long getAvailableSpace(boolean bl) throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.getAvailableSpace(bl);
    }

    long getTotalSpace(boolean bl) throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.getTotalSpace(bl);
    }

    IFSFileImpl getImpl() throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_;
    }

    int getListFiles0LastNumObjsReturned() {
        return this.listFiles0LastNumObjsReturned_;
    }

    String getListFiles0LastRestartName() {
        if (this.listFiles0LastRestartName_ == null) {
            return "";
        }
        return this.listFiles0LastRestartName_;
    }

    byte[] getListFiles0LastRestartID() {
        return this.listFiles0LastRestartID_;
    }

    public String getName() {
        int n;
        String string = null;
        int n2 = this.path_.lastIndexOf(47);
        string = n2 >= 0 ? (n2 < this.path_.length() - 1 ? this.path_.substring(n2 + 1) : "") : this.path_;
        int n3 = string.indexOf(34);
        if (n3 >= 0 && n3 == string.lastIndexOf(34) && (n = this.path_.lastIndexOf(34, n2)) >= 0) {
            int n4 = this.path_.lastIndexOf(47, n);
            string = n4 >= 0 ? this.path_.substring(n4 + 1) : this.path_;
        }
        return string;
    }

    public String getOwnerName() throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.getOwnerName();
    }

    public long getOwnerUID() throws IOException {
        long l = -1L;
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            l = this.impl_.getOwnerUID();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
        return l;
    }

    public int getOwnerId() throws IOException {
        int n = -1;
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            n = (int)this.impl_.getOwnerUID();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
        return n;
    }

    public String getParent() {
        return IFSFile.getParent(this.path_);
    }

    static String getParent(String string) {
        String string2 = null;
        if (!string.equals(separator)) {
            if (string.length() == 0) {
                return null;
            }
            int n = string.lastIndexOf(47);
            if (n <= 0) {
                string2 = separator;
            } else {
                if (n == string.length() - 1) {
                    return IFSFile.getParent(string.substring(0, string.length() - 1));
                }
                string2 = string.substring(0, n);
            }
        }
        return string2;
    }

    public IFSFile getParentFile() {
        String string = this.getParent();
        if (string == null) {
            return null;
        }
        if (this.system_ == null) {
            IFSFile iFSFile = new IFSFile();
            try {
                iFSFile.setPath(string);
            }
            catch (PropertyVetoException propertyVetoException) {
                throw new InternalErrorException(10, propertyVetoException.getMessage());
            }
            return iFSFile;
        }
        return new IFSFile(this.system_, string);
    }

    public String getPath() {
        return this.path_;
    }

    public String getPathPointedTo() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null && !this.isSymbolicLink_) {
            return null;
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.getPathPointedTo();
    }

    public int getPatternMatching() throws IOException {
        return this.patternMatching_;
    }

    public Permission getPermission() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException, UnsupportedEncodingException {
        if (this.permission_ == null) {
            this.permission_ = new Permission(this);
        }
        return this.permission_;
    }

    byte[] getRestartID() {
        if (this.cachedAttributes_ != null) {
            return this.cachedAttributes_.getRestartID();
        }
        if (Trace.traceOn_) {
            Trace.log(2, "IFSFile.getRestartID() was called when cachedAttributes_==null.");
        }
        return null;
    }

    public String getSubtype() throws IOException, AS400SecurityException {
        if (this.subType_ == null) {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            this.subType_ = this.impl_.getSubtype();
        }
        return this.subType_;
    }

    public boolean isSourcePhysicalFile() throws AS400Exception, AS400SecurityException, IOException {
        if (!this.path_.endsWith(".FILE") || this.path_.indexOf("/QSYS.LIB") == -1 || !this.getSubtype().equals("PF")) {
            if (Trace.traceOn_) {
                Trace.log(1, "Not a physical file.");
            }
            return false;
        }
        return this.impl_.isSourcePhysicalFile();
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public int hashCode() {
        return this.path_.hashCode();
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
        this.fileListeners_ = new Vector();
        this.cachedAttributes_ = null;
        this.impl_ = null;
    }

    public boolean isAbsolute() {
        if (this.path_.length() == 0) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        return this.path_.length() > 0 && this.path_.charAt(0) == '/';
    }

    int isDirectory0() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null) {
            if (this.isDirectory_) {
                return 0;
            }
            return 2;
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.isDirectory();
    }

    public boolean isDirectory() throws IOException {
        int n = 2;
        try {
            n = this.isDirectory0();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
        return n == 0;
    }

    int isFile0() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null) {
            if (this.isFile_) {
                return 0;
            }
            return 2;
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.isFile();
    }

    public boolean isFile() throws IOException {
        int n = 2;
        try {
            n = this.isFile0();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
        return n == 0;
    }

    public boolean isHidden() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null) {
            return (this.cachedAttributes_.getFixedAttributes() & 2) != 0;
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.isHidden();
    }

    public boolean isSymbolicLink() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null) {
            return this.isSymbolicLink_;
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.isSymbolicLink();
    }

    public boolean isReadOnly() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null) {
            return (this.cachedAttributes_.getFixedAttributes() & 1) != 0;
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.isReadOnly();
    }

    public boolean isSorted() throws IOException {
        return this.sortLists_;
    }

    public long lastAccessed() throws IOException {
        try {
            if (this.cachedAttributes_ != null) {
                return this.cachedAttributes_.getAccessDate();
            }
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            return this.impl_.lastAccessed();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    long lastModified0() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null) {
            return this.cachedAttributes_.getModificationDate();
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.lastModified();
    }

    public long lastModified() throws IOException {
        try {
            return this.lastModified0();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    long length0() throws IOException, AS400SecurityException {
        if (this.cachedAttributes_ != null) {
            return this.cachedAttributes_.getSize();
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.length();
    }

    public long length() throws IOException {
        try {
            return this.length0();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public String[] list() throws IOException {
        return this.list("*");
    }

    public String[] list(IFSFileFilter iFSFileFilter) throws IOException {
        return this.list(iFSFileFilter, "*");
    }

    String[] list0(IFSFileFilter iFSFileFilter, String string) throws IOException, AS400SecurityException {
        String string2;
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if ((string2 = this.path_).lastIndexOf(47) != string2.length() - 1) {
            string2 = string2 + '/';
        }
        String[] stringArray = this.impl_.listDirectoryContents(string2 + string);
        String[] stringArray2 = null;
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length];
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                boolean bl = false;
                if (string3.equals(DOT) || string3.equals(DOTDOT)) continue;
                bl = false;
                if (iFSFileFilter == null) {
                    bl = true;
                } else {
                    IFSFile iFSFile = new IFSFile(this.system_, string2, string3);
                    if (iFSFileFilter.accept(iFSFile)) {
                        bl = true;
                    }
                }
                if (!bl) continue;
                stringArray2[n++] = string3;
            }
            if (n == 0) {
                stringArray2 = new String[]{};
            } else if (stringArray2.length != n) {
                String[] stringArray3 = new String[n];
                System.arraycopy(stringArray2, 0, stringArray3, 0, n);
                stringArray2 = stringArray3;
            }
        }
        return stringArray2;
    }

    public String[] list(IFSFileFilter iFSFileFilter, String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("pattern");
        }
        try {
            return this.list0(iFSFileFilter, string);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public String[] list(String string) throws IOException {
        return this.list(null, string);
    }

    public IFSFile[] listFiles() throws IOException {
        return this.listFiles(null, "*");
    }

    public IFSFile[] listFiles(IFSFileFilter iFSFileFilter) throws IOException {
        return this.listFiles(iFSFileFilter, "*");
    }

    public IFSFile[] listFiles(IFSFileFilter iFSFileFilter, String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("pattern");
        }
        try {
            return this.listFiles0(iFSFileFilter, string, -1, null, null, true);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public IFSFile[] listFiles(String string) throws IOException {
        return this.listFiles(null, string);
    }

    IFSFile[] listFiles0(IFSFileFilter iFSFileFilter, String string, int n, String string2) throws IOException, AS400SecurityException {
        return this.listFiles0(iFSFileFilter, string, n, string2, null, true);
    }

    private IFSFile[] listFiles0(IFSFileFilter iFSFileFilter, String string, int n, String string2, byte[] byArray, boolean bl) throws IOException, AS400SecurityException {
        String string3;
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if ((string3 = this.path_).lastIndexOf(47) != string3.length() - 1) {
            string3 = string3 + '/';
        }
        IFSCachedAttributes[] iFSCachedAttributesArray = string2 != null ? this.impl_.listDirectoryDetails(string3 + string, string3, n, string2) : this.impl_.listDirectoryDetails(string3 + string, string3, n, byArray, bl);
        if (Trace.isTraceOn()) {
            Trace.log(1, "IFSFile::listFile0(): returned (" + this.listFiles0LastNumObjsReturned_ + ") pre objects");
        }
        if (iFSCachedAttributesArray == null) {
            return new IFSFile[0];
        }
        this.listFiles0LastNumObjsReturned_ = iFSCachedAttributesArray.length;
        IFSFile[] iFSFileArray = new IFSFile[iFSCachedAttributesArray.length];
        if (iFSCachedAttributesArray.length > 0) {
            IFSFile iFSFile = new IFSFile(this.system_, iFSCachedAttributesArray[iFSCachedAttributesArray.length - 1]);
            this.listFiles0LastRestartName_ = iFSFile.getName();
            this.listFiles0LastRestartID_ = iFSFile.getRestartID();
        }
        int n2 = 0;
        for (int i = 0; i < iFSCachedAttributesArray.length; ++i) {
            IFSFile iFSFile = new IFSFile(this.system_, iFSCachedAttributesArray[i]);
            if (iFSFileFilter != null && !iFSFileFilter.accept(iFSFile)) continue;
            iFSFileArray[n2++] = iFSFile;
        }
        if (n2 == 0) {
            iFSFileArray = new IFSFile[]{};
        } else if (iFSFileArray.length != n2) {
            IFSFile[] iFSFileArray2 = new IFSFile[n2];
            System.arraycopy(iFSFileArray, 0, iFSFileArray2, 0, n2);
            iFSFileArray = iFSFileArray2;
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "IFSFile::listFile0(): returned (" + iFSFileArray.length + ") post objects");
        }
        return iFSFileArray;
    }

    IFSFile[] listFiles0(IFSFileFilter iFSFileFilter, String string, int n, byte[] byArray) throws IOException, AS400SecurityException {
        return this.listFiles0(iFSFileFilter, string, n, null, byArray, false);
    }

    IFSFile[] listFiles0(IFSFileFilter iFSFileFilter, String string) throws IOException, AS400SecurityException {
        return this.listFiles0(iFSFileFilter, string, -1, null, null, true);
    }

    int mkdir0(String string) throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.mkdir(string);
    }

    public boolean mkdir() throws IOException {
        int n = 2;
        try {
            n = this.mkdir0(this.path_);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
        return n == 0;
    }

    int mkdirs0() throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.mkdirs();
    }

    public boolean mkdirs() throws IOException {
        int n = 2;
        try {
            n = this.mkdirs0();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
        return n == 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeFileListener(FileListener fileListener) {
        if (fileListener == null) {
            throw new NullPointerException("listener");
        }
        this.fileListeners_.removeElement(fileListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
    }

    int renameTo0(IFSFile iFSFile) throws IOException, PropertyVetoException, AS400SecurityException {
        String string;
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if ((string = iFSFile.getAbsolutePath()).length() == 0) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        this.vetos_.fireVetoableChange("path", this.path_, iFSFile.getAbsolutePath());
        int n = this.impl_.renameTo(iFSFile.getImpl());
        if (n == 0) {
            String string2 = this.path_;
            this.path_ = iFSFile.getAbsolutePath();
            this.changes_.firePropertyChange("path", string2, this.path_);
            this.cachedAttributes_ = null;
        }
        return n;
    }

    public boolean renameTo(IFSFile iFSFile) throws IOException, PropertyVetoException {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        int n = 2;
        try {
            n = this.renameTo0(iFSFile);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
        return n == 0;
    }

    boolean setAccess(int n, boolean bl, boolean bl2) throws IOException, AS400SecurityException {
        if (n != 4 && n != 2 && n != 1) {
            throw new ExtendedIllegalArgumentException("accessType (" + n + ")", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.setAccess(n, bl, bl2);
    }

    public boolean setCCSID(int n) throws IOException {
        boolean bl = false;
        try {
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            bl = this.impl_.setCCSID(n);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
        if (bl && this.fileListeners_.size() != 0) {
            IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
        }
        return bl;
    }

    boolean setFixedAttributes(int n) throws IOException {
        if ((n & 0xFFFFFF00) != 0) {
            throw new ExtendedIllegalArgumentException("attributes (" + n + ")", 2);
        }
        try {
            boolean bl;
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            if (bl = this.impl_.setFixedAttributes(n)) {
                this.cachedAttributes_ = null;
            }
            return bl;
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public boolean setHidden() throws IOException {
        return this.setHidden(true);
    }

    public boolean setHidden(boolean bl) throws IOException {
        try {
            boolean bl2;
            if (this.impl_ == null) {
                this.chooseImpl();
            }
            if (bl2 = this.impl_.setHidden(bl)) {
                this.cachedAttributes_ = null;
                if (this.fileListeners_.size() != 0) {
                    IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
                }
            }
            return bl2;
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    public boolean setLastModified(long l) throws IOException, PropertyVetoException {
        this.vetos_.fireVetoableChange("lastModified", null, new Long(l));
        try {
            return this.setLastModified0(l);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    boolean setLastModified0(long l) throws IOException, AS400SecurityException {
        boolean bl;
        if (l < -1L) {
            throw new ExtendedIllegalArgumentException("time (" + Long.toString(l) + ")", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (bl = this.impl_.setLastModified(l)) {
            this.changes_.firePropertyChange("lastModified", null, new Long(l));
            if (this.fileListeners_.size() != 0) {
                IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
            }
            this.cachedAttributes_ = null;
        }
        return bl;
    }

    public boolean setLength(int n) throws IOException {
        try {
            return this.setLength0(n);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    boolean setLength0(int n) throws IOException, AS400SecurityException {
        boolean bl;
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("length (" + Integer.toString(n) + ")", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (bl = this.impl_.setLength(n)) {
            if (this.fileListeners_.size() != 0) {
                IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
            }
            this.cachedAttributes_ = null;
        }
        return bl;
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("path");
        }
        if (this.impl_ != null) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        String string2 = this.path_;
        String string3 = string.length() == 0 || string.charAt(0) != '/' ? separator + string : string;
        this.vetos_.fireVetoableChange("path", string2, string3);
        this.path_ = string3;
        this.changes_.firePropertyChange("path", string2, string3);
    }

    public void setPatternMatching(int n) throws IOException {
        if (n < 0 || n > 2) {
            throw new ExtendedIllegalArgumentException("patternMatching (" + n + ")", 2);
        }
        if (this.impl_ == null) {
            try {
                this.chooseImpl();
            }
            catch (AS400SecurityException aS400SecurityException) {
                Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
                throw new ExtendedIOException(this.path_, 5);
            }
        }
        this.impl_.setPatternMatching(n);
        this.patternMatching_ = n;
    }

    public void setPermission(Permission permission) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException, PropertyVetoException, UnknownHostException {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        AS400 aS400 = permission.getSystem();
        if (aS400 == null) {
            throw new ExtendedIllegalArgumentException("permission.system (null)", 2);
        }
        if (aS400.equals(this.system_)) {
            if (!this.getFileSystem().equals(permission.getObjectPath())) {
                throw new ExtendedIllegalArgumentException("permission.objectPath (" + permission.getObjectPath() + ")", 2);
            }
        } else {
            String string = aS400.getSystemName();
            throw new ExtendedIllegalArgumentException("permission.system (" + string + ")", 2);
        }
        this.vetos_.fireVetoableChange("permission", null, this.permission_);
        this.permission_ = permission;
        permission.commit();
        this.changes_.firePropertyChange("permission", null, this.permission_);
    }

    public boolean setReadOnly() throws IOException {
        return this.setReadOnly(true);
    }

    public boolean setReadOnly(boolean bl) throws IOException {
        try {
            return this.setReadOnly0(bl);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
            throw new ExtendedIOException(this.path_, 5);
        }
    }

    boolean setReadOnly0(boolean bl) throws IOException, AS400SecurityException {
        boolean bl2;
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (bl2 = this.impl_.setReadOnly(bl)) {
            this.cachedAttributes_ = null;
            if (this.fileListeners_.size() != 0) {
                IFSFileDescriptor.fireModifiedEvents(this, this.fileListeners_);
            }
        }
        return bl2;
    }

    public void setSorted(boolean bl) throws IOException, AS400SecurityException {
        if (this.impl_ == null) {
            try {
                this.chooseImpl();
            }
            catch (AS400SecurityException aS400SecurityException) {
                Trace.log(2, SECURITY_EXCEPTION, (Throwable)aS400SecurityException);
                throw new ExtendedIOException(this.path_, 5);
            }
        }
        this.impl_.setSorted(bl);
        this.sortLists_ = bl;
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        this.vetos_.fireVetoableChange("system", this.system_, aS400);
        AS400 aS4002 = this.system_;
        this.system_ = aS400;
        this.changes_.firePropertyChange("system", aS4002, this.system_);
    }

    public String toString() {
        return this.path_;
    }
}

