/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import java.sql.Timestamp;
import java.util.Date;

public class AS400JDBCTimestamp
extends Timestamp {
    static final String copyright = "Copyright (C) 2012-2013 International Business Machines Corporation and others.";
    private static final long serialVersionUID = 1L;
    long picos_ = (long)super.getNanos() * 1000L;
    int length_;

    public AS400JDBCTimestamp(long l, int n) {
        super(l);
        this.length_ = n;
    }

    public AS400JDBCTimestamp(long l) {
        super(l);
        this.length_ = 32;
    }

    public long getPicos() {
        return this.picos_;
    }

    public void setPicos(long l) {
        this.picos_ = l;
        super.setNanos((int)(this.picos_ / 1000L));
    }

    public int getNanos() {
        return (int)(this.getPicos() / 1000L);
    }

    public void setNanos(int n) {
        this.setPicos((long)n * 1000L);
    }

    public String toString() {
        String string = super.toString();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        stringBuffer.append(string);
        if (this.length_ >= 20) {
            stringBuffer.append(".");
            int n2 = 20;
            for (long i = 100000000000L; n2 < this.length_ && i > 0L; ++n2, i /= 10L) {
                char c = (char)(48L + this.picos_ / i % 10L);
                stringBuffer.append(c);
            }
        }
        return stringBuffer.toString();
    }

    public void setTime(long l) {
        super.setTime(l);
        this.picos_ = (long)super.getNanos() * 1000L;
    }

    public boolean equals(Timestamp timestamp) {
        return this.compareTo(timestamp) == 0;
    }

    public boolean equals(Object object) {
        if (object instanceof Timestamp) {
            return this.equals((Timestamp)object);
        }
        return false;
    }

    public boolean before(Timestamp timestamp) {
        return this.compareTo(timestamp) < 0;
    }

    public boolean after(Timestamp timestamp) {
        return this.compareTo(timestamp) > 0;
    }

    public int compareTo(Timestamp timestamp) {
        long l;
        long l2 = this.getTime();
        if (l2 != (l = timestamp.getTime())) {
            if (l2 < l) {
                return -1;
            }
            return 1;
        }
        long l3 = timestamp instanceof AS400JDBCTimestamp ? ((AS400JDBCTimestamp)timestamp).getPicos() : (long)(timestamp.getNanos() * 1000);
        if (this.picos_ == l3) {
            return 0;
        }
        if (this.picos_ < l3) {
            return -1;
        }
        return 1;
    }

    public int compareTo(Date date) {
        return this.compareTo((Timestamp)date);
    }

    public static void main(String[] stringArray) {
        String[][] stringArrayArray = new String[][]{{"1351719245000", "19", "0", "2012-10-31 16:34:05"}, {"1351719245000", "21", "0", "2012-10-31 16:34:05.0"}, {"1351719245000", "21", "100000000000", "2012-10-31 16:34:05.1"}, {"1351719245000", "21", "123456789012", "2012-10-31 16:34:05.1"}, {"1351719245000", "22", "123456789012", "2012-10-31 16:34:05.12"}, {"1351719245000", "23", "123456789012", "2012-10-31 16:34:05.123"}, {"1351719245000", "24", "123456789012", "2012-10-31 16:34:05.1234"}, {"1351719245000", "25", "123456789012", "2012-10-31 16:34:05.12345"}, {"1351719245000", "26", "123456789012", "2012-10-31 16:34:05.123456"}, {"1351719245000", "27", "123456789012", "2012-10-31 16:34:05.1234567"}, {"1351719245000", "28", "123456789012", "2012-10-31 16:34:05.12345678"}, {"1351719245000", "29", "123456789012", "2012-10-31 16:34:05.123456789"}, {"1351719245000", "30", "123456789012", "2012-10-31 16:34:05.1234567890"}, {"1351719245000", "31", "123456789012", "2012-10-31 16:34:05.12345678901"}, {"1351719245000", "32", "123456789012", "2012-10-31 16:34:05.123456789012"}, {"1351719245000", "0", "0", "2012-10-31 16:34:05.000000000000"}, {"1351719245000", "0", "123456789012", "2012-10-31 16:34:05.123456789000"}, {"1351719245000", "0", "123456789012", "2012-10-31 16:34:05.123456789000"}, {"1351719245000", "0", "123456789012", "2012-10-31 16:34:05.123456789000"}, {"1351719245000", "0", "123456789012", "2012-10-31 16:34:05.123456789000"}, {"1351719245000", "0", "123456789012", "2012-10-31 16:34:05.123456789000"}, {"1351719245000", "0", "123456789012", "2012-10-31 16:34:05.123456789000"}, {"1351719245000", "0", "123456789012", "2012-10-31 16:34:05.123456789000"}, {"1351719245000", "0", "123456789012", "2012-10-31 16:34:05.123456789000"}, {"1351719245000", "0", "123456789012", "2012-10-31 16:34:05.123456789000"}, {"1351719245000", "0", "123456789012", "2012-10-31 16:34:05.123456789000"}, {"1351719245000", "0", "123456789012", "2012-10-31 16:34:05.123456789000"}, {"1351719245000", "0", "123456789012", "2012-10-31 16:34:05.123456789000"}, {"1351719245123", "0", "-1", "2012-10-31 16:34:05.123000000000"}, {"1351719245123", "21", "-1", "2012-10-31 16:34:05.1"}, {"1351719245123", "21", "-1", "2012-10-31 16:34:05.1"}, {"1351719245123", "22", "-1", "2012-10-31 16:34:05.12"}, {"1351719245123", "23", "-1", "2012-10-31 16:34:05.123"}};
        System.out.println("Unit testing AS400JDBCTimestamp");
        int n = 0;
        int n2 = stringArrayArray.length;
        for (int i = 0; i < n2; ++i) {
            String string;
            AS400JDBCTimestamp aS400JDBCTimestamp;
            long l = Long.parseLong(stringArrayArray[i][0]);
            int n3 = Integer.parseInt(stringArrayArray[i][1]);
            long l2 = Long.parseLong(stringArrayArray[i][2]);
            String string2 = stringArrayArray[i][3];
            if (n3 == 0) {
                aS400JDBCTimestamp = new AS400JDBCTimestamp(l);
                if (l2 >= 0L) {
                    aS400JDBCTimestamp.setNanos((int)(l2 / 1000L));
                }
            } else {
                aS400JDBCTimestamp = new AS400JDBCTimestamp(l, n3);
                if (l2 >= 0L) {
                    aS400JDBCTimestamp.setPicos(l2);
                }
            }
            if (!(string = aS400JDBCTimestamp.toString()).equals(string2)) {
                System.out.println("For case " + i + " got " + string + " sb " + string2 + " for time=" + l + " len=" + n3 + " picos=" + l2);
                continue;
            }
            ++n;
        }
        System.out.println("Test completed " + n + " of " + n2 + " successful");
    }
}

