/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;

public abstract class AS400AbstractTime
implements AS400DataType {
    static final long serialVersionUID = 4L;
    static final boolean DEBUG = false;
    static final Locale LOCALE_DEFAULT = Locale.US;
    static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT-0");
    static final Character AMPERSAND = new Character('&');
    static final Character BLANK = new Character(' ');
    static final Character COLON = new Character(':');
    static final Character COMMA = new Character(',');
    static final Character HYPHEN = new Character('-');
    static final Character PERIOD = new Character('.');
    static final Character SLASH = new Character('/');
    static final String DATE_PATTERN_XSD = "yyyy-MM-dd";
    static final String TIME_PATTERN_XSD = "HH:mm:ss";
    static final String TIMESTAMP_PATTERN_XSD = "yyyy-MM-dd'T'HH:mm:ss";
    private int length_;
    private transient GregorianCalendar calendar_;
    private transient SimpleDateFormat dateFormatter_;
    private transient CharConverter charConverter_;
    private static Hashtable hashDateFormatterXSD_ = null;
    private static Hashtable hashTimeFormatterXSD_ = null;
    private static Hashtable hashTimestampFormatterXSD_ = null;
    private transient Date[] centuryMap_;
    private int format_;
    private Character separator_;
    private boolean separatorHasBeenSet_ = false;
    private TimeZone timeZone_ = null;
    static /* synthetic */ Class class$com$ibm$as400$access$AS400Date;
    static /* synthetic */ Class class$com$ibm$as400$access$AS400Time;
    static /* synthetic */ Class class$com$ibm$as400$access$AS400Timestamp;

    AS400AbstractTime() {
        this.timeZone_ = TIMEZONE_GMT;
    }

    AS400AbstractTime(TimeZone timeZone) {
        this.timeZone_ = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone_;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, "Unexpected cloning error", (Throwable)cloneNotSupportedException);
            throw new InternalErrorException(6);
        }
    }

    public int getByteLength() {
        return this.length_;
    }

    public abstract Object getDefaultValue();

    public abstract int getInstanceType();

    public abstract Class getJavaType();

    synchronized GregorianCalendar getCalendar() {
        if (this.calendar_ == null) {
            TimeZone timeZone = this.getTimeZone();
            if (Trace.traceOn_) {
                Trace.log(1, "AS400AbstractTime.getCalendar(): Setting internal timezone to " + timeZone);
            }
            this.calendar_ = new GregorianCalendar(timeZone, LOCALE_DEFAULT);
        }
        return this.calendar_;
    }

    synchronized GregorianCalendar getCalendar(Date date) {
        this.getCalendar().setTime(date);
        return this.calendar_;
    }

    private synchronized GregorianCalendar getCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        this.getCalendar().set(n, n2, n3, n4, n5, n6);
        return this.calendar_;
    }

    int getLength() {
        return this.length_;
    }

    int getFormat() {
        return this.format_;
    }

    Character getSeparator() {
        return this.separator_;
    }

    synchronized void setSeparator(Character c) {
        this.separator_ = c;
        this.separatorHasBeenSet_ = true;
    }

    synchronized void setFormat(int n) {
        Character c = this.separatorHasBeenSet_ ? this.separator_ : this.defaultSeparatorFor(n);
        this.setFormat(n, c);
    }

    synchronized void setFormat(int n, Character c) {
        if (!this.isValidFormat(n)) {
            throw new ExtendedIllegalArgumentException("format (" + n + ")", 2);
        }
        this.format_ = n;
        this.separator_ = c;
        this.length_ = this.lengthFor(this.format_);
        this.dateFormatter_ = null;
    }

    public byte[] toBytes(Object object) {
        byte[] byArray = new byte[this.length_];
        this.toBytes(object, byArray, 0);
        return byArray;
    }

    public int toBytes(Object object, byte[] byArray) {
        return this.toBytes(object, byArray, 0);
    }

    public int toBytes(Object object, byte[] byArray, int n) {
        String string = this.toString(object);
        try {
            this.getCharConverter().stringToByteArray(string, byArray, n);
        }
        catch (CharConversionException charConversionException) {
            Trace.log(2, charConversionException);
            throw new InternalErrorException(10, charConversionException.getMessage());
        }
        return this.length_;
    }

    public Object toObject(byte[] byArray) {
        return this.toObject(byArray, 0);
    }

    public abstract Object toObject(byte[] var1, int var2);

    public abstract String toString(Object var1);

    CharConverter getCharConverter() {
        try {
            if (this.charConverter_ == null) {
                this.charConverter_ = new CharConverter(37);
            }
            return this.charConverter_;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.log(2, unsupportedEncodingException);
            throw new InternalErrorException(10, unsupportedEncodingException.getMessage());
        }
    }

    synchronized SimpleDateFormat getDateFormatter() {
        if (this.dateFormatter_ == null) {
            this.dateFormatter_ = new SimpleDateFormat(this.patternFor(this.format_, this.separator_));
            this.dateFormatter_.setTimeZone(this.getTimeZone());
        }
        return this.dateFormatter_;
    }

    synchronized SimpleDateFormat getDateFormatter(Integer n) {
        if (n == null) {
            return this.getDateFormatter();
        }
        this.getDateFormatter().set2DigitYearStart(this.getStartDateForCentury(n));
        return this.dateFormatter_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SimpleDateFormat getDateFormatterXSD(TimeZone timeZone) {
        Serializable serializable;
        if (hashDateFormatterXSD_ == null) {
            serializable = class$com$ibm$as400$access$AS400Date == null ? (class$com$ibm$as400$access$AS400Date = AS400AbstractTime.class$("com.ibm.as400.access.AS400Date")) : class$com$ibm$as400$access$AS400Date;
            synchronized (serializable) {
                if (hashDateFormatterXSD_ == null) {
                    hashDateFormatterXSD_ = new Hashtable();
                }
            }
        }
        if ((serializable = (SimpleDateFormat)hashDateFormatterXSD_.get(timeZone)) == null) {
            Class clazz = class$com$ibm$as400$access$AS400Date == null ? (class$com$ibm$as400$access$AS400Date = AS400AbstractTime.class$("com.ibm.as400.access.AS400Date")) : class$com$ibm$as400$access$AS400Date;
            synchronized (clazz) {
                serializable = (SimpleDateFormat)hashDateFormatterXSD_.get(timeZone);
                if (serializable == null) {
                    serializable = new SimpleDateFormat(DATE_PATTERN_XSD);
                    ((DateFormat)serializable).setTimeZone(timeZone);
                    hashDateFormatterXSD_.put(timeZone, serializable);
                }
            }
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SimpleDateFormat getTimeFormatterXSD(TimeZone timeZone) {
        Serializable serializable;
        if (hashTimeFormatterXSD_ == null) {
            serializable = class$com$ibm$as400$access$AS400Time == null ? (class$com$ibm$as400$access$AS400Time = AS400AbstractTime.class$("com.ibm.as400.access.AS400Time")) : class$com$ibm$as400$access$AS400Time;
            synchronized (serializable) {
                if (hashTimeFormatterXSD_ == null) {
                    hashTimeFormatterXSD_ = new Hashtable();
                }
            }
        }
        if ((serializable = (SimpleDateFormat)hashTimeFormatterXSD_.get(timeZone)) == null) {
            Class clazz = class$com$ibm$as400$access$AS400Time == null ? (class$com$ibm$as400$access$AS400Time = AS400AbstractTime.class$("com.ibm.as400.access.AS400Time")) : class$com$ibm$as400$access$AS400Time;
            synchronized (clazz) {
                serializable = (SimpleDateFormat)hashTimeFormatterXSD_.get(timeZone);
                if (serializable == null) {
                    serializable = new SimpleDateFormat(TIME_PATTERN_XSD);
                    ((DateFormat)serializable).setTimeZone(timeZone);
                    hashTimeFormatterXSD_.put(timeZone, serializable);
                }
            }
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SimpleDateFormat getTimestampFormatterXSD(TimeZone timeZone) {
        Serializable serializable;
        if (hashTimestampFormatterXSD_ == null) {
            serializable = class$com$ibm$as400$access$AS400Timestamp == null ? (class$com$ibm$as400$access$AS400Timestamp = AS400AbstractTime.class$("com.ibm.as400.access.AS400Timestamp")) : class$com$ibm$as400$access$AS400Timestamp;
            synchronized (serializable) {
                if (hashTimestampFormatterXSD_ == null) {
                    hashTimestampFormatterXSD_ = new Hashtable();
                }
            }
        }
        if ((serializable = (SimpleDateFormat)hashTimestampFormatterXSD_.get(timeZone)) == null) {
            Class clazz = class$com$ibm$as400$access$AS400Timestamp == null ? (class$com$ibm$as400$access$AS400Timestamp = AS400AbstractTime.class$("com.ibm.as400.access.AS400Timestamp")) : class$com$ibm$as400$access$AS400Timestamp;
            synchronized (clazz) {
                serializable = (SimpleDateFormat)hashTimestampFormatterXSD_.get(timeZone);
                if (serializable == null) {
                    serializable = new SimpleDateFormat(TIMESTAMP_PATTERN_XSD);
                    ((DateFormat)serializable).setTimeZone(timeZone);
                    hashTimestampFormatterXSD_.put(timeZone, serializable);
                }
            }
        }
        return serializable;
    }

    private synchronized Date getStartDateForCentury(int n) {
        if (this.centuryMap_ == null) {
            this.centuryMap_ = new Date[10];
        }
        if (this.centuryMap_[n] == null) {
            this.centuryMap_[n] = this.getCalendar(100 * (19 + n), 0, 1, 0, 0, 0).getTime();
        }
        return this.centuryMap_[n];
    }

    abstract String patternFor(int var1, Character var2);

    abstract Character defaultSeparatorFor(int var1);

    abstract boolean isValidFormat(int var1);

    abstract int lengthFor(int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

