#!/bin/bash
# Simple script to backup MySQL databases

# Parent backup directory


  #sudo /etc/init.d/mysqld restart
 sudo rm  /var/log/httpd/access_log
 sudo rm  /var/log/httpd/error_log
  sudo rm  /var/log/httpd/ssl_error_log
  sudo rm  /var/log/httpd/ssl_access_log
  sudo rm  /var/log/httpd/ssl_request_log
  sudo service  httpd restart
  sudo service  mysqld restart

backup_parent_dir="/var/www/html/db_backup"
delete_backup_date=$(date --date="4 days ago" +"%Y%m%d")
echo "delete_backup_date ${delete_backup_date} " 
sudo rm "/var/www/html/db_backup/${delete_backup_date}" -r -f

# MySQL settings
mysql_host="localhost"
mysql_user="mysqlaws"
mysql_password="local*62M!C8}V]T7U_tRtitpl"

# Read MySQL password from stdin if empty
if [ -z "${mysql_password}" ]; then
  echo -n "Enter MySQL ${mysql_user} password: "
  read -s mysql_password
  echo
fi

# Check MySQL password
echo exit | mysql --host=${mysql_host}  --user=${mysql_user} --password=${mysql_password} -B 2>/dev/null
if [ "$?" -gt 0 ]; then
  echo "MySQL ${mysql_user} password incorrect"
  exit 1
else
  echo "MySQL ${mysql_user} password correct."
fi

# Create backup directory and set permissions
backup_date=`date +%Y%m%d`
backup_dir="${backup_parent_dir}/${backup_date}"
echo "Backup directory: ${backup_dir}"
mkdir -p "${backup_dir}"
#chmod 700 "${backup_dir}"

# Get MySQL databases
mysql_databases=`echo 'show databases' | mysql --host=${mysql_host} --user=${mysql_user} --password=${mysql_password} -B | sed /^Database$/d`

# Backup and compress each database
for database in $mysql_databases
do
  if [ "${database}" == "information_schema" ] || [ "${database}" == "performance_schema" ]; then
        additional_mysqldump_params="--skip-lock-tables"
  else
        additional_mysqldump_params=""
  fi
   if [ "${database}" = "leap_wf" ] || [ "${database}" == "leap_ecom" ] ; then 
  echo "Creating backup of \"${database}\" database"
  mysqldump --host=${mysql_host} ${additional_mysqldump_params} --user=${mysql_user} --password=${mysql_password} ${database} | gzip > "${backup_dir}/${database}.gz"
  else
  echo "skipping of \"${database}\" database "
  fi
  #chmod 600 "${backup_dir}/${database}.gz"
done
