/**
 * 
 */


import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import javax.sql.DataSource;

import org.apache.log4j.Logger;

/**
 * @author A57TAZZ
 *
 */
public class JDBCAccessor {

	/** JDBCACCESSOR static variable referes to the instance of this class*/
	public static JDBCAccessor JDBCACCESSOR = new JDBCAccessor();

	final Logger logger;
	static DataSource dataSource = null;
	static String jtSystem = "";
	static {
		try {
			if (dataSource == null) {
				jtSystem = "US400IN";		// do remember to change the system name accordingly to US400IN / US400IND
//				String dataSourceName = "jdbc/inapplications/ind_datasource";	// WAS Development Testing
				String dataSourceName = "java:jboss/jdbc/sdin/sdin_datasource";	// Jboss Datasource
//				String dataSourceName = "jdbc/inapplications/in_datasource";	// prod
				//String dataSourceName = "jdbc/prims/prims_datasource";
				InitialContext namingContext = new InitialContext();
				Object obj = namingContext.lookup(dataSourceName);
				dataSource = (DataSource) obj;
			}
		} catch (NamingException ne) {

		} catch (Exception e) {

		}
	}

	/**
	 * default private constructor
	 */

	public JDBCAccessor() {
		logger = Logger.getLogger(JDBCAccessor.class);
	}

	/**
	 *
	 * @param uid user id
	 * @param password
	 * @return returns connection object
	 */
	public Connection getConnection(String uid, String password) {
		Connection conn = null;
		try {
			conn = dataSource.getConnection();

		} catch (Exception e1) {
			try {
				Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
				//conn = DriverManager.getConnection("jdbc:odbc:sg400b", uid,password);

	  			//conn = DriverManager.getConnection("jdbc:odbc:R102TKMM",uid,password);
				conn = DriverManager.getConnection("jdbc:odbc:N104V2WM",uid,password);
//				conn = DriverManager.getConnection("jdbc:odbc:US400IND",uid,password);
			} catch (ClassNotFoundException e) {
				if (logger.isDebugEnabled()) {
					logger.debug("JDBCAccessor getConnection()", e);
				}
			} catch (SQLException e) {
				if (logger.isDebugEnabled()) {
					logger.debug("JDBCAccessor getConnection()"
							+ e.getLocalizedMessage());
				}
			}
		}
		return conn;

	}
	
	public Connection getJTConnection(String system, String uid, String pwd ) throws Exception
	{
		if(uid.isEmpty() || uid.equals(""))
		{
			uid="BPCSSECOFR";
		}
		if(pwd.isEmpty() || pwd.equals(""))
		{
			pwd="spring@6m";
		}
		Connection con=null;
	    
		try{
			
		    DriverManager.registerDriver(new com.ibm.as400.access.AS400JDBCDriver());
			String url = "jdbc:as400://"+jtSystem.toUpperCase()+";promt=false";
			con = DriverManager.getConnection (url,uid,pwd);
		}
		catch(SQLException e){
			if (logger.isDebugEnabled()) {
				logger.debug("JDBCAccessor getConnection()"
						+ e.getLocalizedMessage());
			}
		}
		return con;
	}

	public Connection getConnectionWithMessage(String uid, String password)
			throws Exception {
		Connection conn = null;

		String msg = "Incorrect User ID/Password!";
		try {
			conn = dataSource.getConnection(uid, password);
			} catch (Throwable e1) {
			try {
				Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
				//conn = DriverManager.getConnection("jdbc:odbc:sg400b", uid, password);
				//conn = DriverManager.getConnection("jdbc:odbc:R102TKMM",uid,password);
				conn = DriverManager.getConnection("jdbc:odbc:N104V2WM",uid,password);
//				conn = DriverManager.getConnection("jdbc:odbc:US400IND",uid,password);

			} catch (ClassNotFoundException e) {
			} catch (SQLException e) {
				String s1 = e.getErrorCode() + "";
				if (s1.indexOf("002") != -1) {
					msg = "Password for user " + uid
							+ " on server US400IN is not correct.";
				} else if (s1.indexOf("270") != -1) {
					msg = "User profile will be disabled with next invalid password.";
				} else if (s1.indexOf("011") != -1) {
					msg = "User " + uid
							+ " on server US400IN has been disabled.";
				} else {
					msg = "Incorrect User ID/Password.";
				}
				if (logger.isDebugEnabled()) {
					logger.debug("State : " + msg + "\t" + e.getErrorCode());
				}
			}
			if (conn == null)
				throw new Exception(msg);

		}
		return conn;
	}

	/**
	 * to know the login is valid or not returns true if login is valid
	 * @param uid user id
	 * @param password
	 * @return returns user is valid or not
	 */
	public boolean isLoginValid(String uid, String password) {
		Connection conn = getConnection(uid, password);
		return (conn != null);
	}

	/**
	 * used to close the Resources
	 * @param rs rs represents Result Set
	 * @param stmt stmt represents Statement
	 */
	public void closeJDBCAccessor(ResultSet rs, Statement stmt) {
		closeJDBCAccessor(null, rs, stmt);
	}

	/**
	 * used to close the Resources
	 * @param conn conn represents connection object
	 * @param rs rs represents Result Set
	 * @param stmt stmt represents Statement
	 */
	public void closeJDBCAccessor(Connection conn, ResultSet rs, Statement stmt) {
		try {
			if (rs != null) {
				rs.close();
			}
			if (stmt != null) {
				stmt.close();
			}
			if (conn != null) {
				conn.close();
			}
			if (logger.isDebugEnabled()) {
				logger.debug("JDBCAccessor closeJDBCAccessor()");
			}
		} catch (SQLException e) {

			if (logger.isDebugEnabled()) {
				logger.debug("JDBCAccessor closeJDBCAccessor()", e);
			}
		}
	}
}
