/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class ExtractImages {
    private int imageCounter = 1;
    private static final String PASSWORD = "-password";
    private static final String PREFIX = "-prefix";
    private static final String ADDKEY = "-addkey";
    private static final String NONSEQ = "-nonSeq";

    private ExtractImages() {
    }

    public static void main(String[] args) throws Exception {
        ExtractImages extractor = new ExtractImages();
        extractor.extractImages(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractImages(String[] args) throws Exception {
        if (args.length < 1 || args.length > 4) {
            ExtractImages.usage();
            return;
        }
        String pdfFile = null;
        String password = "";
        String prefix = null;
        boolean addKey = false;
        boolean useNonSeqParser = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    ExtractImages.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(PREFIX)) {
                if (++i >= args.length) {
                    ExtractImages.usage();
                }
                prefix = args[i];
                continue;
            }
            if (args[i].equals(ADDKEY)) {
                addKey = true;
                continue;
            }
            if (args[i].equals(NONSEQ)) {
                useNonSeqParser = true;
                continue;
            }
            if (pdfFile != null) continue;
            pdfFile = args[i];
        }
        if (pdfFile == null) {
            ExtractImages.usage();
            return;
        }
        if (prefix == null && pdfFile.length() > 4) {
            prefix = pdfFile.substring(0, pdfFile.length() - 4);
        }
        PDDocument document = null;
        try {
            if (useNonSeqParser) {
                document = PDDocument.loadNonSeq(new File(pdfFile), null, password);
            } else {
                document = PDDocument.load(pdfFile);
                if (document.isEncrypted()) {
                    StandardDecryptionMaterial spm = new StandardDecryptionMaterial(password);
                    document.openProtection(spm);
                }
            }
            AccessPermission ap = document.getCurrentAccessPermission();
            if (!ap.canExtractContent()) {
                throw new IOException("Error: You do not have permission to extract images.");
            }
            List pages = document.getDocumentCatalog().getAllPages();
            for (PDPage page : pages) {
                PDResources resources = page.getResources();
                this.processResources(resources, prefix, addKey);
            }
            Object var14_14 = null;
            if (document == null) return;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (document == null) throw throwable;
            document.close();
            throw throwable;
        }
        document.close();
    }

    private void processResources(PDResources resources, String prefix, boolean addKey) throws IOException {
        if (resources == null) {
            return;
        }
        Map<String, PDXObject> xobjects = resources.getXObjects();
        if (xobjects != null) {
            for (String key : xobjects.keySet()) {
                PDXObject xobject = xobjects.get(key);
                if (xobject instanceof PDXObjectImage) {
                    PDXObjectImage image = (PDXObjectImage)xobject;
                    String name = null;
                    name = addKey ? this.getUniqueFileName(prefix + "_" + key, image.getSuffix()) : this.getUniqueFileName(prefix, image.getSuffix());
                    System.out.println("Writing image:" + name);
                    image.write2file(name);
                    continue;
                }
                if (!(xobject instanceof PDXObjectForm)) continue;
                PDXObjectForm xObjectForm = (PDXObjectForm)xobject;
                PDResources formResources = xObjectForm.getResources();
                this.processResources(formResources, prefix, addKey);
            }
        }
    }

    private String getUniqueFileName(String prefix, String suffix) {
        String uniqueName = null;
        File f = null;
        while (f == null || f.exists()) {
            uniqueName = prefix + "-" + this.imageCounter;
            f = new File(uniqueName + "." + suffix);
            ++this.imageCounter;
        }
        return uniqueName;
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.pdfbox.ExtractImages [OPTIONS] <PDF file>\n  -password  <password>        Password to decrypt document\n  -prefix  <image-prefix>      Image prefix(default to pdf name)\n  -addkey                      add the internal image key to the file name\n  -nonSeq                      Enables the new non-sequential parser\n  <PDF file>                   The PDF document to use\n");
        System.exit(1);
    }
}

