<?php

if (!class_exists("PartialSmtpConnectionIO")) Mock::GeneratePartial("Swift_Connection_SMTP", "PartialSmtpConnectionIO", array("read", "write"));

class TestOfPLAINAuthenticator extends UnitTestCase
{
	public function testAuthenticatorSendsCorrectlyFormattedNullDelimitedRequests()
	{
		$auth = new Swift_Authenticator_PLAIN();
		$smtp = new PartialSmtpConnectionIO();
		$smtp->setReturnValueAt(0, "read", "235 Authenticated");
		$smtp->expectAt(0, "write", array("AUTH PLAIN foo\0foo\0bar", "*"));
		
		$smtp->setExtension("AUTH", array("PLAIN"));
		$smtp->setUsername("foo");
		$smtp->setPassword("bar");
		$smtp->attachAuthenticator($auth);
		$smtp->postConnect(new Swift($smtp, "xx", Swift::NO_START));
	}
	
	public function testExceptionIsThrownIfBadResponseReceived()
	{
		try {
			$auth = new Swift_Authenticator_PLAIN();
			$smtp = new PartialSmtpConnectionIO();
			$smtp->setReturnValueAt(0, "read", "500 Something");
			
			$smtp->setExtension("AUTH", array("PLAIN"));
			$smtp->setUsername("foo");
			$smtp->setPassword("bar");
			$smtp->attachAuthenticator($auth);
			$smtp->postConnect(new Swift($smtp, "xx", Swift::NO_START));
			$this->fail("This should have thrown an exception since a 235 response was needed.");
		} catch (Swift_Connection_Exception $e) {
			//Pass
		}
	}
	
	public function testRSETIsSentOnFailure()
	{
		try {
			$auth = new Swift_Authenticator_PLAIN();
			$smtp = new PartialSmtpConnectionIO();
			$smtp->setReturnValueAt(0, "read", "500 Something");
			$smtp->expectAt(0, "write", array("AUTH PLAIN foo\0foo\0bar", "*"));
			$smtp->expectAt(1, "write", array("RSET", "*"));
			
			$smtp->setExtension("AUTH", array("PLAIN"));
			$smtp->setUsername("foo");
			$smtp->setPassword("bar");
			$smtp->attachAuthenticator($auth);
			$smtp->postConnect(new Swift($smtp, "xx", Swift::NO_START));
			$this->fail("This should have thrown an exception since a 235 response was needed.");
		} catch (Swift_Connection_Exception $e) {
			//Pass
		}
	}
}
