<?php
error_reporting(E_ALL);
class CustomMailSendExpectation extends Swift_Plugin_MailSend
{
	protected $testcase = null;
	
	public function __construct($test)
	{
		parent::__construct();
		$this->testcase = $test;
	}
}

//Some custom expectations - ouch, yes, yes I know, perhaps I've dug myself into a hole here!
class MailSendExpectingNoTo extends CustomMailSendExpectation
{
	public function doMail($to, $subject, $message, $headers)
	{
		if ($headers->has("To")) $this->testcase->fail("The headers should NOT have a To field in them");
		else $this->testcase->pass();
	}
}

class MailSendExpectingNoSubject extends CustomMailSendExpectation
{
	public function doMail($to, $subject, $message, $headers)
	{
		if ($headers->has("Subject")) $this->testcase->fail("The headers should NOT have a Subject field in them");
		else $this->testcase->pass();
	}
}

class MailSendExpectingVitalHeaders extends CustomMailSendExpectation
{
	public function doMail($to, $subject, $message, $headers)
	{
		if (!$headers->has("From")) $this->testcase->fail("The headers MUST have a From field in them");
		else $this->testcase->pass();
		if (!$headers->has("Return-Path")) $this->testcase->fail("The headers MUST have a Return-Path field in them");
		else $this->testcase->pass();
		if (!$headers->has("Content-Type")) $this->testcase->fail("The headers MUST have a Content-Type field in them");
		else $this->testcase->pass();
		if (!$headers->has("Content-Transfer-Encoding")) $this->testcase->fail("The headers MUST have a Content-Transfer-Encoding field in them");
		else $this->testcase->pass();
	}
}

class MailSendWithGetDoMailArgs extends Swift_Plugin_MailSend
{
	protected $args = array();
	
	public function getDoMailArgs()
	{
		return $this->args;
	}
	
	public function doMail()
	{
		foreach (func_get_args() as $v)
		{
			if (is_object($v)) $this->args[] = clone $v;
			else $this->args[] = $v;
		}
	}
}

class TestOfMailSendPlugin extends UnitTestCase
{	
	public function testHeadersDoNotContainThe_To_Field()
	{
		$swift = new Swift(new Swift_Connection_NativeMail());
		$mailsend = new MailSendExpectingNoTo($this);
		
		$swift->attachPlugin($mailsend, "_MAIL_SEND"); //Override the MailSend plugin with a custom mock
		
		$recipients = new Swift_Address("test@bar.tld", "Test");
		$sender = "foobar@bar.com";
		$subject = "Foo Bar";
		$body = "Foo test\r\nBar";
		$message = new Swift_Message($subject, $body);
		
		$swift->send($message, $recipients, $sender);
	}
	
	public function testHeadersDoNotContainThe_Subject_Field()
	{
		$swift = new Swift(new Swift_Connection_NativeMail());
		$mailsend = new MailSendExpectingNoSubject($this);
		
		$swift->attachPlugin($mailsend, "_MAIL_SEND"); //Override the MailSend plugin with a custom mock
		
		$recipients = new Swift_Address("test@bar.tld", "Test");
		$sender = "foobar@bar.com";
		$subject = "Foo Bar";
		$body = "Foo test\r\nBar";
		$message = new Swift_Message($subject, $body);
		
		$swift->send($message, $recipients, $sender);
	}
	
	public function testVitalHeadersAreIncluded()
	{
		$swift = new Swift(new Swift_Connection_NativeMail());
		$mailsend = new MailSendExpectingVitalHeaders($this);
		
		$swift->attachPlugin($mailsend, "_MAIL_SEND"); //Override the MailSend plugin with a custom mock
		
		$recipients = new Swift_Address("test@bar.tld", "Test");
		$sender = "foobar@bar.com";
		$subject = "Foo Bar";
		$body = "Foo test\r\nBar";
		$message = new Swift_Message($subject, $body);
		
		$swift->send($message, $recipients, $sender);
	}
	
	public function testLineEndingIsCRLFForWindows()
	{
		//Windows users will be using SMTP and therefore need CRLF,
		// *nix and OS X users will be using Sendmail in "-t" mode and therefore need LF
		
		$swift = new Swift(new Swift_Connection_NativeMail());
		$mailsend = new MailSendWithGetDoMailArgs();
		$mailsend->setOS("WIN");
		$swift->attachPlugin($mailsend, "_MAIL_SEND"); //Override the MailSend plugin with a custom mock
		
		$recipients = new Swift_Address("test@bar.tld", "Test");
		$sender = "foobar@bar.com";
		$subject = "Foo Bar";
		$body = "Foo test\r\nBar";
		$message = new Swift_Message($subject, $body);
		$body_orig = $message->build()->readFull();
		$this->assertPattern("~\r\n~", $body);
		$swift->send($message, $recipients, $sender);
		$passed = $mailsend->getDoMailArgs();
		$this->assertNoPattern("~(?<!\r)\n~", $passed[2]);
		$this->assertNoPattern("~(?<!\r)\n~", $passed[3]->build());
	}
	
	public function testLineEndingIsLFForOtherSystems()
	{
		//Windows users will be using SMTP and therefore need CRLF,
		// *nix and OS X users will be using Sendmail in "-t" mode and therefore need LF
		
		$swift = new Swift(new Swift_Connection_NativeMail());
		$mailsend = new MailSendWithGetDoMailArgs();
		$mailsend->setOS("MAC");
		$swift->attachPlugin($mailsend, "_MAIL_SEND"); //Override the MailSend plugin with a custom mock
		
		$recipients = new Swift_Address("test@bar.tld", "Test");
		$sender = "foobar@bar.com";
		$subject = "Foo Bar";
		$body = "Foo test\r\nBar";
		$message = new Swift_Message($subject, $body);
		$body_orig = $message->build()->readFull();
		$this->assertPattern("~\r\n~", $body);
		$swift->send($message, $recipients, $sender);
		$passed = $mailsend->getDoMailArgs();
		$this->assertNoPattern("~\r\n~", $passed[2]);
		$this->assertNoPattern("~\r\n~", $passed[3]->build());
		
		$swift = new Swift(new Swift_Connection_NativeMail());
		$mailsend = new MailSendWithGetDoMailArgs();
		$mailsend->setOS("UNIX");
		$swift->attachPlugin($mailsend, "_MAIL_SEND"); //Override the MailSend plugin with a custom mock
		
		$recipients = new Swift_Address("test@bar.tld", "Test");
		$sender = "foobar@bar.com";
		$subject = "Foo Bar";
		$body = "Foo test\r\nBar";
		$message = new Swift_Message($subject, $body);
		$body_orig = $message->build()->readFull();
		$this->assertPattern("~\r\n~", $body);
		$swift->send($message, $recipients, $sender);
		$passed = $mailsend->getDoMailArgs();
		$this->assertNoPattern("~\r\n~", $passed[2]);
		$this->assertNoPattern("~\r\n~", $passed[3]->build());
	}
	
	public function testRecipientsArePassedCommaSeparatedWithLWSP() //as in "no line breaks"
	{
		$swift = new Swift(new Swift_Connection_NativeMail());
		$mailsend = new MailSendWithGetDoMailArgs();
		$mailsend->setOS("UNIX"); //Just so we have a common format to test with
		$swift->attachPlugin($mailsend, "_MAIL_SEND"); //Override the MailSend plugin with a custom mock
		
		$recipients = new Swift_RecipientList();
		$recipients->addTo("foo@bar.com", "Foo bar");
		$recipients->addTo("zip@button.com", "ZipButton");
		$recipients->addTo("fred@somewhere.tld");
		$recipients->addTo("joe@bloggs.com", "Ol' Joe");
		$sender = "foobar@bar.com";
		$subject = "Foo Bar";
		$body = "Foo test\r\nBar";
		$message = new Swift_Message($subject, $body);
		$swift->send($message, $recipients, $sender);
		$passed = $mailsend->getDoMailArgs();
		$this->assertEqual("Foo bar <foo@bar.com>, ZipButton <zip@button.com>, fred@somewhere.tld, Ol' Joe <joe@bloggs.com>", $passed[0]);
	}
	
	public function testBracesAreLeftOutOfToFieldIfOSIsWindows()
	{
		$swift = new Swift(new Swift_Connection_NativeMail());
		$mailsend = new MailSendWithGetDoMailArgs();
		$mailsend->setOS("WIN");
		$swift->attachPlugin($mailsend, "_MAIL_SEND"); //Override the MailSend plugin with a custom mock
		
		$recipients = new Swift_RecipientList();
		$recipients->addTo("foo@bar.com", "Foo bar");
		$recipients->addTo("zip@button.com", "ZipButton");
		$recipients->addTo("fred@somewhere.tld");
		$recipients->addTo("joe@bloggs.com", "Ol' Joe");
		$sender = "foobar@bar.com";
		$subject = "Foo Bar";
		$body = "Foo test\r\nBar";
		$message = new Swift_Message($subject, $body);
		$swift->send($message, $recipients, $sender);
		$passed = $mailsend->getDoMailArgs();
		$this->assertEqual("foo@bar.com, zip@button.com, fred@somewhere.tld, joe@bloggs.com", $passed[0]);
	}
	
	public function testSubjectIsProvidedInItsEncodedFormatIfNonAsciiIsUsed()
	{
		$swift = new Swift(new Swift_Connection_NativeMail());
		$mailsend = new MailSendWithGetDoMailArgs();
		$swift->attachPlugin($mailsend, "_MAIL_SEND"); //Override the MailSend plugin with a custom mock
		
		$recipients = new Swift_Address("test@bar.tld", "Test");
		$sender = "foobar@bar.com";
		$subject = "cenvéla";
		$body = "Foo test\r\nBar";
		$message = new Swift_Message($subject, $body);
		$this->assertPattern("~\r\n~", $body);
		$swift->send($message, $recipients, $sender);
		$passed = $mailsend->getDoMailArgs();
		$this->assertPattern("~^=\\?[^\\?]+\\?[QB]\\?.*?\\?=\$~sm", $passed[1]);
	}
	
	public function testSubjectIsProvidedUnencodedIfAsciiIsUsed()
	{
		$swift = new Swift(new Swift_Connection_NativeMail());
		$mailsend = new MailSendWithGetDoMailArgs();
		$swift->attachPlugin($mailsend, "_MAIL_SEND"); //Override the MailSend plugin with a custom mock
		
		$recipients = new Swift_Address("test@bar.tld", "Test");
		$sender = "foobar@bar.com";
		$subject = "foobar";
		$body = "Foo test\r\nBar";
		$message = new Swift_Message($subject, $body);
		$this->assertPattern("~\r\n~", $body);
		$swift->send($message, $recipients, $sender);
		$passed = $mailsend->getDoMailArgs();
		$this->assertEqual("foobar", $passed[1]);
	}
}
