<?php

if (!class_exists("PartialSmtpConnectionIO")) Mock::GeneratePartial("Swift_Connection_SMTP", "PartialSmtpConnectionIO", array("read", "write"));

class TestOfCRAMMD5Authenticator extends UnitTestCase
{
	public function testAuthenticatorSendsCorrectlyFormattedHashedRequests()
	{
		$auth = new Swift_Authenticator_CRAMMD5();
		$smtp = new PartialSmtpConnectionIO();
		$smtp->setReturnValueAt(0, "read", "334 " . base64_encode("<xxx.yyy@domain.tld>"));
		$smtp->setReturnValueAt(1, "read", "235 Authenticated");
		$smtp->expectAt(0, "write", array("AUTH CRAM-MD5", "*"));
		$smtp->expectAt(1, "write", array(base64_encode("foo " . Swift_Authenticator_CRAMMD5::generateCRAMMD5Hash("bar", "<xxx.yyy@domain.tld>")), "*"));
		
		$smtp->setExtension("AUTH", array("CRAM-MD5"));
		$smtp->setUsername("foo");
		$smtp->setPassword("bar");
		$smtp->attachAuthenticator($auth);
		$smtp->postConnect(new Swift($smtp, "xx", Swift::NO_START));
	}
	
	public function testExceptionIsThrownIfBadResponseReceived()
	{
		try {
			$auth = new Swift_Authenticator_CRAMMD5();
			$smtp = new PartialSmtpConnectionIO();
			$smtp->setReturnValueAt(0, "read", "500 Something");
			
			$smtp->setExtension("AUTH", array("CRAM-MD5"));
			$smtp->setUsername("foo");
			$smtp->setPassword("bar");
			$smtp->attachAuthenticator($auth);
			$smtp->postConnect(new Swift($smtp, "xx", Swift::NO_START));
			$this->fail("This should have thrown an exception since a 235 response was needed.");
		} catch (Swift_Connection_Exception $e) {
			//Pass
		}
	}
	
	public function testRSETIsSentOnFailure()
	{
		try {
			$auth = new Swift_Authenticator_CRAMMD5();
			$smtp = new PartialSmtpConnectionIO();
			$smtp->setReturnValueAt(0, "read", "500 Something");
			$smtp->expectAt(1, "write", array("RSET", "*"));
			$smtp->setExtension("AUTH", array("CRAM-MD5"));
			$smtp->setUsername("foo");
			$smtp->setPassword("bar");
			$smtp->attachAuthenticator($auth);
			$smtp->postConnect(new Swift($smtp, "xx", Swift::NO_START));
			$this->fail("This should have thrown an exception since a 235 response was needed.");
		} catch (Swift_Connection_Exception $e) {
			//Pass
		}
	}
}
