<?php

class TestOfAttachment extends UnitTestCase
{
	public function testAttachmentContainsNeededHeaders()
	{
		$attachment = new Swift_Message_Attachment("some string");
		$structure = $attachment->build()->readFull();
		$this->assertPattern(
			"~Content-Type: application/octet-stream;\\s* name=(\"?)(.*?)\\1\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Description: \\2\r\nContent-Disposition: attachment;\\s* filename=(\"?)\\2\\3\r\n\r\n.*~s", $structure);
			
		$attachment = new Swift_Message_Attachment(new Swift_File("../files/manchester.jpeg"));
		$structure = $attachment->build()->readFull();
		$this->assertPattern(
			"~Content-Type: application/octet-stream;\\s* name=(\"?)(.*?)\\1\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Description: \\2\r\nContent-Disposition: attachment;\\s* filename=(\"?)\\2\\3\r\n\r\n.*~s", $structure);
	}
	
	public function testFileNameCanBeChanged()
	{
		$attachment = new Swift_Message_Attachment("some string", "my_file.txt");
		$structure = $attachment->build()->readFull();
		$this->assertPattern(
			"~Content-Type: application/octet-stream;\\s* name=(\"?)(my_file\\.txt)\\1\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Description: \\2\r\nContent-Disposition: attachment;\\s* filename=(\"?)\\2\\3\r\n\r\n.*~s", $structure);
		
		$attachment = new Swift_Message_Attachment("some string");
		$attachment->setFileName("foo.txt");
		$structure = $attachment->build()->readFull();
		$this->assertPattern(
			"~Content-Type: application/octet-stream;\\s* name=(\"?)(foo\\.txt)\\1\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Description: \\2\r\nContent-Disposition: attachment;\\s* filename=(\"?)\\2\\3\r\n\r\n.*~s", $structure);
	}
	
	public function testFileNameCanBeReadFromFileStream()
	{
		$attachment = new Swift_Message_Attachment(new Swift_File("../files/manchester.jpeg"));
		$this->assertEqual("manchester.jpeg", $attachment->getFileName());
		$structure = $attachment->build()->readFull();
		$this->assertPattern(
			"~Content-Type: application/octet-stream;\\s* name=(\"?)(manchester\\.jpeg)\\1\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Description: \\2\r\nContent-Disposition: attachment;\\s* filename=(\"?)\\2\\3\r\n\r\n.*~s", $structure);
			
		$attachment = new Swift_Message_Attachment();
		$attachment->setData(new Swift_File("../files/manchester.jpeg"));
		$this->assertEqual("manchester.jpeg", $attachment->getFileName());
		$structure = $attachment->build()->readFull();
		$this->assertPattern(
			"~Content-Type: application/octet-stream;\\s* name=(\"?)(manchester\\.jpeg)\\1\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Description: \\2\r\nContent-Disposition: attachment;\\s* filename=(\"?)\\2\\3\r\n\r\n.*~s", $structure);
	}
	
	public function testFileNameCanBeOverriddenEvenWhenUsingFileStream()
	{
		$attachment = new Swift_Message_Attachment(new Swift_File("../files/manchester.jpeg"), "foo.bar");
		$this->assertEqual("foo.bar", $attachment->getFileName());
		$structure = $attachment->build()->readFull();
		$this->assertPattern(
			"~Content-Type: application/octet-stream;\\s* name=(\"?)(foo\\.bar)\\1\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Description: \\2\r\nContent-Disposition: attachment;\\s* filename=(\"?)\\2\\3\r\n\r\n.*~s", $structure);
		
		$attachment = new Swift_Message_Attachment(new Swift_File("../files/manchester.jpeg"));
		$attachment->setFileName("zip.button");
		$this->assertEqual("zip.button", $attachment->getFileName());
		$structure = $attachment->build()->readFull();
		$this->assertPattern(
			"~Content-Type: application/octet-stream;\\s* name=(\"?)(zip\\.button)\\1\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Description: \\2\r\nContent-Disposition: attachment;\\s* filename=(\"?)\\2\\3\r\n\r\n.*~s", $structure);
		
		$attachment = new Swift_Message_Attachment(new Swift_File("../files/manchester.jpeg"), "foo.bar");
		$attachment->setFileName("test.file");
		$this->assertEqual("test.file", $attachment->getFileName());
		$structure = $attachment->build()->readFull();
		$this->assertPattern(
			"~Content-Type: application/octet-stream;\\s* name=(\"?)(test\\.file)\\1\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Description: \\2\r\nContent-Disposition: attachment;\\s* filename=(\"?)\\2\\3\r\n\r\n.*~s", $structure);
	}
	
	public function testDescriptionCanBeOverridden()
	{
		$attachment = new Swift_Message_Attachment("some string", "my_file.txt");
		$attachment->setDescription("another_file.txt");
		$structure = $attachment->build()->readFull();
		$this->assertPattern(
			"~Content-Type: application/octet-stream;\\s* name=(\"?)(my_file\\.txt)\\1\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Description: another_file\\.txt\r\nContent-Disposition: attachment;\\s* filename=(\"?)\\2\\3\r\n\r\n.*~s", $structure);
			
		$attachment = new Swift_Message_Attachment(new Swift_File("../files/manchester.jpeg"));
		$attachment->setDescription("my_image.jpg");
		$structure = $attachment->build()->readFull();
		$this->assertPattern(
			"~Content-Type: application/octet-stream;\\s* name=(\"?)(.*?)\\1\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Description: my_image\\.jpg\r\nContent-Disposition: attachment;\\s* filename=(\"?)\\2\\3\r\n\r\n.*~s", $structure);
	}
	
	public function testSettingFileNameResetsDescription()
	{
		$attachment = new Swift_Message_Attachment("some string", "my_file.txt");
		$attachment->setDescription("another_file.txt");
		$this->assertEqual("another_file.txt", $attachment->getDescription());
		$attachment->setFileName("zip.button");
		$this->assertEqual("zip.button", $attachment->getDescription());
		$structure = $attachment->build()->readFull();
		$this->assertPattern(
			"~Content-Type: application/octet-stream;\\s* name=(\"?)(zip\\.button)\\1\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Description: \\2\r\nContent-Disposition: attachment;\\s* filename=(\"?)\\2\\3\r\n\r\n.*~s", $structure);
	}
}
