<?php
ini_set("memory_limit",-1);
ini_set('max_execution_time', 5000);
class dmart_avenue_ecom
{
		public $aobj_context;
 
		function __construct($aobj_context,$parent_obj)
		{
		$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->aobj_context=$aobj_context;
		$this->parent_obj=$parent_obj;
		$this->user_id = $_SESSION['user_id'];
		$format_file=$aobj_context->main_src."/src/format.php";
		$this->dec_pat="/^[-+]?[0-9]+\.[0-9]{2}+$/";				
		$this->number_pat="/^[0-9]+$/";		
	 
		 $this->txt_conversion_type=$this->parent_obj->txt_conversion_type;
		 
		 
				
		}
		function TrimWhiteSpaces($text)
		{
		return trim(preg_replace('/\s\s+/', ' ',$text));
		}
		function ReomveCommas($text)
		{
		$xtx= trim(preg_replace('/,/', '',$text));
		$xtx= trim(preg_replace('/-/', '',$xtx));
		return $xtx;
		}
		function getIndexIds($explode_line_arr,$name,$start_index)
		{
			for($i=$start_index;$i<count($explode_line_arr);$i++)
			{
			$cell_val=$explode_line_arr[$i];
			 if (preg_match("/{$name}/", $cell_val))
			 return $i;
			}
		}
		 
		function GetFullDateFormat($date)
		{
			 
			$date_arr=explode(".",$date);
			$prefix=20;
			$str=trim($prefix.$date_arr[2]);
		 
			$year=substr($str,-4);
		 	return trim($date_arr[0]."/". ($date_arr[1])."/".$year);
		}
		function GetDataTxtFromArrStartToEnd($explode_line_arr,$start_indx,$end_indx)
		{
			$txt="";
			for($i=$start_indx;$i<=$end_indx;$i++)
			{
			$o_txt=trim($explode_line_arr[$i]);
			$txt.="{$o_txt} ";
			}
			return $this->TrimWhiteSpaces($txt);
		}
	
	 	 
		function GetLineStartAndEndDetails($explode_line_arr)
		{
			$indx=$this->getIndexIds($explode_line_arr,"Price Value",1);
			$clot_index_row_data=$this->TrimWhiteSpaces($explode_line_arr[$indx]);
			$this->clot_index_exists=0;
			 if((preg_match("/Clot/", $clot_index_row_data)))
			 {
				 $this->clot_index_exists=1;
			 }
			 
			$this->start_line_indx=$indx+1;
			$indx=$this->getIndexIds($explode_line_arr,"Amount in Words",$this->start_line_indx);
			$this->end_line_indx=$indx-2;
		 
		}
		
		function GetRawItems($explode_line_arr)
		{
			$sl_no=1;
			$this->barcode_indx_arr=array();
			$this->barcode_next_line_arr=array();
			$this->raw_items_arr=array();
		 
			for($i=$this->start_line_indx;$i<=$this->end_line_indx;$i++)
			{
			$row_data=$this->TrimWhiteSpaces($explode_line_arr[$i]);
			 
			 $row_data_arr=explode(" ",$row_data);
		 
			 $barcode=substr(trim($row_data_arr[1]),0,13);
			// echo $barcode."</br>";
		 // && preg_match($this->number_pat,$barcode)
			  
			  if(strlen($barcode)>8 && 
							(preg_match("/890/", $barcode) || preg_match("/2901/", $barcode)|| preg_match("/100/", $barcode) ))
			 {
			 array_push($this->barcode_indx_arr,$i);
			 $this->raw_items_arr[$sl_no]=$this->TrimWhiteSpaces($row_data);
			 $sl_no++;
			 $hsn_txt=$this->TrimWhiteSpaces($explode_line_arr[$i+1]);
			 // echo  $hsn_txt."</br>";
			 if(!preg_match("/Code:/", $hsn_txt))
				 	 $hsn_txt=$this->TrimWhiteSpaces($explode_line_arr[$i+2]);
			 $this->barcode_next_line_arr[$barcode]=$hsn_txt;
			 }
			  
			}
 
		 
			
		}
		function GetBillingShippingAddress($explode_line_arr)
		{
			$shipping_address="";
			$billing_address="";
			$index=$this->getIndexIds($explode_line_arr,"Avenue E-Commerce Ltd",1)+1;
			$end_index=$this->getIndexIds($explode_line_arr,"Purchase Order Date",1)-1;
			 
			$shipping_address=$this->GetDataTxtFromArrStartToEnd($explode_line_arr,$index,$end_index);
			 
			$this->final_data['ship_to_address']=$shipping_address;
			$this->final_data['bill_to_address']=$shipping_address;
			
			 
			 
		}
		function GetPoNumberAndDate($explode_line_arr)
		{
			$spl_char = array(":","P.ONumber","PO No","PO Date","#","Delivery Dt","PO #");
			$index=$this->getIndexIds($explode_line_arr,"Purchase Order",0);
			$row_data=$explode_line_arr[$index];		 
			$exp_arr=explode("Purchase Order",$row_data);	 
			$po_number= trim((str_ireplace($spl_char,"",$exp_arr[1])));	
			$arr=explode(" ",$po_number);
			
			$this->final_data['po_number']=$arr[0];
			
			$index=$this->getIndexIds($explode_line_arr,"Purchase Order Date",$index);
			$row_data=$explode_line_arr[$index];		 
			$exp_arr=explode("Purchase Order Date",$row_data);	
			// print_r($exp_arr);
			$po_date= explode(" ",trim($exp_arr[1]));;	
 			// print_r($po_date);
			$this->final_data['po_date']=$this->GetFullDateFormat($po_date[1]);
			
		 		 
			$this->final_data['delivery_date']="00/00/0000";
			$this->final_data['ship_date']=$this->final_data['delivery_date'];
			
			  
		 
			
		}
		
		function ConevertToOrderFormat()
		{
		 
		  	$explode_line_arr=explode("\n",$this->parent_obj->read_txt_data);
		 	
			$this->total_po_qty=0;
			$this->total_po_value=0;
			$this->GetBillingShippingAddress($explode_line_arr);
			$this->GetPoNumberAndDate($explode_line_arr);
			$this->GetLineStartAndEndDetails($explode_line_arr);
			$this->GetRawItems($explode_line_arr);			 
			$this->GetLineItems($explode_line_arr);
			//die();
			   
			return $this->final_data;		
		}
		 
		function GetLineItems($explode_line_arr)
		{ 
		  
			$this->final_po_items=array();
			$sl_no=0;
			$this->total_po_qty=0;
			$this->total_po_value=0;
			  // echo "<pre>";
			 // print_r($this->clot_index_exists);
			  // print_r($this->raw_items_arr); 
			foreach($this->raw_items_arr as $rk=>$rv)
			{
				$raw_txt=$rv;		 
				$item_arr=explode(" ",$raw_txt);
				if(count($item_arr)<4) continue;
				$r_item_arr=array_reverse($item_arr);			
				 
				 
				$this->final_po_items[$sl_no]['po_item_description']=$this->GetDataTxtFromArrStartToEnd($item_arr,2,count($item_arr)-13);
				$this->final_po_items[$sl_no]['po_item_sku_code']=$item_arr[1];
			 	$this->final_po_items[$sl_no]['po_item_barcode']=$item_arr[1];	
				$this->final_po_items[$sl_no]['tot_amt']=str_replace(",","",$r_item_arr[0]);
			
				$this->final_po_items[$sl_no]['po_tax_rate']=$this->ReomveCommas($r_item_arr[2])+$this->ReomveCommas($r_item_arr[3])+$this->ReomveCommas($r_item_arr[4])+$this->ReomveCommas($r_item_arr[5]);
				// $lis_price=$r_item_arr[2];
				$final_rate=$r_item_arr[9];	
				$this->final_po_items[$sl_no]['rate']=$final_rate;//reducing Sch.Val
					$this->final_po_items[$sl_no]['po_item_mrp']=$r_item_arr[10];	
			 	// echo $this->clot_index_exists;
				if($this->clot_index_exists==0)
				{
					$this->final_po_items[$sl_no]['qty']=$r_item_arr[11];
				$this->final_po_items[$sl_no]['uom']=$r_item_arr[12];
				}
				else
				{	
							
					$this->final_po_items[$sl_no]['qty']=$r_item_arr[11];
					$this->final_po_items[$sl_no]['uom']=$r_item_arr[12];
					
					if($this->final_po_items[$sl_no]['qty']=="EA")
					{
						
						$this->final_po_items[$sl_no]['qty']=$r_item_arr[10];
						$this->final_po_items[$sl_no]['uom']=$r_item_arr[11];
							$this->final_po_items[$sl_no]['po_item_mrp']=$r_item_arr[9];	
					}
				}
				//addded new logic
				// if($this->final_po_items[$sl_no]['po_item_mrp']=="EA")
					{
						
					 	$ea_indx=$this->getIndexIds($item_arr,"EA",0);
						$this->final_po_items[$sl_no]['uom']=$item_arr[$ea_indx];
						$this->final_po_items[$sl_no]['qty']=$item_arr[$ea_indx+1];
						$this->final_po_items[$sl_no]['po_item_mrp']=$item_arr[$ea_indx+2];
						$this->final_po_items[$sl_no]['rate']=$item_arr[$ea_indx+3];
						 
					}
 
				$hsn_txt=$this->barcode_next_line_arr[$barcode];
				$hsn_txt_arr=explode("]",$hsn_txt);
				$hsn_code=$hsn_txt_arr[0];
				$spl_char=array("[","]","Code","HSN",":");
				$hsn_code= ((str_ireplace($spl_char,"",$hsn_code)));		 
				$this->final_po_items[$sl_no]['po_item_hsn_code']=trim($hsn_code);
		
				$this->total_po_qty+=$this->final_po_items[$sl_no]['qty'];
				$this->total_po_value+=$this->final_po_items[$sl_no]['tot_amt'];
				$sl_no++;
					
			}
		
			$this->final_data['items']=$this->final_po_items;
			$this->final_data['order_qty']=$this->total_po_qty;
			$this->final_data['order_value']=$this->total_po_value;
			   // echo "<pre>";print_r($this->final_data); die();  
			   return $this->final_data;
			 
			   
		}
	  
		  
		 
			
		 
			 
			 
		 
	function __destruct() {
      unset($this);
    } 
	  
} 
?>
