<?php
	class scheduledMail
	{
		function __construct($aobj_context)
		{
			session_start();
			$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
			$this->aobj_context=$aobj_context;
			require_once($this->aobj_context->main_src.'/src/cManualMailer.php');
			require_once($this->aobj_context->main_src."/src/json.php");
			require_once($this->aobj_context->main_src."/src/format.php");
			
			require_once($this->aobj_context->main_src."/src/report_class.php");
			$this->Excel = new create_report($this->aobj_context);
			require_once($this->aobj_context->main_src."/custom_src/manual_mailer.php");
			$this->file_name = '';
		}
		function sendReportMailForFileRate()
		{
			
			// echo "hi"; die();
			$get_billTo_data = "SELECT  
								DISTINCT
								CONCAT(DATE_FORMAT(DATE_ADD(NOW(),INTERVAL - 30 DAY), '%d-%b-%y'),' to ',DATE_FORMAT(NOW(), '%d-%b-%y')) AS date_range,  
								sales_rep_email_id,
								GROUP_CONCAT(internal_code) AS internal_code,
								DATE_FORMAT(NOW(),'%Y%m%d') AS curr_date
								FROM
								bill_to_customer_master 
								WHERE IFNULL(sales_rep_email_id,'') != ''
								GROUP BY sales_rep_email_id ";
								
			$lobj_billTo_data = $this->aobj_context->mobj_db->GetAll($get_billTo_data);
			
			$num = 1;
			foreach($lobj_billTo_data as $lk => $lv)
			{
				 $sales_rep_email_id=$lv['sales_rep_email_id'];
				 $this->date_range=$lv['date_range'];
				 $btl_int_codes=$lv['internal_code'];
				$this->getQueryData($sales_rep_email_id,$btl_int_codes);
				$this->ReportAttachment($lv,$num);
				$num+1;
				// echo "asd";die();
				$this->sendMail($lv['sales_rep_email_id'],$lv['curr_date']); die();
			}
			
			echo "done";
		}
		function GetQueryData($sales_rep_email_id,$btl_int_codes)
		{
        			
			$get_data="SELECT p.internal_code AS leap_so_no,muser.sysusr AS modified_user,cm.name AS customer,po_number,p.po_date AS po_date, bc.customer_code AS btl_code,
						bc.customer_name AS btl_name,s.description AS status_desc,order_value,am.stock_code,st.name AS state,
						p.sap_document_number,DATE_FORMAT(p.sap_document_date,'%d-%m-%Y') AS sap_document_date,
						am.stock_description AS item,IFNULL(poi.erp_qty,0) AS po_qty,IFNULL(poi.sap_invoice_qty,0) AS sap_invoice_qty,
						ROUND(IFNULL(poi.erp_qty,0)-IFNULL(poi.sap_invoice_qty,0),2) AS diff_qty
						FROM purchase_order p
						INNER JOIN purchase_order_item_group poi ON poi.ref_s_ref_data_code = p.internal_code
						INNER JOIN article_master am ON am.internal_code = poi.item
						INNER JOIN customer_master cm ON cm.internal_code=p.customer
						INNER JOIN bill_to_customer_master bc ON bc.internal_code IN ({$btl_int_codes})
						and bc.sales_rep_email_id='{$sales_rep_email_id}'
						INNER JOIN state st ON st.internal_code = bc.ship_to_state
						INNER JOIN s_sysdb muser ON muser.internal_code=p.modified_by
						INNER JOIN status s ON s.internal_code=p.status
						INNER JOIN location_wise_sap_series ls ON ls.location_code=bc.delivery_location_code AND ls.status='Active'
						WHERE s.internal_code= 7  
						AND p.date > DATE_FORMAT(DATE_ADD(NOW(),INTERVAL - 30 DAY), '%Y-%m-%d')
						order by cm.name,p.po_date";
							
							 // echo $get_data; die();
							 
			$this->obj_get_data = $this->aobj_context->mobj_db->GetAll($get_data);				
			
					
		}
		function ReportAttachment($data,$num)
		{
			$this->Excel->HideGridLines();
			$this->Excel->SetLandscape();
			$this->Excel->RepeateRows(1,6);
				
			$get_company_details = "SELECT  company_name FROM company_setup  ";
			$lobj_get_company_details = $this->aobj_context->mobj_db->GetRow($get_company_details); 
			
			$company_name = $lobj_get_company_details[company_name];
			
			$col_cnt = 14;			
			
			$title_arr = Array('1'=>Array(
											'style'=>'Title_Center',
											'caption'=>$company_name,
											'row'=>'1',
											'col'=>'0',
											'merge'=>"1,0:1,{$col_cnt}"),
											
								'2'=>Array(
												'style'=>'Title_Center',
												'caption'=>'PO Report',
												'row'=>'2',
												'col'=>'0',
												'merge'=>"2,0:2,{$col_cnt}"  // start_row,start_col : end_row,end_col
												),
											
								'3'=>Array(
												'style'=>'Title_Center',
												'caption'=>" From {$this->date_range}",
												'row'=>'3',
												'col'=>'0',
												'merge'=>"3,0:3,{$col_cnt}"  // start_row,start_col : end_row,end_col
												)				
												
											);		
			$this->Excel->SetTitles($title_arr);

			
		    $col_arr["1"]= Array("field"=>"customer","title"=>"Customer","style"=>"Heading_Center_Border","picture"=>"no","feild_style"=>'Data_Left_Border_Left_Right',"width"=>"12");
		    $col_arr["2"]= Array("field"=>"modified_user","title"=>"User","style"=>"Heading_Center_Border","picture"=>"no","feild_style"=>'Data_Left_Border_Left_Right',"width"=>"12");		   
		    $col_arr["3"]= Array("field"=>"po_number","title"=>"PO Number","style"=>"Heading_Center_Border","picture"=>"no","feild_style"=>'Data_Left_Border_Left_Right',"width"=>"15");
		    $col_arr["4"]= Array("field"=>"po_date","title"=>"PO Date","style"=>"Heading_Center_Border","picture"=>"no","feild_style"=>'Data_Left_Border_Left_Right',"width"=>"12");
		    $col_arr["5"]= Array("field"=>"btl_code","title"=>"Bill To Code","style"=>"Heading_Center_Border","picture"=>"no","feild_style"=>'Data_Left_Border_Left_Right',"width"=>"10");
		    $col_arr["6"]= Array("field"=>"btl_name","title"=>"Bill To Name","style"=>"Heading_Center_Border","picture"=>"no","feild_style"=>'Data_Left_Border_Left_Right',"width"=>"30");
			$col_arr["7"]= Array("field"=>"state","title"=>"Ship TO State","style"=>"Heading_Center_Border","picture"=>"no","feild_style"=>'Data_Left_Border_Left_Right',"width"=>"12");
			$col_arr["8"]= Array("field"=>"status_desc","title"=>"Status","style"=>"Heading_Center_Border","picture"=>"no","feild_style"=>'Data_Left_Border_Left_Right',"width"=>"15");
		    $col_arr["9"]= Array("field"=>"leap_so_no","title"=>"U_LEAPSONO","style"=>"Heading_Center_Border","picture"=>"no","feild_style"=>'Data_Left_Border_Left_Right',"width"=>"10");
			$col_arr["10"]= Array("field"=>"sap_document_number","title"=>"SAP Document Number","style"=>"Heading_Center_Border","picture"=>"no","feild_style"=>'Data_Left_Border_Left_Right',"width"=>"20");
		    $col_arr["11"]= Array("field"=>"sap_document_date","title"=>"SAP Document Date","style"=>"Heading_Center_Border","picture"=>"no","feild_style"=>'Data_Left_Border_Left_Right',"width"=>"15");
		    $col_arr["12"]= Array("field"=>"stock_code","title"=>"FG Code","style"=>"Heading_Center_Border","picture"=>"no","feild_style"=>'Data_Left_Border_Left_Right',"width"=>"15");
		    $col_arr["13"]= Array("field"=>"item","title"=>"FG Description","style"=>"Heading_Center_Border","picture"=>"no","feild_style"=>'Data_Left_Border_Left_Right',"width"=>"35");
		    $col_arr["14"]= Array("field"=>"po_qty","title"=>"PO Qty","style"=>"Heading_Center_Border","picture"=>"no","total"=>"Yes","feild_style"=>'Data_Right_Border_Right',"width"=>"20","format"=>"#,##,##0.00");
		    $col_arr["15"]= Array("field"=>"sap_invoice_qty","title"=>"Invoice Qty","style"=>"Heading_Center_Border","picture"=>"no","total"=>"Yes","feild_style"=>'Data_Right_Border_Right',"width"=>"20","format"=>"#,##,##0.00");
		    $col_arr["16"]= Array("field"=>"diff_qty","title"=>"Diff. Qty","style"=>"Heading_Center_Border","picture"=>"no","total"=>"Yes","feild_style"=>'Data_Right_Border_Right',"width"=>"20","format"=>"#,##,##0.00");
		    		
					
			$this->Excel->SetCurrentRow(6);
		    		
			$column_arr = array("header1"=>$col_arr
							    );
			$this->Excel->apply_style="no";
			$this->Excel->alt_color="no";
			$this->Excel->col_arr=$column_arr;
			
			$this->Excel->qry_data_set=$this->obj_get_data;
											
			$this->Excel->WriteExcelSheet();
			
			$highestColumn = $this->Excel->objPHPExcel->getActiveSheet()->getHighestColumn();
			$last_row = $this->Excel->row-1;
			
		
			$this->Excel->objPHPExcel->getActiveSheet()->getStyle("A7:{$highestColumn}{$last_row}")->applyFromArray(
			array(
				'font'  => array(
									'size'  => '8',
									'name'  => 'Cambria',
								  ),
				'alignment' => array(
										'wrap' => true,
										'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
										'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
								   ),
				'borders' => array(
						'allborders' => array(
									'style' => PHPExcel_Style_Border::BORDER_THIN 
								)
							)
					) 
			);	
			
			$this->file_name = "fill_rate_report_".$data['curr_date']."_".$num.".xlsx"; 
			
			$objWriter = PHPExcel_IOFactory::createWriter($this->Excel->objPHPExcel, 'Excel2007');
			$objWriter->save($this->aobj_context->main_src."/attachments/".$this->file_name); 
			
		}
		function sendMail($to,$curr_date)
		{
			$subject ="Fill Rate Report for the period from {$this->date_range}";
			$attachment_arr=array();
			$attachment_arr[0]=array();
			$attachment_arr[0]['path'] = $this->aobj_context->main_src."/attachments/".$this->file_name;
			$attachment_arr[0]['name'] = 'fill_rate_report.xlsx';
			
			 // echo "hi"; die();
			
			$mail_html='';
			$mail_html.='<html>';
			$mail_html.='<body>';
			$mail_html.='<h4>Dear Sir,</h4>';
			$mail_html.="</br> Please find the Fill Rate report for the period from {$this->date_range}";
			$mail_html.="</br></br> Thank You.<br><br>";
			$mail_html.='*-* This is a system generated email *-*';
		 
			$mail_html.='</body>';
			$mail_html.='</html>';	
			
			try 
			{			
				// echo "hi"; die();	
				$to = 'natesha.s@tarkasoft.com';
				$cc = "";
				
				$data = send_mail($this->aobj_context,$to,$subject,$mail_html,$cc,$attachment_arr);
				echo "<pre>";print_r($data);die();
			}
			catch(Exception $e) 
			{
				$data= "Mail Sending Failed - ".$e->getMessage();
			} 
		}
	}
	function sendReportMailForFileRate($aobj_context)
	{
		$obj = new scheduledMail($aobj_context);
		$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$obj->sendReportMailForFileRate();
	}
	
	
?>
