<?php
class graphs
{
	public $internal_code;
	function __construct($aobj_context)
	{
		session_start();
		
		$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->aobj_context=$aobj_context;
		$this->user_id = $_SESSION['user_id'];
		$this->user_type= $_SESSION['user_type'];
		$this->real_name= $_SESSION['real_name'];  
		$this->user_group = $_SESSION['user_group'];
		$this->getFinancialYear();
		$this->graph_year=$this->graph_year;
		$this->graph_color_array=array("#35AA47","#ED4E2A","#4B5FF4","#E2982F","#1AE0A1","#04D215","#ff0066","#6699ff","#cc3300","#008000","#ffff00","#996633");
	}
	
	function getFinancialYear()
	{
		$get_fin_datatils="SELECT
							  internal_code AS fin_year_int_code,
							  start_date    AS fin_year_db_start_date,
							  year_code     AS year_code,
							  end_date      AS fin_year_db_end_date,
							  DATE_FORMAT(start_date, '%d-%b-%Y') AS fin_year_ui_start_date,
							  DATE_FORMAT(end_date, '%d-%b-%Y') AS fin_year_ui_end_date,
							  CONCAT(DATE_FORMAT(start_date,'%Y'),'-',DATE_FORMAT(end_date, '%Y')) AS fin_year_code_manual
							FROM financial_year
							WHERE CURRENT_DATE()BETWEEN start_date
								AND end_date";
		// echo $get_fin_datatils;die();
		$obj_select_no_of_months = $this->aobj_context->mobj_db->GetRow($get_fin_datatils);
		 
		$this->fin_year_int_code=$obj_select_no_of_months['fin_year_int_code'];
		$this->fin_year_code=$obj_select_no_of_months['year_code'];
		$this->fin_year_db_start_date=$obj_select_no_of_months['fin_year_db_start_date'];
		$this->fin_year_db_end_date=$obj_select_no_of_months['fin_year_db_end_date'];
		$this->fin_year_ui_start_date=$obj_select_no_of_months['fin_year_ui_start_date'];
		$this->fin_year_ui_end_date=$obj_select_no_of_months['fin_year_ui_end_date'];
		$this->fin_year_code_manual=$obj_select_no_of_months['fin_year_code_manual'];
		
		$get_max_data="SELECT
						  MAX(CONCAT(processed_year,RIGHT(CONCAT('0',processed_month),2))) AS max_year_month,
						  DATE_FORMAT(NOW(),'%Y%m') AS cur_year_month
						FROM employee_monthly_salary_summary";
		$obj_get_max_data = $this->aobj_context->mobj_db->GetRow($get_max_data);
		$this->max_year_month=$obj_get_max_data['max_year_month'];
		$this->cur_year_month=$obj_get_max_data['cur_year_month'];
		$this->year_month=$this->cur_year_month;
		$this->month_year_txt=date("M-Y",strtotime(substr($this->max_year_month,0,4)."-".substr($this->max_year_month,-2)."-01"));
	}		
	
	function GetUserGraphs()
	{
		$graph_types_arr['Dashboard']='dashboard';
		
		$dash_arr = "";
		foreach($graph_types_arr as $menu_name => $div_id)
		{
			$this->GetUserRightsModules($menu_name);
			$arr=$this->FormUserRightsModules();
			 
			$dash_arr.=$arr;
		}
	 
		echo $this->aobj_context->mobj_output->ToJSONEnvelope($dash_arr,0,"success");  
	}
	
	function FormUserRightsModules()
	{
		$this->final_graph_arr=array();
		$i=0;
		$dash_html = "";
		foreach($this->lobj_module_data	 as $ak=>$av)
		{
			$this->internal_code=$av['internal_code'];
			$this->module_name=$av['module_name'];
			$this->system_module_table_name=$av['system_module_table_name'];
			$this->display_module_name=$av['display_module_name'];
			require_once($this->aobj_context->main_src."/dashboard/{$this->system_module_table_name}.php");
			 
			$obj=new $this->system_module_table_name($this);
			$arr=$obj->GetDashboardData();
			
			 
			$dash_html.=$arr['html_data']; 
		}
		return $dash_html;
	}
	 
	function GetUserRightsModules($menu_name)
	{
		if($this->user_type != 'Admin')
		{
			$join_cond = " INNER JOIN user_rights ur on ur.module_id = s.internal_code ";
			$where_cond = " AND ur.ref_s_sysdb_code in ({$this->user_id},{$this->user_group}) AND ur.is_view = 1 ";
		}
		else
		{
			$join_cond = "";
			$where_cond = " ";
		}	
				
		$get_data = "SELECT DISTINCT
					  s.internal_code,
					  display_module_name,
					  system_module_table_name,
					  module_name,
					  ss.value                 AS sub_menu
					FROM s_user_schema s
					  INNER JOIN s_ref_type sr
						ON sr.internal_code = s.module_type
					  LEFT JOIN s_ref_type ss
						ON ss.internal_code = main_menu {$join_cond}
					WHERE sr.value = '{$menu_name}'
						AND s.active = 1 {$where_cond}
					ORDER BY s.sequence";	
		// echo $get_data;die();
		$this->lobj_module_data = $this->aobj_context->mobj_db->GetAll($get_data); 			
	}
}
function GetUserGraphs($aobj_context)
{
	$change_obj=new graphs($aobj_context);
	$change_obj->GetUserGraphs();
} 
?>