<?php

class TestOfFile extends UnitTestCase
{
	public function testExceptionIsThrowIfFileNotFound()
	{
		try {
			$file = new Swift_File("/no/such/file.php");
			$this->fail("This should have thrown an exception");
		} catch (Swift_FileException $e) {
			//Pass if file really is not there
			$this->assertFalse(file_exists("/no/such/file.php"));
		}
	}
	
	public function testBytesReadFromFileAreCorrect()
	{
		$file = new Swift_File("../files/manchester.jpeg");
		
		$data = "";
		while (false !== $byte = $file->getByte()) $data .= $byte;
		
		$this->assertIdentical($data, file_get_contents("../files/manchester.jpeg"));
	}
	
	public function testReadFullIsSameAsActualFileContents()
	{
		$file = new Swift_File("../files/manchester.jpeg");
		$this->assertIdentical($file->readFull(), file_get_contents("../files/manchester.jpeg"));
	}
	
	public function testFileNameIsReturned()
	{
		$file = new Swift_File("../files/manchester.jpeg");
		$this->assertEqual("manchester.jpeg", $file->getFileName());
		
		$file->setPath(__FILE__); //TestOfFile.php
		$this->assertEqual(basename(__FILE__), $file->getFileName());
	}
	
	//Not easy to test exception throw if file cannot be read so I just trust it ;)
}
