<?php

//We need to use smoke tests to verify the encoding "actually works" ;)

class TestOfEncoder extends UnitTestCase
{
	public function testBase64EncodingFileIsSameAsBase64EncodingString()
	{
		$str_encoded = Swift_Message_Encoder::instance()->base64Encode(file_get_contents("../files/manchester.jpeg"), 76);
		$file_encoded = Swift_Message_Encoder::instance()->base64EncodeFile(new Swift_File("../files/manchester.jpeg"), 76)->readFull();
		$this->assertEqual($str_encoded, $file_encoded);
	}
	
	public function testBase64EncodeContainsOnlyRelevant7BitChars()
	{
		$data = file_get_contents("../files/manchester.jpeg");
		$this->assertNoPattern("~^[a-zA-Z0-9\\+/=]+\$~", $data);
		$encoded = Swift_Message_Encoder::instance()->rawBase64Encode($data);
		$this->assertPattern("~^[a-zA-Z0-9\\+/=]+\$~", $encoded);
	}
	
	public function testBase64EncodedLinesAreNotLongerThanSpecified()
	{
		$data = file_get_contents("../files/manchester.jpeg");
		
		$encoded = Swift_Message_Encoder::instance()->base64Encode($data, 76);
		$lines = explode("\r\n", $encoded);
		foreach ($lines as $line)
		{
			$line .= "\r\n"; //lost in explode()
			$this->assertWithinMargin(0, strlen($line), 76);
		}
		
		$encoded = Swift_Message_Encoder::instance()->base64Encode($data, 1000);
		$lines = explode("\r\n", $encoded);
		foreach ($lines as $line)
		{
			$line .= "\r\n"; //lost in explode()
			$this->assertWithinMargin(0, strlen($line), 1000);
		}
	}
	
	public function testFirstBase64EncodedLineCanHaveUniqueLength()
	{
		$data = file_get_contents("../files/manchester.jpeg");
		
		$encoded = Swift_Message_Encoder::instance()->base64Encode($data, 76, 10);
		$lines = explode("\r\n", $encoded);
		$this->assertWithinMargin(0, strlen($lines[0] . "\r\n"), 10);
		
		$encoded = Swift_Message_Encoder::instance()->base64Encode($data, 76, 13);
		$lines = explode("\r\n", $encoded);
		$this->assertWithinMargin(0, strlen($lines[0] . "\r\n"), 13);
		
		$encoded = Swift_Message_Encoder::instance()->base64Encode($data, 76, 27);
		$lines = explode("\r\n", $encoded);
		$this->assertWithinMargin(0, strlen($lines[0] . "\r\n"), 27);
	}
	
	public function testQPEncodingFileIsSameAsQPEncodingString()
	{
		$str_encoded = Swift_Message_Encoder::instance()->QPEncode(file_get_contents("../files/manchester.jpeg"), 76);
		$file_encoded = Swift_Message_Encoder::instance()->QPEncodeFile(new Swift_File("../files/manchester.jpeg"), 76)->readFull();
		$this->assertEqual($str_encoded, $file_encoded);
	}
	
	public function testQPEncodeContainsOnlyRelevant7BitChars()
	{
		$data = file_get_contents("../files/manchester.jpeg");
		$this->assertNoPattern("~^[^\\x21-\\x3C\\x3E-\\x7E\\x09\\x20=]+\$~", $data);
		$encoded = Swift_Message_Encoder::instance()->rawQPEncode($data);
		$this->assertPattern("~^[\\x21-\\x3C\\x3E-\\x7E\\x09\\x20=]+\$~", $encoded);
	}
	
	public function testQPEncodedLinesAreNotLongerThanSpecified()
	{
		$data = file_get_contents("../files/manchester.jpeg");
		
		$encoded = Swift_Message_Encoder::instance()->QPEncode($data, 76);
		$lines = explode("\r\n", $encoded);
		foreach ($lines as $line)
		{
			$line .= "\r\n"; //lost in explode()
			$this->assertWithinMargin(0, strlen($line), 76);
		}
		
		$encoded = Swift_Message_Encoder::instance()->QPEncode($data, 1000);
		$lines = explode("\r\n", $encoded);
		foreach ($lines as $line)
		{
			$line .= "\r\n"; //lost in explode()
			$this->assertWithinMargin(0, strlen($line), 1000);
		}
	}
	
	public function testFirstQPEncodedLineCanHaveUniqueLength()
	{
		$data = file_get_contents("../files/manchester.jpeg");
		
		$encoded = Swift_Message_Encoder::instance()->QPEncode($data, 76, 10);
		$lines = explode("\r\n", $encoded);
		$this->assertWithinMargin(0, strlen($lines[0] . "\r\n"), 10);
		
		$encoded = Swift_Message_Encoder::instance()->QPEncode($data, 76, 13);
		$lines = explode("\r\n", $encoded);
		$this->assertWithinMargin(0, strlen($lines[0] . "\r\n"), 13);
		
		$encoded = Swift_Message_Encoder::instance()->QPEncode($data, 76, 27);
		$lines = explode("\r\n", $encoded);
		$this->assertWithinMargin(0, strlen($lines[0] . "\r\n"), 27);
	}
	
	public function test7BitEncodedLinesAreNotLongerThanSpecified()
	{
		$data = file_get_contents("../files/manchester.jpeg");
		
		$encoded = Swift_Message_Encoder::instance()->encode7Bit($data, 76);
		$lines = explode("\r\n", $encoded);
		foreach ($lines as $line)
		{
			$line .= "\r\n"; //lost in explode()
			$this->assertWithinMargin(0, strlen($line), 76);
		}
		
		$encoded = Swift_Message_Encoder::instance()->encode7Bit($data, 1000);
		$lines = explode("\r\n", $encoded);
		foreach ($lines as $line)
		{
			$line .= "\r\n"; //lost in explode()
			$this->assertWithinMargin(0, strlen($line), 1000);
		}
	}
	
	public function test8BitEncodedLinesAreNotLongerThanSpecified()
	{
		$data = file_get_contents("../files/manchester.jpeg");
		
		$encoded = Swift_Message_Encoder::instance()->encode8Bit($data, 76);
		$lines = explode("\r\n", $encoded);
		foreach ($lines as $line)
		{
			$line .= "\r\n"; //lost in explode()
			$this->assertWithinMargin(0, strlen($line), 76);
		}
		
		$encoded = Swift_Message_Encoder::instance()->encode8Bit($data, 1000);
		$lines = explode("\r\n", $encoded);
		foreach ($lines as $line)
		{
			$line .= "\r\n"; //lost in explode()
			$this->assertWithinMargin(0, strlen($line), 1000);
		}
	}
	
	public function testAddressChunkIsLossless()
	{
		$string = 'Some arbitrary string with an <add@re.ss> in it';
		$parts = Swift_Message_Encoder::instance()->addressChunk($string);
		$this->assertEqual(array(0 => 'Some arbitrary string with an ', 'a1' => '<add@re.ss>', 2 => ' in it'), $parts);
		
		$string = "Joe Bloggs <some@address>,\r\n " . 
		"Fred Jones <fred>,\r\n " .
		"Zip Button <zip@button.com>";
		$parts = Swift_Message_Encoder::instance()->addressChunk($string);
		$this->assertEqual(array(0 => "Joe Bloggs ", "a1" => "<some@address>", 2 => ",\r\n Fred Jones ", "a3" => "<fred>", 4 => ",\r\n Zip Button ", "a5" => "<zip@button.com>"), $parts);
		
		$string = "Some arbitrary string with an invalid <ad\nd@re.ss> in it";
		$parts = Swift_Message_Encoder::instance()->addressChunk($string);
		$this->assertEqual(array(0 => $string), $parts);
	}
	
	public function testUTF8Detection()
	{
		$iso88591 = file_get_contents("../files/encodings/iso-8859-1.txt");
		$this->assertFalse(Swift_Message_Encoder::instance()->isUTF8($iso88591));
		
		$utf8 = file_get_contents("../files/encodings/utf-8.txt");
		$this->assertTrue(Swift_Message_Encoder::instance()->isUTF8($utf8));
	}
}
