<?php

if (!class_exists("FullMockConnection")) Mock::Generate("DummyConnection", "FullMockConnection");
Mock::GeneratePartial("Swift_Plugin_AntiFlood", "MockAntiFloodPlugin", array("wait"));

class TestOfAntiFloodPlugin extends UnitTestCase
{
	/** Get a mock connection for testing
	 * @param int The number emails you expect to send
	 * @param Swift_Connection A mocked object which has not been setup yet
	 * @return FullMockConnection
	 */
	protected function getWorkingMockConnection($send=1, $conn=null, $reconnect_at=0, $max_reconnect=0)
	{
		$count = 0;
		if (!$conn) $conn = new FullMockConnection();
		$conn->setReturnValueAt($count++, "read", "220 xxx ESMTP");
		$conn->setReturnValueAt($count++, "read", "250-Hello xxx\r\n250 HELP");
		$cycle = 0;
		$reconnected = 0;
		for ($i = 0; $i < $send; $i++)
		{
			$cycle++;
			$conn->setReturnValueAt($count++, "read", "250 Ok");
			$conn->setReturnValueAt($count++, "read", "250 Ok");
			$conn->setReturnValueAt($count++, "read", "354 Go ahead");
			$conn->setReturnValueAt($count++, "read", "250 Ok");
			if ($reconnect_at && $reconnect_at == $cycle)
			{
				if (!$max_reconnect || $max_reconnect > $reconnected)
				{
					$conn->setReturnValueAt($count++, "read", "221 Bye");
					$conn->setReturnValueAt($count++, "read", "220 xxx ESMTP");
					$conn->setReturnValueAt($count++, "read", "250-Hello xxx\r\n250 HELP");
					$cycle = 0;
					$reconnected++;
				}
			}
		}
		$conn->setReturnValue("read", "250 Ok");
		return $conn;
	}
	
	public function testDisconnectIsInvokedAsManyTimesAsNeeded()
	{
		$conn = $this->getWorkingMockConnection(20, null, 5);
		$conn->expectCallCount("stop", 4);
		$conn->expectCallCount("start", 5);
		
		$swift = new Swift($conn);
		$swift->attachPlugin(new Swift_Plugin_AntiFlood(5), "antiflood");
		for ($i = 0; $i < 20; $i++)
		{
			$swift->send(new Swift_Message("foo", "bar"), new Swift_Address("foo@bar.com"), new Swift_Address("foo@bar.com"));
		}
		
		$conn = $this->getWorkingMockConnection(20, null, 15);
		$conn->expectCallCount("stop", 1);
		$conn->expectCallCount("start", 2);
		
		$swift = new Swift($conn);
		$swift->attachPlugin(new Swift_Plugin_AntiFlood(15), "antiflood");
		for ($i = 0; $i < 20; $i++)
		{
			$swift->send(new Swift_Message("foo", "bar"), new Swift_Address("foo@bar.com"), new Swift_Address("foo@bar.com"));
		}
	}
	
	public function testWaitingTimeIsHonoured()
	{
		$conn = $this->getWorkingMockConnection(20, null, 5);
		
		$swift = new Swift($conn);
		$plugin = new MockAntiFloodPlugin();
		$plugin->setWait(10);
		$plugin->setThreshold(5);
		$plugin->expect("wait", array(10));
		
		$swift->attachPlugin($plugin, "antiflood");
		for ($i = 0; $i < 20; $i++)
		{
			$swift->send(new Swift_Message("foo", "bar"), new Swift_Address("foo@bar.com"), new Swift_Address("foo@bar.com"));
		}
	}
}
