<?PHP
//*******************************************************************
// Author 		:	Naveen
//Date			:	26-Aug-2015
//Description	: 	Excel Report Creation 
//*******************************************************************

class create_report
{
	public $title_arr;
	function __construct($aobj_context)
	{
		$this->aobj_context=$aobj_context;
		$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$format_file=$aobj_context->main_src."/src/format.php";
		include_once($format_file); 
		$num_word=$this->aobj_context->main_src."/src/getnumword.php";	

        ini_set("memory_limit","1000000000");
	    ini_set('max_execution_time',1400000);
		
		$excel_writer=$this->aobj_context->main_src."/PHPExcel_1.8.0/Classes/PHPExcel.php";
		include($excel_writer);	
		require_once($this->aobj_context->main_src."/PHPExcel_1.8.0/Classes/PHPExcel/IOFactory.php");
		require_once($this->aobj_context->main_src."/src/PHPExcelStyles.php");
		require_once($this->aobj_context->main_src."/custom_src/CustomExcelStyles.php");
		$this->system_module_table_name = $this->aobj_context->mobj_data["system_module_table_name"];
		$this->report_type = $this->aobj_context->mobj_data["report_type"];
		$this->user_id = $_SESSION['user_id'];
		$this->row=1;
		$this->_total_formatter="#,##0.00";
		$this->column=0;
		$this->_column=0;
		$this->_column=0;
		$this->repeate_header_columns="no";
		$this->alt_color="no";
		$this->print_row_total="yes";
		$this->apply_style="yes";
		$this->col_arr=null;
		$this->qry_data_set=null;
		$this->subtoalfields=null;
		$this->CreateExcelObject();
	}
	
	function defaultFont()
	{
		 $this->worksheet->getDefaultStyle()->getFont()->setName('Cambria')->setSize(9);
		// $this->worksheet->getDefaultStyle()->getNumberFormat()->setFormatCode('#,##0.00;[Red]-#,##0.00');
		 		 
	}
	
	function CreateExcelObject()
	{ 
		// $Add_Format_Style =& new FormatStyle();
		$this->objPHPExcel = new PHPExcel();			
		$this->worksheet=$this->objPHPExcel->setActiveSheetIndex(0);
		$this->objPHPExcel->getActiveSheet()->setTitle('Sheet1');
	    $this->style_arr['Title_Center'] =$Add_Format_Style->Title_Center; 
		$this->objPHPExcel->getProperties()->setCreator("Tarka Infotech Pvt Ltd..")
                                ->setLastModifiedBy("Tarka")
                                ->setTitle($this->system_module_table_name)
                                ->setSubject($this->system_module_table_name);
						
			
		/* 		$this->objPHPExcel->getActiveSheet()->getProtection()->setPassword('PHPExcel');
		$this->objPHPExcel->getActiveSheet()->getProtection()->setSheet(true);		
		$this->objPHPExcel->getActiveSheet()->getProtection()->setSort(true);	
		$this->objPHPExcel->getActiveSheet()->getProtection()->setInsertRows(true);
		$this->objPHPExcel->getActiveSheet()->getProtection()->setFormatCells(true); */
	}	
	
	//Create Excel Sheet
	function AddExcelSheet($sheet_name=null,$border = null,$col_no = null)
	{
		$sheetCount=$this->objPHPExcel->getSheetCount();
		
		$sheetCount=$sheetCount+1;
		
		$sheetname="Sheet".$sheetCount;
		
		// Create the new  sheet to the $objPHPExcel workbook
		$this->worksheet  = $this->objPHPExcel->createSheet();
		
		if($border == 1)
		{ 
	     
			$this->worksheet->getStyle(
		                              "{$col_no}"
									  )->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
		}
		
		
		//  Attach the newly-cloned sheet to the $objPHPExcel workbook
		// $this->objPHPExcel->addSheet($this->worksheet);
		
		if(empty($sheet_name))$sheet_name=$sheetname;
		$this->worksheet->setTitle($sheet_name);
		$this->row=1;
		$this->column=0;
		$this->_column=0;
		$this->_total_req=0;
		$this->col_arr=null;
	}
	
	function SetSheetName($name,$border=null,$col_no=null)
	{
		$this->objPHPExcel->getActiveSheet()->setTitle($name);
		
		if($border == 1)
		{ 
			$this->worksheet->getStyle(
		                              "{$col_no}"
									  )->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
		}
		
		
	}
	
	
	function SetActiveSheetByName($sheetname)
	{
		if(empty($sheetname))
		{
			echo " Sheet Name Can not be empty";
			die();
		}
		else
		{
			$sheet_name_arr=array_flip($this->objPHPExcel->getSheetNames());
			$sheet_index = $sheet_name_arr[$sheetname];
			$this->worksheet=$this->objPHPExcel->setActiveSheetIndex($sheet_index);
		}
	}
	
	 //Hide Grid Lines
	function HideGridLines()
	{
		$this->worksheet->SetShowGridLines(False);
	}
	
	//Show Grid Lines
	function ShowGridLines()
	{
		$this->worksheet->SetShowGridLines(True);
	}
	
	//Set Row
	function SetCurrentRow($row_no=0)
	{
		$this->row=$row_no;
	}
	//Set Start col
	function SetStartColumn($col_no=0)
	{
		$this->column=$col_no;
		$this->_column=$col_no;
	}
	
	//get current Row
	function GetCurrentRow()
	{
		return $this->row;
	}

	function FreezePane($range) // specify range  eg : A1 or A3 
	{
		$this->objPHPExcel->getActiveSheet()->freezePane($range);
	}
	function SetLandscape() 
	{
		$this->objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
	}
	function FitTopage() 
	{
       $this->objPHPExcel->getActiveSheet()->getPageSetup()->setFitToPage(true);
	}
	
	//Set Page Titles
	function SetTitles($title_arr)
	{
		
		foreach($title_arr as $title_key=>$title_arr_val)
		{
			$this->row=empty($title_arr_val['row']) ? 1 : $title_arr_val['row'];
			$col=empty($title_arr_val['col']) ? 0 : $title_arr_val['col'];
			
			$this->worksheet->setCellValueByColumnAndRow($col,$this->row,$title_arr_val['caption'])
											->getStyleByColumnAndRow($col,$this->row)
											->applyFromArray($this->$title_arr_val['style']);
				
			if(!empty($title_arr_val['merge']))
			{
				$range=$this->GetMergeCellsRange($title_arr_val['merge']);
				  // echo $range;die();
				$start_col =explode(":",$range);
				$this->worksheet->mergeCells($range);
				$this->worksheet->SetCellValue($start_col[0],$title_arr_val['caption']);
				$this->worksheet->getStyle($range)->applyFromArray($this->$title_arr_val['style']);
			 
				$merge_cells_arr = explode(":",$title_arr_val['merge']);
			}
		}
	}
	//Set Columns Titles
	function SetColumnTitles($col_title_arr)
	{
		$this->SetTitles($col_title_arr);
	}
	
	//GetMergeCellsRange
	function GetMergeCellsRange($merge_arr_data)
	{
		$merge_arr=explode(":",$merge_arr_data);
		$start_merge_arr=$merge_arr[0];
		$end_merge_arr=$merge_arr[1];
		
		$start_arr=explode(",",$start_merge_arr);
		$ens_arr=explode(",",$end_merge_arr);
		
		$start_row=$start_arr[0];
		$start_col=$start_arr[1];
		$end_row=$ens_arr[0];
		$end_col=$ens_arr[1];
		
		$merge = 'A1:A1';
		if($start_row>=0 && $start_col>=0 && $end_row>=0 && $end_col>=0)
		{
		
			// $start_col = PHPExcel_Cell::stringFromColumnIndex($start_col);
			// $end_col = PHPExcel_Cell::stringFromColumnIndex($end_col);
			$merge = $this->GetStringFromIndex($start_row,$start_col,$end_row,$end_col);
		}
		return $merge;
	}
	
	function GetStringFromIndex($start_row,$start_col,$end_row,$end_col)
	{
		
		$start_col = PHPExcel_Cell::stringFromColumnIndex($start_col);
		$end_col = PHPExcel_Cell::stringFromColumnIndex($end_col);
		$cell_range = "$start_col{$start_row}:$end_col{$end_row}";
		return $cell_range;
	}
	
	//Write Excel Header
	function WriteHeadings()
	{
		// $this->col_arr=$harr;
		foreach($this->col_arr as $ck=>$cv)
		{
			foreach($cv as $k=>$v)
			{
					$style = empty($v['style'])?"Heading_Center_Border":$v['style'];
					// $width = empty($v['width'])?"16":$v['width'];
					
				// $col_name = PHPExcel_Cell::stringFromColumnIndex($this->column);
				// $this->worksheet->getColumnDimension($col_name)->setWidth($width);
				$this->worksheet->setCellValueByColumnAndRow($this->column,$this->row,$v['title'])
												->getStyleByColumnAndRow($this->column,$this->row)
												->applyFromArray($this->$style);
				$this->column++;
				
			}
			$this->row++;
			$this->column=$this->_column;
		}
		$this->column=$this->_column;
		// $this->row++;
	}
	
	
	//Write Excel Header
	function SetCoulmnsWidth()
	{
		// $this->col_arr=$harr;
		$arr_keys = array_keys($this->col_arr);
		$this->_total_columns= count($this->col_arr[$arr_keys[0]]);
		
		foreach($this->col_arr as $ck=>$cv)
		{
			foreach($cv as $k=>$v)
			{
					$style = empty($v['style'])?"Heading_Center_Border":$v['style'];
					// $width = empty($v['width'])?"16":$v['width'];
					
				$col_name = PHPExcel_Cell::stringFromColumnIndex($this->column);
				if(empty($v['width']))
					$this->worksheet->getColumnDimension($col_name)->setAutoSize(true);
				else
					$this->worksheet->getColumnDimension($col_name)->setWidth($v['width']);
				// $this->worksheet->setCellValueByColumnAndRow($this->column,$this->row,$v['title'])
												// ->getStyleByColumnAndRow($this->column,$this->row)
												// ->applyFromArray($this->$style);
				$this->column++;
			}
		}
		$this->column=$this->_column;
	}
	
	//write image to excel
	function WriteExcelImages()
	{
		if(!empty($this->image_arr))
		{
			// $gdImage = imagecreatefromjpeg($this->image_arr['src']);
			$objDrawing = new PHPExcel_Worksheet_Drawing();
			// $objDrawing->setName('Sample image');
			// $objDrawing->setDescription('Sample image');
			// $objDrawing->setImageResource($gdImage);
			$objDrawing->setPath($this->aobj_context->main_path.$this->image_arr['src']);
			$objDrawing->setHeight($this->image_arr['height']);
			$objDrawing->setWidth($this->image_arr['width']);
				if(!empty($this->image_arr['offsetX']))
			$objDrawing->setoffsetX($this->image_arr['offsetX']);
			if(!empty($this->image_arr['offsetY']))
			$objDrawing->setoffsetY($this->image_arr['offsetY']);
		
			$objDrawing->setCoordinates($this->image_arr['cell']);
			$objDrawing->setWorksheet($this->objPHPExcel->getActiveSheet());
		}
	}function WriteExcelImagesManually($image_arr)
	{
		if(!empty($image_arr))
		{
			// $gdImage = imagecreatefromjpeg($this->image_arr['src']);
			$objDrawing = new PHPExcel_Worksheet_Drawing();
			// $objDrawing->setName('Sample image');
			// $objDrawing->setDescription('Sample image');
			// $objDrawing->setImageResource($gdImage);
			$objDrawing->setPath($this->aobj_context->main_path.$image_arr['src']);
			$objDrawing->setHeight($image_arr['height']);
			$objDrawing->setWidth($image_arr['width']);
			if(!empty($image_arr['offsetX']))
			$objDrawing->setoffsetX($image_arr['offsetX']);
			if(!empty($image_arr['offsetY']))
			$objDrawing->setoffsetY($image_arr['offsetY']);
			 
			$objDrawing->setCoordinates($image_arr['cell']);
			$objDrawing->setWorksheet($this->objPHPExcel->getActiveSheet());
		}
	}
	function RepeateRows($start_row,$end_row)
	{
		if($start_row>0 && $end_row>0)
		$this->objPHPExcel->getActiveSheet()->getPageSetup()->setRowsToRepeatAtTopByStartAndEnd($start_row, $end_row);
	}
	
	//write sheet
	function WriteExcelSheet()
	{	
        $this->_total_arr = array();
		$this->SetCoulmnsWidth();
		$this->WriteExcelImages();
		if(!empty($this->col_arr) && strtolower($this->repeate_header_columns)=='no')
			$this->WriteHeadings();
		
		if(empty($this->qry))
		{
			$this->WriteSheetFromArray();
		}
		else
		{
			$qry_data = $this->aobj_context->mobj_db->GetAll($this->qry);	
			$this->qry_data_set=$qry_data;
			$this->WriteSheetFromArray();
		}
	}
	
	function WriteSheetFromArray()
	{
		if(!empty($this->qry_data_set))
		{
			
			// $this->row++;
			$total_arr=array();
			$latest_record_arr=array();
			$this->_subtotalsarray=array();
			$this->temp_sub_total_arr=array();
			$this->_title_arr=array();
			
			foreach($this->subtoalfields as $stk=>$stv)
			{
				$latest_record_arr[$stk]=$this->qry_data_set[0][$stk];
			
				if(!empty($stv['title']))
					array_push($this->_title_arr,array('value'=>$this->qry_data_set[0][$stv['title']],'title_style'=>$stv['title_style'],'title_prompt'=>$this->subtoalfields[$stk]['title_prompt']));
			}
			
			$this->_title_arr = array_reverse($this->_title_arr);
			
			$end_column = $this->column + $this->_total_columns-1;
			$start_column = $this->column;
			$j=0;
			foreach($this->_title_arr as $tk=>$tv)
			{
				if($j==0)$this->row++;
				$merge_range=$this->GetStringFromIndex($this->row,$start_column,$this->row,$end_column);
				$this->worksheet->mergeCells($merge_range);
				
				$title_style = empty($tv['title_style'])?"Data_Left_Border":$tv['title_style'];
				$this->worksheet->setCellValueByColumnAndRow($this->column,$this->row,$tv['title_prompt'].$tv['value'])
											->getStyleByColumnAndRow($this->column,$this->row)
											->applyFromArray($this->$title_style);
				
				
				
				$this->worksheet->getStyle($merge_range)->applyFromArray($this->$title_style);
			 
				$this->row++;
				$j++;
			}
			if(!empty($this->_title_arr) && strtolower($this->repeate_header_columns)=='yes')
				$this->WriteHeadings();
			
			$color_cnt = 0;
			foreach($this->qry_data_set as $k=>$v)
			{
				$this->_title_arr=array();
				foreach($this->_subtotalsarray as $sk=>$sv)
				{
					if($latest_record_arr[$sk]!=$v[$sk])
					{
						$latest_record_arr[$sk]=$v[$sk];
						$sub_subtotalsarray = $this->_subtotalsarray;
						 foreach($sub_subtotalsarray as $ssk=>$ssv)
						{
							if(!empty($sub_subtotalsarray[$ssk]))
							{
								
								$this->WriteSubTotals($ssk);
								if(!empty($this->subtoalfields[$ssk]['title']))
								{
									
									array_push($this->_title_arr,array('value'=>$v[$this->subtoalfields[$ssk]['title']],'title_style'=>$this->subtoalfields[$ssk]['title_style'],'title_prompt'=>$this->subtoalfields[$ssk]['title_prompt']));
									
									// echo ($v[$this->subtoalfields[$ssk]['title']]);print_r($this->_title_arr);die();
								}
								$this->_subtotalsarray[$ssk]="";
							}
							if($sk==$ssk)break;
						} 
					}
				}
				
			$this->_title_arr = array_reverse($this->_title_arr);
			$k=0;
			foreach($this->_title_arr as $tk=>$tv)
			{
				if($k==0)$this->row++;
				$merge_range=$this->GetStringFromIndex($this->row,$start_column,$this->row,$end_column);
				$this->worksheet->mergeCells($merge_range);
				
				$title_style = empty($tv['title_style'])?"Data_Left_Border":$tv['title_style'];
				$this->worksheet->setCellValueByColumnAndRow($this->column,$this->row,$tv['title_prompt'].$tv['value'])
											->getStyleByColumnAndRow($this->column,$this->row)
											->applyFromArray($this->$title_style);
				
				
				
				$this->worksheet->getStyle($merge_range)->applyFromArray($this->$title_style);
			 
				$this->row++;
				$k++;
			}
			if(!empty($this->_title_arr) && strtolower($this->repeate_header_columns)=='yes')
				$this->WriteHeadings();	
				
				$this->column=$this->_column;
				$end_col="";
				$start_row= $this->row;
				foreach($this->col_arr as $ck=>$cv)
				{
					$this->WriteColumnValues($cv,$v);
					$this->row++;
					$end_col=$this->column;
					$this->column=$this->_column;
				}
				$end_row=$this->row-1;
				
				if($this->alt_color=='yes')
				{
					$range=$this->GetStringFromIndex($start_row,$this->_column,$end_row,$end_col-1);
					if($color_cnt%2==0)
						$alternate_color="FFFFFF";
					else	
						$alternate_color="EDF7F9";
						$this->worksheet->getStyle($range)->applyFromArray( array(
																		  'fill' => array(
																					  'type' => PHPExcel_Style_Fill::FILL_SOLID,
																					  'color' => array(
																									'rgb'=> $alternate_color
																									)
																						  )
																			  )
																			  ); 
					
					$color_cnt++;
				}
				// $this->row++;
				// $this->row++;
			}
			
			

			foreach($this->_subtotalsarray as $sk=>$sv)
			{
				$this->WriteSubTotals($sk);
				$latest_record_arr[$sk]=$v[$sk];
				$this->_subtotalsarray[$sk]="";
			}
			$this->column=$this->_column;
			if($this->_total_req==1)
			$this->WriteTotal($this->_total_arr);
			else
			$this->WriteBottomLine();
		}
	}
	
	function WriteColumnValues($column_arr,$v)
	{
		
		foreach($column_arr as $ck=>$cv)
		{
			$wrap = empty($cv['wrap'])?true:($cv['wrap']=='true')?true:false;
			
			if(strtolower($cv[total])=='yes')
			{
				
				$this->_total_arr[$cv[field]]+=$v[$cv[field]];
				
				foreach($this->subtoalfields as $sck=>$scv)
				{
					$this->_subtotalsarray[$sck][$cv[field]]+=$v[$cv[field]];
				}
				$this->_total_req=1;
			}
			$feild_style = empty($cv['feild_style'])?"Data_Center_Border":$cv['feild_style'];
			$feild_format =  $cv['format'];
			// $textFormat="dd/mmm/yyyy";
			if($this->apply_style=='yes')
			{
				$this->worksheet->setCellValueByColumnAndRow($this->column,$this->row,$v[$cv[field]])
										->getStyleByColumnAndRow($this->column,$this->row)
										->applyFromArray($this->$feild_style)->getNumberFormat()->setFormatCode($feild_format);
				
				
				$this->worksheet->getStyleByColumnAndRow($this->column,$this->row)
										->getAlignment()->applyFromArray(
																 array(
																	 'wrap'       => $wrap
																 )
																);
			}
			else
			{
				
				$this->worksheet->setCellValueByColumnAndRow($this->column,$this->row,$v[$cv[field]]);
			}
			$this->column++;
		}
	}
	
	function WriteTotal($total_arr)
	{	
		if($this->print_row_total=='yes')
		{
			// print_r($total_arr);die();
			$this->column=$this->_column;
			$this->grand_total_text="Grand Total";
			foreach($this->col_arr as $k=>$v)
			{
				foreach($v as $ck=>$cv)
				{
					$feild_format = $cv['format'];
					if(strtolower($cv[total])=='yes')
					{	
						
						$gd_total = $total_arr[$cv[field]];
						if(empty($gd_total) OR $gd_total == 0.00)
							$gd_total = "";
						
						$this->worksheet->setCellValueByColumnAndRow($this->column,$this->row,$gd_total)
											->getStyleByColumnAndRow($this->column,$this->row)
											->applyFromArray($this->Heading_Right_Border)->getNumberFormat()->setFormatCode($feild_format);
											
					}
					else
					{
						if($gd_total == "")
						  $print_grand_total = "";
                        else
                           $print_grand_total = $this->grand_total_text;							
											
						$this->worksheet->setCellValueByColumnAndRow($this->column,$this->row,$print_grand_total)
											->getStyleByColumnAndRow($this->column,$this->row)
											->applyFromArray($this->Heading_Right_Border);
						$this->grand_total_text="";					
					}
						$this->worksheet->getStyleByColumnAndRow($this->column,$this->row)
											->applyFromArray(
													 array(
															'fill' => array(
																'type' => PHPExcel_Style_Fill::FILL_SOLID,
																'color' => array('rgb' => "BBF0B1")
															)
														 )
											);
											
					$this->column++;
				}
				$this->row++;
				$this->column=$this->_column;
			}
			// $this->row++;
			$this->column=$this->_column;
		}
		else
			$this->WriteBottomLine();
	}
	
	
	function WriteSubTotals($arr_key)
	{	
		if($this->print_row_total=='yes')
		{
			$this->column=$this->_column;
			foreach($this->col_arr as $k=>$v)
			{
				foreach($v as $ck=>$cv)
				{
					$feild_format =  $cv['format'];
					if(strtolower($cv[total])=='yes')
					{	
						$gd_sub_total = $this->_subtotalsarray[$arr_key][$cv[field]];
						if(empty($gd_sub_total) OR $gd_sub_total == 0.00)
						  $gd_sub_total = "";
											
						$this->worksheet->setCellValueByColumnAndRow($this->column,$this->row,$gd_sub_total)
											->getStyleByColumnAndRow($this->column,$this->row)
											->applyFromArray($this->Heading_Right_Border)->getNumberFormat()->setFormatCode($feild_format);
					}
					else
					{
						$total="";
						if($cv[field]==$this->subtoalfields[$arr_key]['caption_field'])
							$total=empty($this->subtoalfields[$arr_key]['caption'])?"Total":$this->subtoalfields[$arr_key]['caption'];
						elseif($cv[field]==$arr_key)
						{
							if(empty($this->subtoalfields[$arr_key]['caption_field']))
								$total=empty($this->subtoalfields[$arr_key]['caption'])?"Total":$this->subtoalfields[$arr_key]['caption'];
						}	
													
						$this->worksheet->setCellValueByColumnAndRow($this->column,$this->row,$total)
											->getStyleByColumnAndRow($this->column,$this->row)
											->applyFromArray($this->Heading_Right_Border);
					}
					
					$this->worksheet->getStyleByColumnAndRow($this->column,$this->row)
											->applyFromArray(
													 array(
															'fill' => array(
																'type' => PHPExcel_Style_Fill::FILL_SOLID,
																'color' => array('rgb' => $this->subtoalfields[$arr_key]['color'])
															)
														 )
											);
					$this->column++;
				}
				$this->row++;
				$this->column=$this->_column;
			}
			// $this->row++;
			$this->column=$this->_column;
		}
		else
			$this->WriteBottomLine();
	}
	
	function WriteBottomLine()
	{
		$this->column=$this->_column;
		$arr_keys = array_keys($this->col_arr);
		
		foreach($this->col_arr[$arr_keys[0]] as $ck=>$cv)
		{
			$this->worksheet->setCellValueByColumnAndRow($this->column,$this->row,"")
								->getStyleByColumnAndRow($this->column,$this->row)
								->applyFromArray($this->Data_Center_Border_Top);
			$this->column++;
		}
		$this->column=$this->_column;
		$this->row++;
		
	}
	
	function SetColumnWidthManual($column,$width=10)
	{
		$col_name = PHPExcel_Cell::stringFromColumnIndex($column);
		$this->worksheet->getColumnDimension($col_name)->setWidth($width);
	}
	function SetColumnWidthManualByRange($start_col,$end_column,$width=10)
	{
		for($column=$start_col;$column<=$end_column;$column++)
		{
			$col_name = PHPExcel_Cell::stringFromColumnIndex($column);
			$this->worksheet->getColumnDimension($col_name)->setWidth($width);
		}
	}
	
	function SetRowHeight($row,$height=15)
	{
		$this->worksheet->getRowDimension($row)->setRowHeight($height);
	}
	
	function cellColor($row,$col,$color)
	{
		$cells = PHPExcel_Cell::stringFromColumnIndex($col).$row;
		
		$this->objPHPExcel->getActiveSheet()->getStyle($cells)->getFill()->applyFromArray(array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'startcolor' => array(
					 'rgb' => $color
				)
		));
	}
	
	function WriteCell($c_row,$c_column,$data,$style,$merge=null,$add_cell_params=null,$feild_format,$sty_req=1)
	{
		$new_style=$this->$style;
		 
		 if(empty($merge))
		{
			if(!empty($add_cell_params))
			{
				$new_style=array_merge($new_style,$add_cell_params);
			 
			} 
			
			$this->worksheet->setCellValueByColumnAndRow($c_column,$c_row,$data);
											//->getStyleByColumnAndRow($c_column,$c_row)
											//->applyFromArray($new_style); //->getNumberFormat()->setFormatCode($feild_format);
											
		    if($sty_req == 1)
			   $this->worksheet->getStyleByColumnAndRow($c_column,$c_row)->applyFromArray($new_style)->getNumberFormat()->setFormatCode($feild_format);									
			 
		 }
		else
			$this->MergeColumnCells($merge,$style,$data,$add_cell_params); 
	}
	
	function WriteCellNew($c_row,$c_column,$data,$style=null,$merge=null)
	{
	 
		 if(empty($merge))
		{
			$this->worksheet->setCellValueByColumnAndRow($c_column,$c_row,$data);
			if(!empty($style))
			{
				$new_style=$this->$style;
				
				 $this->worksheet->getStyleByColumnAndRow($c_column,$c_row)->applyFromArray($new_style);
			}
			 
			 
		 }
		else
			$this->MergeColumnCells($merge,$style,$data); 
	}
	
	function SetPageZoom($zoom=100)
	{
		$this->worksheet->getSheetView()->setZoomScale($zoom);	
	}
	
	function setScale($scale=100)
	{
	$this->objPHPExcel->getActiveSheet()->getPageSetup()->setScale($scale);
		// $this->worksheet->getSheetView()->setZoomScale($zoom);	
	}
	
	function MergeColumnCells($merge,$style,$data=null,$add_cell_params)
	{
		$new_style=$this->$style;
		if(!empty($add_cell_params))
			{
				$new_style=array_merge($new_style,$add_cell_params);
			 
			}
			
		$range=$this->GetMergeCellsRange($merge);
				  
		$start_col =explode(":",$range);
		$this->worksheet->mergeCells($range);
		if(!empty($data))
			$this->worksheet->SetCellValue($start_col[0],$data);
		$this->worksheet->getStyle($range)->applyFromArray($new_style);
	}
	
	function SendOutput()
	{
		 
			if(strtolower($this->report_type)=='html')
			{
				$this->GetHTML();
				
			}
			else if(strtolower($this->report_type)=='csv')
			{
				$this->GetCSV($this->system_module_table_name);
				
			}
			else if(strtolower($this->report_type)=='excel')
			{
				$this->GetExcel($this->system_module_table_name);
				
			}
			 
			
	}
	//Send Excel
	function GetExcel($name="report_result")
	{
		if($name == "asm_dashboard")
				$name = "dashboard_report";
			
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header("Content-Disposition: attachment;filename={$name}.xlsx");
		header('Cache-Control: max-age=0');
		$objWriter = PHPExcel_IOFactory::createWriter($this->objPHPExcel, 'Excel2007');
		$objWriter->save('php://output'); 
		
		//to save file to poerticular path use this
		/*
			$objWriter = PHPExcel_IOFactory::createWriter($this->objPHPExcel, 'Excel2007');
			$objWriter->save("{$name}.xlsx");
		*/
		
		exit;
	}function GetCSV($name="report_result")
	{
		
		header('Content-type: text/csv');
		header("Content-Disposition: attachment;filename={$name}.csv");
		header('Cache-Control: max-age=0');
		$objWriter = PHPExcel_IOFactory::createWriter($this->objPHPExcel, 'CSV');
		$objWriter->save('php://output');
		$objWriter->save('testExportFile.csv');
		exit;
	}
	
	function GetHTML()
	{
		// $objWriter = PHPExcel_IOFactory::createWriter($this->objPHPExcel, 'HTML');
		// $objWriter->save('php://output');
		
		//to save file to poerticular path use this
		$file_name=$this->system_module_table_name."_".$this->user_id.".html";
		$file_path="imported_files/".$file_name;
		$save_path=$this->aobj_context->main_src."/".$file_path;
		unlink($save_path);
		$objWriter = PHPExcel_IOFactory::createWriter($this->objPHPExcel, 'HTML');
		$objWriter->writeAllSheets();
		$module_system_name = "m_".$this->system_module_table_name;
		$objWriter->save($save_path,$module_system_name);
		echo $this->aobj_context->mobj_output->ToJSONEnvelope($file_path,0,"success"); 
	}
	
	function GetPDF()
	{
			$rendererName = PHPExcel_Settings::PDF_RENDERER_DOMPDF;
				$rendererLibrary = 'dompdf';
			  //	echo dirname(__FILE__); die();
				$rendererLibraryPath = $this->aobj_context->main_src.'/PHPExcel_1.8.0/Classes/PHPExcel/Writer/'.$rendererLibrary;

			// echo $rendererLibraryPath;die();


		if (!PHPExcel_Settings::setPdfRenderer(
					$rendererName,
					$rendererLibraryPath
					)
			)
		{
			die(
					'NOTICE: Please set the $rendererName and $rendererLibraryPath values' .
					'<br />' .
					'at the top of this script as appropriate for your directory structure'
				);
		}

		// Redirect output to a clients web browser (PDF)
		header('Content-Type: application/pdf');
		header('Content-Disposition: attachment;filename="01simple.pdf"');
		header('Cache-Control: max-age=0');
		$objWriter = PHPExcel_IOFactory::createWriter($this->objPHPExcel, 'PDF');
		$objWriter->save('php://output');
	}
}
?>