<?PHP
// AUTHOR  : Srikanth M
// MODULE  : Approval Setup
// DATE    : 22-06-2015

ini_set("memory_limit",-1);
ini_set("max_execution_time", 50000);

class approvals
{	
	private $html;
	function __construct($aobj_context)
	{
		$this->aobj_context=$aobj_context;
		$this->main_path=$aobj_context->main_path;
		$this->main_src=$aobj_context->main_src;
		$this->user_id = $_SESSION['user_id'];
		$this->fw_user_dept = $_SESSION['fw_user_dept'];
		
		require_once($this->aobj_context->main_src."/custom_src/approval_setup.php");
		$this->astp = new approval_setup($aobj_context);
	}
	
	function insertNextApproval($module_id,$module_name,$mod_int_code)
	{
		$lobj_get_app_setup = $this->getCurrentAppDetails($module_id,$module_name,$mod_int_code);
		
		$stage_status = 0;
		
		foreach($lobj_get_app_setup as $ak => $av)
		{
			$crt_cond = trim(html_entity_decode($av['criteria']));	
		
			if(empty($crt_cond) OR $crt_cond == '')
			{					 
				$this->astp->module_name = $module_name;
				$this->astp->module_id = $module_id;
				$this->astp->mod_int_code = $mod_int_code;
				$cr_int_code = $this->astp->checkManualCriteria();
			}
			else
			{
				eval("\$crt_cond = \"{$crt_cond}\";");
				$lobj_check_criteria = $this->aobj_context->mobj_db->GetRow($crt_cond);
				$cr_int_code = $lobj_check_criteria['internal_code'];
			}
							
			if($cr_int_code > 0)
			{
				// Get Approved Role / User
				$get_role_user = "SELECT ar.value AS u_type,
										   sd.internal_code AS role_user 
									FROM approval_setup_roles_users_group aru
									INNER JOIN s_sysdb sd ON sd.internal_code = aru.roles_user
									INNER JOIN s_ref_type ar ON ar.internal_code = sd.u_user_type
									WHERE aru.ref_s_ref_data_code = {$av[internal_code]} 
								  ";
				
				$lobj_get_role_user = $this->aobj_context->mobj_db->GetAll($get_role_user);
							 
				// Get Department
				$get_created_dept_inst = "SELECT dept_int_code,inst_int_code
										  FROM approval_history 
										  WHERE mod_id = {$module_id} AND mod_int_code = {$mod_int_code}
										 ";
				$lobj_get_created_dept_inst = $this->aobj_context->mobj_db->GetRow($get_created_dept_inst);		
				$dept_int_code = $lobj_get_created_dept_inst['dept_int_code'];
				$inst_int_code = $lobj_get_created_dept_inst['inst_int_code'];
									
				if(empty($dept_int_code))
				{						   
					$dept_int_code = $this->fw_user_dept;
					
					if(empty($dept_int_code))
					   $dept_int_code = 0;	
				}

				if(empty($inst_int_code))
				{  
					$get_ist_code = "SELECT plant FROM {$module_name} WHERE internal_code = {$mod_int_code} ";
					$lobj_get_ist_code = $this->aobj_context->mobj_db->GetRow($get_ist_code);
					
					$inst_int_code = $lobj_get_ist_code['plant'];
					if(empty($inst_int_code))
					   $inst_int_code = 0;						
				}
									
					
				foreach($lobj_get_role_user as $rk => $rv) 
				{
					$role= 0;
					$user= 0;
					if($rv['u_type'] == 'Group')
						$role = $rv['role_user'];
					else
						$user = $rv['role_user']; 
				 
					// Insert Next Stage Approval	
					$insert_next_app = "INSERT INTO approval_history
									  (internal_code,mod_id,mod_int_code,app_setup_int_code,stage,status,role_int_code,user_int_code,dept_int_code,inst_int_code,approved_by,approved_date,remarks,
									   created_by,created_date,modified_by,modified_date 
									  )
									  VALUES
									  (0,{$module_id},{$mod_int_code},{$av[internal_code]},{$av[stage]},'',{$role},{$user},{$dept_int_code},{$inst_int_code},0,'0000-00-00','',
									   {$this->user_id},now(),{$this->user_id},now()
									  )
									 ";
					$lobj_insert_next_app = $this->aobj_context->mobj_db->Execute($insert_next_app);	
				}
				$stage_status = 1;					   
			}
			// die();
		}		 
		if($stage_status == 0)
		{	 
			$this->updateFinalApprovalStage($module_id,$module_name,$mod_int_code);
		}
	}
	
	function getCurrentAppDetails($module_id,$module_name,$mod_int_code)
	{
		$get_status = "SELECT status 
		               FROM {$module_name}
		               WHERE internal_code = {$mod_int_code}
					  ";
			
		$lobj_get_status = $this->aobj_context->mobj_db->GetRow($get_status);
					
		// Get Approval Setup
		
		$get_app_setup = "SELECT criteria,aps.internal_code,aps.stage,approve_stage,raject_stage 	  
		                  FROM approval_setup ap
						  INNER JOIN approval_setup_stages_group aps ON aps.ref_s_ref_data_code = ap.internal_code
						  WHERE aps.stage = {$lobj_get_status['status']} AND ap.module = {$module_id}
						 ";
		$lobj_get_app_setup = $this->aobj_context->mobj_db->GetAll($get_app_setup);
		return  $lobj_get_app_setup;
	}	
	
	function getAppStageDetails($module_id,$module_name,$mod_int_code,$app_setup_int_code)
	{
		// Get Approval Setup
		$get_app_setup = "SELECT criteria,aps.internal_code,aps.stage,approve_stage,raject_stage 	  
		                  FROM approval_setup ap
						  INNER JOIN approval_setup_stages_group aps ON aps.ref_s_ref_data_code = ap.internal_code
						  WHERE aps.internal_code = {$app_setup_int_code} 
						 ";
     	$lobj_get_app_setup = $this->aobj_context->mobj_db->GetRow($get_app_setup);
		return  $lobj_get_app_setup;
	}
	
	function ApproveRejectHistoryTable()
	{
		$module_id=$this->aobj_context->mobj_data["module_id"];
		$module_name=$this->aobj_context->mobj_data["module_name"];
		$app_status=$this->aobj_context->mobj_data["status"];
		$app_remarks=addslashes($this->aobj_context->mobj_data["remarks"]);
		$app_history_int_codes=$this->aobj_context->mobj_data["app_history_int_codes"];
				
		$his_int_codes = explode(',',$app_history_int_codes);
		
		// Check Approval Conditions
		$get_mod_int_code = "SELECT DISTINCT mod_int_code FROM approval_history WHERE internal_code in ({$app_history_int_codes})";
		$lobj_get_mod_int_code = $this->aobj_context->mobj_db->GetRow($get_mod_int_code);
		$mod_int_code = $lobj_get_mod_int_code['mod_int_code'];
		
		$this->astp->module_name = $module_name;
		$this->astp->mod_int_code = $mod_int_code;
		$this->astp->app_status = $app_status;
		$update_status = $this->astp->updateApprovalData();
		
		if($update_status != '')
		{
			 echo $this->aobj_context->mobj_output->ToJSONEnvelope($update_status,-1,"Success"); 
			 return;
		}
		else
		{
			foreach($his_int_codes as $hk => $hv)
			{
				$app_hi_int_code = $hv;
							
				$get_mod_int_code = "SELECT stage,mod_int_code,app_setup_int_code FROM approval_history
									 WHERE internal_code = {$app_hi_int_code}
									";
					
				$lobj_get_mod_int_code = $this->aobj_context->mobj_db->GetRow($get_mod_int_code);

				$mod_int_code = $lobj_get_mod_int_code[mod_int_code];			
				$app_setup_int_code = $lobj_get_mod_int_code[app_setup_int_code];			
				$stage = $lobj_get_mod_int_code[stage];			
				
				$lobj_get_app_setup = $this->getAppStageDetails($module_id,$module_name,$mod_int_code,$app_setup_int_code);
			
				if($app_status == 'Approved')
				  $current_status = $lobj_get_app_setup['approve_stage'];		 
				else
				  $current_status = $lobj_get_app_setup['raject_stage'];

				// Update Module status 
				require_once($this->aobj_context->main_src."/custom_src/approval_setup.php");
				$f_obj=new approval_setup($this->aobj_context);	
				$f_obj->module_name=$module_name;
				$f_obj->UpdateApprovalRemarksData();														   
				
				$update_mod_status = "UPDATE {$module_name}
										   SET status = {$current_status}
										   WHERE internal_code = {$mod_int_code}
										 ";
				// echo $update_mod_status;die();  
				
				$lobj_update_mod_status = $this->aobj_context->mobj_db->Execute($update_mod_status);	
				
				// Update Approval History status  
				$update_currenct_status = "UPDATE approval_history
										   SET status = '{$app_status}',
											   approved_by = {$this->user_id},
											   approved_date = now(),
											   remarks = '{$app_remarks}'
										   WHERE mod_id = {$module_id} AND mod_int_code = {$mod_int_code} AND stage = {$stage}
										 ";
				$lobj_update_currenct_status = $this->aobj_context->mobj_db->Execute($update_currenct_status);	
				
				if($app_status == 'Approved')
				{
				   $this->insertNextApproval($module_id,$module_name,$mod_int_code);
				}  
			}
			$message = "Successfully Updated";
			echo $this->aobj_context->mobj_output->ToJSONEnvelope($message,0,"Success"); 
		}
	}
	
	function updateFinalApprovalStage($module_id,$module_name,$mod_int_code)
    {
		// Get Final approval 
		$gte_final_stage = "SELECT internal_code FROM approval_stages 
							WHERE  stage = 'Approved' AND module = {$module_id}
						   ";
		$lobj_gte_final_stage = $this->aobj_context->mobj_db->GetRow($gte_final_stage);	
		
		// Update Module status 
		$update_mod_status = "UPDATE {$module_name}
								   SET status = {$lobj_gte_final_stage['internal_code']}
								   WHERE internal_code = {$mod_int_code}
								 ";
		$lobj_update_mod_status = $this->aobj_context->mobj_db->Execute($update_mod_status);	
	}

	function insertFirstStageApproval($module_id,$module_name,$mod_int_code,$first_int_code)
    {
		if($first_int_code == 0)
		{
			$this->insertFirstStage($module_id,$module_name,$mod_int_code);			
		}
		else
		{
			// Get Last Stage from histroy
			$get_last_stage = "SELECT status
							   FROM approval_history
							   WHERE mod_id = {$module_id} AND mod_int_code = {$mod_int_code}
							   ORDER BY internal_code DESC limit 1
							  ";
			$lobj_get_last_stage = $this->aobj_context->mobj_db->GetRow($get_last_stage);
			
			if($lobj_get_last_stage['status'] == 'Rejected')
			{
				$this->insertFirstStage($module_id,$module_name,$mod_int_code);				 
			}
		}			
	}
	
	function insertFirstStage($module_id,$module_name,$mod_int_code)
	{
		$get_new_stage = "SELECT internal_code
		                   FROM approval_stages
		                   WHERE module = {$module_id}
						   ORDER BY sequence limit 1";
		// echo $get_new_stage; die();
		$lobj_get_new_stage = $this->aobj_context->mobj_db->GetRow($get_new_stage);	
		 
		if($lobj_get_new_stage['internal_code'] > 0)
		{		 
		    // Update Module status 
			$update_mod_status = "UPDATE {$module_name}
									   SET status = {$lobj_get_new_stage['internal_code']}
									   WHERE internal_code = {$mod_int_code}";
			$lobj_update_mod_status = $this->aobj_context->mobj_db->Execute($update_mod_status);
 
            $this->insertNextApproval($module_id,$module_name,$mod_int_code);			
		}		
	}
}

function ApproveRejectHistoryTable($aobj_context)
{
    $class_obj=new approvals($aobj_context);
	$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC); 
	$class_obj->ApproveRejectHistoryTable();
}
?>