<?php
class ReValidateOnceAgin
{
    # The important functions in the ORB are defined static, and hence
    # at the module level, the ORB can be accessed and functions executed
    
     static $revalidate_po_arr = array();
	 static function AddPosCodes($po_int_code)
    {
      if(!in_array($po_int_code, self::$revalidate_po_arr))
      array_push(self::$revalidate_po_arr,$po_int_code);     
    }
}	
class validate_po
{
public $po_int_code;
	public $internal_code;
	public $validate_type;
	
		function __construct($aobj_context)
		{
			//session_start();
			$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
			$this->aobj_context=$aobj_context;
			$this->user_id = $_SESSION['user_id'];	
			$this->user_id=empty($this->user_id)?0:$this->user_id;			
			 require_once($aobj_context->main_src."/src/send_mail.php");	
			$this->classname="validate_po";	
			$this->GetStatusIntCodes();
			$this->item_rates_arr=array();
			 
			$this->GetIsAutoXlite();
		}
		function GetIsAutoXlite()
		{
			 
			$this->auto_xlite_switch="No";
		}
		function ValidatePO()
		{
			$this->replay_msg="";
			$this->UpatePOModifiedDate();
			$this->GetPoHeaderDetails();
			if($this->CheckReadError()==0)
			{
				$this->GetPoItemDetails();
				$this->GetParserSetupParamaters();	
				$this->UpdatePoStatus();
				
				 
			}
		}
		function UpatePOModifiedDate()
		{
			$update_modified_date=" update purchase_order 
									SET modified_date=now(),modified_by={$this->user_id}
									where internal_code={$this->po_int_code}";
				$lobj_update_modified_date= $this->aobj_context->mobj_db->Execute($update_modified_date);
				// echo $update_modified_date;
		}
		function CheckReadError()
		{
			$get_cnt="select count(1) as error_cnt from parser_error_logs
							where customer='{$this->customer}'
							and po_number='{$this->po_number}'
							and error_type='Read Error'";
			$lobj_get_cnt= $this->aobj_context->mobj_db->GetRow($get_cnt);
		 
			 
			$error_cnt=$lobj_get_cnt['error_cnt'];
			$error_cnt=empty($error_cnt)?0:$error_cnt;
			if($error_cnt==0)
			{
				return $error_cnt;
			}
			else
			{
				$read_error_int_code=$this->status_details["Read Error"];
				$update_status_code=" update purchase_order 
									SET status={$read_error_int_code}
									where internal_code={$this->po_int_code}";
				$lobj_update_status_code= $this->aobj_context->mobj_db->Execute($update_status_code);
				return $error_cnt;
			}
							
		}
		function DeleteAllValidateParameters()
		{
			$delete_from_header="delete from purchase_order_validations_group
								where ref_s_ref_data_code={$this->po_int_code}";
			$lobj_delete_from_header= $this->aobj_context->mobj_db->Execute($delete_from_header);
			$get_po_items_int_code="
									SELECT GROUP_CONCAT(internal_code) as item_int_codes
									FROM 
									purchase_order_item_group where ref_s_ref_data_code ={$this->po_int_code} 
									";	
			$lobj_get_po_items_int_code= $this->aobj_context->mobj_db->GetRow($get_po_items_int_code);	
// echo $get_po_items_int_code;die();			
			$po_item_int_codes=$lobj_get_po_items_int_code[item_int_codes];
			$delete_from_grp="delete from purchase_order_item_errors_group
								where ref_s_ref_data_code in({$po_item_int_codes})";
			$lobj_delete_from_grp= $this->aobj_context->mobj_db->Execute($delete_from_grp);
			 
			 
		}
		 
		function GetPoHeaderDetails()
		{
			$get_details="select
							cm.auto_ignore_artcle as auto_ignore_artcle,
							cm.tcs_applicable as tcs_applicable,
							po.customer as customer,
							po.po_number ,
							po.date  AS processing_date ,
							po.po_date  AS po_date ,
							po.ship_date AS ship_date ,
							cm.remarks as customer_keyword,
							po.bill_to,
							po.ship_to,
							po.po_vat_no,
							po.po_cst_no,
							po.po_site_code,
							po.order_type,
							po.bill_to_address,
							po.po_vendor_code,	
							po.ship_to_address,	
							po.error_po_path,	
							po.contact_person,	
							po.order_value,	
							po.ship_point,po.delivery_date,DATEDIFF(po.date,po.delivery_date) as transit_date_diff 						 
							from
							purchase_order po
							inner join customer_master cm on cm.internal_code=po.customer	
						 
							where po.internal_code='{$this->po_int_code}'
						 ";			 
				$lobj_get_details= $this->aobj_context->mobj_db->GetRow($get_details);	
			 
				$this->customer=$lobj_get_details['customer'];
				$this->auto_ignore_artcle=$lobj_get_details['auto_ignore_artcle'];
				$this->tcs_applicable=$lobj_get_details['tcs_applicable'];
				$this->customer_keyword=$lobj_get_details['customer_keyword'];
				
				$this->order_type=$lobj_get_details['order_type'];
				$this->po_number=$lobj_get_details['po_number'];
				$this->po_date=$lobj_get_details['po_date'];   
                               	$this->processing_date=$lobj_get_details['processing_date'];    
				$this->ship_date=$lobj_get_details['ship_date'];
				$this->po_vat_no=$lobj_get_details['po_vat_no'];
				$this->po_cst_no=$lobj_get_details['po_cst_no'];
				$this->po_vendor_code=$lobj_get_details['po_vendor_code'];
				$this->bill_to_int_code=($lobj_get_details['bill_to']);
				$this->po_site_code=($lobj_get_details['po_site_code']);
				$this->error_po_path=($lobj_get_details['error_po_path']);
				$this->contact_person=($lobj_get_details['contact_person']);
				$this->order_value=($lobj_get_details['order_value']);
				
				$this->ship_to= ($lobj_get_details['ship_to']);
				$this->delivery_date= ($lobj_get_details['delivery_date']);
				$this->transit_date_diff= ($lobj_get_details['transit_date_diff']);
				$this->bill_to_address=strtolower($lobj_get_details['bill_to_address']);
				$this->ship_point=strtolower($lobj_get_details['ship_point']);
				$this->ship_to_address=strtolower($lobj_get_details['ship_to_address']);					 
				$this->v_params=$lobj_get_details['v_params'];
				$this->po_head_success_validations=array();
			 
				
				$get_status_data="select pov.parameter_name,pov.validation_status
						 from purchase_order_validations_group pov
						WHERE ref_s_ref_data_code='{$this->po_int_code}'";
					$lobj_get_status_data= $this->aobj_context->mobj_db->GetAll($get_status_data);	
 			// echo $get_status_data;die();
				foreach($lobj_get_status_data as $vk=>$vv)	
				{	
					if($vv['validation_status']=="Success")
					array_push($this->po_head_success_validations,$vv['parameter_name']);
					
				}
				 
		} 
		function GetPoItemDetails()
		{
			$get_item_details="select poi.internal_code,po_item_sku_code,
							po_original_qty,qty,rate,poi.uom,
							value,po_item_mrp,poi.item,
							po_item_barcode,po_tax_rate ,poi.carton_ean,poi.pack_qty
							from
							purchase_order po
							inner join purchase_order_item_group poi
							on poi.ref_s_ref_data_code=po.internal_code
						 
							where po.internal_code={$this->po_int_code}
						 ";
		 	  // echo $get_item_details;die();
			$lobj_get_item_details= $this->aobj_context->mobj_db->GetAll($get_item_details);
			$this->po_items_arr=array();
			$this->po_item_success_validations=array();
			foreach($lobj_get_item_details as $ik=>$iv)
			{
				$item_grp_int_code=$iv['internal_code'];
				$this->po_item_success_validations[$item_grp_int_code]=array();
				$this->po_items_arr[$iv['internal_code']]['item_int_code']=$iv['item'];
				$this->po_items_arr[$iv['internal_code']]['po_item_sku_code']=$iv['po_item_sku_code'];
				$this->po_items_arr[$iv['internal_code']]['po_original_qty']=$iv['po_original_qty'];
				$this->po_items_arr[$iv['internal_code']]['qty']=$iv['qty'];
				$this->po_items_arr[$iv['internal_code']]['rate']=$iv['rate'];
				$this->po_items_arr[$iv['internal_code']]['po_tax_rate']=$iv['po_tax_rate'];
				$this->po_items_arr[$iv['internal_code']]['po_item_mrp']=$iv['po_item_mrp'];
				$this->po_items_arr[$iv['internal_code']]['uom']=$iv['uom'];
				 
				$this->po_items_arr[$iv['internal_code']]['po_item_barcode']=$iv['po_item_barcode'];
				$this->po_items_arr[$iv['internal_code']]['carton_ean']=$iv['carton_ean'];
				$this->po_items_arr[$iv['internal_code']]['pack_qty']=$iv['pack_qty'];
				
				$get_status_data="select pov.item_parameter_name,pov.item_validation_status
						 from purchase_order_item_errors_group pov
						WHERE ref_s_ref_data_code='{$item_grp_int_code}'";
					$lobj_get_status_data= $this->aobj_context->mobj_db->GetAll($get_status_data);	
 			
				foreach($lobj_get_status_data as $vk=>$vv)	
				{	
					if($vv['item_validation_status']=="Success")
					array_push($this->po_item_success_validations[$item_grp_int_code],$vv['item_parameter_name']);
					
				}
				
			}
			 
			 		
		}
		function GetParserSetupParamaters()
		{
		 
			$get_validate_data="select  
						ifnull(default_action,'Failed') as default_action,
						vp.po_type,lp.customer,customer_keyword,name,po_type,
						vp.internal_code ref_validation_code,error_code,error_description,
						vp.function_name,vp.status from 
						leap_parser_setup lp 
						inner join leap_parser_setup_validations_group lg 
						on lp.internal_code=lg.ref_s_ref_data_code
						inner join validation_parameters vp on vp.internal_code=lg.function_name
						where vp.status='Active'
						and lg.validation_status='Active'
						and lp.customer={$this->customer}
						order by vp.vp_sequence ";
			$lobj_get_validate_data= $this->aobj_context->mobj_db->GetAll($get_validate_data);
		 // echo $get_validate_data;
			foreach($lobj_get_validate_data as $ak=>$av)
			{
				$function_name=$av['function_name'];	
				$po_type=$av['po_type'];	
				$this->error_code=$av['error_code'];	
				$this->default_action=$av['default_action'];	
				$this->error_description=$av['error_description'];	
				$this->ref_validation_code=$av['ref_validation_code'];	
				//echo $function_name.'---';
				if(!in_array($this->ref_validation_code,$this->po_head_success_validations))
				call_user_func(array($this->classname, $function_name));			 
			}	
		}
#START1##########################ValidatePOBtlWithBtlMaster##################################################				
		function ValidatePOBtlWithBtlMaster()
		{
			$extra_cond="";
			if($this->customer==45 || $this->customer==46|| $this->customer==44)
			$extra_cond=" and vendor_code='{$this->po_vendor_code}' ";
			
			$get_btl_details="SELECT btl.internal_code,btl.btl_tcs_applicable,
						customer_reference,customer_code,
						IFNULL(status,'Active') AS status,
						IFNULL(allow_decimal_qty_to_erp,'No') AS allow_decimal_qty_to_erp,
						customer_name, IFNULL(btl_po_code,'')  AS btl_po_code,
						s.code AS po_ship_to_state_code,
						ws.code AS po_ship_from_state_code ,btl.delivery_location_code
						FROM 
						bill_to_customer_master btl 
						INNER JOIN state s ON s.internal_code=btl.ship_to_state
						INNER JOIN location_wise_warehouse w ON w.internal_code=btl.ship_from_warehouse
						INNER JOIN state ws ON ws.internal_code=w.state
						WHERE customer_reference='{$this->customer}'
							{$extra_cond} and IFNULL(btl_po_code,'')!=''
						 ";
			$lobj_get_btl_details= $this->aobj_context->mobj_db->GetAll($get_btl_details);
			// echo $get_btl_details;die();
 
 			 $this->bill_to_int_code=0;
			$this->allow_decimal_qty_to_erp="No";
			$this->btl_tcs_applicable="No";
			$this->po_ship_to_state_code="";
			$this->po_ship_from_state_code="";
			$this->delivery_location_code="";
					$this->po_btl_minimum_order_val="0";
			$btl_code_found=0;
			if(count($lobj_get_btl_details)>0)
			{
				foreach($lobj_get_btl_details as $btlk=>$btlv)
				{
					$this->po_btl_int_code=$btlv['internal_code'];
				
					
					
					$customer_code=$btlv['customer_code'];
					 
					$btl_po_code=strtolower($btlv['btl_po_code']);
					$btl_po_code=trim($btl_po_code);
					/* $last_comma=substr($btl_po_code,-1);
					if($last_comma==",")
						$btl_po_code=substr($btl_po_code,0,strlen($btl_po_code)-1); 
					if($this->customer!=46)
					{
						 $replace_arr=array(",","(",")"," " );
						$this->bill_to_address=str_ireplace($replace_arr,"",$this->bill_to_address);
						$btl_po_code=str_ireplace($replace_arr,"",$btl_po_code);
					}*/
					$status=strtolower($btlv[status]);
					 
					if(!empty($btl_po_code) && $btl_code_found==0)
					{
						  // echo $btl_po_code.'---'.$this->bill_to_address."</br>";
								 
								 if (preg_match("/{$btl_po_code}/",$this->bill_to_address))
								{
									$btl_code_found=1;
									//-- echo $split_btl_po_code.'---'.$this->bill_to_address."<br>";
									$this->bill_to_int_code=$this->po_btl_int_code;
								 
									 	$this->allow_decimal_qty_to_erp=$btlv['allow_decimal_qty_to_erp'];
									 	$this->btl_tcs_applicable=$btlv['btl_tcs_applicable'];
									 	$this->po_ship_to_state_code=$btlv['po_ship_to_state_code'];
									 	$this->po_ship_from_state_code=$btlv['po_ship_from_state_code'];
									 	$this->delivery_location_code=$btlv['delivery_location_code'];
							 
									  $this->UpdatePoHeaderTable('bill_to',$this->po_btl_int_code);	
									
									break;
								}
					}
					 
					  
				}				
				 
				 
			}
			if($btl_code_found==0)
			{
				$this->UpdatePoHeaderTable('bill_to',0);	
				$description=$this->error_code."-".$this->error_description;
				$this->insertIntoPoHeaderValidations($this->default_action,$description);	
			}	
			// echo $this->bill_to_int_code;die();
		}
		 
#END1##########################ValidatePOBtlWithBtlMaster##################################################		
 
#START2##########################ValidatePOStlWithStlMaster##################################################		
		function ValidatePOStlWithStlMaster()
		{ 
			$get_stl_details="SELECT stl.internal_code,stl.stl_code,
							stl.stl_po_code1,stl_po_code2,stl_po_code3,
							ifnull(stl.status,'Active') as status
								FROM 
								purchase_order
								po  
								INNER JOIN ship_to_customer_master
								stl ON stl.bill_to_customer=po.bill_to 
								where po.internal_code={$this->po_int_code}
								 
								 ";
			$lobj_get_stl_details= $this->aobj_context->mobj_db->GetAll($get_stl_details);	
		 // echo $get_stl_details;die();
			$stl_code_found=false;
			foreach($lobj_get_stl_details as $btlk=>$btlv)
			{
				$this->po_stl_int_code=$btlv['internal_code'];
				$stl_po_code1=strtolower($btlv['stl_po_code1']);
				$stl_po_code2=strtolower($btlv['stl_po_code2']);
				$stl_po_code3=strtolower($btlv['stl_po_code3']);
				$stl_code=strtolower($btlv['stl_code']);
				$status=strtolower($btlv['status']);
				  
			 	if(!empty($stl_po_code1))
				{
					$pos1 = strpos($this->ship_to_address, $stl_po_code1);
					if($pos1===false){}
					else
					{
					 
					 	$stl_code_found=true;
						if($status!='active')
						{
						$description=$this->error_code."-"."STL Code({$stl_code}) is Inactive.{$stl_po_code1}";
						$this->insertIntoPoHeaderValidations($this->default_action,$description);
				
						}
						else
						$this->UpdatePoHeaderTable('ship_to',$this->po_stl_int_code);						
						break;
					}
				}
				/* if(!empty($stl_po_code2))
				{
					$pos2 = strpos($this->ship_to_address, $stl_po_code2);
					if($pos2===false){}
					else
					{	
						$stl_code_found=true;
						$this->UpdatePoHeaderTable('ship_to',$this->po_stl_int_code);			
						break;
					}
				}
				if(!empty($stl_po_code3))
				{
					$pos3 = strpos($this->ship_to_address, $stl_po_code3);
					if($pos3===false){}
					else
					{	
						$stl_code_found=true;
						$this->UpdatePoHeaderTable('ship_to',$this->po_stl_int_code);
						break;
					}
				}	 */			
			}
			if(!$stl_code_found)
			{
				$description=$this->error_code."-".$this->error_description;
				$this->insertIntoPoHeaderValidations($this->default_action,$description);
				
				 
			}	
		}
	 
#START4##########################ValidatePoTransitTime##################################################
		function ValidatePoTransitTime()
		{
			  
			if($this->transit_date_diff<7)
			$this->insertIntoPoHeaderValidations("Success","Validated Trasnsit Time");	
			else
			{
			 $description=$this->error_code."-".$this->error_description."Delivery Date:{$this->delivery_date} ";
			 $this->insertIntoPoHeaderValidations($this->default_action,$description);
			//$this->insertIntoPoHeaderValidations("Failed","Trasit Date:{$leap_transittime_txt} & Delivery Date:{$delivery_date_txt} ");	
			}		
				 
		}
#END4##########################ValidatePoTransitTime##################################################		
	 
#START4##########################ValidatePOMinimumOrderValue##################################################
		function ValidatePOMinimumOrderValue()
		{
			
			if($this->order_value<$this->po_btl_minimum_order_val)
			{
				 $description=$this->error_code."-".$this->error_description." Min Order Val:<b>{$this->po_btl_minimum_order_val}</b> :: PO Order Val:<b>{$this->order_value}</b>";
				$this->insertIntoPoHeaderValidations($this->default_action,$description);
			}
			
			else
			{
				$this->insertIntoPoHeaderValidations("Success","Validated Trasnsit Time");	
			 	
			}		
				 
		}
#END4##########################ValidatePoTransitTime##################################################		

#START4##########################ValidatePOItemMasterCode##################################################
		function GetArticalMasterDetails()
		{
			$this->artical_master_int_code_arr=array();
			$this->artical_master_int_code_status_arr=array();
			$this->artical_master_ca_code_arr=array();
			$get_item_int_code=" SELECT 
									am.internal_code,am.customer_article_code, ean as barcode,am.status
									,stock_code AS tm_stock_code  	,pack_qty, am.category as am_category_int_code,c.category_name
									FROM article_master am
									left join  category c on c.internal_code=am.category 
									WHERE customer='{$this->customer}'
							 
								AND IfNULL(am.status,'Active')!='InActive' ";
			$lobj_get_item_int_code= $this->aobj_context->mobj_db->GetAll($get_item_int_code);
		     // echo $get_item_int_code;die();
			if(count($lobj_get_item_int_code)>0)
			{
				foreach($lobj_get_item_int_code as $ik=>$iv)
				{
					$this->artical_master_int_code_arr[$iv['internal_code']]['customer_article_code']=$iv['customer_article_code'];
			 
					$this->artical_master_int_code_arr[$iv['internal_code']]['barcode']=$iv['barcode'];
					$this->artical_master_int_code_arr[$iv['internal_code']]['tm_stock_code']=$iv['tm_stock_code'];				 
					$this->artical_master_int_code_arr[$iv['internal_code']]['uom']=$iv['uom'];
					$this->artical_master_int_code_arr[$iv['internal_code']]['pack_qty']=$iv['pack_qty'];
					$this->artical_master_int_code_arr[$iv['internal_code']]['am_category_int_code']=$iv['am_category_int_code'];
					$this->artical_master_int_code_arr[$iv['internal_code']]['category_name']=$iv['category_name'];
				   
					$uom=$iv['uom'];
					$customer_article_code=$iv['customer_article_code'];
					$customer_article_code_uom=strtolower($customer_article_code.$uom);
					$this->artical_master_ca_code_arr[$iv['customer_article_code']]=$iv['internal_code'];
					$this->artical_master_ca_code_arr[$customer_article_code_uom]=$iv['internal_code'];
					 
					 
				}
			} 
			  
		}
		function GetTaxCodeMasterDetails()
		{
			$this->tax_master_code_arr=array();
			$get_data="SELECT location_code,item_group_name,
						tax_code_within_state,tax_code_out_of_state ,
						tcs_tax_code_within_state,tcs_tax_code_out_of_state 
							FROM tax_code_determination
							WHERE location_code='{$this->delivery_location_code}'";
			$lobj_get_data= $this->aobj_context->mobj_db->GetAll($get_data);
// echo $get_data;die();			
			foreach($lobj_get_data as $ak=>$av)
			{
				$this->tax_master_code_arr[$av['item_group_name']]['tax_code_within_state']=$av['tax_code_within_state'];
				$this->tax_master_code_arr[$av['item_group_name']]['tax_code_out_of_state']=$av['tax_code_out_of_state'];
				$this->tax_master_code_arr[$av['item_group_name']]['tcs_tax_code_within_state']=$av['tcs_tax_code_within_state'];
				$this->tax_master_code_arr[$av['item_group_name']]['tcs_tax_code_out_of_state']=$av['tcs_tax_code_out_of_state'];
			}	
 
		}
		function GetPriceDetails()
		{ 
			// if(empty($this->po_items_arr))
			{
				$get_item_rates="SELECT  am.internal_code AS item_int_code,
									pm.internal_code AS price_int_code 
									,pm.basic_price, IFNULL(pm.mrp,0) AS mrp, tax_perc
									 
									FROM article_master am
									INNER JOIN price_master pm ON am.customer=pm.customer
									AND am.stock_code=pm.stock_code
									where am.customer={$this->customer}
									 
									and am.status='Active'
									  ";
					$lobj_get_item_int_code= $this->aobj_context->mobj_db->GetAll($get_item_rates);
				 // echo $get_item_rates;die();
				if(count($lobj_get_item_int_code)>0)
				{
					 foreach($lobj_get_item_int_code as $ik=>$iv)
					 {
						$mrp=$iv['mrp'];
						$basic_price=$iv['basic_price'];
						$price_int_code=$iv['price_int_code'];
						if(count($this->item_rates_arr[$iv['item_int_code']])==0)
						{
						 $this->item_rates_arr[$iv['item_int_code']]['price_int_code']=$iv['price_int_code'];
						 $this->item_rates_arr[$iv['item_int_code']]['mrp']=$iv['mrp'];
						 $this->item_rates_arr[$iv['item_int_code']]['tax_perc']=$iv['tax_perc'];
						 $this->item_rates_arr[$iv['item_int_code']]['basic_price']=$iv['basic_price'];
					
						}
					}
				}
				 
			}	
 	
			 
		}
		
		function ValidatePOItemMasterCode()
		{
		 
			$this->GetPriceDetails();
			$this->GetArticalMasterDetails();
			$this->GetTaxCodeMasterDetails();
		 
			 foreach($this->po_items_arr as $igk=>$igv)
			 {
				$this->po_item_grp_int_code=$igk;
			
				$uom=strtolower($igv['uom']);
				$po_item_sku_code=$igv['po_item_sku_code'];
				$po_item_sku_code_uom=$po_item_sku_code.$uom;
				
				if(array_key_exists($po_item_sku_code_uom,$this->artical_master_ca_code_arr))
				{
					
						$this->item_int_code=$this->artical_master_ca_code_arr[$po_item_sku_code_uom];
						
						 
						 
						$this->updateItemDetailsForPoItem("item",$this->item_int_code);
						$sap_fg_code=$this->artical_master_int_code_arr[$this->item_int_code]['tm_stock_code'];
						$this->updateItemDetailsForPoItem("sap_fg_code",$sap_fg_code);
						
						$this->po_items_arr[$this->po_item_grp_int_code][item_int_code]=$this->item_int_code;
						$this->po_items_arr[$this->po_item_grp_int_code][tm_stock_code]=$this->artical_master_int_code_arr[$this->item_int_code]['tm_stock_code'];
					 
					
					 
				}
				else if(array_key_exists($po_item_sku_code,$this->artical_master_ca_code_arr))
				{
					if($this->artical_master_ca_code_arr[$po_item_sku_code]>0)
					{
						$this->item_int_code=$this->artical_master_ca_code_arr[$po_item_sku_code];
						
						$sap_fg_code=$this->artical_master_int_code_arr[$this->item_int_code]['tm_stock_code'];
						$this->updateItemDetailsForPoItem("sap_fg_code",$sap_fg_code);
						
						$this->updateItemDetailsForPoItem("item",$this->item_int_code);
						$this->po_items_arr[$this->po_item_grp_int_code][item_int_code]=$this->item_int_code;
						$this->po_items_arr[$this->po_item_grp_int_code][tm_stock_code]=$this->artical_master_int_code_arr[$this->item_int_code]['tm_stock_code'];
					 
						 
					}
					else
					{ 
					$description=$this->error_code."-".$this->error_description;
				 
					$this->insertIntoPoItemValidations($this->default_action,$description);
					$this->UpdateItemsAsIgnoredMannualy($this->po_item_grp_int_code);
					}	
				}
				else
					
				{  
				$description=$this->error_code."-".$this->error_description;
				$this->insertIntoPoItemValidations($this->default_action,$description);
				$this->UpdateItemsAsIgnoredMannualy($this->po_item_grp_int_code);
				
				}	
				
			 }
		}
		function UpdateItemsAsIgnoredMannualy($item_int_code)
		{
		 
			if($this->bill_to_int_code>0 && $this->auto_ignore_artcle=='Yes')
			{
			$update_item="update purchase_order_item_group
						set ignore_for_xlite='Yes',
						 ignore_for_xlite_reason='13',
						 ignore_for_xlite_remarks='Auto Ignore from System as its Other Company Product'
						where internal_code={$item_int_code}";
			$lobj_update_item= $this->aobj_context->mobj_db->Execute($update_item);
			//echo $update_item."</br>";
			if($lobj_update_item)
			{
				$update_child_item_status="update purchase_order_item_errors_group
											set item_validation_status='Ignore'
											where item_validation_status in('Failed','Warning')
											and ref_s_ref_data_code={$item_int_code}";
				$lobj_update_child_item_status= $this->aobj_context->mobj_db->Execute($update_child_item_status);
// echo $update_child_item_status;				
				
			}
			}
			// echo $update_item;
		}
		function UpdateItemsAsIgnoredMannualyForCaseQty($item_int_code)
		{ 
		 
			 
			$update_item="update purchase_order_item_group
						set ignore_for_xlite='Yes',
						 ignore_for_xlite_reason='14',
						 ignore_for_xlite_remarks='Auto Ignore from System as lessthan 1 Case Qty'
						where internal_code={$item_int_code}";
			$lobj_update_item= $this->aobj_context->mobj_db->Execute($update_item);
			//echo $update_item."</br>";
			if($lobj_update_item)
			{
				$update_child_item_status="update purchase_order_item_errors_group
											set item_validation_status='Ignore'
											where item_validation_status in('Failed','Warning')
											and ref_s_ref_data_code={$item_int_code}";
				$lobj_update_child_item_status= $this->aobj_context->mobj_db->Execute($update_child_item_status);
// echo $update_child_item_status;				
				
			}
		 
			// echo $update_item;
		}
#END4##########################ValidatePOItemMasterCode##################################################		
#START5 
		function ValidatePoItemBasicPriceWithPPC()
		{		
		 
 
			foreach($this->po_items_arr as $igk=>$igv)
			{
				$this->po_item_grp_int_code=$igk;
				$rate=$igv['rate'];
		 
				$item_int_code=$igv['item_int_code'];
				if(empty($item_int_code)) continue;
				$basic_price=  $this->item_rates_arr[$item_int_code]['basic_price'];
			 
			 
				$rate_round=round($rate,2);
				$basic_price_round=round($basic_price,2);
				$diff=abs($rate_round-$basic_price_round);
				//if(round($rate,2)==round($basic_price,2))
				$this->updateItemDetailsForPoItem("leap_price",$basic_price); 
				if($diff>=0 and $diff<=0.99)
				{
				
					$this->insertIntoPoItemValidations("Success","Item Rate Found");
						
				}
				else
				{
					 
					$description=$this->error_code."-".$this->error_description."(PO Rate:{$rate}::Price Master Rate:{$basic_price})";
					$this->insertIntoPoItemValidations($this->default_action,$description);
					 
				}
			}		 
		}
		 
#END5##########################ValidatePoItemBasicPriceWithPPC##################################################		
#START5##########################ValidatePoItemMRPWithPPC##################################################		
		 
		function ValidatePoItemMRPWithPPC()
		{		
			 
			foreach($this->po_items_arr as $igk=>$igv)
			{
				$this->po_item_grp_int_code=$igk;
		
				$po_item_mrp=$igv['po_item_mrp'];
				$item_int_code=$igv['item_int_code'];
				if(empty($item_int_code)) continue;
				$mrp= $this->item_rates_arr[$item_int_code]['mrp'];
				$this->updateItemDetailsForPoItem("leap_item_mrp",$mrp); 
				if($po_item_mrp!=$mrp)
				{ 
                     
					$description=$this->error_code."-".$this->error_description." PO MRP: {$po_item_mrp} Leap MRP : {$mrp}";
					$this->insertIntoPoItemValidations($this->default_action,$description);
					 
				}
				 
					
				 

			}	// die();
		}
		 
#END5##########################ValidatePoItemMRPWithPPC##################################################		
#START8##########################	ValidateItemCaseQty##################################################		
		 
		function ValidateItemCaseQty()
		{		
	
	 
			foreach($this->po_items_arr as $igk=>$igv)
			{
				$this->po_item_grp_int_code=$igk;
				$item_int_code=$igv['item_int_code'];if(empty($item_int_code)) continue;
				 
				$qty=$igv['po_original_qty'];
				// $moq=$this->artical_master_int_code_arr[$item_int_code]['moq'];	
				$pack_qty=$this->artical_master_int_code_arr[$item_int_code]['pack_qty'];	
				 
				// $uom=$this->artical_master_int_code_arr[$item_int_code]['uom'];	
				 
				// if($uom=="EA")
				{
					$old_qty=$igv['qty'];
					 
					$xlite_qty=intval($qty/$pack_qty)*$pack_qty;
					$xlite_qty_update=intval($qty/$pack_qty);
				
					$xlite_qty_update_float=round($qty/$pack_qty,2);
					  // echo $old_qty.'--'.$pack_qty.'--'.$xlite_qty;die();
					  // echo $xlite_qty_update_float.'---';
					  if($this->allow_decimal_qty_to_erp=="Yes")
					  {
						  $xlite_qty_update=$xlite_qty_update_float;
					  }
					  
					if($xlite_qty!=$qty)
					{
						$description=$this->error_code."-".$this->error_description." Calculated Bill Qty:{$xlite_qty_update}::PO Qty:{$qty} -- Pack Qty:{$pack_qty} ";
						if($xlite_qty==0)
						$this->insertIntoPoItemValidations("Failed",$description);
						else
						$this->insertIntoPoItemValidations($this->default_action,$description);
					
						//if($xlite_qty>0)
							
						$this->updateItemDetailsForPoItem("erp_qty",$xlite_qty_update);
						$this->UpdateERPPrice($pack_qty);
						if($xlite_qty_update>0 && $xlite_qty_update<1)
						{
							//$this->UpdateItemsAsIgnoredMannualyForCaseQty($this->po_item_grp_int_code);
						}
					}
					else
					{
						$this->updateItemDetailsForPoItem("erp_qty",$xlite_qty_update);
						if($xlite_qty_update>0 && $xlite_qty_update<1)
						{
							//$this->UpdateItemsAsIgnoredMannualyForCaseQty($this->po_item_grp_int_code);
						}
						$this->UpdateERPPrice($pack_qty);
					}	
				}				
			}		 
		}	
		function ValidateItemCaseQtyWithouError()
		{		
	
	 
			foreach($this->po_items_arr as $igk=>$igv)
			{
				$this->po_item_grp_int_code=$igk;
				$item_int_code=$igv['item_int_code'];if(empty($item_int_code)) continue;
				 
				$qty=$igv['po_original_qty'];
				// $moq=$this->artical_master_int_code_arr[$item_int_code]['moq'];	
				$pack_qty=$this->artical_master_int_code_arr[$item_int_code]['pack_qty'];	
				 
				// $uom=$this->artical_master_int_code_arr[$item_int_code]['uom'];	
				 
				// if($uom=="EA")
				{
					$old_qty=$igv['qty'];
					 
					$xlite_qty=intval($qty/$pack_qty)*$pack_qty;
					$xlite_qty_update=intval($qty/$pack_qty);
				
					$xlite_qty_update_float=round($qty/$pack_qty,2);
					  // echo $old_qty.'--'.$pack_qty.'--'.$xlite_qty;die();
					  // echo $xlite_qty_update_float.'---';
					  if($this->allow_decimal_qty_to_erp=="Yes")
					  {
						  $xlite_qty_update=$xlite_qty_update_float;
					  }
					  
				 
						$this->updateItemDetailsForPoItem("erp_qty",$xlite_qty_update);
						$this->UpdateERPPrice($pack_qty);
					 	
				}				
			}		 
		}		
		function UpdateERPPrice($pack_qty)
		{ 
		 
			$update_item_int_code="update purchase_order_item_group
									set erp_price=rate*{$pack_qty}
									where internal_code={$this->po_item_grp_int_code}";
			$lobj_update_item_int_code= $this->aobj_context->mobj_db->Execute($update_item_int_code);	
	  
		}
		
#END8##########################	ValidateItemCaseQty##################################################	
#START8##########################	ValidateSAPTaxCode##################################################		
		 
		function ValidateSAPTaxCode()
		{		
	
	 
			foreach($this->po_items_arr as $igk=>$igv)
			{
				$this->po_item_grp_int_code=$igk;
				$item_int_code=$igv['item_int_code'];
				if(empty($item_int_code)) continue;
				$am_category_int_code=$this->artical_master_int_code_arr[$item_int_code]['am_category_int_code'];	
				$category_name=$this->artical_master_int_code_arr[$item_int_code]['category_name'];	
				$tax_arr= $this->tax_master_code_arr[$am_category_int_code];
				if(empty($tax_arr))
				{
						$description=$this->error_code."-".$this->error_description." Item Tax Code Not Found for <b>{$category_name}</b> for Location {$this->delivery_location_code}";
					 	$this->insertIntoPoItemValidations("Failed",$description);
						continue;
				}
				else
				{
					$row_tax_code="";
					if($this->po_ship_to_state_code==$this->po_ship_from_state_code)
					{
						
						$row_tax_code=$this->tax_master_code_arr[$am_category_int_code]['tax_code_within_state'];
						if($this->btl_tcs_applicable=='Yes')
						{
							$row_tax_code=$this->tax_master_code_arr[$am_category_int_code]['tcs_tax_code_within_state'];
						}
					}	
					else
					{
						$row_tax_code=$this->tax_master_code_arr[$am_category_int_code]['tax_code_out_of_state'];
						if($this->btl_tcs_applicable=='Yes')
						{
							$row_tax_code=$this->tax_master_code_arr[$am_category_int_code]['tcs_tax_code_out_of_state'];
						}
					}
					 
						$this->updateItemDetailsForPoItem("erp_tax_code",$row_tax_code);
					  
					if(empty($row_tax_code))
					{
								$description=$this->error_code."-".$this->error_description." Item Tax Code Not Found for <b>{$category_name}</b> for Location {$this->delivery_location_code}";
							$this->insertIntoPoItemValidations("Failed",$description);
							 
					}
					 
						
				}					

			 							
					 
				}				
			 		 
		}		
#END8##########################	ValidateSAPTaxCode##################################################		
#START9##########################	ValidatePoItemBarCodeWithArticleMaster##################################################		
		 
		function ValidatePoItemBarCodeWithArticleMaster()
		{			 		
			foreach($this->po_items_arr as $igk=>$igv)
			{
				$this->po_item_grp_int_code=$igk;
				$item_int_code=$igv['item_int_code'];if(empty($item_int_code)) continue;
				$po_item_barcode=$igv['po_item_barcode'];
				$article_barcode=$this->artical_master_int_code_arr[$item_int_code]['barcode'];
				if($po_item_barcode!=$article_barcode)
				{
				$description=$this->error_code."-".$this->error_description."(Article EAN:<b>{$article_barcode}</b>::PO EAN:<b>{$po_item_barcode}</b>)";
				$this->insertIntoPoItemValidations($this->default_action,$description);
				}				 
			}		 
		}		
#END9##########################	ValidatePoItemBarCodeWithArticleMaster##################################################	
 #START9##########################	ValidatePoItemTaxRateWithArticleMaster##################################################		
		 
		function ValidatePoItemTaxRateWithArticleMaster()
		{			 		
			foreach($this->po_items_arr as $igk=>$igv)
			{
				$this->po_item_grp_int_code=$igk;
				$item_int_code=$igv['item_int_code'];if(empty($item_int_code)) continue;
				$po_tax_rate=$igv['po_tax_rate'];
				if(empty($item_int_code)) continue;
				$tax_perc= $this->item_rates_arr[$item_int_code]['tax_perc'];
				// echo $po_tax_rate.'--'.$tax_perc."<br>";
				// echo "<pre>";print_r($this->item_rates_arr[$item_int_code]);
				 
				if($po_tax_rate!=$tax_perc)
				{
				$description=$this->error_code."-".$this->error_description."(PO Tax Rate:{$po_tax_rate}::SAP Tax Rate:{$tax_perc})";
				$this->insertIntoPoItemValidations($this->default_action,$description);
				}
				$this->updateItemDetailsForPoItem("leap_tax_rate",$tax_perc); 				
			}		 
		}		
#END9##########################	ValidatePoItemTaxRateWithArticleMaster##################################################		
#START9##########################	ValidatePoItemTaxRateWithArticleMasterTesco##################################################		
		 
		function ValidatePoItemTaxRateWithArticleMasterTesco()
		{			
			if($this->po_site_code=="VAT Included")
			{
				foreach($this->po_items_arr as $igk=>$igv)
				{
					$this->po_item_grp_int_code=$igk;
					$item_int_code=$igv['item_int_code'];if(empty($item_int_code)) continue;
					$po_tax_rate=$igv['po_tax_rate'];
					$article_po_tax_rate=$this->artical_master_int_code_arr[$item_int_code]['tax_rate'];
					if($po_tax_rate!=$article_po_tax_rate)
					{
					$description=$this->error_code."-".$this->error_description;
					$this->insertIntoPoItemValidations($this->default_action,$description);
					}				 
				}
		  }	
		}		
#END9##########################	ValidatePoItemTaxRateWithArticleMasterTesco##################################################		

##########################Common Functions##################################################		
		function updateItemDetailsForPoItem($field_name,$val,$field_name1=null,$val1=null)
		{ 
			$upd_cond="";
			if(!is_null($field_name1))
			$upd_cond=" ,{$field_name1}='{$val1}'";
			$update_item_int_code="update purchase_order_item_group
									set {$field_name}='{$val}' {$upd_cond}
									where internal_code={$this->po_item_grp_int_code}";
			$lobj_update_item_int_code= $this->aobj_context->mobj_db->Execute($update_item_int_code);	
	 	 // echo $update_item_int_code.'</br>';
			if($field_name=="item")
			$this->insertIntoPoItemValidations("Success","Item Code Found");
		}
		
		function UpdatePoHeaderTable($field_name,$val)
		{
			$update_btl_code=" update purchase_order 
								SET {$field_name}={$val}
								where internal_code={$this->po_int_code}";
			$lobj_get_btl_details= $this->aobj_context->mobj_db->Execute($update_btl_code);
			
			
			 
			if($field_name!='status')
			$this->insertIntoPoHeaderValidations("Success","Successfully Found");	
		}
		function insertIntoPoHeaderValidations($status,$validation_remarks)
		{
			$delete_from="delete from purchase_order_validations_group
								where ref_s_ref_data_code={$this->po_int_code}
								and parameter_name={$this->ref_validation_code}";
			$lobj_delete_from= $this->aobj_context->mobj_db->Execute($delete_from);	
			$inser_into="insert into purchase_order_validations_group 
						 (ref_s_ref_data_code,parameter_name,run_date,validation_status,
						validation_remarks,
						created_by,created_date,modified_by,modified_date)
						values  
						(
						{$this->po_int_code},
						{$this->ref_validation_code},
						current_date(),
						'{$status}',
						'{$validation_remarks}',
						{$this->user_id},now(),{$this->user_id},now()
						)";	
			$lobj_inser_into= $this->aobj_context->mobj_db->Execute($inser_into);
			
	 
 		 
		}
		function insertIntoPoItemValidations($item_validation_status,$item_validation_remarks)
		{
			$delete_from="delete from purchase_order_item_errors_group
								where ref_s_ref_data_code={$this->po_item_grp_int_code}
								and item_parameter_name={$this->ref_validation_code}";
			$lobj_delete_from= $this->aobj_context->mobj_db->Execute($delete_from);	
		              // echo $delete_from;die();
			$inser_into="insert into purchase_order_item_errors_group 
						 (ref_s_ref_data_code,item_parameter_name,item_run_date,item_validation_status,
						item_validation_remarks,
						created_by,created_date,modified_by,modified_date)
						values  
						(
						{$this->po_item_grp_int_code},
						{$this->ref_validation_code},
						current_date(),
						'{$item_validation_status}',
						'{$item_validation_remarks}',
						{$this->user_id},now(),{$this->user_id},now()
						)";	
			$lobj_inser_into= $this->aobj_context->mobj_db->Execute($inser_into); 	
	
		}
		function GetStatusIntCodes()
		{
			$get_s_data=" SELECT internal_code,status FROM status";
			$lobj_get_s_data= $this->aobj_context->mobj_db->GetAll($get_s_data);
			$this->status_details=array();
			foreach($lobj_get_s_data as $sk=>$sv)
			{
			$this->status_details[$sv['status']]=$sv['internal_code'];
			}
		}
	 
		function UpdateItemStatus()
		{
			$get_item_errors="update purchase_order_item_group   
				set  purchase_order_item_group.is_item_error='Yes'
					from purchase_order_item_group inner join 
								( 
								select poi.internal_code,COUNT(poie.internal_code) AS failure_count
								from
								purchase_order po
								inner join purchase_order_item_group poi
								on poi.ref_s_ref_data_code=po.internal_code
								inner join purchase_order_item_errors_group poie
								on poie.ref_s_ref_data_code=poi.internal_code
								where po.internal_code={$this->po_int_code}	
								AND item_validation_status='Failed'
								group by poi.internal_code)b								
								on purchase_order_item_group.internal_code=b.internal_code";
			$lobj_get_item_status= $this->aobj_context->mobj_db->Execute($get_item_errors);	
		 
			 
		}
		function UpdatePoStatus()
		{
			if(empty($this->po_number))
			{
				$get_data=" select po_number from purchase_order where internal_code={$this->po_int_code}";
				$lobj_get_po_number= $this->aobj_context->mobj_db->GetRow($get_data);				
				$this->po_number=$lobj_get_po_number['po_number'];
			}
		$this->UpdateItemStatus();
			$get_header_status="SELECT COUNT(*) AS failure_count
							FROM purchase_order_validations_group
							WHERE ref_s_ref_data_code={$this->po_int_code}
							AND validation_status='Failed'";
			$lobj_get_header_status= $this->aobj_context->mobj_db->GetRow($get_header_status);				
			$head_status_count=$lobj_get_header_status['failure_count'];
 
			$get_item_errors="select count(poie.internal_code) AS failure_count
							from
							purchase_order po
							inner join purchase_order_item_group poi
							on poi.ref_s_ref_data_code=po.internal_code
							inner join purchase_order_item_errors_group poie
							on poie.ref_s_ref_data_code=poi.internal_code
							where po.internal_code={$this->po_int_code}
							AND item_validation_status='Failed'";
			$lobj_get_item_status= $this->aobj_context->mobj_db->GetRow($get_item_errors);		
 	
			$item_status_count=$lobj_get_item_status['failure_count'];	
			$error_cnt=$head_status_count+$item_status_count;
			$s_error_int_code=$this->status_details['Error'];
			$s_order_int_code=$this->status_details['Order'];
			$s_ignored_int_code=$this->status_details['Ignored'];
			$get_qty_details="select COUNT(poi.internal_code) as zero_qty
							from
							purchase_order po
							inner join purchase_order_item_group poi
							on poi.ref_s_ref_data_code=po.internal_code 
							inner join purchase_order_item_errors_group poie
							on poie.ref_s_ref_data_code=poi.internal_code			
							AND item_validation_status!='Blocked'
							where po.internal_code={$this->po_int_code}
							and qty=0 and ifnull(ignore_for_xlite,'No')='No'  ";
			$lobj_get_qty_details= $this->aobj_context->mobj_db->GetRow($get_qty_details);
			$zero_qty=$lobj_get_qty_details['zero_qty'];
		 
			$this->po_order_status="";
			if($error_cnt==0 && $zero_qty==0)
			{
				$update_s_code=$s_order_int_code;
				$this->po_order_status="Order";
				 
				unlink($this->error_po_path);
			}
			else
			{
				$update_s_code=$s_error_int_code;
				$this->po_order_status="Error";
			}
			$get_ignored_cnt="SELECT COUNT(poi.internal_code) AS item_qt,SUM(IF(IFNULL(ignore_for_xlite,'No')='Yes',1,0)) ignore_cnt
							FROM
							purchase_order po
							INNER JOIN purchase_order_item_group poi
							ON poi.ref_s_ref_data_code=po.internal_code  
							WHERE po.internal_code={$this->po_int_code} ";
				$lobj_get_ignored_cnt= $this->aobj_context->mobj_db->GetRow($get_ignored_cnt);
				$item_qt=$lobj_get_ignored_cnt['item_qt'];
				$ignore_cnt=$lobj_get_ignored_cnt['ignore_cnt'];
			if($item_qt==$ignore_cnt)
			{
				$update_s_code=$s_ignored_int_code;
				$this->po_order_status="Ignored";
			}
			$this->UpdatePoHeaderTable('status',$update_s_code);
		 
			if($this->po_order_status=="Order" || $this->po_order_status=="SAP Error")
			{
				 $this->PushtoSap();
			}
			else
			{
				$this->replay_msg.="<b>".$this->po_number."</b> is Validated </br>";
			}
			
		}
		 
		function PushtoSap()
		{
			
				$this->replay_msg.="<b>".$this->po_number."</b> is Validated </br>. and it will be pushed based on SAP Upload Date";
			 
			// require_once($this->aobj_context->main_src."/custom_src/sap_sales_order_hana.php");	
			// $class_obj=new sap_sales_order_hana($this->aobj_context,$this->po_int_code,"Cron");
			 // $class_obj->PushSalesDataToSAP($this->po_int_code);
			 // $class_obj->sap_leap_msg;
			// $this->replay_msg.="<b>".$this->po_number."</b> is Validated </br>".$class_obj->sap_leap_msg;
		}
		 
	function __destruct() 
	{
     unset($this);
    }	
}
function ValidatePO($aobj_context)
{
	
	$po_int_codes = $aobj_context->mobj_data["po_int_codes"];
	$po_int_code_arr=explode(',',$po_int_codes);
	 	$msg="";
	foreach($po_int_code_arr AS $ak)
	{
		if(empty($ak)) continue;
		if($ak>0)
		{
			$error_obj=new validate_po($aobj_context);
			$error_obj->validate_type="UI";	
			$error_obj->po_int_code=$ak;	
			$error_obj->DeleteAllValidateParameters();	
			$error_obj->ValidatePO();
			$msg.=$error_obj->replay_msg;
			unset($error_obj);	
		}
	}
 
	$data="Po Is Validated";
	echo $aobj_context->mobj_output->ToJSONEnvelope($msg,0,"success"); 
}
 
function ValidatePOFromCron($aobj_context)
{
	$_SESSION['user_id']=1;
	$po_int_codes = $aobj_context->mobj_data["po_int_codes"];
	$po_int_code_arr=explode(',',$po_int_codes);
	$msg="";
	foreach($po_int_code_arr AS $ak)
	{
		if(empty($ak)) continue;
		if($ak>0)
		{
			$error_obj=new validate_po($aobj_context);
			 
			$error_obj->validate_type="Cron";				
			$error_obj->po_int_code=$ak;	
			$error_obj->DeleteAllValidateParameters();	
			$error_obj->ValidatePO();
			$msg.=$error_obj->replay_msg;
			unset($error_obj);	
		}
	}
 
	// $data="Po Is Validated";
	echo $aobj_context->mobj_output->ToJSONEnvelope($msg,0,"success"); 
}function ValidatePOForSinlePoIntCode($aobj_context,$po_int_codes)
{
	$_SESSION['user_id']=1;
	$po_int_codes = $aobj_context->mobj_data["po_int_codes"];
	$po_int_code_arr=explode(',',$po_int_codes);
	foreach($po_int_code_arr AS $ak)
	{
		if(empty($ak)) continue;
		if($ak>0)
		{
			$error_obj=new validate_po($aobj_context);
		 
			$error_obj->validate_type="Cron";				
			$error_obj->po_int_code=$ak;	
			$error_obj->DeleteAllValidateParameters();	
			$error_obj->ValidatePO();
			unset($error_obj);	
		}
	}
	 
}
function AutoInsertIgnoreArticle($aobj_context)
{
 
	$get_qty_details="INSERT INTO ignore_articles(customer,article_code,description,created_by,created_date)
			SELECT ref_cust_code,po_item_sku_code,'Auto Insert',1,NOW()
				FROM
				( SELECT DISTINCT c.internal_code AS ref_cust_code,po_item_sku_code FROM purchase_order_item_group pig
				 INNER JOIN purchase_order po ON po.internal_code=pig.ref_s_ref_data_code
				 INNER JOIN customer_master c ON c.internal_code=po.customer
				 WHERE ignore_for_xlite='yes'
				 AND ignore_for_xlite_reason=13)a
				 LEFT JOIN ignore_articles i ON i.customer=ref_cust_code AND a.po_item_sku_code=article_code
				 WHERE i.internal_code IS NULL";
 	$lobj_get_qty_details= $aobj_context->mobj_db->Execute($get_qty_details);
	echo $aobj_context->mobj_output->ToJSONEnvelope($lobj_get_qty_details,0,"success"); 
	 
}
?>