<?php
	class scheduledMail
	{
		function __construct($aobj_context)
		{
			session_start();
			$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
			$this->aobj_context=$aobj_context;
			require_once($this->aobj_context->main_src.'/src/cManualMailer.php');
			require_once($this->aobj_context->main_src."/src/json.php");
			require_once($this->aobj_context->main_src."/src/format.php");
			
			require_once($this->aobj_context->main_src."/src/report_class.php");
			$this->Excel = new create_report($this->aobj_context);
			require_once($this->aobj_context->main_src."/custom_src/manual_mailer.php");
			$this->file_name = '';
		}
		function sendReportMailForFileRate()
		{
				$this->getQueryData();
				$this->ReportAttachment_one();
				$this->ReportAttachment_two();
				// echo "asd";die();
				$this->sendMail(); die();
			
		}
		function GetQueryData()
		{
        			
			$get_data="SELECT p.internal_code AS leap_so_no,cm.name AS customer,po_number,p.po_date AS po_date, bc.customer_code AS btl_code,
						bc.customer_name AS btl_name,s.description AS status_desc,order_value,am.stock_code,st.name AS state,
						p.sap_document_number,DATE_FORMAT(p.sap_document_date,'%d-%m-%Y') AS sap_document_date,
						poi.value AS order_value,poi.sap_invoice_line_total invoice_line_value,poi.qty*poi.rate AS qty_rate_val,
						am.stock_description AS item,IFNULL(poi.erp_qty,0) AS po_qty,IFNULL(poi.sap_invoice_qty,0) AS sap_invoice_qty,
						ROUND(IFNULL(poi.erp_qty,0)-IFNULL(poi.sap_invoice_qty,0),2) AS diff_qty
						FROM purchase_order p
						INNER JOIN purchase_order_item_group poi ON poi.ref_s_ref_data_code = p.internal_code
						INNER JOIN article_master am ON am.internal_code = poi.item
						INNER JOIN customer_master cm ON cm.internal_code=p.customer
						INNER JOIN bill_to_customer_master bc ON bc.internal_code=p.bill_to
						INNER JOIN state st ON st.internal_code = bc.ship_to_state
						INNER JOIN status s ON s.internal_code=p.status
						INNER JOIN location_wise_sap_series ls ON ls.location_code=bc.delivery_location_code AND ls.status='Active'
						WHERE s.status ='Pushed To ERP' AND poi.ignore_for_xlite = 'No' and DATE_FORMAT(p.date,'%Y%m') = DATE_FORMAT(NOW(), '%Y%m') 
						order by cm.name,p.po_date ";
							
							 // echo $get_data; die();
							 
			$this->obj_get_data = $this->aobj_context->mobj_db->GetAll($get_data);				
			
			$get_po_drop_data="SELECT cm.name AS customer_name,
								st.name AS state,
								bc.customer_code,bc.customer_name as bill_to,
								p.po_number,
								p.internal_code AS leap,
								DATE_FORMAT(p.po_date,'%d-%m-%Y') AS po_date,
								p.order_value,
								ifnull(p.sap_invoice_value,0) as sap_invoice_value,
								s.status
								FROM purchase_order p
								LEFT JOIN customer_master cm
								ON cm.internal_code = p.customer
								LEFT JOIN bill_to_customer_master bc
								ON bc.internal_code = p.bill_to
								LEFT JOIN state st ON st.internal_code =bc.ship_to_state
								LEFT JOIN s_sysdb muser
								ON muser.internal_code = p.modified_by
								LEFT JOIN status s
								ON s.internal_code = p.status
								WHERE 1=1 and (ifnull(p.sap_invoice_value,0)/p.order_value*100)<80
									AND s.status ='Pushed To ERP'  and DATE_FORMAT(p.date,'%Y%m') = DATE_FORMAT(NOW(), '%Y%m') 
								order by cm.name,p.po_date,p.bill_to";			
								 // echo "<pre>".$get_po_drop_data;die();
		$this->obj_get_po_drop_data = $this->aobj_context->mobj_db->GetAll($get_po_drop_data);
		}
		
		function ReportAttachment_one()
		{
			/* $this->Excel->HideGridLines();
			$this->Excel->SetLandscape();
			$this->Excel->RepeateRows(1,6); */
			$date_range=date("M-Y");	
			$get_company_details = "SELECT  company_name FROM company_setup  ";
			$lobj_get_company_details = $this->aobj_context->mobj_db->GetRow($get_company_details); 
			
			$company_name = $lobj_get_company_details[company_name];
			
			$col_cnt = 14;			
			
			$title_arr = Array('1'=>Array(
											'style'=>'Title_Center',
											'caption'=>$company_name,
											'row'=>'1',
											'col'=>'0',
											'merge'=>"1,0:1,{$col_cnt}"),
											
								'2'=>Array(
												'style'=>'Title_Center',
												'caption'=>'Fill Rate Report For '.$date_range,
												'row'=>'2',
												'col'=>'0',
												'merge'=>"2,0:2,{$col_cnt}"  // start_row,start_col : end_row,end_col
												)
											);
								
			$this->Excel->SetTitles($title_arr);
			$this->Excel->HideGridLines();
			$this->Excel->setScale(60);
			$this->row=5;
			$this->Excel->SetColumnWidthManual(0,15);
			$this->Excel->SetColumnWidthManual(1,12);
			$this->Excel->SetColumnWidthManual(2,15);
			$this->Excel->SetColumnWidthManual(3,15);
			$this->Excel->SetColumnWidthManual(4,35);
			$this->Excel->SetColumnWidthManual(5,15);
			$this->Excel->SetColumnWidthManual(6,15);
			$this->Excel->SetColumnWidthManual(7,15);
			$this->Excel->SetColumnWidthManual(8,10);
			$this->Excel->SetColumnWidthManual(9,15);
			$this->Excel->SetColumnWidthManual(10,40);
			$this->Excel->SetColumnWidthManual(11,10);
			$this->Excel->SetColumnWidthManual(12,10);
			$this->Excel->SetColumnWidthManual(13,10);
			$this->Excel->SetColumnWidthManual(14,10);
			$this->Excel->SetColumnWidthManual(15,10);
			
			$this->Excel->WriteCellNew($this->row,0,"Customer","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,1,"PO Number","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,2,"PO Date","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,3,"Bill To Code","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,4,"Bill To Name","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,5,"Ship TO State","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,6,"U_LEAPSONO","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,7,"SAP Document Number","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,8,"SAP Document Date","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,9,"FG Code","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,10,"FG Description","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,11,"PO Qty","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,12,"Invoice Qty","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,13,"Diff. Qty","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,14,"Order Value","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,15,"Invoice Line Value","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,16,"Fill Rate %","Heading_Center_Border");
		
			$this->row=6;
			foreach($this->obj_get_data as $k2=>$v2)
			{
				$col=0;
				$customer=$v2['customer'];
				$po_number=$v2['po_number'];
				$po_date=$v2['po_date'];
				$btl_code=$v2['btl_code'];
				$btl_name=$v2['btl_name'];
				$state=$v2['state'];
				$status_desc=$v2['status_desc'];
				$leap_so_no=$v2['leap_so_no'];
				$sap_document_number=$v2['sap_document_number'];
				$sap_document_date=$v2['sap_document_date'];
				$stock_code=$v2['stock_code'];
				$item=$v2['item'];
				$qty_rate_val=$v2['qty_rate_val'];
				$order_value=$v2['order_value'];
				$invoice_line_value=$v2['invoice_line_value'];
				$po_qty=$v2['po_qty'];
				$sap_invoice_qty=$v2['sap_invoice_qty'];
				$diff_qty=$v2['diff_qty'];
				$fill_rate_perc = Round($invoice_line_value/$qty_rate_val*100,0);
				
				
				$this->Excel->WriteCellNew($this->row,$col,$customer);$col++;
				$this->Excel->WriteCellNew($this->row,$col,$po_number);$col++;
				$this->Excel->WriteCellNew($this->row,$col,$po_date); $col++;
				$this->Excel->WriteCellNew($this->row,$col,$btl_code); $col++;
				$this->Excel->WriteCellNew($this->row,$col,$btl_name); $col++;
				$this->Excel->WriteCellNew($this->row,$col,$state); $col++;
				$this->Excel->WriteCellNew($this->row,$col,$leap_so_no); $col++;
				$this->Excel->WriteCellNew($this->row,$col,$sap_document_number); $col++;
				$this->Excel->WriteCellNew($this->row,$col,$sap_document_date); $col++;
				$this->Excel->WriteCellNew($this->row,$col,$stock_code); $col++;
				$this->Excel->WriteCellNew($this->row,$col,$item); $col++;
				$this->Excel->WriteCellNew($this->row,$col,$po_qty); $col++;
				$this->Excel->WriteCellNew($this->row,$col,$sap_invoice_qty); $col++;
				$this->Excel->WriteCellNew($this->row,$col,$diff_qty); $col++;
				$this->Excel->WriteCellNew($this->row,$col,$qty_rate_val); $col++;
				$this->Excel->WriteCellNew($this->row,$col,$invoice_line_value); $col++;
				$this->Excel->WriteCellNew($this->row,$col,$fill_rate_perc); 
				
				$this->row++;
			}
	
			  $highestColumm = $this->Excel->objPHPExcel->setActiveSheetIndex(0)->getHighestColumn(); // e.g. "EL" 
			  $highestRow = $this->Excel->objPHPExcel->setActiveSheetIndex(0)->getHighestRow(); 
			  $range="A5:{$highestColumm}{$highestRow}";
			  $this->Excel->objPHPExcel->getActiveSheet()->getStyle($range)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);	
			  
			
			
			$this->file_name_one = "fill_rate_report_".date("Y_m_d").".xlsx"; 
			
			$objWriter = PHPExcel_IOFactory::createWriter($this->Excel->objPHPExcel, 'Excel2007');
			$objWriter->save($this->aobj_context->main_src."/attachments/".$this->file_name_one); 
			
		}
		function ReportAttachment_two()
		{
			/* $this->Excel->HideGridLines();
			$this->Excel->SetLandscape();
			$this->Excel->RepeateRows(1,6); */
			$date_range=date("M-Y");	
			$get_company_details = "SELECT  company_name FROM company_setup  ";
			$lobj_get_company_details = $this->aobj_context->mobj_db->GetRow($get_company_details); 
			
			$company_name = $lobj_get_company_details[company_name];
			
			$col_cnt = 14;			
			
			$title_arr = Array('1'=>Array(
											'style'=>'Title_Center',
											'caption'=>$company_name,
											'row'=>'1',
											'col'=>'0',
											'merge'=>"1,0:1,{$col_cnt}"),
											
								'2'=>Array(
												'style'=>'Title_Center',
												'caption'=>' PO Drop Report	'.$date_range,
												'row'=>'2',
												'col'=>'0',
												'merge'=>"2,0:2,{$col_cnt}"  // start_row,start_col : end_row,end_col
												)
											);
								
			$this->Excel->SetTitles($title_arr);
			$this->Excel->HideGridLines();
			$this->Excel->setScale(60);
			$this->row=5;
			$this->Excel->SetColumnWidthManual(0,20);
			$this->Excel->SetColumnWidthManual(1,20);
			$this->Excel->SetColumnWidthManual(2,15);
			$this->Excel->SetColumnWidthManual(3,40);
			$this->Excel->SetColumnWidthManual(4,15);
			$this->Excel->SetColumnWidthManual(5,15);
			$this->Excel->SetColumnWidthManual(6,15);
			$this->Excel->SetColumnWidthManual(7,15);
			$this->Excel->SetColumnWidthManual(8,15);
			$this->Excel->SetColumnWidthManual(9,25);
			$this->Excel->SetColumnWidthManual(10,25);
			  
			$this->Excel->WriteCellNew($this->row,0,"Customer Reference","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,1,"State","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,2,"Bill Customer Code","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,3,"Bill Customer Name","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,4,"Po Number","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,5,"Leap#","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,6,"PO Date","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,7,"Order Value","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,8,"Invoice Value","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,9,"PO Service Status","Heading_Center_Border");
			$this->Excel->WriteCellNew($this->row,10,"Reson for Non-Service","Heading_Center_Border");
			$this->row++;       
			
			$this->row=6;
			foreach($this->obj_get_po_drop_data as $k2=>$v2)
			{
				$col=0;
			$customer_name=$v2['customer_name'];
			$bill_to=$v2['bill_to'];
			$customer_code=$v2['customer_code'];
			$po_number=$v2['po_number'];
			$po_date=$v2['po_date'];
			$leap=$v2['leap'];
			$order_value=$v2['order_value'];
			$state=$v2['state'];
			$sap_invoice_value=$v2['sap_invoice_value'];
			if($sap_invoice_value==0)
			{
				$po_status = 'NS(Not Serve)';	
			}
			if($sap_invoice_value>0)
			{
				$po_status = 'PS(Partially Serve)';	
			} 
			
			$this->Excel->WriteCellNew($this->row,$col,$customer_name);$col++;
			$this->Excel->WriteCellNew($this->row,$col,$state);$col++;
			$this->Excel->WriteCellNew($this->row,$col,$customer_code);$col++;
			$this->Excel->WriteCellNew($this->row,$col,$bill_to);$col++;
			$this->Excel->WriteCellNew($this->row,$col,$po_number); $col++;
			$this->Excel->WriteCellNew($this->row,$col,$leap); $col++;
			$this->Excel->WriteCellNew($this->row,$col,$po_date); $col++;
			$this->Excel->WriteCellNew($this->row,$col,$order_value); $col++;
			$this->Excel->WriteCellNew($this->row,$col,$sap_invoice_value); $col++;
			$this->Excel->WriteCellNew($this->row,$col,$po_status); $col++;
			$this->Excel->WriteCellNew($this->row,$col,''); 
			$this->row++;
			}
		
			$highestColumm = $this->Excel->objPHPExcel->setActiveSheetIndex(0)->getHighestColumn(); // e.g. "EL" 
			$highestRow = $this->Excel->objPHPExcel->setActiveSheetIndex(0)->getHighestRow(); 
			$range="A5:{$highestColumm}{$highestRow}";
			$this->Excel->objPHPExcel->getActiveSheet()->getStyle($range)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);	
			
			$this->file_name_two = "po_drop_report_".date("Y_m_d").".xlsx"; 
			
			$objWriter = PHPExcel_IOFactory::createWriter($this->Excel->objPHPExcel, 'Excel2007');
			$objWriter->save($this->aobj_context->main_src."/attachments/".$this->file_name_two); 
		}
		
		function getChainQueryData()
		{
        			
			$get_chain_wise_data="SELECT cm.name ,sum(round(p.order_value,0)) as po_value,sum(round(ifnull(p.sap_invoice_value,0),0)) as invoice_value
									FROM purchase_order p
									INNER JOIN customer_master cm ON cm.internal_code=p.customer
									INNER JOIN status s ON s.internal_code=p.status
									WHERE s.status ='Pushed To ERP' AND DATE_FORMAT(p.date,'%Y%m') = DATE_FORMAT(NOW(), '%Y%m')
									group by cm.name
									order by cm.name ";
									
							 // echo $get_data; die();
							 
			$obj_get_chain_wise_data = $this->aobj_context->mobj_db->GetAll($get_chain_wise_data);	

			$html='<div style="float: left;margin-left:4%"><h4>Chain wise FillRate</h4><table><tbody>';
			$html.= "<tr style='background-color:powderblue;'>";
			$html.= "<th style='border: 1px solid orange; padding: 5px; text-align: left;'>Customer</th>";
			$html.= "<th style='border: 1px solid orange; padding: 5px; text-align: left;'>PO Value</th>";
			$html.= "<th style='border: 1px solid orange; padding: 5px; text-align: left;'>Invoice Value</th>";
			$html.= "<th style='border: 1px solid orange; padding: 5px; text-align: left;'>Fillrate %</th>";
			$html.="</tr>";
			foreach($obj_get_chain_wise_data as $ck => $cv)
			{
				$customer = $cv['name'];
				$po_value = $cv['po_value'];
				$invoice_value = $cv['invoice_value'];
				$fill_rate_perc = Round($invoice_value/$po_value*100,0);
				
				$total_po +=$po_value;
				$total_invoice +=$invoice_value;
				$total_fill_rate_perc = Round($total_invoice/$total_po*100,0);
				
				$html.="<tr>";
				$html.="<td style='border: 1px solid orange; padding: 3px; text-align: left;'>{$customer}</td>";
				$html.="<td style='border: 1px solid orange; padding: 3px; text-align: right;'>{$po_value}</td>";
				$html.="<td style='border: 1px solid orange; padding: 3px; text-align: right;'>{$invoice_value}</td>";
				$html.="<td style='border: 1px solid orange; padding: 3px; text-align: right;'>{$fill_rate_perc} %</td>";
				$html.="</tr>";
			}
			$html.="<tr>";
			$html.= "<td style='border: 1px solid orange; padding: 5px; text-align: left;'><b>ALL INDIA </td>";
			$html.="<td style='border: 1px solid orange; padding: 3px; text-align: right;'><b>{$total_po}</td>";
			$html.="<td style='border: 1px solid orange; padding: 3px; text-align: right;'><b>{$total_invoice}</td>";
			$html.="<td style='border: 1px solid orange; padding: 3px; text-align: right;'><b>{$total_fill_rate_perc} %</td>";
			$html.="</tr>";
				$html.='</tbody></table></div>';
			return $html;			
					
		}
		function getStateQueryData()
		{
        			
			$get_state_wise_data="SELECT st.name as state ,sum(round(p.order_value,0)) as po_value,sum(round(ifnull(p.sap_invoice_value,0),0)) as invoice_value
									FROM purchase_order p
									left JOIN bill_to_customer_master bc ON bc.internal_code = p.bill_to
									INNER JOIN state st ON st.internal_code = bc.ship_to_state
									INNER JOIN status s ON s.internal_code=p.status
									WHERE s.status ='Pushed To ERP' AND DATE_FORMAT(p.date,'%Y%m') = DATE_FORMAT(NOW(), '%Y%m')
									group by st.name
									order by st.name";
									
							 // echo $get_data; die();
							 
			$obj_get_state_wise_data = $this->aobj_context->mobj_db->GetAll($get_state_wise_data);				
			$html_state='<div style="float: left"><h4>State wise FillRate</h4><table><tbody>';
			$html_state.= "<tr style='background-color:powderblue;'>";
			$html_state.= "<th style='border: 1px solid orange; padding: 5px; text-align: left;'>State</th>";
			$html_state.= "<th style='border: 1px solid orange; padding: 5px; text-align: left;'>PO Value</th>";
			$html_state.= "<th style='border: 1px solid orange; padding: 5px; text-align: left;'>Invoice Value</th>";
			$html_state.= "<th style='border: 1px solid orange; padding: 5px; text-align: left;'>Fillrate %</th>";
			$html_state.="</tr>";
			foreach($obj_get_state_wise_data as $sk => $sv)
			{
				$state = $sv['state'];
				$po_value = $sv['po_value'];
				$invoice_value = $sv['invoice_value'];
				$fill_rate_perc = Round($invoice_value/$po_value*100,0);
				$total_po += $po_value;
				$total_invoice += $invoice_value;
				$total_fill_rate_perc = Round($total_invoice/$total_po*100,0);
				
				$html_state.="<tr>";
				$html_state.="<td style='border: 1px solid orange; padding: 3px; text-align: left;'>{$state}</td>";
				$html_state.="<td style='border: 1px solid orange; padding: 3px; text-align: right;'>{$po_value}</td>";
				$html_state.="<td style='border: 1px solid orange; padding: 3px; text-align: right;'>{$invoice_value}</td>";
				$html_state.="<td style='border: 1px solid orange; padding: 3px; text-align: right;'>{$fill_rate_perc} %</td>";
				$html_state.="</tr>";
			}
			$html_state.="<tr>";
			$html_state.= "<td style='border: 1px solid orange; padding: 5px; text-align: left;'><b>ALL INDIA</td>";
			$html_state.="<td style='border: 1px solid orange; padding: 3px; text-align: right;'><b>{$total_po}</td>";
			$html_state.="<td style='border: 1px solid orange; padding: 3px; text-align: right;'><b>{$total_invoice}</td>";
			$html_state.="<td style='border: 1px solid orange; padding: 3px; text-align: right;'><b>{$total_fill_rate_perc} %</td>";
			$html_state.="</tr>";
				$html_state.='</tbody></table></div>';
			return $html_state;	
			
			 
		}
		
		function sendMail()
		{
			$get_email_id="SELECT GROUP_CONCAT(DISTINCT mt.mail_id) AS to_mail_id,
							GROUP_CONCAT(DISTINCT mt.cc_mail_id) AS cc_mail_id
							FROM mt_team_mail_id mt
							";
			
			$lobj_get_email_id= $this->aobj_context->mobj_db->GetRow($get_email_id);
		  
			$to = $lobj_get_email_id['to_mail_id'];
			$cc = $lobj_get_email_id['cc_mail_id'];
	  		
			
			$date_range=date("M-Y");
			$subject ="Fill Rate Report for the period {$date_range}";
			$attachment_arr=array();
			$attachment_arr[0]=array();
			$attachment_arr[0]['path'] = $this->aobj_context->main_src."/attachments/".$this->file_name_one;
			$attachment_arr[0]['name'] = 'fill_rate_report.xlsx';
			
			$attachment_arr[1]=array();
			$attachment_arr[1]['path'] = $this->aobj_context->main_src."/attachments/".$this->file_name_two;
			$attachment_arr[1]['name'] = 'po_drop_report.xlsx';
			
			
			 // echo "hi"; die();
			
			$mail_html='';
			$mail_html.='<html>';
			$mail_html.='<body>';
			$mail_html.='<h4>Dear Sir,</h4>';
			$mail_html.=" Please find the Fill Rate report for the  period {$date_range}";
			$mail_html.='<div>';
		
		
			$mail_html.=$this->getStateQueryData();
				$mail_html.=$this->getChainQueryData();
			$mail_html.='</div><div style="clear:both"></div>';
			
		
			$mail_html.="</br></br> Thank You.<br><br>";
			$mail_html.='*-* This is a system generated email *-*';
			$mail_html.='</body>';
			$mail_html.='</html>';	
			echo $mail_html;
			try 
			{			
				// echo "hi"; die();	
				// $to = 'komala@tarkasoft.com'; 
				// $to = ',natesha.s@tarkasoft.com,komala@tarkasoft.com';
				$cc.= ',natesha.s@tarkasoft.com';
				// $cc= 'natesha.s@tarkasoft.com';
				
				$data = send_mail($this->aobj_context,$to,$subject,$mail_html,$cc,$attachment_arr);
				echo "<pre>";print_r($data);die();
			}
			catch(Exception $e) 
			{
				$data= "Mail Sending Failed - ".$e->getMessage();
			} 
		}
	}
	function sendReportMailForFileRate($aobj_context)
	{
		$obj = new scheduledMail($aobj_context);
		$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$obj->sendReportMailForFileRate();
	}
	
	
?>
