<?php
class grid_filters
{
	function __construct($aobj_context)
	{
		$this->aobj_context=$aobj_context;
		$this->aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->user_id = $_SESSION['user_id'];
		$this->user_type = $_SESSION['user_type'];
		$this->usr = $_SESSION['usr'];
		$this->table_name = $aobj_context->mobj_data["table_name"];	
	}

	function GetApprovalFilterCond()	  
	{
		switch($this->table_name)
		{
			case "pr_inv":
			return $this->GetPRFilter();				
			break;
			case "party":
			return $this->GetPartyFilter();				
			break;

			default:
			return "";
			break;
		}		 
	}

	function GetFilterCond()	  
	{
		switch($this->table_name)
		{
			case "customer_master":
			return $this->GetCustomerMasterFilter();				
			break;
			case "invoice":
			return $this->GetInvoiceFilter();				
			break;
			case "authorised_signatory":
			return $this->GetAuthorisedSignatoryFilter();				
			break;
			case "consultant":
			return $this->GetConsultantFilter();				
			break;
			case "pr_inv":
			return $this->GetPRFilter();				
			break;
			case "party":
			return $this->GetPartyFilter();				
			break;
			
			default:
			return "";
			break;
		}		 
	}
	
	function GetPRFilter()
	{
		$cond="";
 
		$app_cond="";
		if($this->usr == 'Saravanan Kumar')
		{
			$app_cond=" AND ifnull(ap.stage,'') = ''";
		}
		
		$get_pr_int_codes="select group_concat(distinct pr.internal_code)  as pr_int_codes
							from pr_inv pr
							INNER JOIN pr_inv_items_group pri ON pri.ref_s_ref_data_code = pr.internal_code
							LEFT JOIN po_inv_pr_details_group por ON por.ref_pr_item_code=pri.internal_code
							LEFT JOIN po_inv_items_group pog ON por.ref_s_ref_data_code=pog.internal_code
							LEFT JOIN po_inv po_in ON pog.ref_s_ref_data_code=po_in.internal_code
							LEFT JOIN approval_stages AS ap	ON ap.internal_code = pr.status
							where 1=1 
							AND ((por.internal_code IS NULL AND IF(pr.cancelled IS NULL OR pr.cancelled = '','No',pr.cancelled) <> 'Yes')
									  OR IF(po_in.cancelled IS NULL OR po_in.cancelled = '','No',po_in.cancelled) = 'Yes')
									  {$app_cond} ";	
		// echo $get_pr_int_codes;die();
		$lobj_get_pr_int_codes = $this->aobj_context->mobj_db->GetRow($get_pr_int_codes);
		$pr_int_codes=$lobj_get_pr_int_codes['pr_int_codes'];

		$cond="	and pr_inv.internal_code in({$pr_int_codes}) ";
		return $cond;
	}	
	
	function GetPartyFilter()
	{
		$cond="";

		$get_user_department = "SELECT dep.name as department FROM s_sysdb s 
								INNER JOIN department dep on dep.internal_code = s.user_dept
								WHERE s.internal_code = {$this->user_id}
							   ";
		$lobj_get_user_department = $aobj_context->mobj_db->GetRow($get_user_department);
		
		$department = $lobj_get_user_department['department'];
		
		if($department == 'PROPOSAL')
		{
			$cond=" AND  party.type = 'Customer' ";
		}	
		else
		{
			$cond=" AND  party.type <> 'Customer' ";
		}	
		return $cond;
	}
	
	function GetCustomerMasterFilter()
	{
		$cond="";
		if($this->user_type!="Admin")
		{
			$get_map_loc_int_codes="select group_concat(ug.location)  as loc_int_codes
			from user_master_location_mapping_group ug
			where ug.ref_s_ref_data_code={$this->user_id}";			
			$lobj_get_map_loc_int_codes = $this->aobj_context->mobj_db->GetRow($get_map_loc_int_codes);
			$loc_int_codes=$lobj_get_map_loc_int_codes['loc_int_codes'];

			$cond="	and customer_master.location in({$loc_int_codes}) ";
		}
		return $cond;
	}
	
	function GetInvoiceFilter()
	{
		$cond="";
		if($this->user_type!="Admin")
		{
			$get_map_loc_int_codes="select group_concat(ug.location)  as loc_int_codes
									from user_master_location_mapping_group ug
									where ug.ref_s_ref_data_code={$this->user_id}";			
			$lobj_get_map_loc_int_codes = $this->aobj_context->mobj_db->GetRow($get_map_loc_int_codes);
			$loc_int_codes=$lobj_get_map_loc_int_codes['loc_int_codes'];

			$cond="	and invoice.location in({$loc_int_codes}) ";
		}
	    return $cond;
	}
	
	function GetAuthorisedSignatoryFilter()
	{
		$cond="";
		if($this->user_type!="Admin")
		{
			$get_map_loc_int_codes="select group_concat(ug.location)  as loc_int_codes
									from user_master_location_mapping_group ug
									where ug.ref_s_ref_data_code={$this->user_id}";			
			$lobj_get_map_loc_int_codes = $this->aobj_context->mobj_db->GetRow($get_map_loc_int_codes);
			$loc_int_codes=$lobj_get_map_loc_int_codes['loc_int_codes'];

			$cond="	and  location in({$loc_int_codes}) ";
		}
	    return $cond;
	}
	
	function GetConsultantFilter()
	{
		$cond="";
		if($this->user_type!="Admin")
		{
			$get_map_loc_int_codes="select group_concat(ug.location)  as loc_int_codes
									from user_master_location_mapping_group ug
									where ug.ref_s_ref_data_code={$this->user_id}";			
			$lobj_get_map_loc_int_codes = $this->aobj_context->mobj_db->GetRow($get_map_loc_int_codes);
			$loc_int_codes=$lobj_get_map_loc_int_codes['loc_int_codes'];

			$cond="	and  location in({$loc_int_codes}) ";
		}
	    return $cond;
	}
}	
?>
