<?PHP
require_once("calc_commercials.php");	
class commercials extends calc_commercials
{
	function __construct($aobj_context)
	{
		session_start();
		$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->aobj_context=$aobj_context;
		$this->user_id = $_SESSION['user_id'];	
		require_once($this->aobj_context->main_src."/src/json.php");
		require_once($this->aobj_context->main_src."/src/format.php");
		$this->json = new Services_JSON();
		parent:: __construct($aobj_context);
	}
	function GetFreshTaxDataOnSelectOfTaxIntCode()
	{
		$this->tax_int_code= $this->aobj_context->mobj_data["tax_int_code"];
		$this->geditinternalcode= $this->aobj_context->mobj_data["geditinternalcode"];
		$this->system_module_name= $this->aobj_context->mobj_data["system_module_name"];
		$item_tax_structure=$this->GetItemTaxStructureData($this->tax_int_code);
		$doc_tax_structure=$this->GetDocTaxStructureData($this->tax_int_code);
		$arr['item_tax_structure']=$item_tax_structure;
		 
		$arr['doc_html']=$this->FormDocTaxStructureHtmlData($doc_tax_structure,$this->system_module_name);
		echo $this->aobj_context->mobj_output->ToJSONEnvelope($arr,0,"success");
		
	}
	function GetDocTaxStructureData($tax_int_code)
	{
		
		$get_data="SELECT  tsg.internal_code AS doc_tax_grp_code,tc.name AS doc_tax_name,
					percentage AS doc_percentage,
					amount AS doc_amount,0 as group_int_code 					 
					FROM tax_structure t INNER JOIN tax_structure_details_group tsg ON t.internal_code=tsg.ref_s_ref_data_code
					INNER JOIN tax_components tc ON tc.internal_code=tsg.component
					WHERE tsg.level='Document'
					AND  t.internal_code={$tax_int_code} order by tsg.sequence
					";
		$lobj_get_file_id = $this->aobj_context->mobj_db->GetAll($get_data);		
		return 	$lobj_get_file_id;	
	}
	function GetItemTaxStructureData($tax_int_code)
	{
		
		$get_data="SELECT  tsg.internal_code AS itm_tax_grp_code,tc.name AS item_tax_name,
					percentage AS itm_percentage,0 as itm_val_per_qty,
					amount AS itm_amount,0 as group_int_code 					 
					FROM tax_structure t INNER JOIN tax_structure_details_group tsg ON t.internal_code=tsg.ref_s_ref_data_code
					INNER JOIN tax_components tc ON tc.internal_code=tsg.component
					WHERE tsg.level='Item'
					AND  t.internal_code={$tax_int_code}
					";
		$lobj_get_file_id = $this->aobj_context->mobj_db->GetAll($get_data);		
		return 	$lobj_get_file_id;	
	}
	function FormDocTaxStructureHtmlData($doc_obj,$system_module_name)
	{
			$table_data=" <div class='table-responsive'  id='div_doc_tax_structure' >  ";
				$table_data.="<table  class='table table-sm '  id='tbl_doc_tax_structure'> ";
				/* $table_data.="	<thead>";
				$table_data.="	<tr style='background:#F5F5F5;'>";
				$table_data.="	<th style='border-bottom:none;'>Sl</th>";
				$table_data.="	<th style='border-bottom:none;'>Desc</th>";
				$table_data.="	<th style='border-bottom:none;'>Perc</th>";
				$table_data.="	<th style='border-bottom:none;'>Amt</th>";
				$table_data.="	</thead>"; */
				$table_data.="	<tbody>";
				$tr_id=1;
				foreach($doc_obj as $ek=>$ev)
				{		
					$doc_tax_name=$ev['doc_tax_name'];
					$doc_percentage=$ev['doc_percentage'];
					$doc_amount=$ev['doc_amount'];
					$doc_tax_grp_code=$ev['doc_tax_grp_code'];
					$group_int_code=$ev['group_int_code'];

				 
					$table_data.="	<tr id='{$tr_id}'>";
					/* $table_data.="	<td style='border-bottom:none;'>{$tr_id}</td>"; */
					$table_data.="	<td style='border:none; text-align: right;' id='doc_tax_name_{$tr_id}'>{$doc_tax_name} &nbsp; &nbsp;</td>";
					$table_data.="	<td style='border:none; width:100px; '>
										<div class='input-icon right'>
											<i style='color: #000; margin-top: 3px;'>%</i>
											<input class='form-control input-sm' style='text-align:right; '  onkeypress='return acceptNumbersOnlyForModule(event);' onblur=\"Tax.HandleDocTaxDataOnBlur('{$system_module_name}',{$tr_id});\" id='doc_percentage_{$tr_id}' value='{$doc_percentage}' />
										</div>
									</td>";
					$table_data.="	<td style='border:none; width: 140px; '><input class='form-control input-sm' style='text-align:right; ' onkeypress='return acceptNumbersOnlyForModule(event);'   onblur=\"Tax.HandleDocTaxDataOnBlur('{$system_module_name}',{$tr_id});\" id='doc_amount_{$tr_id}' value='{$doc_amount}' />"; 
					$table_data.="	 <input type='hidden' id='doc_tax_grp_code_{$tr_id}' value='{$doc_tax_grp_code}' />" ;
					$table_data.="	 <input type='hidden' id='group_int_code_{$tr_id}' value='{$group_int_code}' /> </td>";

					$table_data.="	</tr>";
					$tr_id++;

				} 
				$table_data.="	</tbody></table>";
			return $table_data;	
	}
	//############################ After EDIT REASSIGN TAX STRUCTURE DATA############################
	function ReAssignAllTaxStructureDataAfterEditRecord()
	{
		$this->tax_int_code= $this->aobj_context->mobj_data["tax_int_code"];
		$this->system_module_name= $this->aobj_context->mobj_data["system_module_name"];
		$this->geditinternalcode= $this->aobj_context->mobj_data["geditinternalcode"];
		$this->tax_structure_doc_table= $this->aobj_context->mobj_data["tax_structure_doc_table"];
		$this->tax_structure_item_table= $this->aobj_context->mobj_data["tax_structure_item_table"];
		$this->tax_structure_item_tax_table= $this->aobj_context->mobj_data["tax_structure_item_tax_table"];
		$item_tax_structure=$this->GetItemTaxStructureData($this->tax_int_code);
		$doc_tax_structure=$this->GetDocTaxStructureDataAfterEdit($this->geditinternalcode,$this->tax_structure_doc_table);
	 
		$saved_item_tax_structure=$this->GetItemTaxStructureDataAfterEdit($this->geditinternalcode,$this->tax_structure_item_table,$this->tax_structure_item_tax_table);
		// die();
		$arr['item_tax_structure']=$item_tax_structure;
		$arr['saved_item_tax_structure']=$saved_item_tax_structure;
		$arr['doc_html']=$this->FormDocTaxStructureHtmlData($doc_tax_structure,$this->system_module_name);
		echo $this->aobj_context->mobj_output->ToJSONEnvelope($arr,0,"success");
	}
	function GetDocTaxStructureDataAfterEdit($geditinternalcode,$tax_structure_doc_table)
	{
		
		$get_data="SELECT  tsg.internal_code AS doc_tax_grp_code,tc.name AS doc_tax_name,
				IFNULL(doc.doc_percentage,tsg.percentage) AS doc_percentage,
				IFNULL(doc.doc_amount,tsg.amount) AS doc_amount,IFNULL(doc.internal_code,0) AS group_int_code 					 
				FROM tax_structure t INNER JOIN tax_structure_details_group tsg ON t.internal_code=tsg.ref_s_ref_data_code
				INNER JOIN tax_components tc ON tc.internal_code=tsg.component
				LEFT JOIN {$tax_structure_doc_table} doc ON doc.doc_tax_grp_code=tsg.internal_code 
				WHERE tsg.level='Document' AND doc.ref_s_ref_data_code={$geditinternalcode}
					";
				
		$lobj_get_file_id = $this->aobj_context->mobj_db->GetAll($get_data);	
 
		return 	$lobj_get_file_id;	
	}
	function GetItemTaxStructureDataAfterEdit($geditinternalcode,$tax_structure_item_table,$tax_structure_item_tax_table)
	{
		
		$get_data="SELECT  grp_itm.internal_code as itm_grp_int_code,tsg.internal_code AS itm_tax_grp_code,tc.name AS item_tax_name,
						IFNULL(grp_tax.itm_percentage,tsg.percentage) AS itm_percentage,
						IFNULL(grp_tax.itm_amount,tsg.amount) AS itm_amount,
						IFNULL(grp_tax.itm_val_per_qty,0) AS itm_val_per_qty,
						IFNULL(grp_tax.internal_code,0) AS group_int_code 					 
						FROM tax_structure t INNER JOIN tax_structure_details_group tsg ON t.internal_code=tsg.ref_s_ref_data_code
						INNER JOIN tax_components tc ON tc.internal_code=tsg.component
						LEFT JOIN {$tax_structure_item_tax_table} grp_tax ON grp_tax.itm_tax_grp_code=tsg.internal_code
						LEFT JOIN {$tax_structure_item_table} grp_itm ON grp_itm.internal_code=grp_tax.ref_s_ref_data_code
						WHERE grp_itm.ref_s_ref_data_code={$geditinternalcode}
						AND tsg.level='Item'
						ORDER BY grp_itm.internal_code,tsg.sequence
					";
		$lobj_get_file_id = $this->aobj_context->mobj_db->GetAll($get_data);	
		$item_tax_arr=array();	
		$i=0;
		 foreach($lobj_get_file_id as $ak=>$av)
		 {
			 $item_tax_arr[$av['itm_grp_int_code']][$i]['itm_tax_grp_code']=$av['itm_tax_grp_code'];
			 $item_tax_arr[$av['itm_grp_int_code']][$i]['item_tax_name']=$av['item_tax_name'];
			 $item_tax_arr[$av['itm_grp_int_code']][$i]['itm_percentage']=$av['itm_percentage'];
			 $item_tax_arr[$av['itm_grp_int_code']][$i]['itm_val_per_qty']=$av['itm_val_per_qty'];
			 $item_tax_arr[$av['itm_grp_int_code']][$i]['itm_amount']=$av['itm_amount'];
			 $item_tax_arr[$av['itm_grp_int_code']][$i]['group_int_code']=$av['group_int_code'];
			 $i++;
		 }
		 
		 return($item_tax_arr);
	}
	function CalcItemCommercialsFromScreen()
	{
		  
		  $row_id = stripslashes($this->aobj_context->mobj_data["row_id"]);
		  $group_details_arr = stripslashes($this->aobj_context->mobj_data["item_row_obj"]);
		$mobj_group_details_arr = $this->json->decode($group_details_arr);
		$item_row_obj = object_to_array($mobj_group_details_arr); 
		  
		  $o_group_details_arr = stripslashes($this->aobj_context->mobj_data["other_item_row_obj"]);
		$o_mobj_group_details_arr = $this->json->decode($o_group_details_arr);
		$other_item_row_obj = object_to_array($o_mobj_group_details_arr); 
		  
		  $o_doc_row_obj_arr = stripslashes($this->aobj_context->mobj_data["doc_row_obj"]);
		$o_o_doc_row_obj_arr_arr = $this->json->decode($o_doc_row_obj_arr);
		$doc_row_obj = object_to_array($o_o_doc_row_obj_arr_arr); 
	
		
 
			$all_item_tax_row_data_arr=array();
			foreach($item_row_obj as $row_id=>$row_val)
			{
			 $fin_arr=$this->CalcItemCommercials($row_val);	
		  
			$all_item_tax_row_data_arr[$row_id]=$fin_arr;
			} 
			/*  echo "<pre>";
			 print_r($all_item_tax_row_data_arr);
			 print_r($other_item_row_obj);die();	 */
			 
			 $all_item_tax_arr=array_merge_custom($all_item_tax_row_data_arr,$other_item_row_obj);
			 $summmed_item_tax_arr=$this->SumAllItemCommercialsArr($all_item_tax_arr);
			/*  echo "<pre>";
			 print_r($summmed_item_tax_arr);die(); */
			/*  $doc_row_val['doc_row_obj']=$doc_row_obj;
			 $doc_row_val['all_item_tax_arr']=$summmed_item_tax_arr; */
			 $doc_tax_arr=$this->CalcDocCommFormula($doc_row_obj,$summmed_item_tax_arr);		
			 
			$arr['all_item_tax_row_data_arr']=$all_item_tax_row_data_arr;
			$arr['doc_tax_arr']=$doc_tax_arr;
			echo $this->aobj_context->mobj_output->ToJSONEnvelope($arr,0,"success");
	}
	function CalcDocCommercialsFromScreen()
	{
		 
			$group_details_arr = stripslashes($this->aobj_context->mobj_data["item_row_obj"]);
			$mobj_group_details_arr = $this->json->decode($group_details_arr);
			$item_row_obj = object_to_array($mobj_group_details_arr); 

			$o_doc_row_obj_arr = stripslashes($this->aobj_context->mobj_data["doc_row_obj"]);
			$o_o_doc_row_obj_arr_arr = $this->json->decode($o_doc_row_obj_arr);
			$doc_row_obj = object_to_array($o_o_doc_row_obj_arr_arr); 

			$summmed_item_tax_arr=$this->SumAllItemCommercialsArr($item_row_obj);
			$doc_tax_arr=$this->CalcDocCommFormula($doc_row_obj,$summmed_item_tax_arr);		
			$arr['doc_tax_arr']=$doc_tax_arr;
			echo $this->aobj_context->mobj_output->ToJSONEnvelope($arr,0,"success");
	}
}
function GetFreshTaxDataOnSelectOfTaxIntCode($aobj_context)
{
	$dash_obj=new commercials($aobj_context);		
	$dash_obj->GetFreshTaxDataOnSelectOfTaxIntCode();
}
function ReAssignAllTaxStructureDataAfterEditRecord($aobj_context)
{
	$dash_obj=new commercials($aobj_context);		
	$dash_obj->ReAssignAllTaxStructureDataAfterEditRecord();
}
function CalcItemCommercialsFromScreen($aobj_context)
{
	$dash_obj=new commercials($aobj_context);		
	$dash_obj->CalcItemCommercialsFromScreen();
}
function CalcDocCommercialsFromScreen($aobj_context)
{
	$dash_obj=new commercials($aobj_context);		
	$dash_obj->CalcDocCommercialsFromScreen();
}
function array_merge_custom($first, $second) {
    $result = array();
    foreach($first as $key => $value) {
        $result[$key] = $value;
    }
    foreach($second as $key => $value) {
        $result[$key] = $value;
    }

    return $result;
}

?>