<?php

if (!class_exists("PartialSmtpConnectionIO")) Mock::GeneratePartial("Swift_Connection_SMTP", "PartialSmtpConnectionIO", array("read", "write"));

class TestOfLOGINAuthenticator extends UnitTestCase
{
	public function testAuthenticatorSendsCorrectlyFormattedBase64EncodedRequests()
	{
		$auth = new Swift_Authenticator_LOGIN();
		$smtp = new PartialSmtpConnectionIO();
		$smtp->setReturnValueAt(0, "read", "334 " . base64_encode("username:"));
		$smtp->setReturnValueAt(1, "read", "334 " . base64_encode("password:"));
		$smtp->setReturnValueAt(2, "read", "235 Authenticated");
		$smtp->expectAt(0, "write", array("AUTH LOGIN", "*"));
		$smtp->expectAt(1, "write", array(base64_encode("foo"), "*"));
		$smtp->expectAt(2, "write", array(base64_encode("bar"), "*"));
		
		$smtp->setExtension("AUTH", array("LOGIN"));
		$smtp->setUsername("foo");
		$smtp->setPassword("bar");
		$smtp->attachAuthenticator($auth);
		$smtp->postConnect(new Swift($smtp, "xx", Swift::NO_START));
	}
	
	public function testExceptionIsThrownIfBadResponseReceived()
	{
		try {
			$auth = new Swift_Authenticator_LOGIN();
			$smtp = new PartialSmtpConnectionIO();
			$smtp->setReturnValueAt(0, "read", "334 " . base64_encode("username:"));
			$smtp->setReturnValueAt(1, "read", "400 No");
			$smtp->setReturnValueAt(2, "read", "400 No");
			
			$smtp->setExtension("AUTH", array("LOGIN"));
			$smtp->setUsername("foo");
			$smtp->setPassword("bar");
			$smtp->attachAuthenticator($auth);
			$smtp->postConnect(new Swift($smtp, "xx", Swift::NO_START));
			$this->fail("This should have failed since a 334 and 235 response were wanted.");
		} catch (Swift_Connection_Exception $e) {
			//Pass
		}
	}
	
	public function testRSETIsSentOnFailure()
	{
		try {
			$auth = new Swift_Authenticator_LOGIN();
			$smtp = new PartialSmtpConnectionIO();
			$smtp->setReturnValueAt(0, "read", "334 " . base64_encode("username:"));
			$smtp->setReturnValueAt(1, "read", "400 No");
			$smtp->setReturnValueAt(2, "read", "400 No");
			$smtp->expectAt(0, "write", array("AUTH LOGIN", "*"));
			$smtp->expectAt(1, "write", array(base64_encode("foo"), "*"));
			$smtp->expectAt(2, "write", array("RSET", "*"));
			$smtp->setExtension("AUTH", array("LOGIN", "*"));
			$smtp->setUsername("foo");
			$smtp->setPassword("bar");
			$smtp->attachAuthenticator($auth);
			$smtp->postConnect(new Swift($smtp, "xx", Swift::NO_START));
			$this->fail("This should have failed since a 334 and 235 response were wanted.");
		} catch (Swift_Connection_Exception $e) {
			//Pass
		}
	}
}
