<?php

class TestOfImage extends UnitTestCase
{
	public function testImageTypeIsDetected()
	{
		$image = new Swift_Message_Image(new Swift_File("../files/manchester.jpeg"));
		$this->assertEqual("image/jpeg", $image->getContentType());
		
		$image = new Swift_Message_Image(new Swift_File("../files/gecko.png"));
		$this->assertEqual("image/png", $image->getContentType());
		
		$image = new Swift_Message_Image(new Swift_File("../files/durham.gif"));
		$this->assertEqual("image/gif", $image->getContentType());
	}
	
	public function testExceptionIsThrownIfWrongFileTypeGiven()
	{
		try {
			$image = new Swift_Message_Image(new Swift_File("../files/cv.pdf"));
			$this->fail("This should have thrown an exception since PDF is not an image");
		} catch (Swift_Message_MimeException $e) {
			//Pass
		}
	}
}
