<?php

class TestOfDefaultLog extends UnitTestCase
{
	public function testLoggerAddsEntriesWithLabelPrepended()
	{
		$log = new Swift_Log_DefaultLog();
		$log->add("xxx", ">>"); //Swift_Log::COMMAND
		ob_start();
		$log->dump();
		$dump = ob_get_clean();
		$this->assertPattern("~>> xxx\\b~", $dump);
		
		$log = new Swift_Log_DefaultLog();
		$log->add("xxx", "++"); //Swift_Log::COMMAND
		ob_start();
		$log->dump();
		$dump = ob_get_clean();
		$this->assertPattern("~\\+\\+ xxx\\b~", $dump);
	}
	
	public function testDumpReturnsRecordsSeparatedByLF()
	{
		$log = new Swift_Log_DefaultLog();
		$log->add("xxx", ">>");
		$log->add("yyy", "!!");
		ob_start();
		$log->dump();
		$dump = ob_get_clean();
		$this->assertPattern("~>> xxx\n!! yyy\\b~", $dump);
	}
	
	public function testNoMoreThanMaxEntriesAreStored()
	{
		$log = new Swift_Log_DefaultLog();
		$log->setMaxSize(10);
		for ($i = 0; $i < 100; $i++)
		{
			$log->add(rand(), ">>");
		}
		ob_start();
		$log->dump();
		$dump = ob_get_clean();
		$lines = explode("\n", $dump);
		$this->assertEqual(10, count($lines));
		
		$log->setMaxSize(11);
		for ($i = 0; $i < 100; $i++)
		{
			$log->add(rand(), ">>");
		}
		ob_start();
		$log->dump();
		$dump = ob_get_clean();
		$lines = explode("\n", $dump);
		$this->assertEqual(11, count($lines));
	}
	
	public function testLastEntryInTruncatedLogIsNewset()
	{
		$log = new Swift_Log_DefaultLog();
		$log->setMaxSize(10);
		for ($i = 0; $i < 100; $i++)
		{
			$log->add(rand(), ">>");
		}
		$log->add("Foo", "!!");
		$log->add("Bar", "<<");
		
		ob_start();
		$log->dump();
		$dump = ob_get_clean();
		$lines = explode("\n", $dump);
		$this->assertEqual("<< Bar", $lines[count($lines)-1]);
	}
	
	public function testLogSizeOfZeroIsIgnored()
	{
		$log = new Swift_Log_DefaultLog();
		$log->setMaxSize(0);
		for ($i = 0; $i < 100; $i++)
		{
			$log->add(rand(), ">>");
		}
		
		ob_start();
		$log->dump();
		$dump = ob_get_clean();
		$lines = explode("\n", $dump);
		$this->assertTrue(count($lines) >= 100);
	}
	
	public function testClearEmptiesTheLog()
	{
		$log = new Swift_Log_DefaultLog();
		$log->setMaxSize(0);
		for ($i = 0; $i < 100; $i++)
		{
			$log->add(rand(), ">>");
		}
		$log->clear();
		ob_start();
		$log->dump();
		$dump = ob_get_clean();
		$this->assertEqual("", $dump);
	}
}
