<?php
class notice_board
{
	public $internal_code;
	
	function __construct($aobj_context)
	{
		session_start();
		$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->aobj_context=$aobj_context;
		$this->user_id = $_SESSION['user_id'];
		require_once($this->aobj_context->main_src."/src/format.php");
	}
	function GetDisplayToGroupData()
	{
		$geditinternalcode = $this->aobj_context->mobj_data["geditinternalcode"];
		
		$get_dept_list="SELECT
						  IFNULL(b.is_select_dept,0) AS is_select_dept,
						  IFNULL(b.department,d.internal_code) AS department,
						  IFNULL(b.txt_ref_schema_department,d.name) AS txt_ref_schema_department
						FROM department d
						  LEFT JOIN (SELECT
									   IF(nbdg.is_select_dept = 1,'checked','') AS is_select_dept,
									   d.internal_code AS department,
									   d.NAME          AS txt_ref_schema_department
									 FROM notice_board nb
									   INNER JOIN notice_board_department_group nbdg
										 ON nbdg.ref_s_ref_data_code = nb.internal_code
									   LEFT JOIN department d
										 ON d.internal_code = nbdg.department
									 WHERE nb.internal_code = {$geditinternalcode}) b
							ON b.department = d.internal_code";

		$lobj_get_dept_list = $this->aobj_context->mobj_db->GetAll($get_dept_list);	
		
		$get_emp_list="SELECT
						  IFNULL(b.is_select_emp,0) AS is_select_emp,
						  IFNULL(b.employee,e.internal_code) AS employee,
						  IFNULL(b.txt_ref_schema_employee,e.real_name) AS txt_ref_schema_employee
						FROM s_sysdb e
						  LEFT JOIN (SELECT
									   IF(nbeg.is_select_emp = 1,'checked','') AS is_select_emp,
									   e.internal_code AS employee,
									   e.real_name          AS txt_ref_schema_employee
									 FROM notice_board nb
									   INNER JOIN notice_board_employee_group nbeg
										 ON nbeg.ref_s_ref_data_code = nb.internal_code
									   LEFT JOIN s_sysdb e
										 ON e.internal_code = nbeg.employee
									 WHERE nb.internal_code = {$geditinternalcode}) b
							ON b.employee = e.internal_code";

		$lobj_get_emp_list = $this->aobj_context->mobj_db->GetAll($get_emp_list);
		
		$arr['dept_data']=$lobj_get_dept_list;
		$arr['emp_data']=$lobj_get_emp_list;
		echo $this->aobj_context->mobj_output->ToJSONEnvelope($arr,0,"success");  		
	}
	function GetNoticeDataForDashboard()
	{
		$get_notice_board_data = "SELECT 
									DISTINCT a.nb_int_code,
									DATE_FORMAT(a.nb_date,'%d-%b-%y') AS nb_date,
									a.nb_subject,
									a.nb_msg_type 
								FROM (SELECT
										  nb.internal_code AS nb_int_code,
										  nb.date          AS nb_date,
										  nb.subject       AS nb_subject,
										  nb.message_type AS nb_msg_type
										FROM notice_board nb
										WHERE nb.display_to = 'All' AND DATE_FORMAT(NOW(),'%Y-%m-%d') BETWEEN nb.from_date AND nb.to_date 
										UNION ALL 
										SELECT
											nb.internal_code  AS nb_int_code,
											nb.date           AS nb_date,
											nb.subject        AS nb_subject,
											nb.message_type AS nb_msg_type
										FROM notice_board nb
											INNER JOIN notice_board_department_group nbdg
												ON nbdg.ref_s_ref_data_code = nb.internal_code
											LEFT JOIN s_sysdb um
												ON um.user_dept = nbdg.department
										WHERE nb.display_to = 'Department' AND um.internal_code = {$this->user_id} AND DATE_FORMAT(NOW(),'%Y-%m-%d') BETWEEN nb.from_date AND nb.to_date 
										UNION ALL 
										SELECT
											nb.internal_code   AS nb_int_code,
											nb.date            AS nb_date,
											nb.subject         AS nb_subject,
											nb.message_type AS nb_msg_type
										FROM notice_board nb
											INNER JOIN notice_board_employee_group nbeg
												ON nbeg.ref_s_ref_data_code = nb.internal_code
											LEFT JOIN s_sysdb uma
												ON uma.internal_code = nbeg.employee
										WHERE nb.display_to = 'Employee' AND uma.internal_code = {$this->user_id} AND DATE_FORMAT(NOW(),'%Y-%m-%d') BETWEEN nb.from_date AND nb.to_date) a
										ORDER BY nb_date ASC";
								
		$lobj_get_notice_board_data =  $this->aobj_context->mobj_db->GetAll($get_notice_board_data);
		
		$html = '';
		foreach($lobj_get_notice_board_data as $ak=>$av)
		{
			$nb_int_code = $av['nb_int_code'];
			$nb_date = $av['nb_date'];
			$nb_subject = $av['nb_subject'];
			$nb_msg_type = $av['nb_msg_type'];
			
			$msg_icon = "";
			if($nb_msg_type == "Circular")
			{
				$msg_icon = "fa fa-file-o";
				$icon_clr = "#2cabe3";
			}
			else if($nb_msg_type == "Notice")
			{
				$msg_icon = "fa fa-bell-o";
				$icon_clr = "#ffc36d";
			}
			else if($nb_msg_type == "Announcement")
			{
				$msg_icon = "fa fa-bullhorn";
				$icon_clr = "#ff7676";
			}
			else if($nb_msg_type == "Greetings")
			{
				$msg_icon = "fa fa-gift";
				$icon_clr = "#707cd2";
			}	
			
			$html.="<li>
						<a href='javascript:;' onclick=\"NoticeBoard.OpenNoticeDetailsInPopup({$nb_int_code});\">
							<i class='{$msg_icon} pull-left tooltip-primary' data-placement='right' data-toggle='tooltip' data-original-title='{$nb_msg_type}' style='color:{$icon_clr};font-size:21px;'></i>&nbsp;&nbsp;
							<span style='overflow: hidden ! important; text-overflow: ellipsis; white-space: nowrap; width: 162px; display: -moz-inline-box; font-weight: 600;'>	{$nb_subject}
							</span>
							<span class='pull-right'>{$nb_date}</span>
						</a>
					</li>";
		}
		echo $this->aobj_context->mobj_output->ToJSONEnvelope($html,0,"success");  									
	}
	function GetNoticeDetailsForPopup()
	{
		$nb_int_code = $this->aobj_context->mobj_data["nb_int_code"];
		
		$get_notice_msg_details = "SELECT
									  nb.internal_code AS nb_int_code,
									  DATE_FORMAT(nb.date,'%d-%b-%y') AS nb_date,
									  nb.subject       AS nb_subject,
									  nb.message_type AS nb_msg_type,
									  nb.message	AS nb_msg 		
									FROM notice_board nb
									WHERE nb.internal_code = {$nb_int_code}";

		$lobj_get_notice_msg_details =  $this->aobj_context->mobj_db->GetRow($get_notice_msg_details);
		
		$nb_date = $lobj_get_notice_msg_details['nb_date'];
		$nb_subject = $lobj_get_notice_msg_details['nb_subject'];
		$nb_msg_type = $lobj_get_notice_msg_details['nb_msg_type'];
		$nb_msg = $lobj_get_notice_msg_details['nb_msg'];
		
		$msg_icon = "";
		if($nb_msg_type == "Circular")
		{
			$msg_icon = "fa fa-file-o";
			$icon_clr = "#2cabe3";
		}
		else if($nb_msg_type == "Notice")
		{
			$msg_icon = "fa fa-bell-o";
			$icon_clr = "#ffc36d";
		}
		else if($nb_msg_type == "Announcement")
		{
			$msg_icon = "fa fa-bullhorn";
			$icon_clr = "#ff7676";
		}
		else if($nb_msg_type == "Greetings")
		{
			$msg_icon = "fa fa-gift";
			$icon_clr = "#707cd2";
		}	
		
		$html = '<table cellspacing="0" cellpadding="0" border="0" style="width: 100%;">
					<tbody>
					  <tr>
						<td>
							<p><b><i class="'.$msg_icon.'" style="color:'.$icon_clr.'"></i> &nbsp;'.$nb_msg_type.' <span class="pull-right">'.$nb_date.'</span></b></p>
							<p><b>Subject : </b>'.$nb_subject.'</p>
							<p><b>Message : </b>'.$nb_msg.'</p>
							<b>- Thanks (Admin team) <br></b> 
						</td>
					  </tr>
					</tbody>
				</table>';

		echo $this->aobj_context->mobj_output->ToJSONEnvelope($html,0,"success");  									
	}
}
function GetDisplayToGroupData($aobj_context)
{
	$notice_obj=new notice_board($aobj_context);	
	$notice_obj->GetDisplayToGroupData();
}
function GetNoticeDataForDashboard($aobj_context)
{
	$notice_obj=new notice_board($aobj_context);	
	$notice_obj->GetNoticeDataForDashboard();
}
function GetNoticeDetailsForPopup($aobj_context)
{
	$notice_obj=new notice_board($aobj_context);	
	$notice_obj->GetNoticeDetailsForPopup();
}
