<?php
class dynamicmastersdetailsnew
{
	function __construct($aobj_context)
	{
		session_start();
		$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->aobj_context=$aobj_context;
		$this->login_cnt = $_SESSION['login_cnt'];
		$this->user_id = $_SESSION['user_id'];
		require_once($this->aobj_context->main_src."/src/json.php");
		require_once($this->aobj_context->main_src."/src/format.php");
		require_once($this->aobj_context->main_src."/src/approvals.php");
		$this->json = new Services_JSON();
		$path= $this->aobj_context->main_src."/src/log_information.php"; 	
		require_once($path);
		$this->log = new log_information($this->aobj_context);
	}
	
	function object_to_array($data) 
	{
		if ((! is_array($data)) and (! is_object($data))) return 'xxx'; //$data;

		$result = array();

		$data = (array) $data;
		foreach ($data as $key => $value)
		{
			if (is_object($value)) $value = (array)(($value));
			if (is_array($value)) 
				$result[$key] = $this->object_to_array($value);
			else
				$result[$key] = $value;
		}
		return $result;
	}

	function AssignParamsValues()		
	{
		$this->save_obj_data = json_decode(file_get_contents('php://input'), true);
		$this->AssignFWParamsValues($this->save_obj_data,"UI");
	}
	
	function GetSystemNamePropertiesForModule($module_id)
	{
		$get_data="SELECT system_name,t.value AS data_type
						FROM s_user_schema_elements su 
						INNER JOIN s_ref_type t  ON t.internal_code=su.data_type
						WHERE su.ref_s_user_schema_code={$module_id}";
		$lobj_get_data = $this->aobj_context->mobj_db->GetAll($get_data);	
		$this->system_name_prop_arr=array();
		foreach($lobj_get_data as $ak=>$av)
		{
			$this->system_name_prop_arr[$av['system_name']]['data_type']=$av['data_type'];
		}	
	}
	
	function AssignFWParamsValues($save_obj_data,$call_type)//$call_type is UI,BackEnd
	{
		$this->call_type=$call_type;
		$this->system_module_table_name=$save_obj_data["system_module_table_name"];
	 
		$this->schema_id=$save_obj_data["ref_s_user_schema_code"];
		$this->root_file_name=$this->aobj_context->main_src."/validation_files/validate_{$this->system_module_table_name}.php";
		if (file_exists($this->root_file_name)) 
		{
			require_once($this->root_file_name);
		}
		$this->internal_code=$save_obj_data["internal_code"];
		$this->larr_save_data = $save_obj_data["save_schema_details_arr"]; 
		$this->group_details_arr = $save_obj_data["group_details_arr"];  
		$this->g_system_names_full_arr = $save_obj_data["g_system_names_full_arr"];  
	
		$this->GetSystemNamePropertiesForModule($this->schema_id);
		$this->CretaeImageFolderPath();
		$this->FormInsertUpdateCommands();
		$this->CallValidateFile();
		return $this->handleSaveEvents();
	}
	
	//create image folder path
	function CretaeImageFolderPath()
	{
		$this->user_image_folder_path = $this->aobj_context->main_src."/user_images/{$this->system_module_table_name}";
		mkdir($this->user_image_folder_path);
	}
	
	//Handle Images 
	function HandleImageSave()
	{
		$image_data = $this->save_obj_data['image_data'];
	 
		if(!empty($image_data))
		{
			foreach($image_data as $k=>$v)
			{
				$system_name=$k;
				$field_path = $this->user_image_folder_path."/".$system_name;
				mkdir($field_path);
				$image_base64_encoaded=urldecode($v['data']);
				
				$image_class=urldecode($v['class']);
				$file_name=urldecode($v['file_name']);
				$file_path=$this->last_inserted_id."_".$file_name;
				$image_path = $field_path."/".$file_path;
				
				$image_content=explode('base64,',$image_base64_encoaded);
				$image_header=explode('/',$image_content[0]);
				$image_type=$image_header[1];
				$image_type=substr($image_type,0,strlen($image_type)-1);
				$db_path = "user_images/{$this->system_module_table_name}/{$system_name}/{$file_path}";
				$image_data=str_replace(' ', '+', $image_content[1]);
				$image_data = base64_decode($image_data);
				
				if($this->save_type=='New')
				{
					if(!empty($file_name))
					{
						$success = file_put_contents($image_path, $image_data);
						$this->UpdateImagePaths($this->system_module_table_name,$system_name,$db_path,$this->last_inserted_id);
					}
				}
				else
				{
					if(empty($file_name) && $image_class=='fileinput fileinput-new')
					$this->GetImagePathAndDelete($this->system_module_table_name,$system_name,$this->last_inserted_id);
					
					elseif(!empty($file_name) && $image_class=='fileinput fileinput-exists')
					{
						$success = file_put_contents($image_path, $image_data);
						$this->UpdateImagePaths($this->system_module_table_name,$system_name,$db_path,$this->last_inserted_id);
					}
				}	
			}
		}
	}
	
	function UploadAttachment()
	{
		$attachment_data = $this->save_obj_data['attachment_data'];
		
		if(!empty($attachment_data))
		{
			foreach($attachment_data as $k=>$v)
			{
				$system_name=$k;
				$field_path = $this->user_image_folder_path."/".$system_name;
				mkdir($field_path);
				$file_base64_encoaded=urldecode($v['file_content']);
				
				$file_name=urldecode($v['file_name']);
				$attach_state=$v['attach_state'];
				
				$file_path=$this->last_inserted_id."_".$file_name;
				$file_store_path = $field_path."/".$file_path;
				
				$db_path = "user_images/{$this->system_module_table_name}/{$system_name}/{$file_path}";
				// $file_ext = end(explode('.', $file_name));
				$file_content=explode('base64,',$file_base64_encoaded);
				$file_data=str_replace(' ', '+', $file_content[1]);
				$file_data = base64_decode($file_data);
				
				if($this->internal_code==0)
				{
					if(!empty($file_name))
					{
						$success = file_put_contents($file_store_path, $file_data);
						 $this->UpdateImagePaths($this->system_module_table_name,$system_name,$db_path,$this->last_inserted_id);
					}
				}
				else
				{
					if($attach_state=='Delete')
					{
						$this->GetImagePathAndDelete($this->system_module_table_name,$system_name,$this->last_inserted_id);
					}
					elseif($attach_state=='New')
					{
						$this->GetImagePathAndDelete($this->system_module_table_name,$system_name,$this->last_inserted_id);
						$success = file_put_contents($file_store_path, $file_data);
						$this->UpdateImagePaths($this->system_module_table_name,$system_name,$db_path,$this->last_inserted_id);
					}
				}	
			}
		}
	}
	
	function HandleGroupImages($group_table_name,$group_img_arr)
	{
		foreach($group_img_arr as $k=>$system_name_arr)
		{
			$group_int_code = $k;
			foreach($system_name_arr as $sk=>$sv)
			{
				$system_name=$sk;
				$image_data = urldecode($sv['image_data']);
				 
				$image_type = urldecode($sv['image_type']);
				$file_name = urldecode($sv['image_name']);
			
				$field_path = $this->user_image_folder_path."/".$system_name;
				mkdir($field_path);
				$image_base64_encoaded=urldecode($image_data);
				
				$file_path=$group_int_code."_".$file_name;
				$image_path = $field_path."/".$file_path;
				
				$image_content=explode('base64,',$image_base64_encoaded);
				$db_path = "user_images/{$this->system_module_table_name}/{$system_name}/{$file_path}";
				$image_data=str_replace(' ', '+', $image_content[1]);
				$image_data = base64_decode($image_data);
				if($this->save_type=='New')
				{
					if($image_type=='new-image' || $image_type=='New')//second check we are handling for attachment
					{
						$success = file_put_contents($image_path, $image_data);
						$this->UpdateImagePaths($group_table_name,$system_name,$db_path,$group_int_code);
					}
				}
				else
				{
					if($image_type=='new-image' || $image_type=='New')//second check we are handling for attachment
					{
						$success = file_put_contents($image_path, $image_data);
						$this->UpdateImagePaths($group_table_name,$system_name,$db_path,$group_int_code);
					}
					elseif($image_type=='no-image' || $image_type=="Delete")
					{
						$this->GetImagePathAndDelete($group_table_name,$system_name,$group_int_code);
					}
				}
			}	
		}
	}
	
	function GetImagePathAndDelete($table_name,$system_name,$internal_code)
	{
		$get_data="select {$system_name} as image_path from {$table_name} 
					WHERE internal_code='{$internal_code}'";
		$lobj_get_data = $this->aobj_context->mobj_db->GetRow($get_data);	
		$image_path=$this->aobj_context->main_src."/".$lobj_get_data['image_path'];
		unlink($image_path);
		$this->UpdateImagePaths($table_name,$system_name,"",$internal_code);
	}
	
	function UpdateImagePaths($table_name,$system_name,$val,$internal_code)
	{
		$update_qry = " UPDATE {$table_name}
						SET {$system_name}='{$val}'
						WHERE internal_code='{$internal_code}'";
		$lobj_update_qry = $this->aobj_context->mobj_db->Execute($update_qry);
	}

	function FormInsertUpdateCommands()
	{
		$this->insert_cols="";
		$this->insert_col_values="";
		$this->update_col_values="";
		$this->update_auto_inc_array=array();
		// print_r($this->larr_save_data);
		foreach($this->larr_save_data as $pk=>$pv)
		{
			$this->insert_cols.=$pk.",";
			$system_name=$pk;
			$o_cell_val=addslashes(urldecode($pv));
		 
			$data_type=$this->system_name_prop_arr[$system_name]['data_type'];
			$cell_val="'{$o_cell_val}'";
		 
			if($data_type=="Date")
			{
				if(empty($o_cell_val) || $o_cell_val=="00/00/0000"|| $o_cell_val=="null" ) 
					$cell_val=" NULL ";	
				else 
					$cell_val="'".db_date_format($o_cell_val)."'";	
			}
			else if($data_type=="DateTime")
			{
				if(empty($o_cell_val) || $o_cell_val=="00/00/0000 00:00" ) 
					$cell_val=" NULL ";	
				else 
					$cell_val="'".db_date_format_time($o_cell_val)."'";	
			}
			$this->insert_col_values.= $cell_val.",";		
			$this->update_cond.=$pk."= ".$cell_val.",";
		}
		$this->insert_cols=substr($this->insert_cols,0,strlen($this->insert_cols)-1);
		$this->insert_col_values=substr($this->insert_col_values,0,strlen($this->insert_col_values)-1);
		$this->update_cond.=" modified_by={$this->user_id}, modified_date=now() ";
		$this->update_qry=" update {$this->system_module_table_name} set {$this->update_cond} where internal_code={$this->internal_code}";
	}
	
	function CallValidateFile()
	{
		// echo "<pre>";
		// print_r($this->g_system_names_full_arr);die();
		$error_span="";
		
		foreach($this->larr_save_data as $system_name=>$system_val)
		{
			$cell_val=addslashes(urldecode($system_val));
			$data_type=$this->g_system_names_full_arr[$system_name]['Type'];
			$optional=$this->g_system_names_full_arr[$system_name]['optional'];
			$element_name=$this->g_system_names_full_arr[$system_name]['element_name'];
			$number_range_from=$this->g_system_names_full_arr[$system_name]['number_range_from'];
			$number_range_to=$this->g_system_names_full_arr[$system_name]['number_range_to'];
			$is_ref_module_code_lov=$this->g_system_names_full_arr[$system_name]['is_ref_module_code_lov'];
			
			if($optional==0)
			{
				if($data_type=="Text" && empty($cell_val))
				{
					$error_span.="<span class='clearfix' style='color:red'><b>{$element_name}</b> cannot be Empty</span>";
				}
				else if($data_type=="Large Text" && empty($cell_val))
				{
					$error_span.="<span class='clearfix' style='color:red'><b>{$element_name}</b> cannot be Empty</span>";
				}
				else if($data_type=="Number")
				{
					if($number_range_from!=0 && $number_range_to!=0)
					{
						if($cell_val<$number_range_from || $cell_val>$number_range_to)
							$error_span.="<span class='clearfix' style='color:red'><b>{$element_name}</b> should be between {$number_range_from} and {$number_range_to} </span>";
					}
				}
				else if($data_type=="Email")
				{
					if(!$this->HandleEmailValidation($cell_val))
						$error_span.="<span class='clearfix' style='color:red'><b>{$cell_val}</b> is Invalid Email Id</span>";
				}
				else if($data_type=="Reference Data" && empty($cell_val))
				{
					$error_span.="<span class='clearfix' style='color:red'><b>{$element_name}</b> cannot be Empty</span>";
				}
				if($data_type=="Date" && (empty($cell_val) || $cell_val=="0000-00-000" || $cell_val=="00/00/0000"))
				{
					$error_span.="<span class='clearfix' style='color:red'><b>{$element_name}</b> cannot be Empty</span>";
				}
			}
		}
		
		if(!empty($error_span))
		{
			$_SESSION['error_flag']=0;
			if($this->call_type == 'UI')
			{
				$rdata['msg']=$error_span;
				echo $this->aobj_context->mobj_output->ToJSONEnvelope($rdata,-1,"Failure");
				return 	$rdata;
			}
			else
			{
				$mod_arr['status_code'] = 0;
				$mod_arr['message'] = $error_span;
				return 	$rdata;
			}
		}
		$_SESSION['error_flag']=1;		 
 
		if($_SESSION['error_flag']==1 && function_exists('validate'))
		{
			validate($this); 
		}
	}
	
	function HandleEmailValidation($mail)
	{
		return (!preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]+\.)+[a-z]{2,6}$/ix", $mail)) ? false : true;
	}
	
	function handleSaveEvents()
	{
		if($_SESSION['error_flag']==1)
		{
			if($this->internal_code==0)
			{
				$this->save_type='New';
				return $this->InsertNewRecord();
			}	
			else  
			{
				$this->save_type='Edit';
				$this->UpdateExistingRecord();
			}	
		}
	}
	
	function FormGroupUpdateInsertCommands($group_table_name,$full_arr,$ref_s_ref_data_code)
	{
		$existing_grp_arr=array();
		if($this->save_type=='Edit')
		{
			$get_existing_records="select internal_code from {$group_table_name} where ref_s_ref_data_code={$ref_s_ref_data_code}";
			$lobj_get_existing_records = $this->aobj_context->mobj_db->GetAll($get_existing_records);
			foreach($lobj_get_existing_records as $ak=>$av)
			{
				$existing_grp_arr[$av[internal_code]]=$av['internal_code'];
			}			
		}
		
		$image_group_arr=array();
		$row_image_group_arr=array();
		$image_system_names_arr=array();
		 
		foreach($full_arr as $fk=>$arr)// looping throgh each row
		{
			$grp_insert_cols="";
			$grp_insert_col_values="";
			$grp_update_col_values="";
			$grp_update_cond="";
			$group_int_code=$arr['group_int_code'];
			$child_groups_arr=$arr['child_groups'];

			// echo $group_table_name."---";
			foreach($arr as $pk=>$pv)
			{
				$value_type= gettype($pv);
				if($value_type=='array')
				{
					$image_group_arr[$pk]=$pv;
					if(!in_array($pk,$image_system_names_arr))
					array_push($image_system_names_arr,$pk);
					continue;
				}
				if($pk=="group_int_code" || $pk=="child_groups"|| $pk=="id" || $pk=="item_tax_name" || strpos($pk,'txt_ref_schema_') !== false) continue;
				$grp_insert_cols.=$pk.",";
				$system_name=$pk;
				
				$o_cell_val=addslashes(urldecode($pv));
				$data_type=$this->system_name_prop_arr[$system_name]['data_type'];
				$cell_val="'{$o_cell_val}'";
				 
				if($data_type=="Date")
				{
					if(empty($o_cell_val) || $o_cell_val=="00/00/0000" || $o_cell_val=="null" ) 
						$cell_val=" NULL ";	
					else 
						$cell_val="'".db_date_format($o_cell_val)."'";	
				}
				else if($data_type=="DateTime")
				{
					if(empty($o_cell_val) || $o_cell_val=="00/00/0000 00:00" ) 
						$cell_val=" NULL ";	
					else 
						$cell_val="'".db_date_format_time($o_cell_val)."'";	
				}
				else if($data_type=="Number")
				{
					if($o_cell_val=="null" || $o_cell_val=="undefined" || (empty($o_cell_val) && $o_cell_val!="0")) $cell_val=" NULL ";		
				}
				else if($data_type=="Reference Data")
				{ 	
					if($o_cell_val=="null" || $o_cell_val=="undefined" || (empty($o_cell_val) && $o_cell_val!="0")) $cell_val=" NULL ";		
				}
						
				$grp_insert_col_values.= $cell_val.",";		
				$grp_update_cond.=$pk."= ".$cell_val.",";
				 
			}

			$grp_insert_cols=substr($grp_insert_cols,0,strlen($grp_insert_cols)-1);
			$grp_insert_col_values=substr($grp_insert_col_values,0,strlen($grp_insert_col_values)-1);
			$grp_update_cond.=" modified_by={$this->user_id}, modified_date=now() ";
			if($group_int_code>0)
			{
				unset($existing_grp_arr[$group_int_code]);
				$qry=" update {$group_table_name} set {$grp_update_cond} where internal_code={$group_int_code}";
				// echo $qry;die(); 
				$lobj_rs = $this->aobj_context->mobj_db->Execute($qry); 
				$second_level_ref_s_ref_data_code = $group_int_code;
				 
				if(!$lobj_rs)	
				{	if($this->call_type == 'UI')
					{			
						$rdata['msg']="Updation failed in {$group_table_name} ".mysql_error();
						echo $this->aobj_context->mobj_output->ToJSONEnvelope($rdata,-1,"Failure");
						return 	$rdata;
					}
					else
					{
						$mod_arr['status_code'] = -1;
						$mod_arr['message'] = 'Failed';
						return $mod_arr;
					}
				}
				$row_image_group_arr[$second_level_ref_s_ref_data_code]=$image_group_arr;
				$this->HandleGroupImages($group_table_name,$row_image_group_arr);
			}
			else
			{
				$qry="insert into {$group_table_name}
								( ref_s_ref_data_code, {$grp_insert_cols},created_by,
								created_date,
								modified_by,
								modified_date) values 
								({$ref_s_ref_data_code},{$grp_insert_col_values},{$this->user_id},now(),{$this->user_id},now()
								)";
				$lobj_rs = $this->aobj_context->mobj_db->Execute($qry); 
				$mysql_err=mysql_error();
				//  echo $qry;	
				$second_level_ref_s_ref_data_code = $this->aobj_context->mobj_db->Insert_ID();
				if(!$lobj_rs)	
				{			
					if($this->call_type == 'UI')
					{
						$rdata['msg']="Insertion failed in {$group_table_name} ". $mysql_err;
						echo $this->aobj_context->mobj_output->ToJSONEnvelope($rdata,-1,"Failure");
						return 	$rdata;
					}
					else
					{
						$mod_arr['status_code'] = -1;
						$mod_arr['message'] = 'Failed';
						return $mod_arr;
					}
				}
				$row_image_group_arr[$second_level_ref_s_ref_data_code]=$image_group_arr;
				$this->HandleGroupImages($group_table_name,$row_image_group_arr);
			}	
			if(!empty($child_groups_arr))
			{
				foreach($child_groups_arr as  $child_table_name =>$c_val)
				{
				   $this->FormGroupUpdateInsertCommands($child_table_name,$c_val,$second_level_ref_s_ref_data_code);
				}
			}				
		}// looping throgh each row ends	
		if($this->save_type=='Edit' && !empty($existing_grp_arr))
		{		 
			$ids=implode(",",$existing_grp_arr);
			if(!empty($image_system_names_arr))
			{
				foreach($existing_grp_arr as $dk=>$dv)
				{
					$del_int_code=$dv;
					foreach($image_system_names_arr as $imk_system_name)
					{
						$this->GetImagePathAndDelete($group_table_name,$imk_system_name,$del_int_code);
					}
				}
			}
			$delete_qry="delete from {$group_table_name}
								 where ref_s_ref_data_code={$ref_s_ref_data_code}
								and internal_code in({$ids})";
						
			$lobj_delete_qry = $this->aobj_context->mobj_db->Execute($delete_qry); 
		}
	}
	
	function HandleGroupDetails()
	{
		foreach($this->group_details_arr  as $grp_table_name => $grp_values)
		{
			$group_table_name=$grp_table_name;	
			$arr_values=($grp_values); 
			if(empty($arr_values))
			{
				if($this->save_type=='Edit') // in editing mode, if user delete all records then delete all record from back end
				{
					$delete_="delete from {$group_table_name} where ref_s_ref_data_code={$this->last_inserted_id}";
					$lobj_get_existing_records = $this->aobj_context->mobj_db->Execute($delete_);
				}
				continue;
			}
			else
			{
				$this->FormGroupUpdateInsertCommands($group_table_name,$arr_values,$this->last_inserted_id);
			}
		}
	}
	
	function InsertNewRecord()
	{
		$insert_qry="insert into {$this->system_module_table_name}
							( ref_s_user_schema_code, {$this->insert_cols},created_by,
							created_date,
							modified_by,
							modified_date) values 
							({$this->schema_id},{$this->insert_col_values},{$this->user_id},now(),{$this->user_id},now()
							)";	
		// echo "<pre>".$insert_qry; die();		
		$lobj_rs = $this->aobj_context->mobj_db->Execute($insert_qry); 
 
		$mysql_err=mysql_error();
		$this->last_inserted_id = $this->aobj_context->mobj_db->Insert_ID();
		
		if($this->last_inserted_id >0)
		{
			$this->HandleImageSave();
			$this->UploadAttachment();
			$this->HandleGroupDetails();	
			 
			$table=$this->system_module_table_name;
			$user_schema_code=$this->schema_id;
			$lstr_ids=$this->last_inserted_id;
			  
		    if (function_exists('postSave'))
			{
				$post_data =  postSave($this,$this->last_inserted_id,$this->internal_code); 
			}
			$this->log->InsertIntoAuditLog($table,$user_schema_code,$lstr_ids,'Insert');
			require_once($this->aobj_context->main_src."/custom_src/approval_setup.php");
			$f_obj=new approval_setup($this->aobj_context);	 
			$approval_flag=$f_obj->GetFirstStageApprovalFlag($this->system_module_table_name);
			
			if($approval_flag == '' || empty($approval_flag))
				$approval_flag=0;
			
			if($approval_flag == 0)
			{
				$app_obj = new approvals($this->aobj_context);
				$app_obj->insertFirstStageApproval($this->schema_id,$this->system_module_table_name,$this->last_inserted_id,$this->internal_code);
			} 
			
			if($this->call_type == 'UI')
			{
				$rdata['msg'] = (!empty($post_data))?$post_data:"Inserted  Successfully.";
				$rdata['last_id'] = $this->last_inserted_id;
				print_r($this->aobj_context->mobj_output->ToJSONEnvelope($rdata,0,"success"));
				return;
			}
			else
			{
				$mod_arr['status_code'] = $this->last_inserted_id;
				$mod_arr['message'] = 'Successful';
				return $mod_arr;
			}
		}	 
		else
		{
			if($this->call_type == 'UI')
			{
				$rdata['msg']="Insertion Failed ".$mysql_err;
				echo $this->aobj_context->mobj_output->ToJSONEnvelope($rdata,-1,"Failure");
				return 	$rdata;
			}
            else
			{
				$mod_arr['status_code'] = 0;
				$mod_arr['message'] = 'Failed';
				return $mod_arr;
			} 			 
		}
	}
	
	function UpdateExistingRecord()
	{
		// echo $this->update_qry;die();
		$table=$this->system_module_table_name;
		$user_schema_code=$this->schema_id;
		$lstr_ids=$this->internal_code;
		$this->log->GetElementDetailsForCompare($user_schema_code);
		$this->log->GetPreviousTransDetails($table,$user_schema_code,$lstr_ids);
		$this->log->GetNewTransDetails($table,$this->larr_save_data,$this->group_details_arr,$user_schema_code,$lstr_ids);
		 
		$lobj_rs = $this->aobj_context->mobj_db->Execute($this->update_qry);
		
		$this->last_inserted_id=$this->internal_code;	
		$this->HandleImageSave();		
		$this->UploadAttachment();		
		$mysql_err=mysql_error();
		 
		if($lobj_rs)
		{
		    $this->HandleGroupDetails();	
		    if(function_exists('postSave'))
			{
				postSave($this,$this->internal_code,$this->internal_code); 
			}
	        
            $app_obj = new approvals($this->aobj_context);
			$app_obj->insertFirstStageApproval($this->schema_id,$this->system_module_table_name,$this->last_inserted_id,$this->internal_code);
			
		    $rdata['last_id'] = $this->internal_code;
			$rdata['msg']= "Updated  Successfully.";
			print_r($this->aobj_context->mobj_output->ToJSONEnvelope($rdata,0,"success"));
			return;
		}
		else
		{
			$rdata['msg'] = "Udatation Failed.".$mysql_err;
			print_r($this->aobj_context->mobj_output->ToJSONEnvelope($rdata,-1,"Failure"));      
		} 
	}
	
	####################### GetSchemaModuleDetailsForUpdateNew START##########################################
	function GetSchemaModuleDetailsForUpdateNew()
	{
		include_once($this->aobj_context->src."/json.php"); 
		$json = new Services_JSON();
		$this->search_fields = stripslashes( ($this->aobj_context->mobj_data["search_fields"]));
		$this->full_arr = stripslashes( ($this->aobj_context->mobj_data["full_arr"]));
		$mobj_full_arr= $json->decode($this->full_arr);
		$larr_mobj_full_arr = get_object_vars($mobj_full_arr);
		if(!(empty($this->search_fields)) or ($this->search_fields!='null'))
		{
			$mobj_search_fields = $json->decode($this->search_fields);
			$larr_mobj_search_fields = get_object_vars($mobj_search_fields);
		 
		}
		
		$is_edit_allowed = 1;
		$this->internal_code=($this->aobj_context->mobj_data["internal_code"]);
		$this->ur_edit_days=($this->aobj_context->mobj_data["ur_edit_days"]);															
		$this->schema_id=($this->aobj_context->mobj_data["schema_id"]);
		$this->table_name=($this->aobj_context->mobj_data["table_name"]);
		$this->search_fields=($this->aobj_context->mobj_data["search_fields"]);
		$qry=$this->getGeneralViewQry();
		$this->GetNextPrevRecordsIntCode($larr_mobj_search_fields,$larr_mobj_full_arr);
		 // echo "<pre>".$qry;
		$lobj_qry = $this->aobj_context->mobj_db->GetRow($qry);
		if($this->ur_edit_days > 0)
		{
			$get_date_diff = "SELECT DATEDIFF(NOW(),created_date) AS date_diff from {$this->table_name} where internal_code = {$this->internal_code}";
			$lobj_get_date_diff = $this->aobj_context->mobj_db->GetRow($get_date_diff);
			$date_diff = $lobj_get_date_diff['date_diff'];
			
			if($date_diff > $this->ur_edit_days)
				$is_edit_allowed = 0;
			else
				$is_edit_allowed = 1;
		}				  
		$data['internal_code']=$this->internal_code;
		$data['is_edit_allowed']=$is_edit_allowed;								 
		$data['previous_int_code']=$this->previous_int_code;
		$data['next_int_code']=$this->next_int_code;
		$data['details']=$lobj_qry;
		$data['grp_details']=$this->getGroupViewQry();
		$data['saved_ref_display_arr']=GetRefDisplayArray($this->aobj_context,$this->schema_id, $this->internal_code);
		print_r($this->aobj_context->mobj_output->ToJSONEnvelope($data,0,"success"));      
	}	
	
	function GetNextPrevRecordsIntCode($larr_mobj_search_fields,$larr_mobj_full_arr)
	{
		// $larr_mobj_full_arr = get_object_vars($mobj_full_arr);
		// echo "<pre>";
		// print_r($larr_mobj_full_arr);die();
		$filter_cond="";
		if(!empty($larr_mobj_search_fields))
		{
			foreach($larr_mobj_search_fields as $k => $v)
			{
				$db_field=str_replace("gs_","",$k);
				$data_type=$larr_mobj_full_arr[$db_field]->Type;
				$ref_module_code=$larr_mobj_full_arr[$db_field]->ref_module_code;
			
				$s_db_field=$db_field;
				if($data_type == 'Date')
					$filter_cond=" and date_format({$s_db_field},'%d/%m/%Y') like '{$v}%' ";
				else if($data_type == 'Reference Data')
				{
					$key_int_codes=$this->GetModuleKeyData($ref_module_code,$v);
					$filter_cond.=" and {$s_db_field} in ({$key_int_codes}) "; 
				}
				else
					$filter_cond.=" and {$s_db_field} like '{$v}%' "; 
			}
		}
			
		//Get Previous Record Int code
		$pre_record_qry = "SELECT IFNULL(MAX(internal_code),0) as previous_int_code
							FROM {$this->table_name}
							WHERE internal_code < {$this->internal_code}
							{$filter_cond} ";
		    // echo $pre_record_qry."<br>"; 
		$lobj_pre_record_qry = $this->aobj_context->mobj_db->GetRow($pre_record_qry);
		$this->previous_int_code=$lobj_pre_record_qry[previous_int_code];
		
		//Get Next Record Int code
		$next_record_qry = "SELECT IFNULL(MIN(internal_code),0) as next_int_code
							FROM {$this->table_name}
							WHERE internal_code > {$this->internal_code}
							{$filter_cond} ";
		// echo $pre_record_qry; die();
		$lobj_next_record_qry = $this->aobj_context->mobj_db->GetRow($next_record_qry);
		$this->next_int_code=$lobj_next_record_qry[next_int_code];
	}
	
	function GetModuleKeyData($ref_module_code,$val)		
	{
		$get_key_fields="select field_id,table_name from module_meta_columns where module_id='{$ref_module_code}'";
		$lobj_get_key_fields = $this->aobj_context->mobj_db->GetRow($get_key_fields);
		// echo $get_key_fields; die();
		$get_data="select group_concat(internal_code) as int_codes 
					from {$lobj_get_key_fields[table_name]}
					where concat({$lobj_get_key_fields[field_id]}) like '{$val}%'";
		  // echo $get_data; die();
		$lobj_rs = $this->aobj_context->mobj_db->GetRow($get_data);
		$int_codes=$lobj_rs['int_codes'];
		return $int_codes;
	}
	
	function FormGroupQry($schema_id,$group_id,$group_table_name)
	{
		$select_ref_module_code="select 
					GROUP_CONCAT(join_table_name SEPARATOR ' ') as qry from 
					(select concat(' left join ',s.system_module_table_name, 
					' as ',s.system_module_table_name ,'_',sus.internal_code,
					' on ',s.system_module_table_name,'_',sus.internal_code,'.internal_code =',
					concat(sch.system_module_table_name,'_',sg.system_group_table_name,'_group') ,'.', db_field) as join_table_name
					from s_user_schema_elements  sus
					inner join  s_user_schema_group sg on sg.internal_code=sus.ref_s_user_schema_group_code
					inner join s_user_schema s on sus.ref_module_code=s.internal_code
					inner join s_user_schema sch on sus.ref_s_user_schema_code=sch.internal_code
					where sus.ref_s_user_schema_code={$schema_id} 
					AND sus.ref_s_user_schema_group_code={$group_id}	
					and is_multiple_group=1 and ref_module_code>0) j";
		$obj_select_ref_module_code =  $this->aobj_context->mobj_db->GetRow($select_ref_module_code);
		/* echo "<pre>";
		print_r($select_ref_module_code);die(); */
		$join_qry=(count($obj_select_ref_module_code)>0)?$obj_select_ref_module_code[qry]:'';
						
		$get_display_cols="select GROUP_CONCAT(field_name) as field_name  from 
						(select 
						 
						
						CASE 
						WHEN data_type='Date' 
							THEN CONCAT('date_format(',table_name,'.',field_name,',\"%d/%m/%Y\") as ', field_name)
						WHEN data_type='DateTime' 
							THEN CONCAT('date_format(',table_name,'.',field_name,',\"%d/%m/%Y %H:%i\") as ', field_name)
						WHEN data_type='Reference Data' THEN concat(\"ifnull(concat( \",f1,f2,\" ),'') as txt_ref_schema_\",field_name,',',table_name,'.',field_name)
						WHEN data_type='Checkbox' THEN    CONCAT('if(',table_name,'.',field_name,'=1,\"checked\",\"\") as ', field_name)
						ELSE CONCAT(table_name,'.',field_name,' as ', field_name) END AS 	field_name
						
						
						from 
						(select  s.internal_code, su.internal_code as ele_id,
						ref_module_code, concat(system_module_table_name,'_',system_group_table_name,'_group') as table_name ,
						field_id,
						if(ifnull(field_id1,'')!='',concat(table_name,'_',su.internal_code,'.',field_id1
						),'') as f1,
						if(ifnull(field_id2,'')!='',concat(',\'-\',',table_name,'_',su.internal_code,'.',field_id2),'') as f2 
						,ifnull(multiple,0) as multiple ,
						db_field as field_name ,t1.value as data_type
						from s_user_schema s inner join s_user_schema_elements su on 
						su.ref_s_user_schema_code=s.internal_code
						inner join s_ref_type t on t.internal_code=su.s_ref_type_meta
						inner join s_ref_type t1 on t1.internal_code=data_type
						inner join s_user_schema_group ug on ug.internal_code=su.ref_s_user_schema_group_code
						left join module_meta_columns mmc on mmc.module_id=su.ref_module_code
						where s.internal_code={$schema_id} and t.value='Meta' 
						and su.is_multiple_group=1 	AND ug.internal_code={$group_id}	
						order by ifnull(ug.sequence,0),su.sequence,su.internal_code ) l 
						where   multiple=1 )   a ";		
		$lobj_get_display_cols = $this->aobj_context->mobj_db->GetRow($get_display_cols);	
		// echo "<pre>".$get_display_cols;die();
		$arr['display_field_name']=$lobj_get_display_cols[field_name];
		$arr['join_qry']=$join_qry;
		// $qry = " select {$group_table_name}.internal_code as group_int_code,{$lobj_get_display_cols[field_name]}   from 
		// {$group_table_name}  {$join_qry}
		// where {$group_table_name}.ref_s_ref_data_code={$internal_code} order by {$group_table_name}.row_sequence";
		// echo "<pre>".$get_display_cols;die();
		// $lobj_qry = $this->aobj_context->mobj_db->GetAll($qry);  
		return $arr;
	}
	
	function GetThirdLevelTables()
	{
		$select_third_group_names="SELECT IFNULL(sg.parent_group_code,0) AS parent_group_code,sg.internal_code AS group_id,sg.name,
							CONCAT(system_module_table_name,'_',pg.system_group_table_name,'_group') AS s_group_table_name,
							CONCAT(system_module_table_name,'_',sg.system_group_table_name,'_group') AS t_group_table_name 
							FROM s_user_schema_group sg
							INNER JOIN s_user_schema_group pg ON pg.internal_code=sg.parent_group_code
							INNER JOIN s_user_schema s ON s.internal_code=sg.ref_s_user_schema_code	
							WHERE sg.ref_s_user_schema_code={$this->schema_id}
							AND sg.multiple=1  and ifnull(sg.tax_structure_type,'None')!='Item Tax' ";
		$lobj_select_third_group_names = $this->aobj_context->mobj_db->GetAll($select_third_group_names);
		$this->third_level_data_arr=array();
		foreach( $lobj_select_third_group_names as $gk=>$gv)
		{
			$group_id=$gv['group_id'];
			$s_group_table_name=$gv['s_group_table_name'];
			$t_group_table_name=$gv['t_group_table_name'];
				
			$extra_join_cond=" inner join {$s_group_table_name} on {$s_group_table_name}.internal_code={$t_group_table_name}.ref_s_ref_data_code";
			
			$d_arr=$this->FormGroupQry($this->schema_id,$group_id,$t_group_table_name);
			 
			$qry = " select {$t_group_table_name}.ref_s_ref_data_code,{$t_group_table_name}.internal_code as group_int_code,{$d_arr[display_field_name]}   from 
						{$t_group_table_name} {$extra_join_cond} {$d_arr[join_qry]}
						where {$s_group_table_name}.ref_s_ref_data_code={$this->internal_code} order by {$t_group_table_name}.row_sequence,{$t_group_table_name}.internal_code";
			$lobj_qry = $this->aobj_context->mobj_db->GetAll($qry); 
			$i=0;
			foreach($lobj_qry as $tk=>$tv)
			{
				$ref_s_ref_data_code=$tv['ref_s_ref_data_code'];
				unset($tv['ref_s_ref_data_code']);
				$this->third_level_data_arr[$s_group_table_name][$ref_s_ref_data_code][$t_group_table_name][$i]=$tv;
				$i++;
			}
		}	 
	}
	
	function getGroupViewQry()
	{
		require_once($this->aobj_context->main_src."/custom_src/get_jqgrid_localdata_qry.php");
		$jqgrid_obj=new jqgrid_localdata_qry($this->aobj_context);
		$this->GetThirdLevelTables();
		$this->aobj_context->mobj_db->execute("SET @@session.group_concat_max_len=10000");
		
		$select_distinct_group_names="select sg.internal_code,name,sg.is_grid_edit,sg.is_grid_edit_inline,system_module_table_name,
								concat(system_module_table_name,'_',system_group_table_name,'_group') as group_table_name,
								 ifnull(parent_group_code,0) as parent_group_code
								from s_user_schema_group sg
								inner join s_user_schema s on s.internal_code=sg.ref_s_user_schema_code	
								where sg.ref_s_user_schema_code={$this->schema_id}
								and sg.multiple=1 and ifnull(sg.parent_group_code,0)=0   and ifnull(sg.tax_structure_type,'None')!='Doc'
								order by ifnull(sg.sequence,0)";
		$lobj_select_distinct_group_names = $this->aobj_context->mobj_db->GetAll($select_distinct_group_names);
		// echo "<pre>".$select_distinct_group_names;
		$grp_arr=array();
		
		foreach( $lobj_select_distinct_group_names as $gk=>$gv)
		{
			$group_id=$gv['internal_code'];
			$system_module_table_name=$gv['system_module_table_name'];
			 
			$group_table_name=$gv['group_table_name'];
			$is_grid_edit=$gv['is_grid_edit'];
			$is_grid_edit_inline=$gv['is_grid_edit_inline'];
			if($is_grid_edit=='0')
			{
				$d_arr=$this->FormGroupQry($this->schema_id,$group_id,$group_table_name);
				$qry = " select {$group_table_name}.internal_code as group_int_code,{$d_arr[display_field_name]}   from 
								{$group_table_name}  {$d_arr[join_qry]}
							where {$group_table_name}.ref_s_ref_data_code={$this->internal_code} order by {$group_table_name}.row_sequence,{$group_table_name}.internal_code ";
				$lobj_qry = $this->aobj_context->mobj_db->GetAll($qry); 
				// echo "<pre>";
				// print_r($qry);
				if(array_key_exists($group_table_name,$this->third_level_data_arr))
				{
					$new_obj=$lobj_qry;
					$k=0;
					foreach($new_obj as $nk=>$nv)
					{
						$nv['child_data']=$this->third_level_data_arr[$group_table_name][$nv['group_int_code']];
						$lobj_qry[$k]=$nv;
						$k++;
					}
				}
				$grp_arr[$group_table_name]=$lobj_qry;
			}
			else if ($is_grid_edit=='1' )
			{
				if($is_grid_edit_inline=='1')//for jqgrid edit table
				$grp_arr[$group_table_name]=$jqgrid_obj->GetJqGridLocalDataQry($system_module_table_name,$group_table_name,$this->internal_code);
			}
		}
		return $grp_arr	;
	}	
	
	function getGeneralViewQry()
	{
		$this->aobj_context->mobj_db->execute("SET @@session.group_concat_max_len=10000");
	 
		$select_ref_module_code="select 
			GROUP_CONCAT(join_table_name SEPARATOR ' ') as qry from 
			(select concat(' left join ',s.system_module_table_name, 
			' as ',s.system_module_table_name ,'_',sus.internal_code,
			' on ',s.system_module_table_name,'_',sus.internal_code,'.internal_code =',
			sch.system_module_table_name ,'.', db_field) as join_table_name
			from s_user_schema_elements  sus
			inner join s_user_schema s on sus.ref_module_code=s.internal_code
			inner join s_user_schema sch on sus.ref_s_user_schema_code=sch.internal_code
			where ref_s_user_schema_code={$this->schema_id}  
			and is_multiple_group=0 and ref_module_code>0) j";
		$obj_select_ref_module_code =  $this->aobj_context->mobj_db->GetRow($select_ref_module_code);
 
		$join_qry=(count($obj_select_ref_module_code)>0)?$obj_select_ref_module_code[qry]:'';
				
		$get_display_cols="select GROUP_CONCAT(field_name) as field_name  from 
					(select 
					
					case when data_type='Date'
					then concat('date_format(',table_name,'.',field_name,',\"%d/%m/%Y\") as ', field_name)
					when data_type='DateTime'
					then concat('date_format(',table_name,'.',field_name,',\"%d/%m/%Y %H:%i\") as ', field_name)
					when data_type='Reference Data'
					THEN concat(\"concat(\",f1,f2,\") as txt_ref_schema_\",field_name,',',table_name,'.',field_name)
					when data_type='Number'
					THEN CONCAT('ifnull(',table_name,'.',field_name,',0) as ', field_name	)
					else
					concat(table_name,'.',field_name,' as ', field_name	)
					end as field_name
					
					from 
					(select  s.internal_code, su.internal_code as ele_id,
					ref_module_code, s.system_module_table_name as table_name ,
					field_id,
					if(ifnull(field_id1,'')!='',concat(table_name,'_',su.internal_code,'.',field_id1
					),'') as f1,
					if(ifnull(field_id2,'')!='',concat(',\'-\',',table_name,'_',su.internal_code,'.',field_id2),'') as f2 
					,ifnull(multiple,0) as multiple ,
					db_field as field_name ,t1.value as data_type
					from s_user_schema s inner join s_user_schema_elements su on 
					su.ref_s_user_schema_code=s.internal_code
					inner join s_ref_type t on t.internal_code=su.s_ref_type_meta
					inner join s_ref_type t1 on t1.internal_code=data_type
					left join s_user_schema_group ug on ug.internal_code=su.ref_s_user_schema_group_code
					left join module_meta_columns mmc on mmc.module_id=su.ref_module_code
					where s.internal_code={$this->schema_id} and t.value='Meta' 
					and su.is_multiple_group=0
					order by ifnull(ug.sequence,0),su.sequence,su.internal_code ) l 
					where   multiple=0 )   a ";		
		$lobj_get_display_cols = $this->aobj_context->mobj_db->GetRow($get_display_cols);	
		// echo "<pre>";
		// print_r($get_display_cols);die();
		
		$qry = " select {$lobj_get_display_cols[field_name]}   from 
				{$this->table_name}  {$join_qry}
				where {$this->table_name}.internal_code={$this->internal_code}";
		// echo "<pre>". $qry; die();
		return 	$qry;
	}	
	####################### GetSchemaModuleDetailsForUpdateNew END##########################################
}//end of class

function AddUserSchemaGeneralDetailsNew($aobj_context)
{
	$obj=new dynamicmastersdetailsnew($aobj_context);
	$obj->AssignParamsValues();
}
function GetSchemaModuleDetailsForUpdateNew($aobj_context)
{
	$obj=new dynamicmastersdetailsnew($aobj_context);
	$obj->GetSchemaModuleDetailsForUpdateNew();
}

############### OTHER FUNCTIONS##############

function GetRefDisplayArray($aobj_context,$schema_id, $internal_code)
{
	$get_ref_display_table_fields="select  ref.name,su. ref_s_user_schema_group_code,
						s.value as ref_value,s1.value as basevalue,
						su.system_name as field_id,
						ref_us.system_module_table_name as table_name, 
						ref.system_name as field_name, 
						if(linked_usg.multiple=0,
						linked_us.system_module_table_name,
						CONCAT(linked_us.system_module_table_name,'_',linked_usg.system_group_table_name,'_entry')) 
						as base_table_name,
						 linked.system_name as base_table_field_name 
						,su.source_field from s_user_schema_elements su 
						inner join s_user_schema_elements ref on ref.internal_code=su.source_field
						inner join s_user_schema ref_us on ref_us.internal_code=ref.ref_s_user_schema_code
						inner join s_user_schema_elements linked on linked.internal_code=su.linked_field
						inner join s_user_schema linked_us on linked_us.internal_code=linked.ref_s_user_schema_code
						inner join s_user_schema_group linked_usg on linked_usg.internal_code=linked.ref_s_user_schema_group_code
						inner join s_ref_type s on s.internal_code=ref.s_ref_type_meta
						inner join s_ref_type s1 on s1.internal_code=linked.s_ref_type_meta
						where su.ref_s_user_schema_code={$schema_id} ";
	$lobj_get_ref_display_table_fields=  $aobj_context->mobj_db->GetAll($get_ref_display_table_fields);
		 
	$k=0;
	foreach($lobj_get_ref_display_table_fields as $k=>$v)
	{
		//if ref module is of type meta seacch the value in meta table by passing the id as below
		if($v[ref_value]=='Meta')
		{
			$obj_get_base_id='';
			if($v[basevalue]=='Meta')
			{
				//need to get the id stored for this element and use that id as internal_code in next query
				$get_base_id="select ".$v[base_table_field_name]." as id
					from " .$v[base_table_name]. " where 
					internal_code={$internal_code}";
				 $obj_get_base_id=$aobj_context->mobj_db->Getrow($get_base_id);

				 
				$get_ref_meta_value="select ".$v[field_name]. " as value from ".$v[table_name]." where 
				internal_code=".$obj_get_base_id[id];
				$obj_get_ref_meta_value=$aobj_context->mobj_db->Getrow($get_ref_meta_value);
			 
			 
				$s_ref_display[$v[field_id]]=$obj_get_ref_meta_value['value'];
				$k++;
			}
			else if($v[basevalue]=='User')
			{
				//need to get the id stored for this element and use that id as internal_code in next query
				$get_base_id="select value as id from " .$v[base_table_name]. " where 
					ref_s_module_code={$internal_code} and ref_s_user_schema_elements_code=".$v[base_table_field_name];
					
				$obj_get_base_id=$aobj_context->mobj_db->Getrow($get_base_id);	
				$get_ref_meta_value="select ".$v[field_name]. " as value from ".$v[table_name]." where 
				internal_code=".$obj_get_base_id[id];
				//echo $get_ref_meta_value;
				$obj_get_ref_meta_value=$aobj_context->mobj_db->Getrow($get_ref_meta_value);
				$s_ref_display[$v[field_id]]=$obj_get_ref_meta_value['value'];
				$k++;
			}
		}
		else if($v[ref_value]=='User')
		{
			$obj_get_base_id='';
			if($v[basevalue]=='Meta')
			{
				//need to get the id stored for this element and use that id as internal_code in next query
				$get_base_id="select ".$v[base_table_field_name]." as id from " .$v[base_table_name]. " where 
					internal_code={$internal_code}";
				$obj_get_base_id=$aobj_context->mobj_db->Getrow($get_base_id);	
				
				$get_ref_usr_value="select value  from ".$v[table_name]." where 
				ref_s_module_code=  {$internal_code} and ref_s_user_schema_elements_code =".$obj_get_base_id[id];
				$obj_get_ref_usr_value=$aobj_context->mobj_db->Getrow($get_ref_usr_value);
				$s_ref_display[$v[field_id]]=$obj_get_ref_meta_value['value'];
				$k++;
			}
			else if($v[basevalue]=='User')
			{
				//need to get the id stored for this element and use that id as internal_code in next query
				$get_base_id="select value as id from " .$v[base_table_name]. " where 
					ref_s_module_code={$internal_code} and ref_s_user_schema_elements_code=".$v[base_table_field_name];
				$obj_get_base_id=$aobj_context->mobj_db->Getrow($get_base_id);
				 
				$get_ref_usr_value="select value  from ".$v[table_name]." where 
					ref_s_module_code=  {$obj_get_base_id[id]} and ref_s_user_schema_elements_code =".$v[field_name];
				$obj_get_ref_usr_value=$aobj_context->mobj_db->Getrow($get_ref_usr_value);
					 
				$s_ref_display[$v[field_id]]=$obj_get_ref_meta_value['value'];
				$k++;
			}
		} 
	}
	return 	$s_ref_display;	
}
?>