<?php
ini_set("memory_limit",-1);
	ini_set('max_execution_time', 11400);
class db_sync 
{	
		function __construct($aobj_context)
		{
			session_start();
			$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
			$this->aobj_context=$aobj_context;
		}
		function GetUserSchemaNames()
		{
			$get_data=" select internal_code,module_name,display_module_name,concat('module_',internal_code) as old_table_name
						from s_user_schema where is_menu_only=0
						 and internal_code=41
						  order by internal_code";
			 $this->user_schema_arr = $this->aobj_context->mobj_db->GetAll($get_data);			
		}
		function PerformDbSync()
		{
			foreach($this->user_schema_arr as $ak=>$av)
			{
				$this->schema_id=$av[internal_code];
				$module_name=$av[module_name];
				$display_module_name=$av[display_module_name];
				$this->old_table_name=$av[old_table_name];
				$this->new_table_name=getReplacedName($module_name);
				$this->UpdateNewTableNameAndAlter();
				$this->GetHeaderElementsAndUpdate();
				$this->GetGroupTableNameAndUpdate();
				
			 
			}
		}
		function UpdateNewTableNameAndAlter()
		{
			$update_table="update s_user_schema set system_module_table_name='{$this->new_table_name}'
							where internal_code={$this->schema_id}";
			 $obj_update_table = $this->aobj_context->mobj_db->Execute($update_table);	
			$alter_field="alter table {$this->old_table_name}  RENAME  TO
							{$this->new_table_name}";	           
			$lobj_alter_field = $this->aobj_context->mobj_db->Execute($alter_field); 
			
		}
		 
		 
		function GetGroupTableNameAndUpdate()
		{
			$get_group_names="select internal_code,name,system_group_table_name,multiple,sequence,
							CONCAT('user_schema_',ref_s_user_schema_code,'_entry_',internal_code) as entry_table_name,
							CONCAT('user_schema_',ref_s_user_schema_code,'_group_',internal_code) as group_table_name 
							from s_user_schema_group
							where multiple=1 and ref_s_user_schema_code={$this->schema_id}";
			 $this->user_schema_group_arr = $this->aobj_context->mobj_db->GetAll($get_group_names);
 		 echo "<pre>";//$get_group_names;die();
			foreach($this->user_schema_group_arr as $ak=>$av)
			{
				 
				$this->group_int_code=$av[internal_code];
				$this->group_name=getReplacedName($av[name]);
			 
				$this->old_entry_table_name=$av[entry_table_name];
				$this->old_group_table_name=$av[group_table_name];
				
				$this->new_entry_table_name=$this->new_table_name."_".$this->group_name."_entry";
				$this->new_group_table_name=$this->new_table_name."_".$this->group_name."_group";
				 
				 
			$update_table="update s_user_schema_group set system_group_table_name='{$this->group_name}'
								where internal_code={$this->group_int_code}";
			 $obj_update_table = $this->aobj_context->mobj_db->Execute($update_table);	
			 
			$alter_field="alter table {$this->old_entry_table_name}  RENAME  TO
							{$this->new_entry_table_name}";	           
			$lobj_alter_field = $this->aobj_context->mobj_db->Execute($alter_field);  
			 
			$alter_field="alter table {$this->old_group_table_name}  RENAME  TO
									{$this->new_group_table_name}";	           
			$lobj_alter_field = $this->aobj_context->mobj_db->Execute($alter_field);  
			$this->GetGroupElementsAndUpdate(); 
			}		
		}
		function GetGroupElementsAndUpdate()
		{
			$get_data="select ue.internal_code as ele_id,decimals, 
						CONCAT('u_',ue.ref_s_user_schema_code,'_g_',ug.internal_code,'_ele_',ue.internal_code) as old_db_field,
						ue.system_name as new_db_field
						from s_user_schema_elements ue
						inner join s_user_schema u on u.internal_code=ue.ref_s_user_schema_code
						inner join s_user_schema_group ug on ug.internal_code=ref_s_user_schema_group_code
						where  ue.ref_s_user_schema_code={$this->schema_id}
						and ug.internal_code={$this->group_int_code}";
			 $this->user_schema_grp_ele_arr = $this->aobj_context->mobj_db->GetAll($get_data);		
		 
			foreach($this->user_schema_grp_ele_arr as $ak=>$av)
			{
				 
				$this->ele_id=$av[ele_id];
				$this->decimals=$av[decimals];
				$this->decimal_value=$this->decimals+12;
				$this->old_db_field=$av[old_db_field];
				$this->new_db_field=getReplacedName($av[new_db_field]);
				$this->GetDataTypedetails();
				$update_db_field="update  s_user_schema_elements set db_field='{$this->new_db_field}'
								where internal_code={$this->ele_id}";
				$lobj_alter_field = $this->aobj_context->mobj_db->Execute($update_db_field);	
				
				$alter_field="alter table {$this->new_entry_table_name}  change  
							{$this->old_db_field}  {$this->new_db_field} {$this->data_type}";	
			 					
				$lobj_alter_field = $this->aobj_context->mobj_db->Execute($alter_field);
				
				
				$alter_field="alter table {$this->new_group_table_name}  change  
							{$this->old_db_field}  {$this->new_db_field} {$this->data_type}";	
			 					
				$lobj_alter_field = $this->aobj_context->mobj_db->Execute($alter_field);
				 
				
			}	
 		 
		}
		function GetHeaderElementsAndUpdate()
		{
			$get_data="select ue.internal_code as ele_id,decimals, 
						CONCAT('m_',ue.ref_s_user_schema_code,'_ele_',ue.internal_code) as old_db_field,
						ue.system_name as new_db_field
						from s_user_schema_elements ue
						inner join s_user_schema u on u.internal_code=ue.ref_s_user_schema_code
						left join s_user_schema_group ug on ug.internal_code=ref_s_user_schema_group_code
						where  ue.ref_s_user_schema_code={$this->schema_id}
						and (ug.multiple is null	or  ug.multiple=0)";
			 $this->user_schema_ele_arr = $this->aobj_context->mobj_db->GetAll($get_data);		
			foreach($this->user_schema_ele_arr as $ak=>$av)
			{
				 
				$this->ele_id=$av[ele_id];
				$this->decimals=$av[decimals];
				$this->decimal_value=$this->decimals+12;
				$this->old_db_field=$av[old_db_field];
				$this->new_db_field=getReplacedName($av[new_db_field]);
				$this->GetDataTypedetails();
				$update_db_field="update  s_user_schema_elements set db_field='{$this->new_db_field}'
								where internal_code={$this->ele_id}";
				$lobj_alter_field = $this->aobj_context->mobj_db->Execute($update_db_field);	
				$alter_field="alter table {$this->new_table_name}  change  
							{$this->old_db_field}  {$this->new_db_field} {$this->data_type}";	
			 					
				$lobj_alter_field = $this->aobj_context->mobj_db->Execute($alter_field);
				
			}	
		}
		function GetDataTypedetails()
		{
		$get_type="select case when s.value='Text' then 'varchar(500)'
				when s.value='List Of Values' then 'varchar(50)'
				when s.value='Reference Data' then 'int(11)'
				when s.value='Auto Increment' then 'varchar(50)'
				when s.value ='Number' and {$this->decimal_value}>12 then 'decimal({$this->decimal_value},{$this->decimals})'
				when s.value ='Number' and {$this->decimal_value}=12 then 'int(11)'
				when s.value ='Date' then 'date'
				when s.value='Month' then 'int(6)'
				when s.value='Image' then 'varchar(250)'
				else 'text' end as data_type 
				from 
				s_user_schema_elements suse 
				left join s_ref_type s on s.internal_code=suse.data_type
				where suse.internal_code={$this->ele_id}";
		$lobj_get_type = $this->aobj_context->mobj_db->GetRow($get_type);	
		$this->data_type=$lobj_get_type[data_type];
		}
		function DoDbSync()
		{
			$this->GetUserSchemaNames();
			$this->PerformDbSync();
		}
}
function DoDbSync($aobj_context)
{
	$obj=new db_sync($aobj_context);
	$obj->DoDbSync();
	print_r($aobj_context->mobj_output->ToJSONEnvelope($rdata,0,"success"));
			return $rdata;
} 
function getReplacedName($name)
{
	$spl_char = array("*","/","~","!","@","#","$","%","^","&",":",";","?","/","\\","_","-","'"," ",".");
	$view_name = strtolower(str_replace($spl_char,"_",$name));
	return strtolower(str_ireplace("__","_",$view_name));
}
?>
