<?php
ini_set("memory_limit",-1);
ini_set('max_execution_time', 5000);
class wall_mart_sap
{
		public $aobj_context;
 
		function __construct($aobj_context,$parent_obj)
		{
		$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->aobj_context=$aobj_context;
		$this->parent_obj=$parent_obj;
		$this->user_id = $_SESSION['user_id'];
		$format_file=$aobj_context->main_src."/src/format.php";
		$this->dec_pat="/^[-+]?[0-9]+\.[0-9]{2}+$/";				
		$this->number_pat="/^[0-9]+$/";		
		$this->new_parser_kewords=array();
		$get_address="select LOWER(customer_keyword) as customer_keyword 
					from customer_master where internal_code={$parent_obj->customer_int_code}";
		$lobj_get_address = $this->aobj_context->mobj_db->GetRow($get_address);		
		 
		$this->new_parser_kewords=explode(",",$lobj_get_address['customer_keyword']);
		}
		function TrimWhiteSpaces($text)
		{
		return trim(preg_replace('/\s\s+/', ' ',$text));
		}
		function ReomveCommas($text)
		{
		return trim(preg_replace('/,/', '',$text));
		}
		function getIndexIds($explode_line_arr,$name,$start_index)
		{
			for($i=$start_index;$i<count($explode_line_arr);$i++)
			{
			$cell_val=$explode_line_arr[$i];
			 if (preg_match("/{$name}/", $cell_val))
			 return $i;
			}
		}
		function getIndexIdsExactMatch($explode_line_arr,$name,$start_index)
		{
			for($i=$start_index;$i<count($explode_line_arr);$i++)
			{
			$cell_val=$explode_line_arr[$i];
			 if ($name==$cell_val)
			 return $i;
			}
		}
		function GetFullDateFormat($date)
		{
		$date=trim($date);
		return str_ireplace(".","/",$date);
		 	 
		}
		function GetDataTxtFromArrStartToEnd($explode_line_arr,$start_indx,$end_indx)
		{
			$txt="";
			for($i=$start_indx;$i<=$end_indx;$i++)
			{
			$o_txt=trim($explode_line_arr[$i]);
			$txt.="{$o_txt} ";
			}
			return trim($txt);
		}
		function GetShippingAddress($explode_line_arr)
		{
	 
			$index=$this->getIndexIds($explode_line_arr,"SHIP TO",1);
			 
			$ship_start_indx=$index; 
			 
			$ship_end_indx=$this->getIndexIds($explode_line_arr,"Place of Supply",$ship_start_indx)-1;
		 
			$ship_address=$this->GetDataTxtFromArrStartToEnd($explode_line_arr,$ship_start_indx,$ship_end_indx);
			$arr=array("Delivery Site",":");
			$ship_address=str_ireplace($arr,"",$ship_address);
			 
			$this->final_data['ship_to_address']=$this->TrimWhiteSpaces($ship_address);
			$this->final_data['bill_to_address']=$this->final_data['ship_to_address'];
		}
		 
		function GetLineStartAndEndDetails($explode_line_arr)
		{
		 
			$indx=$this->getIndexIds($explode_line_arr,"#Vendor Stock",1);
			$this->start_line_indx=$indx+1;
			$indx=$this->getIndexIds($explode_line_arr,"Total cost without tax",$this->start_line_indx);
			$this->end_line_indx=$indx-1;
		 
		}
		
		function GetRawItems($explode_line_arr)
		{
			 	$this->raw_items_arr=array();
			$start_indx_arr=array();
			$this->item_indx_arr=array();//get index basd on the sl no 10,20,30,40
			for($i=$this->start_line_indx;$i<=$this->end_line_indx;$i++)
			{
			$row_data=$explode_line_arr[$i];
			 $row_data_arr=explode(" ",$row_data);
			 $article_no=trim($row_data_arr[0]);
			 $article_no_o="";
			 if(preg_match("/#/", $article_no) && strlen($article_no)==6)
			 {
			 $article_no_o=substr($article_no,-5);
			 
			 }
			 
			 if(preg_match("/#/", $article_no) && strlen($article_no_o)==5 && (preg_match($this->number_pat,$article_no_o)))
			 {
			 
				$line_start=$i;
				array_push($this->raw_items_arr,$line_start);
			 }
				   
			}
		 
		}
		function ConevertToOrderFormat()
		{
		 
		  
			$explode_line_arr=explode("\n",$this->parent_obj->read_txt_data);
			 
			 $this->total_po_qty=0;
			 $this->total_po_value=0;
			$seller_address="";
			$index=$this->getIndexIds($explode_line_arr,"PURCHASE ORDER NO",1);
			$row_data=$explode_line_arr[$index];
			$data_arr=explode("PURCHASE ORDER NO",$row_data);
			$spl_char = array(":",".","","PO No","No","PO Number","VENDOR CODE","VENDORCODE");
			$po_number=trim(str_ireplace($spl_char,"",$data_arr[1]));
			$po_number_arr=explode(" ",$po_number);
			$this->final_data['po_number']=$po_number_arr[0];
			
			
			$index=$this->getIndexIds($explode_line_arr,"ORDER DATE",1);
			$row_data=$explode_line_arr[$index];
			$data_arr=explode("ORDER DATE",$row_data);
		 
			$spl_char = array(":","","","PO No","No","PO Number","VENDOR CODE","VENDORCODE");
			$po_number=trim(str_ireplace($spl_char,"",$data_arr[1]));
			$po_number_arr=explode(" ",$po_number);
			$this->final_data['po_date']=str_ireplace(".","/",$po_number_arr[0]);
			
			
			$index=$this->getIndexIds($explode_line_arr,"PO CANCEL DATE",1);
			$row_data=$explode_line_arr[$index];
			$data_arr=explode("PO CANCEL DATE",$row_data);
		 
			$spl_char = array(":","","","PO No","No","PO Number","VENDOR CODE","VENDORCODE");
			$po_number=trim(str_ireplace($spl_char,"",$data_arr[1]));
			$po_number_arr=explode(" ",$po_number);
			$this->final_data['delivery_date']=str_ireplace(".","/",$po_number_arr[0]);
			
			
		 
			
			$this->final_data['po_vendor_code']="";
			$this->final_data['po_site_code']=$this->final_data['po_vendor_code'];
		 
			
			 
		 
		 
			$this->GetShippingAddress($explode_line_arr);
		 

			$this->GetLineStartAndEndDetails($explode_line_arr);
			$this->GetRawItems($explode_line_arr);			 
			$this->GetLineItems($explode_line_arr);
			  $this->final_data['bill_to_address']=trim($this->final_data['po_site_code'])." ".$this->final_data['bill_to_address'];
			 $del_address=$this->final_data['ship_to_address'];
			 
			 foreach($this->new_parser_kewords as $keyword)
			{
				$explode_arr=explode("~",$keyword);
				$cust=$explode_arr[0];
				$vendor_code=trim($explode_arr[1]);
				 
				if(preg_match("/{$cust}/", strtolower($del_address))) 
				$this->final_data['po_vendor_code']=trim($this->final_data['po_vendor_code']).$vendor_code;
			
			}
			
			  
			return $this->final_data;		
		}
		 
		function GetLineItems($explode_line_arr)
		{ 
			
			$this->final_po_items=array();
			$sl_no=0;
			$this->total_po_qty=0;
			$this->total_po_value=0;
			$this->last_index_arr=array();
	 			foreach($this->raw_items_arr as $rk=>$rv)
				{
					$last_index=$this->raw_items_arr[$rk+1]-1;
					if($last_index<0)
					$last_index=$this->end_line_indx;	
					$this->last_index_arr[$rv]=$last_index;
				}
			 
			foreach($this->raw_items_arr as $rk=>$rv)
			{
				$article_code_txt=str_ireplace("#","",$explode_line_arr[$rv]);
				$raw_txt=$explode_line_arr[$rv+1];
			 
				//echo $article_code_txt.'--'.$item_text_txt."</br>";
				$row_start_index=$rv;
				$row_end_index=$this->last_index_arr[$rv];
			 
				$item_arr=explode(" ",$raw_txt);			 
				$r_item_arr=array_reverse($item_arr);	
		 
				
				 	$uom_index=$this->getIndexIdsExactMatch($item_arr,"CS",1);
					$qty_orderd=$item_arr[$uom_index-1];
					$pack=$item_arr[$uom_index+1];
					$mrp=$item_arr[$uom_index+2];
					$rate=$item_arr[$uom_index+4];
					$pack_exp=explode("EA",$pack);
					$mrp_exp=explode("/",$mrp);
					$real_mrp=$mrp_exp[0];
					$pack_qty=$pack_exp[0];
				 
					$full_qty=$qty_orderd*$pack_qty;
				
				 
			 
		  
				$this->final_po_items[$sl_no]['po_item_description']=$this->GetDataTxtFromArrStartToEnd($item_arr,2,$uom_index-1);
				$this->final_po_items[$sl_no]['po_item_sku_code']=$article_code_txt;
				
				$this->final_po_items[$sl_no]['po_item_barcode']="";
				$this->final_po_items[$sl_no]['qty']=$this->ReomveCommas($full_qty);
				$this->final_po_items[$sl_no]['uom']="CS";
				
		 
				$this->final_po_items[$sl_no]['po_tax_rate']= $this->GetTaxRates($explode_line_arr,$row_start_index,$row_end_index);
				 

				$this->final_po_items[$sl_no]['tot_amt']=$this->ReomveCommas($r_item_arr[0]);
				$this->final_po_items[$sl_no]['rate']=round($this->ReomveCommas($rate)/$this->ReomveCommas($full_qty),2);
				// if($this->final_po_items[$sl_no]['po_tax_rate']==0)
				$this->final_po_items[$sl_no]['po_item_mrp']=$this->ReomveCommas($real_mrp);
			 
				
				
				// else
				// $this->final_po_items[$sl_no]['po_item_mrp']=$this->ReomveCommas($r_item_arr1[3]);
		 	$this->final_po_items[$sl_no]['po_item_hsn_code']=$item_arr1[0];
				 
				$this->total_po_qty+=$this->final_po_items[$sl_no]['qty'];
				$this->total_po_value+=$this->final_po_items[$sl_no]['tot_amt'];
				$sl_no++;
					
			}
		 
			$this->final_data['items']=$this->final_po_items;
			$this->final_data['order_qty']=$this->total_po_qty;
			$this->final_data['order_value']=$this->total_po_value;
 
			   return $this->final_data;
			   
			   
		}
		function GetTaxRates($explode_line_arr,$row_start_index,$row_end_index)
		{
			$total_tax=0;
			 for($i=$row_start_index;$i<=$row_end_index;$i++)
			 {
				 $txt=trim($explode_line_arr[$i]);
				 if(preg_match("/cgst/", strtolower($txt)))
				 {
					 $cgst_split=explode("CGST",$txt);
					 $space_split=explode(" ",trim($cgst_split[1]));
					 
					 	$spl_char = array("(",")"," ","%");
						$total_tax+=trim(str_ireplace($spl_char,"",$space_split[0]));
					  
				 } if(preg_match("/sgst/", strtolower($txt)))
				 {
					 $cgst_split=explode("SGST",$txt);
					 $space_split=explode(" ",trim($cgst_split[1]));
					 
					 	$spl_char = array("(",")"," ","%");
						$total_tax+=trim(str_ireplace($spl_char,"",$space_split[0]));
					  
				 }if(preg_match("/igst/", strtolower($txt)))
				 {
					 $cgst_split=explode("IGST",$txt);
					 $space_split=explode(" ",trim($cgst_split[1]));
					 
					 	$spl_char = array("(",")"," ","%");
						$total_tax+=trim(str_ireplace($spl_char,"",$space_split[0]));
					  
				 }
			 
			 }
			 
			return $total_tax;
		}
		 
	 
		  
		 
			
		 
			 
			 
		 
	function __destruct() {
      
    } 
	  
} 
?>