<?php
ini_set("memory_limit",-1);
ini_set('max_execution_time', 5000);
class dmart
{
		public $aobj_context;
 
		function __construct($aobj_context,$parent_obj)
		{
		$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->aobj_context=$aobj_context;
		$this->parent_obj=$parent_obj;
		$this->user_id = $_SESSION['user_id'];
		$format_file=$aobj_context->main_src."/src/format.php";
		$this->dec_pat="/^[-+]?[0-9]+\.[0-9]{2}+$/";				
		$this->number_pat="/^[0-9]+$/";		
	 
		 $this->txt_conversion_type=$this->parent_obj->txt_conversion_type;
		 
		 
				
		}
		function TrimWhiteSpaces($text)
		{
		return trim(preg_replace('/\s\s+/', ' ',$text));
		}
		function ReomveCommas($text)
		{
		return trim(preg_replace('/,/', '',$text));
		}
		function getIndexIds($explode_line_arr,$name,$start_index)
		{
			for($i=$start_index;$i<count($explode_line_arr);$i++)
			{
			$cell_val=$explode_line_arr[$i];
			 if (preg_match("/{$name}/", $cell_val))
			 return $i;
			}
		}
		 
		function GetFullDateFormat($date)
		{
			$date_arr=explode(".",$date);
			$prefix=20;
			$str=trim($prefix.$date_arr[2]);
		 
			$year=substr($str,-4);
		 	return trim($date_arr[0]."/". ($date_arr[1])."/".$year);
		}
		function GetDataTxtFromArrStartToEnd($explode_line_arr,$start_indx,$end_indx)
		{
			$txt="";
			for($i=$start_indx;$i<=$end_indx;$i++)
			{
			$o_txt=trim($explode_line_arr[$i]);
			$txt.="{$o_txt} ";
			}
			return $this->TrimWhiteSpaces($txt);
		}
	
	 	 
		function GetLineStartAndEndDetails($explode_line_arr)
		{ 
			$indx=$this->getIndexIds($explode_line_arr,"Sno",1);
			$clot_index_row_data=$this->TrimWhiteSpaces($explode_line_arr[$indx]);
			// echo $clot_index_row_data."<br>";
			$this->clot_index_exists=0;
			$this->tpv_index_exists=0;
			 if((preg_match("/Clot/", $clot_index_row_data)))
			 {
				 $this->clot_index_exists=1;
			 }
			  if((preg_match("/T P V/", $clot_index_row_data)))
			 {
				 $this->tpv_index_exists=1;
			 }
			 
			$this->start_line_indx=$indx+1;
			$indx=$this->getIndexIds($explode_line_arr,"Total",$this->start_line_indx);
			$this->end_line_indx=$indx-1;
		 
		}
		
		function GetRawItems($explode_line_arr)
		{
			$sl_no=1;
			$this->barcode_indx_arr=array();
			$this->barcode_next_line_arr=array();
			$this->raw_items_arr=array();
		 
			for($i=$this->start_line_indx;$i<=$this->end_line_indx;$i++)
			{
			$row_data=$this->TrimWhiteSpaces($explode_line_arr[$i]);
			 
			 $row_data_arr=explode(" ",$row_data);
		 
			 $barcode=substr(trim($row_data_arr[1]),0,13);
			// echo $barcode."</br>";
		 // && preg_match($this->number_pat,$barcode)
			  
			  if(strlen($barcode)>8 && 
							(preg_match("/890/", $barcode) || preg_match("/2901/", $barcode)|| preg_match("/100/", $barcode) ))
			 {
			 array_push($this->barcode_indx_arr,$i);
			 $this->raw_items_arr[$sl_no]=$this->TrimWhiteSpaces($row_data);
			 $sl_no++;
			 $hsn_txt=$this->TrimWhiteSpaces($explode_line_arr[$i+1]);
			 // echo  $hsn_txt."</br>";
			 if(!preg_match("/Code:/", $hsn_txt))
				 	 $hsn_txt=$this->TrimWhiteSpaces($explode_line_arr[$i+2]);
			 $this->barcode_next_line_arr[$barcode]=$hsn_txt;
			 }
			  
			}
 
		 
			
		}
		function GetBillingShippingAddress($explode_line_arr)
		{
			$shipping_address="";
			$billing_address="";
			$index=$this->getIndexIds($explode_line_arr,"Phone",1);
			$spl_char = array("Ship To","PURCHASE ORDER");
			$shipping_address=$this->GetDataTxtFromArrStartToEnd($explode_line_arr,0,$index-1);
			$shipping_address=((str_ireplace($spl_char,"",$shipping_address)));	
			$this->final_data['ship_to_address']=$shipping_address;
			
			$del_index_s=$this->getIndexIds($explode_line_arr,"Phone",$index);
			$del_index_e=$this->getIndexIds($explode_line_arr,"Email",$index);
			$del_index_e1=$this->getIndexIds($explode_line_arr,"Vendor FSSAI",$index);
			if(empty($del_index_e1))
			$del_index_e1=$del_index_e;
			$billing_address=$this->GetDataTxtFromArrStartToEnd($explode_line_arr,$del_index_s,$del_index_e1);
			$this->final_data['bill_to_address']=$billing_address." ".$shipping_address;
			  
			
			 
		}
		function GetPoNumberAndDate($explode_line_arr)
		{
			$spl_char = array(":","P.ONumber","PO No","PO Date","#","Delivery Dt","PO #");
			$index=$this->getIndexIds($explode_line_arr,"PO",0);
			$row_data=$explode_line_arr[$index];		 
			$exp_arr=explode("PO",$row_data);	 
			$po_number= trim((str_ireplace($spl_char,"",$exp_arr[1])));	
			$arr=explode(" ",$po_number);
			
			$this->final_data['po_number']=$arr[0];
			
			$index=$this->getIndexIds($explode_line_arr,"PO Date",$index);
			$row_data=$explode_line_arr[$index];		 
			$exp_arr=explode("PO Date",$row_data);	 
			$po_date= ((str_ireplace($spl_char,"",$exp_arr[1])));		 
			$this->final_data['po_date']=$this->GetFullDateFormat($po_date);
			
			$index=$this->getIndexIds($explode_line_arr,"Delivery Dt",$index);
			$row_data=$explode_line_arr[$index];		 
			$exp_arr=explode("Delivery Dt",$row_data);	 
			$po_date= ((str_ireplace($spl_char,"",$exp_arr[1])));		 
			$this->final_data['delivery_date']=$this->GetFullDateFormat($po_date);
			$this->final_data['ship_date']=$this->final_data['delivery_date'];
			
			  
		 
			
		}
		
		function ConevertToOrderFormat()
		{
		 
		  	$explode_line_arr=explode("\n",$this->parent_obj->read_txt_data);
		 	
			$this->total_po_qty=0;
			$this->total_po_value=0;
			$this->GetBillingShippingAddress($explode_line_arr);
			$this->GetPoNumberAndDate($explode_line_arr);
			$this->GetLineStartAndEndDetails($explode_line_arr);
			$this->GetRawItems($explode_line_arr);			 
			$this->GetLineItems($explode_line_arr);
			//die();
			   
			return $this->final_data;		
		}
		 
		function GetLineItems($explode_line_arr)
		{ 
		  
			$this->final_po_items=array();
			$sl_no=0;
			$this->total_po_qty=0;
			$this->total_po_value=0;
			 // echo "<pre>";
			 // print_r($this->tpv_index_exists);
			 // print_r($this->raw_items_arr);
			foreach($this->raw_items_arr as $rk=>$rv)
			{
				$raw_txt=$rv;		 
				$item_arr=explode(" ",$raw_txt);
				if(count($item_arr)<4) continue;
				$r_item_arr=array_reverse($item_arr);			
				 
				$barcode=str_ireplace("SCOTCH","",$item_arr[1]);
				$barcode=substr(trim($barcode),0,13);
				$this->final_po_items[$sl_no]['po_item_description']=$this->GetDataTxtFromArrStartToEnd($item_arr,2,count($item_arr)-13);
				$this->final_po_items[$sl_no]['po_item_sku_code']=$barcode;
			 	$this->final_po_items[$sl_no]['po_item_barcode']=$barcode; 		
				$this->final_po_items[$sl_no]['tot_amt']=str_replace(",","",$r_item_arr[0]);
				$this->final_po_items[$sl_no]['po_item_mrp']=$r_item_arr[1];	
				$this->final_po_items[$sl_no]['po_tax_rate']=$r_item_arr[4]+$r_item_arr[5];
				$lis_price=$r_item_arr[2];
				$final_rate=round($lis_price/(1+(round($this->final_po_items[$sl_no]['po_tax_rate']/100,2))),2);
				$this->final_po_items[$sl_no]['rate']=$final_rate;//reducing Sch.Val
			 
				if($this->clot_index_exists==1)
				{
					$this->final_po_items[$sl_no]['qty']=$r_item_arr[11];
				$this->final_po_items[$sl_no]['uom']=$r_item_arr[12];
				}
				else
				{	
							
				$this->final_po_items[$sl_no]['qty']=$r_item_arr[10];
				$this->final_po_items[$sl_no]['uom']=$r_item_arr[11];
				}
			 
				if($this->tpv_index_exists==1)
				{
					$this->final_po_items[$sl_no]['qty']=$r_item_arr[11];
					$this->final_po_items[$sl_no]['uom']=$r_item_arr[12];
				}
				$hsn_txt=$this->barcode_next_line_arr[$barcode];
				$hsn_txt_arr=explode("]",$hsn_txt);
				$hsn_code=$hsn_txt_arr[0];
				$spl_char=array("[","]","Code","HSN",":");
				$hsn_code= ((str_ireplace($spl_char,"",$hsn_code)));		 
				$this->final_po_items[$sl_no]['po_item_hsn_code']=trim($hsn_code);
				$this->final_po_items[$sl_no]['uom']="";
				$this->total_po_qty+=$this->final_po_items[$sl_no]['qty'];
				$this->total_po_value+=$this->final_po_items[$sl_no]['tot_amt'];
				$sl_no++;
					
			}
		
			$this->final_data['items']=$this->final_po_items;
			$this->final_data['order_qty']=$this->total_po_qty;
			$this->final_data['order_value']=$this->total_po_value;
			   // echo "<pre>";
			   // print_r($this->final_data);die();
			   return $this->final_data;
			 
			   
		}
	 
		  
		 
			
		 
			 
			 
		 
	function __destruct() {
      unset($this);
    } 
	  
} 
?>
