<?PHP
ini_set("memory_limit",-1);
ini_set('max_execution_time', 11400);
class sap_sales_order_repush
{
	public $aobj_context;
    function __construct($aobj_context,$po_number,$call_type)
    {
		$this->aobj_context=$aobj_context;
	 
		require_once($this->aobj_context->main_src."/src/format.php");
		$this->po_number = $po_number;	
		$this->call_type = $call_type;	
		$this->user_id = $_SESSION['user_id'];
		$this->GetSapConfiguration();
	}	
	function GetSapConfiguration()
	{
		$get_paths="   SELECT
				  
				  database_server,
				  database_name,
				  database_type,
				  database_username,
				  database_password,
				  company_username,
				  company_password,
				  sap_language,
				  license_server,
				  sap_ip_port,
				  sap_ip_address 
				  
				FROM  sap_configuration
				WHERE status='Active'";
			$lobj_get_paths = $this->aobj_context->mobj_db->GetRow($get_paths); 
			// echo $get_paths;die();
			 
			$this->database_server=$lobj_get_paths['database_server'];
			$this->database_name=$lobj_get_paths['database_name'];
			$this->database_type=$lobj_get_paths['database_type'];
			$this->database_username=$lobj_get_paths['database_username'];
			$this->database_password=$lobj_get_paths['database_password'];
			$this->company_username=$lobj_get_paths['company_username'];
			$this->company_password=$lobj_get_paths['company_password'];
			$this->sap_language=$lobj_get_paths['sap_language'];
			$this->license_server=$lobj_get_paths['license_server'];
			$this->sap_ip_address=$lobj_get_paths['sap_ip_address'];
			$this->sap_ip_port=$lobj_get_paths['sap_ip_port'];
	}
	function GetLEAPSAPSessionID()
	{
		$curl = curl_init();
	
		$input = '<?xml version="1.0" encoding="UTF-16"?>
					<env:Envelope xmlns:env="http://schemas.xmlsoap.org/soap/envelope/">
					  <env:Body>
						<dis:Login xmlns:dis="http://www.sap.com/SBO/DIS">
						  <DatabaseServer>'.$this->database_server.'</DatabaseServer>
						  <DatabaseName>'.$this->database_name.'</DatabaseName>
						  <DatabaseType>'.$this->database_type.'</DatabaseType>
						  <DatabaseUsername>'.$this->database_username.'</DatabaseUsername>
						  <DatabasePassword>'.$this->database_password.'</DatabasePassword>
						  <CompanyUsername>'.$this->company_username.'</CompanyUsername>
						  <CompanyPassword>'.$this->company_password.'</CompanyPassword>
						  <Language>'.$this->sap_language.'</Language>
						  <LicenseServer>'.$this->license_server.'</LicenseServer>
						</dis:Login>
					  </env:Body>
					</env:Envelope>';
// echo $input;die();
		curl_setopt_array($curl, array(
			  CURLOPT_PORT => $this->sap_ip_port,//"8088",
			  CURLOPT_URL => $this->sap_ip_address,//"http://180.179.24.145:8088/B1WS/Service.asmx",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => $input,
			CURLOPT_HTTPHEADER => array(
				"Content-Type: text/xml",
			),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);
 
		curl_close($curl);
 
		if ($err)
		{
			 $arr['session_msg']="Error While Getting Session---".$err;
			 $arr['session_id']="";
			 
		} 
		else
		{
			try
			{
				$response = preg_replace("/(<\/?)(\w+):([^>]*>)/", "$1$2$3", $response);
				$xml = new SimpleXMLElement($response);
				$body = $xml->xpath('//envBody')[0];
				$array = json_decode(json_encode((array)$body), TRUE); 
				$error_msg=$array['envFault']['envReason']['envText'];
				if(!empty($error_msg))
				{
					 $arr['session_msg']="Error While Getting Session".$error_msg;
					$arr['session_id']="";
				}
				else
				{
						 $arr['session_msg']="success";
							$arr['session_id']=$array['LoginResponse']['SessionID'];
				}
			}
			catch(Exception $e) {
			 
 
				 $arr['session_msg']="<span style='color:red;font-weight:bold;'>Error while Getting Session Id from SAP.. Please contact SAP Administrator</br></span>".$e->getMessage().$response;
				$arr['session_id']="";
			 
			}
			 
		
			 
		}
	 
		 return $arr;
	}
	
	
	
	function RepushPushSalesDataToSAP($po_int_code,$checked_arr)
	{
		$this->sap_session_id="";
		$this->sap_leap_msg="";
		$this->po_int_code=$po_int_code;
		$this->checked_arr=$checked_arr;
		$session_arr=$this->GetLEAPSAPSessionID();
		$session_id=$session_arr['session_id'];
		$session_msg=$session_arr['session_msg'];
		if(empty($session_id))
		{
			$this->sap_leap_msg.=$session_msg;
			return;
		}
		else
		{
			$session_id=trim($session_id);
			 
			$this->GetHeaderDetails($session_id);
		}
	}
	function GetHeaderDetails($session_id)
	{
		$get_full_fill=" SELECT full_fill_from 
						 FROM purchase_order po
						  INNER JOIN bill_to_customer_master btl ON btl.internal_code= po.bill_to
						  WHERE po.internal_code={$this->po_int_code} ";
		$lobj_get_full_fill= $this->aobj_context->mobj_db->GetRow($get_full_fill);		
		$full_fill_from=$lobj_get_full_fill['full_fill_from'];	
		if($full_fill_from=='Distributor')
		{
			
			$update_qry="  UPDATE purchase_order SET status=14  WHERE internal_code={$this->po_int_code}";
			$lobj_update_qry= $this->aobj_context->mobj_db->Execute($update_qry);
			
				$msg=" </br>Po is Fullfilled by Distributor..Not Pushed to SAP";
				$this->sap_leap_msg.=$msg;
				return;
		}
		$get_header_data=" SELECT distinct   IFNULL(pushed_to_erp,'No') as pushed_to_erp,DATE_FORMAT(DATE_ADD(CURRENT_DATE() ,INTERVAL 1 MONTH),'%Y%m%d') doc_due_date,
								 DATE_FORMAT(CURRENT_DATE() ,'%Y%m%d') doc_date,
								 DATE_FORMAT(CURRENT_DATE() ,'%Y%m%d')  tax_date,btl.customer_code AS btl_code,
								 IFNULL(ls.series,'') AS series,
								 IFNULL(ls.branch_id,'') AS branch_id,
								 po_number,
								 po.internal_code AS po_int_code,c.code AS base_customer,
								po_number AS num_at_card,
								 po.internal_code AS U_LEAPSONO,wh.warehouse_code as warehouse_code
								 
								 FROM purchase_order po
								 INNER JOIN bill_to_customer_master btl ON btl.internal_code= po.bill_to
								 INNER JOIN location_wise_warehouse wh ON wh.internal_code=btl.ship_from_warehouse
								 
								 INNER JOIN customer_master c ON c.internal_code=po.customer
								 LEFT JOIN location_wise_sap_series ls ON ls.location_code=btl.delivery_location_code AND ls.status='Active'
									where po.internal_code={$this->po_int_code}  ";
									
			$lobj_get_header_data= $this->aobj_context->mobj_db->GetRow($get_header_data);
			 
			if(empty($lobj_get_header_data))
			{
					$msg=" </br>Error While Getting Header Data...";
					$this->sap_leap_msg.=$msg;
					return;
			}
				$pushed_to_erp=$lobj_get_header_data['pushed_to_erp'];
					$po_number=$lobj_get_header_data['po_number'];
				 
				$warehouse_code=$lobj_get_header_data['warehouse_code'];
				$po_int_code=$lobj_get_header_data['po_int_code'];
			
			
				$doc_due_date=$lobj_get_header_data['doc_due_date'];
				$doc_date=$lobj_get_header_data['doc_date'];
				$tax_date=$lobj_get_header_data['tax_date'];
				$btl_code=$lobj_get_header_data['btl_code'];
				$series=$lobj_get_header_data['series'];
				$rand_no=rand(10,1000);
					$xml_file=$po_int_code."_".$po_number."_{$doc_date}_repush_{$rand_no}.xml";;
				// $s="AB2B2DBA-96D1-41C2-A749-310991526961";
				// $s=$session_id;
				if(empty($series))
				{
							$msg="</br>Series Name is Empty. Please check Location Wise SAP Series Master for PO No {$po_number}";
					$this->sap_leap_msg.=$msg;
					
					
					return;
				}
				$base_customer=$lobj_get_header_data['base_customer'];
				$num_at_card=$lobj_get_header_data['num_at_card'];
				$U_LEAPSONO=$lobj_get_header_data['U_LEAPSONO'];
				$branch_id=$lobj_get_header_data['branch_id'];
				if(empty($branch_id))
				{
							$msg="</br>branch_id is Empty. Please check Location Wise SAP Series Master for PO No {$po_number}";
					$this->sap_leap_msg.=$msg;
					
					
					return;
				}
				
				$DocType = 'I';
				    // echo '...'.$this->sap_session_id.'---';
		$this->sap_xml= '<?xml version="1.0" encoding="utf-8"?>
					<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
						<soap:Header>
							<MsgHeader xmlns="http://www.sap.com/SBO/DIS">';
			// $this->sap_xml.="<SessionID>AB2B2DBA-96D1-41C2-A749-310991526961</SessionID>";
			  $this->sap_xml.=" <SessionID>{$session_id}</SessionID> ";
			$this->sap_xml.=' <ServiceName>OrdersService</ServiceName>
							</MsgHeader>
						</soap:Header>
						<soap:Body>
							<Add xmlns="OrdersService">
								<Document xmlns="http://www.sap.com/SBO/DIS">
									<CardCode>'.$btl_code.'</CardCode>
									<DocDueDate>'.$doc_due_date.'</DocDueDate>
									<DocDate>'.$doc_date.'</DocDate>
									<TaxDate>'.$tax_date.'</TaxDate>
									<Series>'.$series.'</Series>
									<NumAtCard>'.$num_at_card.'</NumAtCard>
									<DocType>'.$DocType.'</DocType>
									<U_LEAPSONO>'.$U_LEAPSONO.'</U_LEAPSONO> 
									<BPL_IDAssignedToInvoice>'.$branch_id.'</BPL_IDAssignedToInvoice>
										<DocumentLines> ';
										
							$get_items="SELECT  stock_code ,erp_qty,erp_tax_code,erp_price FROM purchase_order_item_group
											poi INNER JOIN article_master am ON poi.item=am.internal_code
											WHERE poi.ref_s_ref_data_code={$this->po_int_code} 
										  and poi.internal_code in({$this->checked_arr})";
						$lobj_get_items= $this->aobj_context->mobj_db->GetAll($get_items);
				 
						if(empty($lobj_get_items))
						{
							$msg="Items Cannot be Empty for PO No-- {$po_number} ";
							$this->sap_leap_msg.=$msg;
							return;
					 
						}
						$line_no=0;
						$error_item=0;
						foreach($lobj_get_items as $ak=>$av)
						{
							$stock_code=$av['stock_code'];
							$erp_qty=$av['erp_qty'];
							$erp_price=$av['erp_price'];
							$erp_tax_code=$av['erp_tax_code'];
							if($erp_qty<=0)
							{
								$error_item++;
								$msg="ERP QTY Cannot be 0 for FG {$stock_code} {$po_number} ";
								$this->sap_leap_msg.=$msg;
								return;
							
							 
							}if($erp_price<=0)
							{
								$error_item++;
							 
								$msg="ERP PRICE Cannot be 0 for FG {$stock_code} {$po_number} ";
								$this->sap_leap_msg.=$msg;
								return;
							}if(empty($erp_tax_code))
							{
								$error_item++;
								$msg="ERP Tax Code cannot be Empty for FG {$stock_code} {$po_number}";
					 			$this->sap_leap_msg.=$msg;
								return;
							}
							$this->sap_xml.= "	<DocumentLine>
																<LineNum>{$line_no}</LineNum>
																<ItemCode>{$stock_code}</ItemCode>
																<Quantity>{$erp_qty}</Quantity>
																<UnitPrice>{$erp_price}</UnitPrice>
																<TaxCode>{$erp_tax_code}</TaxCode>
																<WarehouseCode>{$warehouse_code}</WarehouseCode>
															</DocumentLine>";
							$line_no++;								
						}
										
		$this->sap_xml.= ' 
							</DocumentLines> 
							</Document>
							</Add>
						</soap:Body>
					</soap:Envelope>	';
			$fp = fopen($this->aobj_context->main_src."/sales_order_xml/{$xml_file}", 'w');
			fwrite($fp, $this->sap_xml);
 
		fclose($fp);
	 // echo $this->sap_xml;die();
	 
	if($error_item==0)
	{
			$curl = curl_init();
			curl_setopt_array($curl, array(
		  CURLOPT_PORT => $this->sap_ip_port,//"8088",
			  CURLOPT_URL => $this->sap_ip_address,//"http://180.179.24.145:8088/B1WS/Service.asmx",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => $this->sap_xml,
			CURLOPT_HTTPHEADER => array(
				"Content-Type: text/xml",
			),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err)
		{
				$msg="Error While Pushing to SAP for {$po_number}.</br><span style='color:red;'>{$err}</span>";
				$this->sap_leap_msg.=$msg;
				return;
								
		 
		} 
		else
		{
			try{
				
			$response = preg_replace("/(<\/?)(\w+):([^>]*>)/", "$1$2$3", $response);
				$xml = new SimpleXMLElement($response);
			 
				$body = $xml->xpath('//envBody')[0];
				$array = json_decode(json_encode((array)$body), TRUE); 
				 
					$error_msg=$array['envFault']['envReason']['envText'];
					$doc_entry_no=$array['AddResponse']['DocumentParams']['DocEntry'];
			 
					if(empty($error_msg) && !empty($doc_entry_no))
					{
						$msg="</br>Success fully Pushed to SAP -- Order No {$doc_entry_no}";
						$this->sap_leap_msg.=$msg;
						$this->UpdatePoItemStatus($this->po_int_code,$doc_entry_no,"Success",$xml_file);
					}
					else
					{
						$msg="</br> Error While Pushing to SAP for {$error_msg}";
						$this->sap_leap_msg.=$msg;
						$this->UpdatePoItemStatus($this->po_int_code,'',$error_msg,$xml_file);
						return;
					}
			}
			catch(Exception $e) {
			 
				 
				$msg="<span style='color:red;font-weight:bold;'>Error while Pushing Sales Order to  SAP.. Please contact SAP Administrator</br></span>".$e->getMessage().$response;
				$this->sap_leap_msg.=$msg;
				return;
			 
			}
					 
			}
		}	
	}
	function UpdatePoItemStatus($po_int_code,$doc_entry_no,$remarks,$repush_xml_file)
	{ 
		$update="  UPDATE purchase_order_item_group
			SET  repush_date=now(), repush_ref_no='{$doc_entry_no}',repush_remarks='{$remarks}',repush_xml_file='{$repush_xml_file}' 
						WHERE ref_s_ref_data_code={$po_int_code}  and   internal_code in({$this->checked_arr}) ";
					 
		$obj=$this->aobj_context->mobj_db->Execute($update);				
		
	}
 
	 
	 
}
function RepushPushSalesOrdertoSAP($aobj_context)
{
	$po_int_codes = $aobj_context->mobj_data["po_int_codes"];
	$checked_arr = $aobj_context->mobj_data["checked_arr"];
	$po_int_code_arr=explode(',',$po_int_codes);
	$msg="";
	foreach($po_int_code_arr AS $ak)
	{
		if(empty($ak)) continue;
		if($ak>0)
		{
			$obj=new sap_sales_order_repush($aobj_context);
			 $obj->RepushPushSalesDataToSAP($ak,$checked_arr);
			$msg.=$obj->sap_leap_msg;
		 
		}
	}
 
	echo $aobj_context->mobj_output->ToJSONEnvelope($msg,0,"success"); 
	 
}

 ?>