<?PHP
ini_set("memory_limit",-1);
ini_set('max_execution_time', 11400);
class dat_file
{
	public $aobj_context;
    function __construct($aobj_context,$po_number,$call_type,$push_to_ftp=0)
    {
		$this->aobj_context=$aobj_context;
		require_once($this->aobj_context->main_src."/custom_src/ftp_push.php");
		require_once($this->aobj_context->main_src."/src/format.php");
		$this->po_number = $po_number;	
		$this->call_type = $call_type;	
		$this->push_to_ftp = $push_to_ftp;	
		$this->user_id = $_SESSION['user_id'];
		$this->GetCompanyData();
		$this->GetItemDetails();
		return $this->CloseTextFile();	
		
	}	
	function GetCompanyData()
	{
		$get_paths="select dat_file_path,log_file_path
							from company_setup 
							where status='Active'";
			$lobj_get_paths = $this->aobj_context->mobj_db->GetRow($get_paths); 
			// echo $get_paths;die();
			 
			$this->dat_file_path=$lobj_get_paths['dat_file_path'];
			$this->log_file_path=$lobj_get_paths['log_file_path'];
	}
	
	function GetItemDetails()
	{
		$get_item_details="select date_format(po.po_date, '%d/%m/%Y') as date,
					po.po_number AS number,
					am.stock_code,am.uom,am.pack_qty,bcm.customer_code,bcm.dat_file_required,
					pog.qty
					from
					purchase_order po 
					inner join purchase_order_item_group pog 
					on pog.ref_s_ref_data_code = po.internal_code 
					inner join article_master am 
					on am.internal_code = pog.item 
					inner join bill_to_customer_master bcm 
					on bcm.internal_code = po.bill_to
					inner join status s on s.internal_code=po.status
					and s.status='Order'
					and ifnull(pog.ignore_for_xlite,'No')='No'
					where po.internal_code = {$this->po_number}";
		$this->lobj_get_item_details=$this->aobj_context->mobj_db->GetAll($get_item_details);
		if(count($this->lobj_get_item_details)>0)
		{
			$number=$this->lobj_get_item_details[0]['number'];
			$customer_code=$this->lobj_get_item_details[0]['customer_code'];
			$this->dat_file_required=$this->lobj_get_item_details[0]['dat_file_required'];
			 
			$this->file_name="dat_".$number."_".$customer_code.".dat";
		 	$this->dat_physical_full_file_path= $this->dat_file_path."\\".$this->file_name;
			// echo $this->dat_physical_full_file_path;die();
				unlink($this->dat_physical_full_file_path);
				$this->fp = fopen($this->dat_physical_full_file_path, 'w');// or die(" can't open file");
		
				fwrite($this->fp, "HIN1_FHP_GALA_ORDERS". "\r\n");
				foreach ($this->lobj_get_item_details as $k => $v)
				{
					$date=$v[date];	
					$this->date=$v[date];
					$number=$v[number];	
					$this->ui_po_number=$v[number];	
					$this->number=$v[number];
					$stock_code=$v[stock_code];	
					$this->stock_code=$v[stock_code];
					$customer_code=$v[customer_code];	
					$this->customer_code=$v[customer_code];
					$qty=$v[qty];	
					$this->qty=$v[qty];
					$this->uom=$v[uom];
					$this->pack_qty=$v[pack_qty];
					if($this->uom=="CAR")
					$this->qty=$this->qty*$this->pack_qty;	
					$this->print_data='';	
					$seperator=';';
					$this->print_data .="POS".$seperator;
					$this->print_data .=($this->number).$seperator;
					$this->print_data .=($this->date).$seperator;
					$this->print_data .=($this->customer_code).$seperator;
					$this->print_data .=($this->stock_code).$seperator;
					$this->print_data .=(round($this->qty,2)).$seperator;
					fwrite($this->fp, $this->print_data . "\r\n");		
				}
 
		}
			
		
	}	
	function CloseTextFile()
	{
		fclose($this->fp); 
		 
		if($this->call_type=='UI')
		{		
	 
				if($this->push_to_ftp==1 && $this->dat_file_required=="Yes")
			{
				$update="update purchase_order set pushed_to_erp='Yes' where internal_code={$this->po_number}";
				 
				$obj_update=$this->aobj_context->mobj_db->Execute($update);
				$ftp_obj=new ftp_push($this->aobj_context);
				$ftp_obj->MoveFileToServer($this->file_name,$this->dat_physical_full_file_path,$this->log_file_path);
			}
			  header("Content-type:application/txt"); 
			header("Content-Disposition:attachment;filename={$this->ui_po_number}.dat");
			readfile($this->dat_physical_full_file_path);
			unlink($this->dat_physical_full_file_path);  
		}
		else
		{
			if($this->push_to_ftp==1 && $this->dat_file_required=="Yes")
			{
				$update="update purchase_order set pushed_to_erp='Yes' where internal_code={$this->po_number}";
				 
				$obj_update=$this->aobj_context->mobj_db->Execute($update);
				$ftp_obj=new ftp_push($this->aobj_context);
				$ftp_obj->MoveFileToServer($this->file_name,$this->dat_physical_full_file_path,$this->log_file_path);
				
				
			}
			return $this->dat_physical_full_file_path;
		}
	}
}
 ?>