<?PHP
class override_and_ignore_report
 {
	public $aobj_context;
	function __construct($aobj_context)
	{ 
		$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->aobj_context=$aobj_context;
		$this->login_ctr = $_SESSION['login_cnt'];	
		require_once($aobj_context->main_src.'/src/format.php');
		$this->from_date = db_date_Format($aobj_context->mobj_data["from_date"]);
		$this->to_date = db_date_Format($aobj_context->mobj_data["to_date"]);	
		$this->customer = $aobj_context->mobj_data["customer"];
		$this->type = $aobj_context->mobj_data["type"];
		$this->user_type = $_SESSION['user_type'];
		$this->uifrom_date = ($aobj_context->mobj_data["from_date"]);
		$this->uito_date = ($aobj_context->mobj_data["to_date"]);
		require_once($this->aobj_context->main_src."/src/report_class.php");
		$this->Excel = new create_report($this->aobj_context);
		require_once($this->aobj_context->main_src."/custom_src/common_data.php");
		$this->comm_obj = new common_data($this->aobj_context);
		$format_file=$aobj_context->main_src."/src/format.php";
		require_once($format_file);
		$excel_writer=$aobj_context->main_src."/Excel_Writer/Writer.php";
		require_once($excel_writer);	 				
		require_once($aobj_context->main_src."/src/getnumword.php");
		$tarka_format_file=$aobj_context->main_src."/custom_src/TarkaFormatStyles.php";
		require_once($tarka_format_file);
	}
	
 	function PODetails()
	{
		$this->date_cond="";						
		$this->cust_cond="";						
		$this->type_cond="";						
		
	
		if($this->customer > 0)
		{
		 $this->cust_cond=" and cm.internal_code={$this->customer}";	
		}
		if($this->type == 'Override')
		{
			$this->type_cond=" and peg.item_validation_status='Override'";	
		}
		else 
		{
			$this->type_cond=" and peg.item_validation_status='Ignore'";	
		}
		
		
		if($this->from_date!='00-00-0000' and $this->to_date=='00-00-0000')
		{
			$this->date_cond=" and  date  >='{$this->from_date}'";
		}
		else if($this->from_date!='00-00-0000' and $this->to_date!='00-00-0000')
		{
			$this->date_cond=" and date  between '{$this->from_date}' and '{$this->to_date}'";
		} 
		
		$get_data="SELECT cm.name AS customer_name,
					st.name AS state,
					bc.customer_code,bc.customer_name AS bill_to,
					p.po_number,
					DATE_FORMAT(p.po_date,'%d-%m-%Y') AS po_date,
					p.order_value,
					IFNULL(p.sap_invoice_value,0) AS sap_invoice_value,
					am.stock_code AS SAP_stock_code,
					am.stock_description,
					am.customer_article_code, 
					pgi.qty AS order_qty,
					peg.item_validation_status,
					peg.item_validation_remarks,
					peg.item_override_remarks,
					orr.name AS override_reason
					FROM purchase_order p
					INNER JOIN purchase_order_item_group pgi ON pgi.ref_s_ref_data_code=p.internal_code
					INNER JOIN purchase_order_item_errors_group peg ON peg.ref_s_ref_data_code=pgi.internal_code
					LEFT JOIN article_master am ON am.internal_code = pgi.item
					LEFT JOIN customer_master cm ON cm.internal_code=p.customer
					LEFT JOIN bill_to_customer_master bc ON bc.internal_code = p.bill_to
					LEFT JOIN state st ON st.internal_code =bc.ship_to_state
					LEFT JOIN over_ride_reasons orr ON orr.internal_code = peg.override_reason
					WHERE 1=1  {$this->type_cond} {$this->date_cond}
					{$this->cust_cond}  
					order by cm.name,p.po_date,p.po_number";			
				     // echo "<pre>".$get_data;die();
		$this->obj_get_data = $this->aobj_context->mobj_db->GetAll($get_data);	
		
		
	}

	function CreateExcelObject()
	{
		$this->Excel->objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
		$this->Excel->objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
		$this->Excel->objPHPExcel->getActiveSheet()->getPageMargins()->setTop(0);
		$this->Excel->objPHPExcel->getActiveSheet()->getPageMargins()->setRight(0.2);
		$this->Excel->objPHPExcel->getActiveSheet()->getPageMargins()->setLeft(0.5);
		$this->Excel->objPHPExcel->getActiveSheet()->getPageMargins()->setBottom(0);
		$this->Excel->objPHPExcel->getActiveSheet()->getPageMargins()->setHeader(1);
		$this->Excel->objPHPExcel->getActiveSheet()->getPageMargins()->setFooter(0);
		$col_cnt=13;
		$get_company_details = "SELECT  company_name FROM company_setup";
		$lobj_get_company_details = $this->aobj_context->mobj_db->GetRow($get_company_details); 
		$company_name = $lobj_get_company_details[company_name];
		$title_arr = Array('1'=>Array(
											'style'=>'Title_Center',
											'caption'=>$company_name,
											'row'=>'1',
											'col'=>'0',
											'merge'=>"1,0:1,{$col_cnt}"),
											
								'2'=>Array(
												'style'=>'Title_Center',
												'caption'=>'Override and Ignore Report',
												'row'=>'2',
												'col'=>'0',
												'merge'=>"2,0:2,{$col_cnt}"  // start_row,start_col : end_row,end_col
												),
											
								'3'=>Array(
												'style'=>'Title_Center',
												'caption'=>" From {$this->uifrom_date} to {$this->uito_date}",
												'row'=>'3',
												'col'=>'0',
												'merge'=>"3,0:3,{$col_cnt}"  // start_row,start_col : end_row,end_col
												)				
												
											);	
		$this->Excel->SetTitles($title_arr);
		$this->Excel->HideGridLines();
		$this->Excel->setScale(60);
		$this->row=5;
		$this->Excel->SetColumnWidthManual(0,20);
	 	$this->Excel->SetColumnWidthManual(1,20);
	 	$this->Excel->SetColumnWidthManual(2,15);
	 	$this->Excel->SetColumnWidthManual(3,40);
	 	$this->Excel->SetColumnWidthManual(4,15);
	 	$this->Excel->SetColumnWidthManual(5,15);
	 	$this->Excel->SetColumnWidthManual(6,15);
	 	$this->Excel->SetColumnWidthManual(7,15);
	 	$this->Excel->SetColumnWidthManual(8,15);
	 	$this->Excel->SetColumnWidthManual(9,40);
	 	$this->Excel->SetColumnWidthManual(10,20);
	 	$this->Excel->SetColumnWidthManual(11,20);
	 	$this->Excel->SetColumnWidthManual(12,20);
	 	$this->Excel->SetColumnWidthManual(13,65);
	 	// $this->Excel->SetColumnWidthManual(14,20);
	 	// $this->Excel->SetColumnWidthManual(15,20);
	 	  
		$this->Excel->WriteCellNew($this->row,0,"Customer Reference","Heading_Center_Border");
		$this->Excel->WriteCellNew($this->row,1,"State","Heading_Center_Border");
		$this->Excel->WriteCellNew($this->row,2,"Bill Customer Code","Heading_Center_Border");
		$this->Excel->WriteCellNew($this->row,3,"Bill Customer Name","Heading_Center_Border");
		$this->Excel->WriteCellNew($this->row,4,"Po Number","Heading_Center_Border");
		$this->Excel->WriteCellNew($this->row,5,"PO Date","Heading_Center_Border");
		$this->Excel->WriteCellNew($this->row,6,"Order Value","Heading_Center_Border");
		$this->Excel->WriteCellNew($this->row,7,"Invoice Value","Heading_Center_Border");
		$this->Excel->WriteCellNew($this->row,8,"SAP Stock Code","Heading_Center_Border");
		$this->Excel->WriteCellNew($this->row,9,"Stock Description","Heading_Center_Border");
		$this->Excel->WriteCellNew($this->row,10,"Customer Article Code","Heading_Center_Border");
		$this->Excel->WriteCellNew($this->row,11,"Order Qty","Heading_Center_Border");
		$this->Excel->WriteCellNew($this->row,12,"Item Validation Status","Heading_Center_Border");
		$this->Excel->WriteCellNew($this->row,13,"Item Validation Status","Heading_Center_Border");
		// $this->Excel->WriteCellNew($this->row,14,"Item Override Remarks","Heading_Center_Border");
		// $this->Excel->WriteCellNew($this->row,15,"Item Override Reason","Heading_Center_Border");
		$this->row++;       
//$this->Excel->objPHPExcel->getActiveSheet()->getStyle('A10')->setQuotePrefix(true);		
	   
	}
	function WriteData()
	{
		$this->row=6;
		foreach($this->obj_get_data as $k2=>$v2)
		{
			$col=0;
			$customer_name=$v2['customer_name'];
			$bill_to=$v2['bill_to'];
			$customer_code=$v2['customer_code'];
			$po_number=$v2['po_number'];
			$po_date=$v2['po_date'];
			$order_value=$v2['order_value'];
			$state=$v2['state'];
			$sap_invoice_value=$v2['sap_invoice_value'];
			$SAP_stock_code=$v2['SAP_stock_code'];
			$stock_description=$v2['stock_description'];
			$customer_article_code=$v2['customer_article_code'];
			$order_qty=$v2['order_qty'];
			$item_validation_status=$v2['item_validation_status'];
			$item_validation_remarks=$v2['item_validation_remarks'];
			$item_override_remarks=$v2['item_override_remarks'];
			$override_reason=$v2['override_reason'];
			
			$this->Excel->WriteCellNew($this->row,$col,$customer_name);$col++;
			$this->Excel->WriteCellNew($this->row,$col,$state);$col++;
			$this->Excel->WriteCellNew($this->row,$col,$customer_code);$col++;
			$this->Excel->WriteCellNew($this->row,$col,$bill_to);$col++;
			$this->Excel->WriteCellNew($this->row,$col,$po_number); $col++;
			$this->Excel->WriteCellNew($this->row,$col,$po_date); $col++;
			$this->Excel->WriteCellNew($this->row,$col,$order_value); $col++;
			$this->Excel->WriteCellNew($this->row,$col,$sap_invoice_value); $col++;
			$this->Excel->WriteCellNew($this->row,$col,$SAP_stock_code); $col++;
			$this->Excel->WriteCellNew($this->row,$col,$stock_description); $col++;
			$this->Excel->WriteCellNew($this->row,$col,$customer_article_code); $col++;
			$this->Excel->WriteCellNew($this->row,$col,$order_qty); $col++;
			$this->Excel->WriteCellNew($this->row,$col,$item_validation_status); $col++;
			$this->Excel->WriteCellNew($this->row,$col,$item_validation_remarks);
			// $this->Excel->WriteCellNew($this->row,$col,$item_override_remarks); $col++;
			// $this->Excel->WriteCellNew($this->row,$col,$override_reason);
			$this->row++;
		}
	}
	function FormatExcel()
	{
	  $highestColumm = $this->Excel->objPHPExcel->setActiveSheetIndex(0)->getHighestColumn(); // e.g. "EL" 
      $highestRow = $this->Excel->objPHPExcel->setActiveSheetIndex(0)->getHighestRow(); 
      $range="A5:{$highestColumm}{$highestRow}";
      $this->Excel->objPHPExcel->getActiveSheet()->getStyle($range)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);	
	  
	}
	function SendOutput()
	{
		
		$this->Excel->objPHPExcel->setActiveSheetIndex(0);
		$this->Excel->SendOutput();
	}
}  	
function downloadReport($aobj_context)
{ 
	$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
	$obj=new override_and_ignore_report($aobj_context); 
	$obj->CreateExcelObject();		
	$obj->PODetails();	
	$obj->WriteData();	
	$obj->FormatExcel();
	$obj->SendOutput();
}
?>