<?php

class TestOfRecipientList extends UnitTestCase
{
	public function testAddressCanBeAddedAsStringOrSwift_Address()
	{
		$list = new Swift_RecipientList();
		$list->addTo(new Swift_Address("foo@bar.tld", "FooBar"));
		$to1 = $list->getTo();
		
		$list = new Swift_RecipientList();
		$list->addTo("foo@bar.tld", "FooBar");
		$to2 = $list->getTo();
		
		$this->assertEqual($to1, $to2);
	}
	
	public function testReturnedListsAreALWAYSOfTypeSwift_Address()
	{
		$list = new Swift_RecipientList();
		$list->addCc(new Swift_Address("foo@bar.com"));
		$list->addCc("joe@bloggs.com", "Joe");
		$list->addCc("jim@somewhere.co.uk");
		
		foreach ($list->getCc() as $entry)
		{
			$this->assertIsA($entry, "Swift_Address");
		}
	}
	
	public function testDuplicateEntriesInSameFieldAreOverWritten()
	{
		$list = new Swift_RecipientList();
		$list->addCc(new Swift_Address("foo@bar.com"));
		$list->addCc("joe@bloggs.com", "Joe");
		$list->addCc("jim@somewhere.co.uk");
		$list->addCc("foo@bar.com", "Foo");
		$this->assertEqual(3, count($list->getCc()));
	}
	
	public function testAddressesCanBeRemoved()
	{
		$list = new Swift_RecipientList();
		$list->addBcc(new Swift_Address("foo@bar.com"));
		$list->addBcc("joe@bloggs.com", "Joe");
		$list->addBcc("jim@somewhere.co.uk");
		$list->removeBcc("joe@bloggs.com");
		$this->assertEqual(array("foo@bar.com", "jim@somewhere.co.uk"), array_keys($list->getBcc()));
	}
	
	public function testAddressesCanBeRemovedUsingObject()
	{
		$list = new Swift_RecipientList();
		$foo = new Swift_Address("foo@bar.com");
		$list->addTo($foo);
		$list->addTo("joe@bloggs.com", "Joe");
		$list->addTo("jim@somewhere.co.uk");
		$list->removeTo($foo);
		$this->assertEqual(array("joe@bloggs.com", "jim@somewhere.co.uk"), array_keys($list->getTo()));
	}
}
